/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Logger;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.CacheHandle;
import oracle.ias.cache.CacheHandleQ;
import oracle.ias.cache.DiskManager;
import oracle.ias.cache.Net;
import oracle.ias.cache.ResponseQ;

class CacheCtx {
    String m_regionName;
    DiskManager m_diskManager;
    boolean m_private;
    boolean m_distribute;
    CacheHandleQ m_handleQ;
    Net m_net;
    private int m_cacheId;
    ResponseQ m_respQ;
    int m_diskIdx = -1;
    long m_totalSize = 0L;
    HashMap m_classLoader = null;
    boolean m_useDms;
    String m_cachedumpPath;
    HashMap m_notDefinedList;
    String m_notDefinedSync;

    CacheCtx(String string, ClassLoader classLoader, int n, boolean bl, boolean bl2, DiskManager diskManager) {
        this.m_regionName = string;
        this.m_diskIdx = n;
        this.m_private = bl;
        this.m_distribute = bl2;
        this.m_diskManager = diskManager;
        this.m_handleQ = new CacheHandleQ(this);
        this.m_net = null;
        this.m_notDefinedSync = "sync";
        if (classLoader != null) {
            this.m_classLoader = new HashMap();
            this.m_classLoader.put(string, classLoader);
        }
    }

    int getIndex() {
        return this.m_diskIdx;
    }

    String getName() {
        return this.m_regionName;
    }

    ClassLoader getClassLoader(String string) {
        if (this.m_classLoader == null) {
            return null;
        }
        return (ClassLoader)this.m_classLoader.get(string);
    }

    void setClassLoader(String string, ClassLoader classLoader) {
        if (this.m_classLoader == null) {
            this.m_classLoader = new HashMap();
        }
        this.m_classLoader.put(string, classLoader);
    }

    void removeClassLoader(String string) {
        if (this.m_classLoader == null) {
            return;
        }
        this.m_classLoader.remove(string);
    }

    void setDms(boolean bl) {
        this.m_useDms = bl;
    }

    boolean useDms() {
        return this.m_useDms;
    }

    DiskManager getDiskManager() {
        return this.m_diskManager;
    }

    CacheHandle getHandle() {
        return this.m_handleQ.getHandle();
    }

    void releaseHandle(CacheHandle cacheHandle) throws CacheException {
        try {
            this.m_handleQ.releaseHandle(cacheHandle);
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
    }

    Net getNet() {
        return this.m_net;
    }

    ResponseQ getResponseQ() {
        return this.m_respQ;
    }

    int getCacheId() {
        if (this.m_net != null && this.m_net.chan != null) {
            return this.m_net.chan.getGlobalPosition();
        }
        return this.m_cacheId;
    }

    void setNet(Net net, int n) {
        this.m_net = net;
        this.m_cacheId = n;
        this.m_respQ = new ResponseQ(this);
    }

    synchronized void updateSize(long l, boolean bl) {
        this.m_totalSize = bl ? (this.m_totalSize += l) : (this.m_totalSize -= l);
    }

    long getTotalSize() {
        return this.m_totalSize;
    }

    boolean isPrivate() {
        return this.m_private;
    }

    boolean isDistributed() {
        return this.m_distribute;
    }

    Logger getLogger(String string) {
        Logger logger = Logger.getLogger(string + "." + this.getName());
        return logger;
    }

    public String getCacheDumpPath() {
        return this.m_cachedumpPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNotDefinedList(long l, String string) {
        Long l2 = new Long(l);
        String string2 = this.m_notDefinedSync;
        synchronized (string2) {
            if (this.m_notDefinedList == null) {
                this.m_notDefinedList = new HashMap();
            }
            this.m_notDefinedList.put(l2, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeNotDefinedList(String string, long l) {
        if (this.m_notDefinedList == null) {
            return;
        }
        String string2 = this.m_notDefinedSync;
        synchronized (string2) {
            Long l2 = new Long(l);
            this.m_notDefinedList.remove(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Long[] getNotDefinedList(String string) {
        Long[] longArray = null;
        String string2 = this.m_notDefinedSync;
        synchronized (string2) {
            if (this.m_notDefinedList == null) {
                longArray = new Long[]{};
            } else if (string == null) {
                Set set = this.m_notDefinedList.keySet();
                longArray = set.toArray(new Long[0]);
            } else if (this.m_notDefinedList.containsValue(string)) {
                Set set = this.m_notDefinedList.keySet();
                ArrayList<Long> arrayList = new ArrayList<Long>();
                longArray = set.toArray(new Long[0]);
                for (int i = 0; i < longArray.length; ++i) {
                    if (!this.m_notDefinedList.get(longArray[i]).equals(string)) continue;
                    arrayList.add(longArray[i]);
                    this.m_notDefinedList.remove(longArray[i]);
                }
                longArray = arrayList.toArray(new Long[0]);
            } else {
                longArray = new Long[]{};
            }
        }
        return longArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getNotDefinedSubRegions(String string) {
        String[] stringArray = null;
        String string2 = string + "/";
        int n = string2.length();
        ArrayList arrayList = new ArrayList();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = this.m_notDefinedSync;
        synchronized (string3) {
            if (this.m_notDefinedList != null) {
                Collection collection = this.m_notDefinedList.values();
                stringArray = collection.toArray(new String[0]);
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].startsWith(string2)) continue;
                    String string4 = stringArray[i].substring(n);
                    int n2 = string4.indexOf("/");
                    if (n2 > 0) {
                        string4 = string4.substring(0, n2);
                    }
                    hashMap.put(string4, string4);
                }
            }
        }
        return hashMap.values().toArray(new String[0]);
    }

    boolean regionIsOnNotDefined(String string) {
        String[] stringArray = null;
        if (this.m_notDefinedList == null) {
            return false;
        }
        Collection collection = this.m_notDefinedList.values();
        stringArray = collection.toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public void setCacheDumpPath(String string) {
        this.m_cachedumpPath = string;
    }

    public String toString() {
        return "[name=" + this.m_regionName + " private=" + this.m_private + " distribute=" + this.m_distribute + " index=" + this.m_diskIdx + " disk manager=[" + this.m_diskManager + "]" + "]";
    }
}

