/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.operation;

import java.sql.SQLException;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.statement.IBatchStatement;
import org.dbunit.database.statement.IStatementFactory;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.operation.AbstractOperation;

public class DeleteAllOperation
extends AbstractOperation {
    DeleteAllOperation() {
    }

    protected String getDeleteAllCommand() {
        return "delete from ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(IDatabaseConnection connection, IDataSet dataSet) throws DatabaseUnitException, SQLException {
        IDataSet databaseDataSet = connection.createDataSet();
        DatabaseConfig databaseConfig = connection.getConfig();
        IStatementFactory statementFactory = (IStatementFactory)databaseConfig.getProperty("http://www.dbunit.org/properties/statementFactory");
        IBatchStatement statement = statementFactory.createBatchStatement(connection);
        try {
            int count = 0;
            ITableIterator iterator = dataSet.reverseIterator();
            while (iterator.next()) {
                String tableName = iterator.getTableMetaData().getTableName();
                ITableMetaData databaseMetaData = databaseDataSet.getTableMetaData(tableName);
                tableName = databaseMetaData.getTableName();
                StringBuffer sqlBuffer = new StringBuffer(128);
                sqlBuffer.append(this.getDeleteAllCommand());
                sqlBuffer.append(this.getQualifiedName(connection.getSchema(), tableName, connection));
                statement.addBatch(sqlBuffer.toString());
                ++count;
            }
            if (count > 0) {
                statement.executeBatch();
                statement.clearBatch();
            }
        }
        finally {
            statement.close();
        }
    }
}

