/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.mssql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.operation.AbstractOperation;
import org.dbunit.operation.CompositeOperation;
import org.dbunit.operation.DatabaseOperation;
import org.dbunit.operation.ExclusiveTransactionException;

public class InsertIdentityOperation
extends AbstractOperation {
    public static final DatabaseOperation INSERT = new InsertIdentityOperation(DatabaseOperation.INSERT);
    public static final DatabaseOperation CLEAN_INSERT = new CompositeOperation(DatabaseOperation.DELETE_ALL, new InsertIdentityOperation(DatabaseOperation.INSERT));
    public static final DatabaseOperation REFRESH = new InsertIdentityOperation(DatabaseOperation.REFRESH);
    private final DatabaseOperation _operation;

    public InsertIdentityOperation(DatabaseOperation operation) {
        this._operation = operation;
    }

    protected boolean hasIdentityColumn(ITableMetaData metaData) throws DataSetException {
        Column[] columns = metaData.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].getSqlTypeName().endsWith("identity")) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(IDatabaseConnection connection, IDataSet dataSet) throws DatabaseUnitException, SQLException {
        Connection jdbcConnection = connection.getConnection();
        Statement statement = jdbcConnection.createStatement();
        try {
            IDataSet databaseDataSet = connection.createDataSet();
            if (!jdbcConnection.getAutoCommit()) {
                throw new ExclusiveTransactionException();
            }
            jdbcConnection.setAutoCommit(false);
            ITableIterator iterator = dataSet.iterator();
            while (iterator.next()) {
                block9: {
                    StringBuffer sqlBuffer;
                    Object var13_12;
                    ITable table = iterator.getTable();
                    String tableName = table.getTableMetaData().getTableName();
                    ITableMetaData metaData = databaseDataSet.getTableMetaData(tableName);
                    boolean hasIdentityColumn = this.hasIdentityColumn(metaData);
                    if (hasIdentityColumn) {
                        StringBuffer sqlBuffer2 = new StringBuffer(128);
                        sqlBuffer2.append("SET IDENTITY_INSERT ");
                        sqlBuffer2.append(this.getQualifiedName(connection.getSchema(), metaData.getTableName(), connection));
                        sqlBuffer2.append(" ON");
                        statement.execute(sqlBuffer2.toString());
                    }
                    try {
                        this._operation.execute(connection, new DefaultDataSet(table));
                        var13_12 = null;
                        if (!hasIdentityColumn) break block9;
                        sqlBuffer = new StringBuffer(128);
                        sqlBuffer.append("SET IDENTITY_INSERT ");
                    }
                    catch (Throwable throwable) {
                        var13_12 = null;
                        if (hasIdentityColumn) {
                            sqlBuffer = new StringBuffer(128);
                            sqlBuffer.append("SET IDENTITY_INSERT ");
                            sqlBuffer.append(this.getQualifiedName(connection.getSchema(), metaData.getTableName(), connection));
                            sqlBuffer.append(" OFF");
                            statement.execute(sqlBuffer.toString());
                        }
                        jdbcConnection.commit();
                        throw throwable;
                        return;
                    }
                    sqlBuffer.append(this.getQualifiedName(connection.getSchema(), metaData.getTableName(), connection));
                    sqlBuffer.append(" OFF");
                    statement.execute(sqlBuffer.toString());
                }
                jdbcConnection.commit();
                {
                }
            }
        }
        finally {
            jdbcConnection.setAutoCommit(true);
            statement.close();
        }
    }
}

