/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.ArrayList;
import java.util.List;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTable;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.RowOutOfBoundsException;

public class CachedTable
extends DefaultTable {
    public CachedTable(ITable table) throws DataSetException {
        super(table.getTableMetaData(), CachedTable.createRowList(table));
    }

    protected CachedTable(ITableMetaData metaData) {
        super(metaData);
    }

    protected static List createRowList(ITable table) throws DataSetException {
        ArrayList<Object[]> rowList = new ArrayList<Object[]>();
        try {
            Column[] columns = table.getTableMetaData().getColumns();
            if (columns.length > 0) {
                int i = 0;
                while (true) {
                    Object[] rowValues = new Object[columns.length];
                    for (int j = 0; j < columns.length; ++j) {
                        Column column = columns[j];
                        rowValues[j] = table.getValue(i, column.getColumnName());
                    }
                    rowList.add(rowValues);
                    ++i;
                }
            }
        }
        catch (RowOutOfBoundsException rowOutOfBoundsException) {
            // empty catch block
        }
        return rowList;
    }
}

