/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.ArrayList;
import java.util.List;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.CachedTable;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTable;
import org.dbunit.dataset.DefaultTableIterator;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.dbunit.dataset.stream.IDataSetProducer;

public class CachedDataSet
extends AbstractDataSet
implements IDataSetConsumer {
    private ITable[] _tables;
    private List _tableList;
    private ITableMetaData _activeMetaData;
    private List _activeRowList;

    public CachedDataSet() {
    }

    public CachedDataSet(IDataSet dataSet) throws DataSetException {
        ArrayList<CachedTable> tableList = new ArrayList<CachedTable>();
        ITableIterator iterator = dataSet.iterator();
        while (iterator.next()) {
            tableList.add(new CachedTable(iterator.getTable()));
        }
        this._tables = tableList.toArray(new ITable[0]);
    }

    public CachedDataSet(IDataSetProducer producer) throws DataSetException {
        producer.setConsumer(this);
        producer.produce();
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        return new DefaultTableIterator(this._tables, reversed);
    }

    public void startDataSet() throws DataSetException {
        this._tableList = new ArrayList();
        this._tables = null;
    }

    public void endDataSet() throws DataSetException {
        this._tables = this._tableList.toArray(new ITable[0]);
        this._tableList = null;
    }

    public void startTable(ITableMetaData metaData) throws DataSetException {
        this._activeMetaData = metaData;
        this._activeRowList = new ArrayList();
    }

    public void endTable() throws DataSetException {
        this._tableList.add(new DefaultTable(this._activeMetaData, this._activeRowList));
        this._activeRowList = null;
        this._activeMetaData = null;
    }

    public void row(Object[] values) throws DataSetException {
        this._activeRowList.add(values);
    }
}

