/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ant;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.dbunit.DatabaseUnitException;
import org.dbunit.ant.DbUnitTaskStep;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.CachedDataSet;
import org.dbunit.dataset.stream.IDataSetProducer;
import org.dbunit.dataset.stream.StreamingDataSet;
import org.dbunit.dataset.xml.FlatXmlProducer;
import org.dbunit.dataset.xml.XmlProducer;
import org.dbunit.ext.mssql.InsertIdentityOperation;
import org.dbunit.operation.DatabaseOperation;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class Operation
implements DbUnitTaskStep {
    private static final String DEFAULT_FORMAT = "flat";
    protected String type = "CLEAN_INSERT";
    private String format;
    private File src;
    private DatabaseOperation _operation;
    private boolean _forwardOperation = true;

    public String getType() {
        return this.type;
    }

    public File getSrc() {
        return this.src;
    }

    public DatabaseOperation getDbOperation() {
        return this._operation;
    }

    public String getFormat() {
        return this.format != null ? this.format : DEFAULT_FORMAT;
    }

    String getRawFormat() {
        return this.format;
    }

    public void setType(String type) {
        if ("UPDATE".equals(type)) {
            this._operation = DatabaseOperation.UPDATE;
            this._forwardOperation = true;
        } else if ("INSERT".equals(type)) {
            this._operation = DatabaseOperation.INSERT;
            this._forwardOperation = true;
        } else if ("REFRESH".equals(type)) {
            this._operation = DatabaseOperation.REFRESH;
            this._forwardOperation = true;
        } else if ("DELETE".equals(type)) {
            this._operation = DatabaseOperation.DELETE;
            this._forwardOperation = false;
        } else if ("DELETE_ALL".equals(type)) {
            this._operation = DatabaseOperation.DELETE_ALL;
            this._forwardOperation = false;
        } else if ("CLEAN_INSERT".equals(type)) {
            this._operation = DatabaseOperation.CLEAN_INSERT;
            this._forwardOperation = false;
        } else if ("NONE".equals(type)) {
            this._operation = DatabaseOperation.NONE;
            this._forwardOperation = true;
        } else if ("MSSQL_CLEAN_INSERT".equals(type)) {
            this._operation = InsertIdentityOperation.CLEAN_INSERT;
            this._forwardOperation = false;
        } else if ("MSSQL_INSERT".equals(type)) {
            this._operation = InsertIdentityOperation.INSERT;
            this._forwardOperation = true;
        } else if ("MSSQL_REFRESH".equals(type)) {
            this._operation = InsertIdentityOperation.REFRESH;
            this._forwardOperation = true;
        } else {
            throw new IllegalArgumentException("Type must be one of: UPDATE, INSERT, REFRESH, DELETE, DELETE_ALL, CLEAN_INSERT, MSSQL_INSERT,  or MSSQL_REFRESH but was: " + type);
        }
        this.type = type;
    }

    public void setSrc(File src) {
        this.src = src;
    }

    public void setFormat(String format) {
        if (!format.equalsIgnoreCase(DEFAULT_FORMAT) && !format.equalsIgnoreCase("xml")) {
            throw new IllegalArgumentException("Type must be either 'flat'(default) or 'xml' but was: " + format);
        }
        this.format = format;
    }

    public void execute(IDatabaseConnection connection) throws DatabaseUnitException {
        if (this._operation == null) {
            throw new DatabaseUnitException("Operation.execute(): setType(String) must be called before execute()!");
        }
        if (this._operation == DatabaseOperation.NONE) {
            return;
        }
        try {
            if (this.format == null) {
                this.format = DEFAULT_FORMAT;
            }
            DefaultHandler producer = null;
            producer = this.format.equalsIgnoreCase("xml") ? new XmlProducer(new InputSource(this.src.toURL().toString())) : new FlatXmlProducer(new InputSource(this.src.toURL().toString()));
            AbstractDataSet dataset = null;
            dataset = this._forwardOperation ? new StreamingDataSet((IDataSetProducer)((Object)producer)) : new CachedDataSet((IDataSetProducer)((Object)producer));
            this._operation.execute(connection, dataset);
        }
        catch (IOException e) {
            throw new DatabaseUnitException(e);
        }
        catch (SQLException e) {
            throw new DatabaseUnitException(e);
        }
    }

    public String getLogMessage() {
        return "Executing operation: " + this.type + "\n          on   file: " + (this.src == null ? null : this.src.getAbsolutePath()) + "\n          with format: " + this.format;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Operation: ");
        result.append(" type=" + this.type);
        result.append(", format=" + this.format);
        result.append(", src=" + this.src == null ? null : this.src.getAbsolutePath());
        result.append(", _operation = " + this._operation);
        return result.toString();
    }
}

