/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.swing;

import java.awt.Component;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import oracle.bali.share.event.ListenerManager;

public abstract class AbstractTableCellEditor
implements TableCellEditor {
    private ListenerManager _editListeners;

    public abstract Component getTableCellEditorComponent(JTable var1, Object var2, boolean var3, int var4, int var5);

    public abstract Object getCellEditorValue();

    public abstract boolean isCellEditable(EventObject var1);

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public boolean stopCellEditing() {
        this.fireChangeEvent(true);
        return true;
    }

    public void cancelCellEditing() {
        this.fireChangeEvent(false);
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        if (this._editListeners == null) {
            this._editListeners = new ListenerManager();
        }
        this._editListeners.addListener((EventListener)cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        if (this._editListeners != null) {
            this._editListeners.removeListener((EventListener)cellEditorListener);
        }
    }

    protected void fireChangeEvent(boolean bl) {
        if (this._editListeners == null) {
            return;
        }
        Enumeration enumeration = this._editListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        ChangeEvent changeEvent = new ChangeEvent(this);
        while (enumeration.hasMoreElements()) {
            if (bl) {
                ((CellEditorListener)enumeration.nextElement()).editingStopped(changeEvent);
                continue;
            }
            ((CellEditorListener)enumeration.nextElement()).editingCanceled(changeEvent);
        }
    }
}

