/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.multi;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.multi.SelectionEvent;
import oracle.bali.inspector.multi.SelectionListener;
import oracle.bali.inspector.multi.SelectionModel;

public class MultiObjectModel
extends PropertyModel {
    private static final Object _UNINITIALIZED_VALUE = new Object();
    private static final String _KEY_MULTIPLE = "MULTIPLE";
    private SelectionModel _selectionModel;
    private BitSet _commonProperties;
    private transient int _valueColumnIndex;
    private transient int _displayValueColumnIndex;
    private transient PropertyModel _primaryModel;
    private transient SelectionListenerImpl _listener;
    private transient Object[][] _mergedValues;
    private transient Vector _properties;
    private transient Object[] _columnIDs;
    private transient int[][] _columnMap;
    private transient BitSet _conflictFlags;

    public MultiObjectModel() {
        this._clearColumnData();
        this._listener = new SelectionListenerImpl();
    }

    public Object[] getColumnMapping() {
        return this._columnIDs;
    }

    public void setSelectionModel(SelectionModel selectionModel) {
        if (this._selectionModel != selectionModel) {
            if (this._selectionModel != null) {
                this._selectionModel.removeSelectionListener(this._listener);
                this._listener.__updateModelListeners(this._selectionModel, false);
            }
            this._selectionModel = selectionModel;
            if (selectionModel != null) {
                selectionModel.addSelectionListener(this._listener);
                this._listener.__updateModelListeners(selectionModel, true);
                this._updateProperties();
            } else {
                this._clearColumnData();
            }
        }
    }

    public SelectionModel getSelectionModel() {
        return this._selectionModel;
    }

    public String getTargetDisplayName() {
        int n;
        if (this._selectionModel != null && (n = this._selectionModel.getSelectedItemCount()) > 0) {
            if (n == 1) {
                return this._primaryModel.getTargetDisplayName();
            }
            return this._getTranslatedString(_KEY_MULTIPLE);
        }
        return null;
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this._selectionModel != null) {
            int n = this._selectionModel.getSelectedItemCount();
            int n2 = 0;
            while (n2 < n) {
                PropertyModel propertyModel = (PropertyModel)this._selectionModel.getSelectedItem(n2);
                propertyModel.setLocale(locale);
                ++n2;
            }
            if (n > 1) {
                this.firePropertyChanged("targetDisplayName", null, this._getTranslatedString(_KEY_MULTIPLE));
            }
        }
    }

    public int getRowCount() {
        if (this._properties != null) {
            return this._properties.size();
        }
        return 0;
    }

    public boolean isDataConflicting(int n, int n2) {
        this._getValue(n, n2);
        int n3 = n + this.getColumnCount() * n2;
        boolean bl = this._getConflictFlags().get(n3);
        if (bl) {
            return true;
        }
        SelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel != null) {
            int n4 = selectionModel.getSelectedItemCount();
            int n5 = 0;
            while (n5 < n4) {
                PropertyModel propertyModel = (PropertyModel)selectionModel.getSelectedItem(n5);
                if (n2 < propertyModel.getRowCount() && propertyModel.isDataConflicting(n, n2)) {
                    return true;
                }
                ++n5;
            }
        }
        return false;
    }

    public Object getValueAt(int n, int n2) {
        return this._getValue(n2, n);
    }

    public void setValueAt(Object object, int n, int n2) {
        if (this._selectionModel == null) {
            return;
        }
        this._getConflictFlags().clear(n2 + this.getColumnCount() * n);
        Object e = this._properties.elementAt(n);
        int n3 = this._selectionModel.getSelectedItemCount();
        int n4 = 0;
        while (n4 < n3) {
            PropertyModel propertyModel = (PropertyModel)this._selectionModel.getSelectedItem(n4);
            try {
                propertyModel.setPropertyByID(this._columnMap[n4][n2], e, object);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                this.throwIllegalArgumentException(throwable, this.getPropertyDisplayName(n, this.getLocale()), object);
            }
            ++n4;
        }
        if (n < this.getRowCount()) {
            this._invalidateCell(n2, n);
        }
    }

    public Object getPropertyByID(int n, Object object) {
        int n2 = this._getRowIndex(object);
        if (n2 != -1) {
            return this.getValueAt(n2, n);
        }
        return PropertyModel.DOES_NOT_EXIST;
    }

    public void setPropertyByID(int n, Object object, Object object2) throws Exception {
        int n2 = this._getRowIndex(object);
        if (n2 != -1) {
            this.setValueAt(object2, n2, n);
        }
    }

    public Enumeration getPropertyIDs() {
        return this._properties.elements();
    }

    public void invalidateValueData() {
        this._invalidateColumn(PropertyModel.COLUMN_VALUE);
        SelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel != null) {
            int n = selectionModel.getSelectedItemCount();
            int n2 = 0;
            while (n2 < n) {
                PropertyModel propertyModel = (PropertyModel)selectionModel.getSelectedItem(n2);
                propertyModel.invalidateValueData();
                ++n2;
            }
        }
    }

    public boolean isPropertyCommon(int n) {
        if (this._commonProperties != null && !this._commonProperties.get(n)) {
            return false;
        }
        SelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel != null) {
            int n2 = selectionModel.getSelectedItemCount();
            int n3 = 0;
            while (n3 < n2) {
                PropertyModel propertyModel = (PropertyModel)selectionModel.getSelectedItem(n3);
                if (!propertyModel.isPropertyCommon(n)) {
                    return false;
                }
                ++n3;
            }
        }
        return true;
    }

    public void dispose() {
        super.dispose();
        SelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel != null) {
            int n = selectionModel.getSelectedItemCount();
            int n2 = 0;
            while (n2 < n) {
                PropertyModel propertyModel = (PropertyModel)selectionModel.getSelectedItem(n2);
                propertyModel.dispose();
                ++n2;
            }
        }
        this.setSelectionModel(null);
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        if (this._selectionModel != null) {
            int n3 = this._selectionModel.getSelectedItemCount();
            int n4 = 0;
            while (n4 < n3) {
                PropertyModel propertyModel = (PropertyModel)this._selectionModel.getSelectedItem(n4);
                bl |= propertyModel.isCellEditable(n, n2);
                ++n4;
            }
        }
        return bl;
    }

    public boolean isSettable(Object object, Object object2) {
        boolean bl = false;
        if (this._selectionModel != null) {
            int n = this._selectionModel.getSelectedItemCount();
            int n2 = 0;
            while (n2 < n) {
                PropertyModel propertyModel = (PropertyModel)this._selectionModel.getSelectedItem(n2);
                bl |= propertyModel.isSettable(object, object2);
                ++n2;
            }
        }
        return bl;
    }

    public void startRead() {
        super.startRead();
        if (this._selectionModel != null) {
            int n = this._selectionModel.getSelectedItemCount();
            int n2 = 0;
            while (n2 < n) {
                PropertyModel propertyModel = (PropertyModel)this._selectionModel.getSelectedItem(n2);
                propertyModel.startRead();
                ++n2;
            }
        }
    }

    public void stopRead() {
        super.stopRead();
        if (this._selectionModel != null) {
            int n = this._selectionModel.getSelectedItemCount();
            int n2 = 0;
            while (n2 < n) {
                PropertyModel propertyModel = (PropertyModel)this._selectionModel.getSelectedItem(n2);
                propertyModel.stopRead();
                ++n2;
            }
        }
    }

    private String _getTranslatedString(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.inspector.resource.InspectorBundle", this.getLocale());
        return resourceBundle.getString(string);
    }

    private void _invalidateColumn(Object object) {
        this._invalidateColumn(this.getColumnIndex(object));
    }

    private void _invalidateColumn(int n) {
        if (n != -1) {
            int n2;
            Object[][] objectArray = this._mergedValues;
            int n3 = this.getRowCount();
            if (objectArray != null) {
                int n4 = 0;
                while (n4 < n3) {
                    objectArray[n][n4] = _UNINITIALIZED_VALUE;
                    ++n4;
                }
            }
            TableModelEvent tableModelEvent = new TableModelEvent(this, 0, n3 - 1, n);
            this.fireTableChanged(tableModelEvent);
            if (n == this._valueColumnIndex && (n2 = this._displayValueColumnIndex) != -1) {
                this._invalidateColumn(n2);
            }
        }
    }

    private void _invalidateRow(int n) {
        if (n != -1) {
            Object[][] objectArray = this._mergedValues;
            if (objectArray == null) {
                return;
            }
            int n2 = this.getColumnCount();
            int n3 = 0;
            while (n3 < n2) {
                objectArray[n3][n] = _UNINITIALIZED_VALUE;
                ++n3;
            }
            this.fireTableRowsUpdated(n, n);
        }
    }

    private void _invalidateCell(int n, int n2) {
        if (n != -1 && n2 != -1) {
            int n3;
            if (this._mergedValues != null) {
                this._mergedValues[n][n2] = _UNINITIALIZED_VALUE;
            }
            if (n2 < this.getRowCount()) {
                this.fireTableCellUpdated(n2, n);
            }
            if (n == this._valueColumnIndex && (n3 = this._displayValueColumnIndex) != -1) {
                this._invalidateCell(n3, n2);
            }
        }
    }

    private BitSet _getConflictFlags() {
        if (this._conflictFlags == null) {
            this._conflictFlags = new BitSet(this.getColumnCount() * this.getRowCount());
        }
        return this._conflictFlags;
    }

    private Object _getValue(int n, int n2) {
        Object object;
        int n3;
        int n4;
        Object[][] objectArray = this._mergedValues;
        if (objectArray == null) {
            int n5 = this.getColumnCount();
            n4 = this.getRowCount();
            objectArray = new Object[n5][n4];
            int n6 = 0;
            while (n6 < n4) {
                n3 = 0;
                while (n3 < n5) {
                    objectArray[n3][n6] = _UNINITIALIZED_VALUE;
                    ++n3;
                }
                ++n6;
            }
            this._mergedValues = objectArray;
        }
        if ((object = this._mergedValues[n][n2]) == _UNINITIALIZED_VALUE) {
            n4 = this._selectionModel.getSelectedItemCount();
            Object e = this._properties.elementAt(n2);
            object = this._primaryModel.getPropertyByID(this._columnMap[0][n], e);
            n3 = 1;
            while (n3 < n4) {
                PropertyModel propertyModel = (PropertyModel)this._selectionModel.getSelectedItem(n3);
                Object object2 = propertyModel.getPropertyByID(this._columnMap[n3][n], e);
                if (object2 != object) {
                    if (object == PropertyModel.DOES_NOT_EXIST) {
                        object = object2;
                    } else if (!(object2 == PropertyModel.DOES_NOT_EXIST || object2 != null && object2.equals(object))) {
                        this._getConflictFlags().set(n + this.getColumnCount() * n2);
                        break;
                    }
                }
                ++n3;
            }
            this._mergedValues[n][n2] = object;
        }
        return object;
    }

    private boolean _updateColumnMap() {
        int n = this._columnIDs.length;
        int n2 = this._selectionModel.getSelectedItemCount();
        if (n2 > 0) {
            Object[] objectArray;
            int n3;
            PropertyModel propertyModel = (PropertyModel)this._selectionModel.getSelectedItem(0);
            Object[] objectArray2 = propertyModel.getColumnMapping();
            int n4 = objectArray2.length;
            Vector<Object> vector = new Vector<Object>(n2);
            int n5 = 0;
            while (n5 < n4) {
                vector.addElement(objectArray2[n5]);
                ++n5;
            }
            int n6 = 1;
            while (n6 < n2) {
                PropertyModel propertyModel2 = (PropertyModel)this._selectionModel.getSelectedItem(n6);
                Object[] objectArray3 = propertyModel2.getColumnMapping();
                n3 = objectArray3.length;
                int n7 = 0;
                while (n7 < n3) {
                    Object object = objectArray3[n7];
                    if (vector.indexOf(object) == -1) {
                        vector.addElement(object);
                    }
                    ++n7;
                }
                ++n6;
            }
            boolean bl = true;
            int n8 = vector.size();
            int n9 = n3 = n != n8 ? 1 : 0;
            if (n3 == 0) {
                objectArray = this._columnIDs;
                int n10 = 0;
                while (n10 < n) {
                    if (!this._columnIDs[n10].equals(vector.elementAt(n10))) {
                        this._columnIDs = null;
                        break;
                    }
                    ++n10;
                }
                bl = n10 != n;
            } else {
                objectArray = new Object[n8];
            }
            vector.copyInto(objectArray);
            this._columnIDs = objectArray;
            int n11 = this._columnMap.length;
            Object object = n11 == n2 ? this._columnMap : (Object)new int[n2][];
            int n12 = 0;
            while (n12 < n2) {
                int[] nArray = n3 == 0 && n12 < n11 ? this._columnMap[n12] : new int[n8];
                PropertyModel propertyModel3 = (PropertyModel)this._selectionModel.getSelectedItem(n12);
                Object[] objectArray4 = propertyModel3.getColumnMapping();
                int n13 = objectArray4.length;
                int n14 = 0;
                while (n14 < n8) {
                    Object object2 = objectArray[n14];
                    int n15 = 0;
                    while (n15 < n13) {
                        if (object2 == objectArray4[n15]) break;
                        ++n15;
                    }
                    nArray[n14] = n15 < n13 ? n15 : -1;
                    ++n14;
                }
                object[n12] = nArray;
                ++n12;
            }
            this._columnMap = object;
            if (bl) {
                this._updateCachedIndices();
            }
            return bl;
        }
        this._clearColumnData();
        return n != 0;
    }

    private int _getRowIndex(Object object) {
        int n = this._properties.indexOf(object);
        if (n != -1) {
            return n;
        }
        return -1;
    }

    private synchronized void _updateProperties() {
        Object object;
        this._mergedValues = null;
        this._conflictFlags = null;
        this._commonProperties = null;
        PropertyModel propertyModel = null;
        Vector<Object> vector = null;
        PropertyModel propertyModel2 = this._primaryModel;
        int n = this._selectionModel.getSelectedItemCount();
        if (n > 0) {
            int n2;
            Object object2;
            int n3;
            int n4;
            Hashtable[] hashtableArray = null;
            if (n > 1) {
                hashtableArray = new Hashtable[n];
                n4 = 1;
                while (n4 < n) {
                    Object var9_10;
                    object = (PropertyModel)this._selectionModel.getSelectedItem(n4);
                    ((PropertyModel)object).startRead();
                    try {
                        hashtableArray[n4] = this._makeIDHashTable(((PropertyModel)object).getPropertyIDs());
                        var9_10 = null;
                        ((PropertyModel)object).stopRead();
                    }
                    catch (Throwable throwable) {
                        var9_10 = null;
                        ((PropertyModel)object).stopRead();
                        throw throwable;
                    }
                    ++n4;
                }
            }
            propertyModel = (PropertyModel)this._selectionModel.getSelectedItem(0);
            n4 = propertyModel.getRowCount();
            vector = new Vector<Object>(n4);
            object = new BitSet(n4);
            propertyModel.startRead();
            try {
                n3 = 0;
                while (n3 < n4) {
                    boolean bl = true;
                    object2 = propertyModel.getPropertyID(n3);
                    vector.addElement(object2);
                    n2 = 1;
                    while (n2 < n) {
                        Object v = hashtableArray[n2].remove(object2);
                        bl &= v != null;
                        ++n2;
                    }
                    if (bl) {
                        ((BitSet)object).set(n3);
                    }
                    ++n3;
                }
                Object var14_18 = null;
                propertyModel.stopRead();
            }
            catch (Throwable throwable) {
                Object var14_19 = null;
                propertyModel.stopRead();
                throw throwable;
            }
            this._commonProperties = object;
            n3 = 1;
            while (n3 < n) {
                Enumeration enumeration = hashtableArray[n3].keys();
                while (enumeration.hasMoreElements()) {
                    object2 = enumeration.nextElement();
                    vector.addElement(object2);
                    n2 = n3 + 1;
                    while (n2 < n) {
                        hashtableArray[n2].remove(object2);
                        ++n2;
                    }
                }
                ++n3;
            }
        }
        this._properties = vector;
        this._primaryModel = propertyModel;
        boolean bl = this._updateColumnMap();
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
        if (propertyModel != propertyModel2) {
            String string = propertyModel2 != null ? propertyModel2.getTargetDisplayName() : null;
            object = propertyModel != null ? propertyModel.getTargetDisplayName() : null;
            this.firePropertyChanged("targetDisplayName", string, object);
        }
    }

    private void _fireDisplayChange(String string, String string2) {
        if (this._selectionModel != null && this._selectionModel.getSelectedItemCount() == 1) {
            this.firePropertyChanged("targetDisplayName", string, string2);
        }
    }

    private void _clearColumnData() {
        this._columnIDs = new Object[0];
        this._columnMap = new int[0][0];
        this._updateCachedIndices();
    }

    private Hashtable _makeIDHashTable(Enumeration enumeration) {
        Hashtable hashtable = new Hashtable();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            hashtable.put(e, _UNINITIALIZED_VALUE);
        }
        return hashtable;
    }

    private void _updateCachedIndices() {
        this._valueColumnIndex = this.getColumnIndex(PropertyModel.COLUMN_VALUE);
        this._displayValueColumnIndex = this.getColumnIndex(PropertyModel.COLUMN_DISPLAY_VALUE);
    }

    private class SelectionListenerImpl
    implements SelectionListener,
    TableModelListener,
    PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("targetDisplayName".equals(propertyChangeEvent.getPropertyName())) {
                MultiObjectModel.this._fireDisplayChange((String)propertyChangeEvent.getOldValue(), (String)propertyChangeEvent.getNewValue());
            }
        }

        public void itemsAdded(SelectionEvent selectionEvent) {
            this._updateListeners(selectionEvent, true);
            MultiObjectModel.this._updateProperties();
        }

        public void itemsRemoving(SelectionEvent selectionEvent) {
            this._updateListeners(selectionEvent, false);
        }

        public void itemsRemoved(SelectionEvent selectionEvent) {
            MultiObjectModel.this._updateProperties();
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            int n = tableModelEvent.getType();
            if (n != 0 || tableModelEvent.getLastRow() == Integer.MAX_VALUE) {
                MultiObjectModel.this._updateProperties();
            } else if (tableModelEvent.getColumn() == -1) {
                this._invalidateRows(tableModelEvent);
            } else {
                this._invalidateCells(tableModelEvent);
            }
        }

        private void _invalidateRows(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getFirstRow() == -1) {
                return;
            }
            int n = tableModelEvent.getFirstRow();
            int n2 = tableModelEvent.getLastRow();
            PropertyModel propertyModel = (PropertyModel)tableModelEvent.getSource();
            int n3 = n;
            while (n3 <= n2) {
                MultiObjectModel.this._invalidateRow(MultiObjectModel.this._getRowIndex(propertyModel.getPropertyID(n3)));
                ++n3;
            }
        }

        private void _invalidateCells(TableModelEvent tableModelEvent) {
            PropertyModel propertyModel = (PropertyModel)tableModelEvent.getSource();
            int n = tableModelEvent.getColumn();
            int n2 = tableModelEvent.getFirstRow();
            int n3 = tableModelEvent.getLastRow();
            Object[] objectArray = propertyModel.getColumnMapping();
            propertyModel.startRead();
            try {
                int n4 = n2;
                while (n4 <= n3) {
                    int n5 = MultiObjectModel.this._getRowIndex(propertyModel.getPropertyID(n4));
                    MultiObjectModel.this._invalidateCell(MultiObjectModel.this.getColumnIndex(objectArray[n]), n5);
                    ++n4;
                }
                Object var10_9 = null;
                propertyModel.stopRead();
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                propertyModel.stopRead();
                throw throwable;
            }
        }

        void __updateModelListeners(SelectionModel selectionModel, boolean bl) {
            int n = selectionModel.getSelectedItemCount();
            int n2 = 0;
            while (n2 < n) {
                PropertyModel propertyModel = (PropertyModel)selectionModel.getSelectedItem(n2);
                if (bl) {
                    propertyModel.addTableModelListener(this);
                    propertyModel.addPropertyChangeListener(this);
                    propertyModel.setLocale(MultiObjectModel.this.getLocale());
                } else {
                    propertyModel.removePropertyChangeListener(this);
                    propertyModel.removeTableModelListener(this);
                }
                ++n2;
            }
        }

        private void _updateListeners(SelectionEvent selectionEvent, boolean bl) {
            SelectionModel selectionModel = selectionEvent.getSelectionModel();
            int n = selectionEvent.getStartIndex();
            int n2 = n + selectionEvent.getItemCount();
            int n3 = n;
            while (n3 < n2) {
                PropertyModel propertyModel = (PropertyModel)selectionModel.getSelectedItem(n3);
                if (bl) {
                    propertyModel.addTableModelListener(this);
                    propertyModel.addPropertyChangeListener(this);
                    propertyModel.setLocale(MultiObjectModel.this.getLocale());
                } else {
                    propertyModel.removePropertyChangeListener(this);
                    propertyModel.removeTableModelListener(this);
                }
                ++n3;
            }
        }
    }
}

