/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.editors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.Locale;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.bali.ewt.chooser.color.ColorChoice;
import oracle.bali.ewt.chooser.color.ColorGrid;
import oracle.bali.ewt.chooser.color.ColorPalettePane;
import oracle.bali.inspector.ExtendedPropertyEditor;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.editors.ColorTableCellEditor;

public class ColorEditor
extends PropertyEditorSupport
implements ExtendedPropertyEditor,
PropertyEditorFactory {
    private static final int _PAINT_INSETS = 3;
    private static final Border _sBORDER = new EmptyBorder(8, 8, 8, 8);
    private Listener _listener;
    private TableCellRenderer _renderer;
    private ColorPalettePane _colorPalettePane;
    private JPanel _customEditor;
    private ColorGrid _tearOffEditor;
    private ColorTableCellEditor _cellEditor;

    public void setValue(Object object) {
        Color color = (Color)object;
        super.setValue(color);
        if (this._colorPalettePane != null) {
            this._colorPalettePane.setSelectedColor(color);
        }
        if (this._tearOffEditor != null) {
            try {
                this._tearOffEditor.setSelectedColor(color);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._tearOffEditor.setSelectedColor(null);
            }
        }
    }

    public boolean isPaintable() {
        return true;
    }

    public final void paintValue(Graphics graphics, Rectangle rectangle) {
        this.paintValue(this.getValue(), graphics, Locale.getDefault(), rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public String getJavaInitializationString() {
        return "new java.awt.Color(" + this.getAsText() + ")";
    }

    public final String getAsText() {
        return null;
    }

    public final void setAsText(String string) throws IllegalArgumentException {
    }

    public Component getCustomEditor() {
        if (this._customEditor == null) {
            ColorPalettePane colorPalettePane = new ColorPalettePane();
            colorPalettePane.setColorNameVisible(false);
            if (this._listener == null) {
                this._listener = new Listener();
            }
            colorPalettePane.addPropertyChangeListener(this._listener);
            this._colorPalettePane = colorPalettePane;
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(_sBORDER);
            jPanel.add("Center", (Component)colorPalettePane);
            this._customEditor = jPanel;
        }
        return this._customEditor;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Object textToValue(String string, Locale locale) throws IllegalArgumentException {
        return null;
    }

    public String valueToText(Object object, Locale locale) {
        return "null";
    }

    public void paintValue(Object object, Graphics graphics, Locale locale, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        Color color2 = (Color)object;
        graphics.setColor(Color.black);
        if (n3 > 20) {
            n3 = 20;
        }
        graphics.drawRect(n += 3, n2 += 3, n3 -= 6, n4 -= 6);
        graphics.setColor(color2);
        graphics.fillRect(n + 1, n2 + 1, n3 - 1, n4 - 1);
        graphics.setColor(color);
    }

    public boolean supportsSmallCustomEditor() {
        return true;
    }

    public Component getSmallCustomEditor() {
        if (this._tearOffEditor == null) {
            ColorGrid colorGrid = new ColorGrid();
            if (this._listener == null) {
                this._listener = new Listener();
            }
            colorGrid.addPropertyChangeListener(this._listener);
            this._tearOffEditor = colorGrid;
        }
        return this._tearOffEditor;
    }

    public Object getEditorValue() {
        return this.getValue();
    }

    public void setEditorValue(Object object) {
        this.setValue(object);
    }

    public boolean hasValueRenderer() {
        return true;
    }

    public TableCellRenderer getValueRenderer() {
        if (this._renderer == null) {
            this._renderer = new ValueRenderer();
        }
        return this._renderer;
    }

    public boolean hasInPlaceEditor() {
        return true;
    }

    public TableCellEditor getInPlaceEditor(Locale locale) {
        if (this._cellEditor == null) {
            this._cellEditor = new ColorTableCellEditor();
        }
        return this._cellEditor;
    }

    public boolean hasTearOffEditor() {
        return this.supportsSmallCustomEditor();
    }

    public Component getTearOffEditor() {
        return this.getSmallCustomEditor();
    }

    public boolean hasAdvancedEditor() {
        return this.supportsCustomEditor();
    }

    public Component getAdvancedEditor() {
        return this.getCustomEditor();
    }

    public ColorGrid getColorGrid() {
        Component component = this.getTearOffEditor();
        return this._tearOffEditor;
    }

    public ColorPalettePane getColorPalettePane() {
        Component component = this.getAdvancedEditor();
        return this._colorPalettePane;
    }

    public ColorChoice getColorChoice() {
        TableCellEditor tableCellEditor = this.getInPlaceEditor(Locale.getDefault());
        return this._cellEditor.getColorChoice();
    }

    private void _setValue(Object object) {
        super.setValue(object);
    }

    private class ValueRenderer
    extends DefaultTableCellRenderer {
        private ValueRenderer() {
        }

        public void paintComponent(Graphics graphics) {
            this.setValue(null);
            Rectangle rectangle = this.getBounds();
            rectangle.x = 0;
            rectangle.y = 0;
            Color color = graphics.getColor();
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(color);
            super.paintComponent(graphics);
            ColorEditor.this.paintValue(graphics, rectangle);
        }
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Color color = null;
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getSource() == ColorEditor.this._colorPalettePane) {
                color = ColorEditor.this._colorPalettePane.getSelectedColor();
            } else if (propertyChangeEvent.getSource() == ColorEditor.this._tearOffEditor) {
                color = ColorEditor.this._tearOffEditor.getSelectedColor();
            }
            ColorEditor.this._setValue(color);
        }
    }
}

