/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractButton;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.statusBar.StatusBar;
import oracle.bali.ewt.util.FocusUtils;
import oracle.bali.ewt.util.MenuUtils;
import oracle.bali.inspector.ColumnModel;
import oracle.bali.inspector.EmptyModel;
import oracle.bali.inspector.FocusHelper;
import oracle.bali.inspector.GroupCellHandler;
import oracle.bali.inspector.InspectorAppearance;
import oracle.bali.inspector.InspectorGroup;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.PropertyEditorHandler;
import oracle.bali.inspector.PropertyExpansionState;
import oracle.bali.inspector.PropertyFilterer;
import oracle.bali.inspector.PropertyGroup;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.SwitchingCellEditor;
import oracle.bali.inspector.TableResizer;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;

public class PropertyInspector
extends JComponent
implements Accessible {
    public static final String PROPERTY_EXPANDED_GROUPS = "expandedGroups";
    public static final String PROPERTY_CATEGORIZED = "categorized";
    public static final String PROPERTY_FIND_VISIBLE = "findVisible";
    public static final String PROPERTY_INTERSECTION = "intersection";
    public static final String PROPERTY_ALPHABETIZE_GROUP_PROPERTIES = "alphabetizeGroupProperties";
    public static final String PROPERTY_STATUS_VISIBLE = "statusVisible";
    public static final String PROPERTY_ACTION_COMPONENT = "actionComponent";
    public static final String PROPERTY_WRITE_ONLY = "writeOnlyIncluded";
    public static final String PROPERTY_READ_ONLY = "readOnlyIncluded";
    public static final String ID_UNION_INTERSECTION = "union";
    public static final String ID_FIND = "find";
    public static final String ID_CATEGORIZED_SORTED = "categorized";
    public static final String ID_UNPIN_PIN = "pin";
    protected static final String ICON_FIND = "find";
    protected static final String ICON_UNION = "union";
    protected static final String ICON_INTERSECTION = "intersection";
    protected static final String ICON_PIN = "link";
    protected static final String ICON_UNPIN = "unlink";
    protected static final String ICON_CATEGORIZED = "categorized";
    protected static final String ICON_ALPHABETIZED = "alphabetized";
    protected static final String ICON_FIND_NEXT = "findNext";
    protected static final String ICON_FIND_PREVIOUS = "findPrevious";
    private static final boolean _USE_LEAD;
    private static final Dimension _BUTTON_SIZE;
    private static final float _SPLITTER_LOCATION = 0.92f;
    static final String __PROPERTY_TARGET_NAME = "targetName";
    private static final String _KEY_FIND = "FIND";
    private static final String _KEY_UNION = "UNION";
    private static final String _KEY_INTERSECTION = "INTERSECTION";
    private static final String _KEY_UNPIN = "UNPIN";
    private static final String _KEY_PIN = "PIN";
    private static final String _FIND_NEXT_ID = "next";
    private static final String _FIND_PREVIOUS_ID = "previous";
    static final String _SORTED_ID = "sorted";
    private static final String _KEY_CATEGORIZED = "CATEGORIZED";
    private static final String _KEY_SORTED = "SORTED";
    private static final String __RESOURCE_BUNDLE = "oracle.bali.inspector.resource.InspectorBundle";
    private static final String _KEY_FIND_LABEL = "FIND_LABEL";
    private static final String _KEY_FIND_NEXT = "FIND_NEXT";
    private static final String _KEY_FIND_PREVIOUS = "FIND_PREVIOUS";
    private static final String _KEY_MULTIPLE_SELECTION = "MULTIPLE_SELECTION";
    private static final String _KEY_FIND_ERROR = "FIND_ERROR";
    private static final String _KEY_FIND_ERROR_TITLE = "FIND_ERROR_TITLE";
    private static Object[] _sDEFAULT_FIND_ARRAY;
    private boolean _readOnlyIncluded;
    private boolean _writeOnlyIncluded;
    private boolean _splitterSet;
    private SwitchingCellEditor _editingInputHandler;
    private InspectorGroup _group;
    private ColumnModel _columnModel;
    private JTextArea _statusText;
    private ExtendedTable _table;
    private JPanel _findArea;
    private Listener _listener;
    private JTextField _findText;
    private JLabel _findLabel;
    private AbstractButton _findPreviousItem;
    private AbstractButton _findNextItem;
    private JSplitPane _splitter;
    private JScrollPane _tableScrollBox;
    private JScrollPane _statusTextScrollBox;
    private transient GroupCellHandler _groupCellHandler;
    private PropertyEditorHandler _propertyEditorHandler;
    private JToggleButton _findItem;
    private MultiIconButton _categorizedItem;
    private MultiIconButton _unionItem;
    private MultiIconButton _pinItem;
    private Component _actionToolBar;
    private transient JPanel _toolbarLabelArea;
    private boolean _statusDisplayed;
    private boolean _alphabetizeGroups;
    private JLabel _accessibleLabel;
    static /* synthetic */ Class class$oracle$bali$inspector$PropertyInspector;

    public PropertyInspector() {
        this(new InspectorGroup());
    }

    public PropertyInspector(InspectorGroup inspectorGroup) {
        this.setInspectorGroup(inspectorGroup);
        this._editingInputHandler = new SwitchingCellEditor(this);
        this._propertyEditorHandler = new PropertyEditorHandler(this, this._editingInputHandler);
        this._groupCellHandler = new GroupCellHandler(this);
        this._listener = new Listener();
        this.setLayout(new BorderLayout(0, 2));
        this._table = new ExtendedTable();
        this._table.getSelectionModel().addListSelectionListener(this._listener);
        this._table.setAutoCreateColumnsFromModel(false);
        this._table.setAutoResizeMode(4);
        this._statusText = new JTextArea(){

            public Color getBackground() {
                return UIManager.getColor("control");
            }
        };
        this._statusText.setFont(this._table.getFont());
        this._statusText.setEditable(false);
        this._statusText.setWrapStyleWord(true);
        this._statusText.setLineWrap(true);
        this._statusText.addFocusListener(this._listener);
        this._tableScrollBox = new JScrollPane(this._table, 20, 31);
        this._tableScrollBox.getViewport().addMouseListener(this._listener);
        this._tableScrollBox.addMouseListener(this._listener);
        this._statusTextScrollBox = new JScrollPane(this._statusText, 20, 31);
        this._splitter = new Splitter((Component)this._tableScrollBox, (Component)this._statusTextScrollBox);
        this.add("Center", this._splitter);
        this._statusDisplayed = true;
        this.add("North", this._buildTitleArea());
        this._columnModel = new ColumnModel();
        this._table.setColumnModel(this._columnModel);
        this.setUnderlyingPropertyModel(new EmptyModel());
        this.setColumnWidth(PropertyModel.COLUMN_DISPLAY_NAME, 160);
        this.setColumnWidth(PropertyModel.COLUMN_VALUE, 180);
        this._table.setPreferredScrollableViewportSize(new Dimension(340, 400));
        this.setColumnRenderer(PropertyModel.COLUMN_DISPLAY_NAME, this._groupCellHandler);
        this.setColumnEditor(PropertyModel.COLUMN_DISPLAY_NAME, this._groupCellHandler);
        this.setColumnRenderer(PropertyModel.COLUMN_VALUE, this._propertyEditorHandler);
        this.setColumnEditor(PropertyModel.COLUMN_VALUE, this._propertyEditorHandler);
        this.updateUI();
    }

    public void setVisibleColumns(Object[] objectArray) {
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        this._columnModel.setVisibleColumnIDs(objectArray);
    }

    public Object[] getVisibleColumns() {
        return this._columnModel.getVisibleColumnIDs();
    }

    public void setUnderlyingPropertyModel(PropertyModel propertyModel) {
        PropertyModel propertyModel2;
        if (propertyModel == null) {
            propertyModel = new EmptyModel();
        }
        if ((propertyModel2 = this.getUnderlyingPropertyModel()) == propertyModel) {
            return;
        }
        this.__commitEdit();
        boolean bl = this.isIntersection();
        boolean bl2 = this.isCategorized();
        PropertyFilterer propertyFilterer = null;
        PropertyFilterer propertyFilterer2 = null;
        String string = null;
        String string2 = null;
        Object[] objectArray = null;
        Object[] objectArray2 = null;
        Object[] objectArray3 = null;
        if (propertyModel2 != null) {
            propertyFilterer = this._getPropertyFilterer();
            objectArray = propertyFilterer.__getFilteredColumns();
            objectArray2 = propertyFilterer.__getFilteredValues();
            objectArray3 = propertyFilterer.__getFilteredDefaults();
            string = propertyFilterer.getTargetDisplayName();
            propertyFilterer.removeTableModelListener(this._listener);
            propertyFilterer.removePropertyChangeListener(this._listener);
            propertyFilterer.disposeFilterer();
        }
        propertyFilterer2 = new PropertyFilterer(propertyModel, this);
        propertyFilterer2.addPropertyChangeListener(this._listener);
        this._columnModel.setPropertyModel(propertyFilterer2);
        this.getPropertyTable().setModel(propertyFilterer2);
        this.getPropertyTable().getSelectionModel().removeListSelectionListener(this._listener);
        this.getPropertyTable().setSelectionModel(new ImmutableSelectionModel());
        this.getPropertyTable().getSelectionModel().addListSelectionListener(this._listener);
        propertyFilterer2.addTableModelListener(this._listener);
        propertyFilterer2.setReadOnlyIncluded(this.isReadOnlyIncluded());
        propertyFilterer2.setWriteOnlyIncluded(this.isWriteOnlyIncluded());
        propertyFilterer2.setAlphabetizeGroupProperties(this.isAlphabetizeGroupProperties());
        if (objectArray != null) {
            propertyFilterer2.setFilterInfo(objectArray, objectArray2, objectArray3);
        }
        Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
        propertyFilterer2.setLocale(locale);
        propertyFilterer2.setUseIntersection(bl);
        string2 = propertyFilterer2.getTargetDisplayName();
        int n = bl2 ? 2 : 1;
        propertyFilterer2.setSortMode(n);
        this._updateCaches(true);
        this._propertyEditorHandler.clear();
        this.repaint();
        this.firePropertyChange(__PROPERTY_TARGET_NAME, string, string2);
    }

    public PropertyModel getUnderlyingPropertyModel() {
        PropertyFilterer propertyFilterer = this._getPropertyFilterer();
        if (propertyFilterer != null) {
            return propertyFilterer.getFilteredModel();
        }
        return null;
    }

    public final PropertyModel getPropertyModel() {
        return this._getPropertyFilterer();
    }

    public void setInspectorGroup(InspectorGroup inspectorGroup) {
        if (inspectorGroup == null) {
            inspectorGroup = new InspectorGroup();
        }
        if (inspectorGroup != this._group) {
            if (this._group != null) {
                this._group.removeInspector(this);
            }
            this._group = inspectorGroup;
            if (inspectorGroup != null) {
                this._group.addInspector(this);
            }
        }
    }

    public InspectorGroup getInspectorGroup() {
        return this._group;
    }

    public void setColumnRenderer(Object object, TableCellRenderer tableCellRenderer) {
        Object object2;
        if (object == PropertyModel.COLUMN_DISPLAY_NAME && !(tableCellRenderer instanceof GroupCellHandler)) {
            object2 = this.getColumnEditor(PropertyModel.COLUMN_DISPLAY_NAME);
            this._groupCellHandler = new GroupCellHandler(this, tableCellRenderer, (TableCellEditor)object2);
            tableCellRenderer = this._groupCellHandler;
            this.setColumnEditor(PropertyModel.COLUMN_DISPLAY_NAME, this._groupCellHandler);
            this._updateCaches(true);
        }
        object2 = this._columnModel.getTableColumn(object);
        ((TableColumn)object2).setCellRenderer(tableCellRenderer);
        this.getPropertyTable().repaint();
    }

    public TableCellRenderer getColumnRenderer(Object object) {
        TableColumn tableColumn = this._columnModel.getTableColumn(object);
        TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
        if (object == PropertyModel.COLUMN_DISPLAY_NAME && tableCellRenderer instanceof GroupCellHandler) {
            tableCellRenderer = ((GroupCellHandler)tableCellRenderer).getDefaultRenderer();
        }
        return tableCellRenderer;
    }

    public void setColumnEditor(Object object, TableCellEditor tableCellEditor) {
        Object object2;
        if (object == PropertyModel.COLUMN_DISPLAY_NAME && !(tableCellEditor instanceof GroupCellHandler)) {
            object2 = this.getColumnRenderer(PropertyModel.COLUMN_DISPLAY_NAME);
            this._groupCellHandler = new GroupCellHandler(this, (TableCellRenderer)object2, tableCellEditor);
            tableCellEditor = this._groupCellHandler;
            this.setColumnRenderer(object, this._groupCellHandler);
            this._updateCaches(true);
        }
        object2 = this._columnModel.getTableColumn(object);
        ((TableColumn)object2).setCellEditor(tableCellEditor);
        this.getPropertyTable().repaint();
    }

    public TableCellEditor getColumnEditor(Object object) {
        TableColumn tableColumn = this._columnModel.getTableColumn(object);
        TableCellEditor tableCellEditor = tableColumn.getCellEditor();
        if (object == PropertyModel.COLUMN_DISPLAY_NAME && tableCellEditor instanceof GroupCellHandler) {
            tableCellEditor = ((GroupCellHandler)tableCellEditor).getDefaultEditor();
        }
        return tableCellEditor;
    }

    public void setColumnWidth(Object object, int n) {
        TableColumn tableColumn = this._columnModel.getTableColumn(object);
        tableColumn.setWidth(n);
        tableColumn.setPreferredWidth(n);
    }

    public int getColumnWidth(Object object) {
        TableColumn tableColumn = this._columnModel.getTableColumn(object);
        if (tableColumn.getModelIndex() != -1) {
            return tableColumn.getWidth();
        }
        return -1;
    }

    public JTable getPropertyTable() {
        return this._table;
    }

    public void setWriteOnlyIncluded(boolean bl) {
        if (this._writeOnlyIncluded != bl) {
            this._writeOnlyIncluded = bl;
            PropertyFilterer propertyFilterer = this._getPropertyFilterer();
            if (propertyFilterer != null) {
                propertyFilterer.setWriteOnlyIncluded(bl);
            }
            this.firePropertyChange(PROPERTY_WRITE_ONLY, !this._writeOnlyIncluded, this._writeOnlyIncluded);
        }
    }

    public boolean isWriteOnlyIncluded() {
        return this._writeOnlyIncluded;
    }

    public void setReadOnlyIncluded(boolean bl) {
        if (this._readOnlyIncluded != bl) {
            this._readOnlyIncluded = bl;
            PropertyFilterer propertyFilterer = this._getPropertyFilterer();
            if (propertyFilterer != null) {
                propertyFilterer.setReadOnlyIncluded(bl);
            }
            this.firePropertyChange(PROPERTY_READ_ONLY, !this._readOnlyIncluded, this._readOnlyIncluded);
        }
    }

    public boolean isReadOnlyIncluded() {
        return this._readOnlyIncluded;
    }

    public void setColumnFilter(Object object, Object object2, Object object3) {
        PropertyFilterer propertyFilterer = this._getPropertyFilterer();
        if (propertyFilterer != null) {
            propertyFilterer.setColumnFilter(object, object2, object3);
        }
    }

    public Object getFilterValue(Object object) {
        PropertyFilterer propertyFilterer = this._getPropertyFilterer();
        return propertyFilterer != null ? propertyFilterer.getFilterValue(object) : PropertyModel.DOES_NOT_EXIST;
    }

    public Object getFilterDefaultValue(Object object) {
        PropertyFilterer propertyFilterer = this._getPropertyFilterer();
        return propertyFilterer != null ? propertyFilterer.getFilterDefaultValue(object) : PropertyModel.DOES_NOT_EXIST;
    }

    public void setStatusText(String string) {
        this._statusText.setText(string);
        this._statusText.setCaretPosition(0);
    }

    public String getStatusText() {
        return this._statusText.getText();
    }

    public PropertyGroup[] getExpandedGroups() {
        PropertyFilterer propertyFilterer = this._getPropertyFilterer();
        return propertyFilterer == null ? null : propertyFilterer.getGroups(true);
    }

    public void setExpandedGroups(PropertyGroup[] propertyGroupArray) {
        PropertyFilterer propertyFilterer = this._getPropertyFilterer();
        if (propertyGroupArray == null) {
            propertyGroupArray = new PropertyGroup[]{};
        }
        if (propertyFilterer != null) {
            propertyFilterer.setGroups(propertyGroupArray, true);
        }
    }

    public boolean isGroupExpanded(PropertyGroup propertyGroup) {
        PropertyFilterer propertyFilterer = this._getPropertyFilterer();
        return propertyFilterer == null ? false : propertyFilterer.isGroupExpanded(propertyGroup);
    }

    public void setGroupExpanded(PropertyGroup propertyGroup, boolean bl) {
        PropertyFilterer propertyFilterer = this._getPropertyFilterer();
        if (propertyFilterer != null) {
            propertyFilterer.setGroupExpanded(propertyGroup, bl);
        }
    }

    public PropertyGroup[] getCollapsedGroups() {
        PropertyFilterer propertyFilterer = this._getPropertyFilterer();
        return propertyFilterer == null ? null : propertyFilterer.getGroups(false);
    }

    public void setCollapsedGroups(PropertyGroup[] propertyGroupArray) {
        PropertyFilterer propertyFilterer = this._getPropertyFilterer();
        if (propertyGroupArray == null) {
            propertyGroupArray = new PropertyGroup[]{};
        }
        if (propertyFilterer != null) {
            propertyFilterer.setGroups(propertyGroupArray, false);
        }
    }

    public boolean isCategorized() {
        PropertyFilterer propertyFilterer = this._getPropertyFilterer();
        return propertyFilterer == null ? true : propertyFilterer.isSorted() == 2;
    }

    public void setCategorized(boolean bl) {
        if (this.isCategorized() != bl) {
            this.__commitEdit();
            int n = bl ? 2 : 1;
            this._updateCategorizedItem(bl);
            PropertyFilterer propertyFilterer = this._getPropertyFilterer();
            if (propertyFilterer != null) {
                propertyFilterer.setSortMode(n);
            }
            this.firePropertyChange("categorized", !bl, bl);
        }
    }

    public boolean isFindVisible() {
        return this._findArea.isVisible();
    }

    public void setFindVisible(boolean bl) {
        if (this.isFindVisible() != bl) {
            this._findArea.setVisible(bl);
            if (bl) {
                this._findText.selectAll();
                this._findText.requestFocus();
            } else {
                this._findText.transferFocus();
            }
            this._findItem.setSelected(bl);
            this.revalidate();
            this.firePropertyChange(PROPERTY_FIND_VISIBLE, !bl, bl);
        }
    }

    public boolean isIntersection() {
        PropertyFilterer propertyFilterer = this._getPropertyFilterer();
        return propertyFilterer == null ? false : propertyFilterer.getUseIntersection();
    }

    public void setIntersection(boolean bl) {
        if (this.isIntersection() != bl) {
            this.__commitEdit();
            PropertyFilterer propertyFilterer = this._getPropertyFilterer();
            if (propertyFilterer != null) {
                propertyFilterer.setUseIntersection(bl);
            }
            this._updateIntersectionItem(bl);
            this.firePropertyChange("intersection", !bl, bl);
        }
    }

    public void setActionToolBar(JToolBar jToolBar) {
        this.setActionComponent(jToolBar);
    }

    public JToolBar getActionToolBar() {
        Component component = this.getActionComponent();
        return component instanceof JToolBar ? (JToolBar)component : null;
    }

    public void setActionComponent(Component component) {
        if (this._actionToolBar != component) {
            Component component2 = this._actionToolBar;
            if (this._actionToolBar != null) {
                this._toolbarLabelArea.remove(this._actionToolBar);
            }
            this._actionToolBar = component;
            if (this._actionToolBar != null) {
                this._toolbarLabelArea.add("North", this._actionToolBar);
            }
            this.firePropertyChange(PROPERTY_ACTION_COMPONENT, component2, this._actionToolBar);
        }
    }

    public Component getActionComponent() {
        return this._actionToolBar;
    }

    public AbstractButton getStandardToolBarItem(String string) {
        if ("union".equals(string)) {
            return this._unionItem;
        }
        if ("categorized".equals(string)) {
            return this._categorizedItem;
        }
        if ("find".equals(string)) {
            return this._findItem;
        }
        if (ID_UNPIN_PIN.equals(string)) {
            return this._pinItem;
        }
        return null;
    }

    public void setStatusVisible(boolean bl) {
        if (this._statusDisplayed != bl) {
            this._statusDisplayed = bl;
            if (this._statusDisplayed) {
                this.remove(this._tableScrollBox);
                this._splitter.setTopComponent(this._tableScrollBox);
                this.add("Center", this._splitter);
            } else {
                this.remove(this._splitter);
                this._splitter.setTopComponent(null);
                this.add("Center", this._tableScrollBox);
            }
            this.firePropertyChange(PROPERTY_STATUS_VISIBLE, !this._statusDisplayed, this._statusDisplayed);
            this.revalidate();
        }
    }

    public boolean isStatusVisible() {
        return this._statusDisplayed;
    }

    public void setAlphabetizeGroupProperties(boolean bl) {
        if (this._alphabetizeGroups != bl) {
            this._alphabetizeGroups = bl;
            PropertyFilterer propertyFilterer = this._getPropertyFilterer();
            if (propertyFilterer != null) {
                propertyFilterer.setAlphabetizeGroupProperties(this._alphabetizeGroups);
            }
            this.firePropertyChange(PROPERTY_ALPHABETIZE_GROUP_PROPERTIES, !this._alphabetizeGroups, this._alphabetizeGroups);
        }
    }

    public boolean isAlphabetizeGroupProperties() {
        return this._alphabetizeGroups;
    }

    public void updateUI() {
        super.updateUI();
        this._splitterSet = false;
        this._groupCellHandler.updateUI();
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this._updateLabels(locale);
    }

    public void addNotify() {
        super.addNotify();
        this._updateLabels(this.getLocale());
    }

    public void doLayout() {
        super.doLayout();
        if (!this._splitterSet && this.getHeight() != 0) {
            this._splitter.setDividerLocation(0.92f);
            this._splitterSet = true;
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this._actionToolBar != null) {
            this._actionToolBar.setEnabled(bl);
        }
        this._pinItem.setEnabled(bl);
        this._findItem.setEnabled(bl);
        this._unionItem.setEnabled(bl);
        this._categorizedItem.setEnabled(bl);
        this._findText.setEnabled(bl);
        this._findLabel.setEnabled(bl);
        this._findPreviousItem.setEnabled(bl);
        this._findNextItem.setEnabled(bl);
        this._statusText.setEnabled(bl);
        this._splitter.setEnabled(bl);
        this._tableScrollBox.setEnabled(bl);
        this._tableScrollBox.getVerticalScrollBar().setEnabled(bl);
        this._statusTextScrollBox.setEnabled(bl);
        this._statusTextScrollBox.getVerticalScrollBar().setEnabled(bl);
        this.getPropertyTable().setEnabled(bl);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new Access();
            StatusBar statusBar = new StatusBar();
            this._accessibleLabel = new AccessLabel();
            statusBar.add(this._accessibleLabel);
            statusBar.setVisible(false);
            this.add("South", (Component)statusBar);
        }
        return this.accessibleContext;
    }

    public PropertyExpansionState[] getExpandedProperties() {
        PropertyFilterer propertyFilterer = this._getPropertyFilterer();
        return propertyFilterer == null ? null : propertyFilterer.getExpandedProperties();
    }

    public void setExpandedProperties(PropertyExpansionState[] propertyExpansionStateArray) {
        PropertyFilterer propertyFilterer = this._getPropertyFilterer();
        if (propertyFilterer != null) {
            propertyFilterer.setExpandedProperties(propertyExpansionStateArray);
        }
    }

    public final boolean showAdvancedEditor(int n) {
        PropertyModel propertyModel = this.getPropertyModel();
        if (!propertyModel.isPropertyWritable(n)) {
            return false;
        }
        Object object = propertyModel.getPropertyID(n);
        if (object != null && object != PropertyModel.DOES_NOT_EXIST) {
            PropertyEditorFactory propertyEditorFactory = propertyModel.getPropertyEditorFactory(n);
            return this._group.showAdvancedEditor(object, propertyEditorFactory, this);
        }
        return false;
    }

    protected final void showAdvancedEditorDialog(int n) {
        this.showAdvancedEditor(n);
    }

    protected int findText(PropertyModel propertyModel, String string, int n, boolean bl, Object[] objectArray) {
        int n2 = string.length();
        Collator collator = Collator.getInstance(this.getLocale());
        collator.setStrength(0);
        int n3 = propertyModel.getRowCount();
        int n4 = n;
        do {
            int n5 = 0;
            while (n5 < objectArray.length) {
                int n6 = propertyModel.getColumnIndex(objectArray[n5]);
                if (n6 != -1) {
                    Object object = propertyModel.getValueAt(n4, n6);
                    String string2 = null;
                    if (object instanceof String) {
                        string2 = (String)object;
                    }
                    if (string2 != null && string2.length() >= n2 && collator.equals(string, string2.substring(0, n2))) {
                        return n4;
                    }
                }
                ++n5;
            }
        } while ((n4 = PropertyInspector._nextRow(n4, bl, n3)) != n);
        return -1;
    }

    protected final void showTearOffEditorPalette(int n) {
        PropertyModel propertyModel = this.getPropertyModel();
        if (!propertyModel.isPropertyWritable(n)) {
            return;
        }
        Object object = propertyModel.getPropertyID(n);
        if (object != null && object != PropertyModel.DOES_NOT_EXIST) {
            PropertyEditorFactory propertyEditorFactory = propertyModel.getPropertyEditorFactory(n);
            this._group.showTearOffEditor(object, propertyEditorFactory, this);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    protected JPopupMenu getMenuForPropertyGroup(PropertyGroup propertyGroup, PropertyModel propertyModel, Object object) {
        return null;
    }

    protected JPopupMenu getMenuForRow(int n, PropertyModel propertyModel, Object object) {
        return null;
    }

    protected Icon getIcon(String string) {
        Image image = ImageUtils.getImageResource((Class)(class$oracle$bali$inspector$PropertyInspector == null ? (class$oracle$bali$inspector$PropertyInspector = PropertyInspector.class$("oracle.bali.inspector.PropertyInspector")) : class$oracle$bali$inspector$PropertyInspector), (String)("images/" + string + ".gif"));
        return new ImageIcon(image);
    }

    protected JTextField createFindTextField() {
        return new JTextField();
    }

    protected AbstractButton createFindNextButton() {
        JButton jButton = new JButton();
        jButton.setMargin(new Insets(0, 2, 0, 2));
        return jButton;
    }

    protected AbstractButton createFindPreviousButton() {
        JButton jButton = new JButton();
        jButton.setMargin(new Insets(0, 2, 0, 2));
        return jButton;
    }

    final String __getTargetDisplayName() {
        PropertyFilterer propertyFilterer = this._getPropertyFilterer();
        return propertyFilterer == null ? null : ((PropertyModel)propertyFilterer).getTargetDisplayName();
    }

    private void _fireAccessibleChange(String string) {
        if (this._accessibleLabel != null) {
            this._accessibleLabel.setText(string);
        }
    }

    private void _updateLabels(Locale locale) {
        if (this._findLabel == null) {
            return;
        }
        String string = this.__getTranslatedString(_KEY_FIND_LABEL);
        this._findLabel.setText(StringUtils.stripMnemonic((String)string));
        this._findLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        string = this.__getTranslatedString(_KEY_FIND_NEXT);
        this._findNextItem.setToolTipText(string);
        string = this.__getTranslatedString(_KEY_FIND_PREVIOUS);
        this._findPreviousItem.setToolTipText(string);
        PropertyFilterer propertyFilterer = this._getPropertyFilterer();
        if (propertyFilterer != null) {
            ((PropertyModel)propertyFilterer).setLocale(locale);
        }
    }

    private JPanel _buildTitleArea() {
        this._toolbarLabelArea = new JPanel(new BorderLayout());
        this._toolbarLabelArea.setBorder(new EmptyBorder(3, 3, 0, 3));
        String string = this.__getTranslatedString(_KEY_FIND);
        this._findItem = new ToggleButton(this.getIcon("find"));
        this._findItem.addItemListener(this._listener);
        this._findItem.setToolTipText(string);
        Icon[] iconArray = new Icon[]{this.getIcon("union"), this.getIcon("intersection")};
        string = this.__getTranslatedString(_KEY_UNION);
        this._unionItem = new MultiIconButton("union", iconArray);
        this._unionItem.addActionListener(this._listener);
        this._unionItem.setToolTipText(string);
        Icon[] iconArray2 = new Icon[]{this.getIcon(ICON_UNPIN), this.getIcon(ICON_PIN)};
        string = this.__getTranslatedString(_KEY_UNPIN);
        this._pinItem = new MultiIconButton(ID_UNPIN_PIN, iconArray2);
        this._pinItem.addActionListener(this._listener);
        this._pinItem.setToolTipText(string);
        Icon[] iconArray3 = new Icon[]{this.getIcon("categorized"), this.getIcon(ICON_ALPHABETIZED)};
        string = this.__getTranslatedString(_KEY_CATEGORIZED);
        this._categorizedItem = new MultiIconButton("categorized", iconArray3);
        this._categorizedItem.addActionListener(this._listener);
        this._categorizedItem.setToolTipText(string);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setBorder(new EmptyBorder(0, 0, 0, 0));
        jToolBar.add(this._findItem);
        jToolBar.add(this._unionItem);
        jToolBar.add(this._categorizedItem);
        this.setActionToolBar(jToolBar);
        this._findArea = this._buildFindArea();
        this._toolbarLabelArea.add("South", this._findArea);
        return this._toolbarLabelArea;
    }

    private JPanel _buildFindArea() {
        JPanel jPanel = new JPanel();
        jPanel.setVisible(false);
        jPanel.setLayout(new BorderLayout(3, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(5, 0));
        jPanel2.setBorder(new EmptyBorder(2, 0, 5, 2));
        JTextField jTextField = this.createFindTextField();
        jTextField.addActionListener(this._listener);
        this._findText = jTextField;
        String string = this.__getTranslatedString(_KEY_FIND_LABEL);
        this._findLabel = new JLabel(StringUtils.stripMnemonic((String)string));
        this._findLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this._findLabel.setLabelFor(this._findText);
        jPanel2.add("West", this._findLabel);
        jPanel2.add("Center", jTextField);
        string = this.__getTranslatedString(_KEY_FIND_NEXT);
        this._findNextItem = this.createFindNextButton();
        this._findNextItem.setIcon(this.getIcon(ICON_FIND_NEXT));
        this._findNextItem.setActionCommand(_FIND_NEXT_ID);
        this._findNextItem.setToolTipText(string);
        this._findNextItem.addActionListener(this._listener);
        string = this.__getTranslatedString(_KEY_FIND_PREVIOUS);
        this._findPreviousItem = this.createFindPreviousButton();
        this._findPreviousItem.setIcon(this.getIcon(ICON_FIND_PREVIOUS));
        this._findPreviousItem.setActionCommand(_FIND_PREVIOUS_ID);
        this._findPreviousItem.setToolTipText(string);
        this._findPreviousItem.addActionListener(this._listener);
        JPanel jPanel3 = new JPanel(new BorderLayout(3, 0));
        jPanel3.add("West", this._findNextItem);
        jPanel3.add("East", this._findPreviousItem);
        jPanel.add("Center", jPanel2);
        jPanel.add("East", jPanel3);
        return jPanel;
    }

    private void _updatePinState(boolean bl) {
        String string = bl ? this.__getTranslatedString(_KEY_PIN) : this.__getTranslatedString(_KEY_UNPIN);
        this._pinItem.setToolTipText(string);
        this._pinItem.setIconIndex(bl ? 1 : 0);
        this.getInspectorGroup().setInspectorPinned(this, bl);
    }

    private void _setIntersection(boolean bl) {
        this._updateIntersectionItem(bl);
        this.setIntersection(bl);
    }

    private void _updateIntersectionItem(boolean bl) {
        String string = bl ? this.__getTranslatedString(_KEY_INTERSECTION) : this.__getTranslatedString(_KEY_UNION);
        this._unionItem.setToolTipText(string);
        this._unionItem.setIconIndex(bl ? 1 : 0);
    }

    private void _setCategorized(boolean bl) {
        this._updateCategorizedItem(bl);
        this.setCategorized(bl);
    }

    private void _updateCategorizedItem(boolean bl) {
        String string = bl ? this.__getTranslatedString(_KEY_CATEGORIZED) : this.__getTranslatedString(_KEY_SORTED);
        this._categorizedItem.setToolTipText(string);
        this._categorizedItem.setIconIndex(bl ? 0 : 1);
    }

    private PropertyFilterer _getPropertyFilterer() {
        TableModel tableModel;
        if (this._table != null && (tableModel = this._table.getModel()) instanceof PropertyFilterer) {
            return (PropertyFilterer)tableModel;
        }
        return null;
    }

    String __getTranslatedString(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(__RESOURCE_BUNDLE, LocaleUtils.getDefaultableLocale((Component)this));
        return resourceBundle.getString(string);
    }

    private void _updateCaches(boolean bl) {
        if (bl) {
            PropertyModel propertyModel = this.getPropertyModel();
            int n = propertyModel.getColumnIndex(PropertyModel.COLUMN_EDITOR_FACTORY);
            int n2 = propertyModel.getColumnIndex(PropertyModel.COLUMN_LEVEL);
            int n3 = propertyModel.getColumnIndex(PropertyModel.COLUMN_VALUE);
            int n4 = propertyModel.getColumnIndex(PropertyModel.COLUMN_DISPLAY_NAME);
            int n5 = propertyModel.getColumnIndex(PropertyModel.COLUMN_IS_WRITABLE);
            int n6 = propertyModel.getColumnIndex(PropertyModel.COLUMN_IS_DRILLABLE);
            this._groupCellHandler.setIndicies(n2, n6);
            this._propertyEditorHandler.setIndicies(n3, n);
            ((ExtendedTable)this.getPropertyTable()).setIndicies(n4, n2, n3, n5);
        }
        this._editingInputHandler.init();
    }

    void __commitEdit() {
        TableCellEditor tableCellEditor = this.getPropertyTable().getCellEditor();
        if (tableCellEditor != null) {
            boolean bl = tableCellEditor.stopCellEditing();
        }
    }

    static final int __getAnchorSelectionIndex(ListSelectionModel listSelectionModel) {
        return _USE_LEAD ? listSelectionModel.getLeadSelectionIndex() : listSelectionModel.getAnchorSelectionIndex();
    }

    private static int _nextRow(int n, boolean bl, int n2) {
        if (bl) {
            if (++n == n2) {
                n = 0;
            }
        } else if (--n == -1) {
            n = n2 - 1;
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ GroupCellHandler access$500(PropertyInspector propertyInspector) {
        return propertyInspector._groupCellHandler;
    }

    static {
        String string = System.getProperty("java.version");
        _USE_LEAD = string == null || !string.startsWith("1.1") && !string.startsWith("1.2") && !string.startsWith("1.3") && !string.startsWith("1.4");
        _BUTTON_SIZE = new Dimension(26, 26);
        _sDEFAULT_FIND_ARRAY = new Object[]{PropertyModel.COLUMN_DISPLAY_NAME};
    }

    private class AccessLabel
    extends JLabel {
        private AccessLabel() {
        }

        public void setText(String string) {
            String string2 = this.getText();
            super.setText(string);
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleName", string2, string);
            }
        }
    }

    private class Access
    extends JComponent.AccessibleJComponent {
        private Access() {
            super(PropertyInspector.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }

    private class Splitter
    extends JSplitPane {
        public Splitter(Component component, Component component2) {
            super(0, component, component2);
            Class<?> clazz = this.getClass();
            try {
                Class[] classArray = new Class[]{Double.TYPE};
                Method method = clazz.getMethod("setResizeWeight", classArray);
                Object[] objectArray = new Object[]{new Double(1.0)};
                method.invoke((Object)this, objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void reshape(int n, int n2, int n3, int n4) {
            int n5 = this.getHeight();
            int n6 = this.getDividerLocation();
            super.reshape(n, n2, n3, n4);
            if (n5 != 0 && n6 != 0) {
                int n7 = this.getDividerLocation();
                int n8 = n5 - n6;
                n7 = n4 - n8;
                this.setDividerLocation(n7);
            } else if (!PropertyInspector.this._splitterSet) {
                this.setDividerLocation(0.92f);
                PropertyInspector.this._splitterSet = true;
            }
        }
    }

    private class MultiIconButton
    extends JButton {
        private int _index = 0;
        private Icon _image0;
        private Icon _image1;

        public MultiIconButton(String string, Icon[] iconArray) {
            super(iconArray[0]);
            this._image0 = iconArray[0];
            this._image1 = iconArray[1];
            this.setActionCommand(string);
        }

        public void updateUI() {
            super.updateUI();
            this.setPreferredSize(_BUTTON_SIZE);
            this.setMinimumSize(_BUTTON_SIZE);
            this.setMaximumSize(_BUTTON_SIZE);
        }

        public int getIconIndex() {
            return this._index;
        }

        public void setIconIndex(int n) {
            this._index = n;
            if (n == 0) {
                this.setIcon(this._image0);
            } else {
                this.setIcon(this._image1);
            }
        }
    }

    private class ToggleButton
    extends JToggleButton {
        public ToggleButton(Icon icon) {
            super(icon);
        }

        public void updateUI() {
            super.updateUI();
            this.setPreferredSize(_BUTTON_SIZE);
            this.setMinimumSize(_BUTTON_SIZE);
            this.setMaximumSize(_BUTTON_SIZE);
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    ItemListener,
    PropertyChangeListener,
    ListSelectionListener,
    TableModelListener,
    FocusListener {
        private Listener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            int n = PropertyInspector.this._statusText.getDocument().getLength();
            PropertyInspector.this._statusText.setCaretPosition(n);
            PropertyInspector.this._statusText.moveCaretPosition(0);
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (PropertyInspector.this.isEnabled()) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    JPopupMenu jPopupMenu = PropertyInspector.this.getMenuForRow(-1, PropertyInspector.this.getUnderlyingPropertyModel(), null);
                    if (jPopupMenu != null) {
                        MenuUtils.showPopupMenu((JPopupMenu)jPopupMenu, (Component)mouseEvent.getComponent(), (int)mouseEvent.getX(), (int)mouseEvent.getY());
                    }
                } else {
                    PropertyInspector.this.getPropertyTable().requestFocus();
                }
            }
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            PropertyInspector.this._updateCaches(true);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = PropertyInspector.this.getPropertyTable().getSelectedRow();
            if (n == -1) {
                PropertyInspector.this.setStatusText(null);
            } else if (PropertyInspector.this.getPropertyTable().getSelectedRowCount() == 1) {
                PropertyModel propertyModel = PropertyInspector.this.getPropertyModel();
                PropertyInspector.this.setStatusText(propertyModel.getPropertyDescription(n));
            } else {
                PropertyInspector.this.setStatusText(PropertyInspector.this.__getTranslatedString(PropertyInspector._KEY_MULTIPLE_SELECTION));
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("targetDisplayName".equals(propertyChangeEvent.getPropertyName())) {
                PropertyModel propertyModel = (PropertyModel)propertyChangeEvent.getSource();
                PropertyInspector.this.firePropertyChange(PropertyInspector.__PROPERTY_TARGET_NAME, propertyChangeEvent.getOldValue(), propertyModel.getTargetDisplayName());
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            PropertyInspector.this.setFindVisible(PropertyInspector.this._findItem.isSelected());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if ("union".equals(string)) {
                PropertyInspector.this._setIntersection(PropertyInspector.this._unionItem.getIconIndex() == 0);
            } else if ("categorized".equals(string)) {
                boolean bl = PropertyInspector.this._categorizedItem.getIconIndex() == 0;
                PropertyInspector.this._setCategorized(!bl);
            } else if (PropertyInspector.ID_UNPIN_PIN.equals(string)) {
                PropertyInspector.this._updatePinState(PropertyInspector.this._pinItem.getIconIndex() == 0);
            } else if (PropertyInspector._FIND_NEXT_ID.equals(string) || PropertyInspector._FIND_PREVIOUS_ID.equals(string)) {
                this._findText(PropertyInspector.this._findText.getText(), PropertyInspector._FIND_NEXT_ID.equals(string));
            } else {
                this._findText(PropertyInspector.this._findText.getText(), true);
            }
        }

        private void _findText(String string, boolean bl) {
            PropertyModel propertyModel = PropertyInspector.this.getPropertyModel();
            if (propertyModel == null) {
                return;
            }
            int n = propertyModel.getRowCount();
            if (n == 0) {
                return;
            }
            int n2 = string.length();
            if (n2 == 0) {
                return;
            }
            JTable jTable = PropertyInspector.this.getPropertyTable();
            int n3 = jTable.getSelectedRow();
            n3 = n3 != -1 ? PropertyInspector._nextRow(n3, bl, n) : (bl ? 0 : n - 1);
            int n4 = PropertyInspector.this.findText(propertyModel, string, n3, bl, _sDEFAULT_FIND_ARRAY);
            if (n4 != -1) {
                jTable.setRowSelectionInterval(n4, n4);
                int n5 = jTable.getColumnCount() - 1;
                jTable.setColumnSelectionInterval(n5, n5);
                jTable.scrollRectToVisible(jTable.getCellRect(n4, 0, false));
                String string2 = propertyModel.getPropertyDisplayName(n4);
                if (string2 instanceof String) {
                    PropertyInspector.this._fireAccessibleChange(string2.toString());
                }
            } else {
                String string3 = PropertyInspector.this.__getTranslatedString(PropertyInspector._KEY_FIND_ERROR);
                String string4 = PropertyInspector.this.__getTranslatedString(PropertyInspector._KEY_FIND_ERROR_TITLE);
                MessageFormat messageFormat = new MessageFormat(string3);
                Object[] objectArray = new Object[]{string};
                string3 = messageFormat.format(objectArray);
                JOptionPane.showMessageDialog(jTable, string3, string4, 1);
            }
        }
    }

    private class ImmutableSelectionModel
    extends DefaultListSelectionModel {
        private ImmutableSelectionModel() {
        }

        public void clearSelection() {
            if (PropertyInspector.this.isEnabled()) {
                super.clearSelection();
            }
        }

        public void addSelectionInterval(int n, int n2) {
            if (PropertyInspector.this.isEnabled()) {
                super.addSelectionInterval(n, n2);
            }
        }

        public void insertIndexInterval(int n, int n2, boolean bl) {
            if (PropertyInspector.this.isEnabled()) {
                super.insertIndexInterval(n, n2, bl);
            }
        }

        public void removeIndexInterval(int n, int n2) {
            if (PropertyInspector.this.isEnabled()) {
                super.removeIndexInterval(n, n2);
            }
        }

        public void setSelectionInterval(int n, int n2) {
            if (PropertyInspector.this.isEnabled()) {
                super.setSelectionInterval(n, n2);
            }
        }

        public void setAnchorSelectionIndex(int n) {
            if (PropertyInspector.this.isEnabled()) {
                super.setAnchorSelectionIndex(n);
            }
        }

        public void setLeadSelectionIndex(int n) {
            if (PropertyInspector.this.isEnabled()) {
                super.setLeadSelectionIndex(n);
            }
        }
    }

    class ExtendedTable
    extends JTable {
        private boolean _inEditingStopped = false;
        private TableResizer _resizer;
        private InspectorAppearance _appearance;
        private FocusHelper _focusHelper;

        public ExtendedTable() {
            this.setTableHeader(null);
            this._appearance = new InspectorAppearance(this);
            this.putClientProperty("terminateEditOnFocusLost", Boolean.FALSE);
            this._focusHelper = new FocusHelper(this);
        }

        public void paint(Graphics graphics) {
            PropertyInspector.this.getPropertyModel().startRead();
            try {
                super.paint(graphics);
                Object var3_2 = null;
                PropertyInspector.this.getPropertyModel().stopRead();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                PropertyInspector.this.getPropertyModel().stopRead();
                throw throwable;
            }
        }

        public boolean getSurrendersFocusOnKeystroke() {
            return true;
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            String string = super.getToolTipText(mouseEvent);
            if (string != null && !"".equals(string) && !string.equals(this.getToolTipText())) {
                return string;
            }
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            int n = this.rowAtPoint(point);
            int n2 = this.columnAtPoint(point);
            if (n2 < 0 || n2 >= this.getColumnCount() || n < 0 || n >= this.getRowCount()) {
                return null;
            }
            TableCellRenderer tableCellRenderer = this.getCellRenderer(n, n2);
            Component component = this.prepareRenderer(tableCellRenderer, n, n2);
            Dimension dimension = component.getPreferredSize();
            int n3 = this.getColumnModel().getColumn(n2).getWidth();
            int n4 = this.getColumnModel().getColumnMargin() * 2;
            if (dimension.width + n4 >= n3) {
                String string2;
                Object object;
                int n5;
                PropertyModel propertyModel;
                Object object2 = this.getValueAt(n, n2);
                if (!(object2 instanceof String) && (propertyModel = (PropertyModel)this.getModel()).getColumnIndex(PropertyModel.COLUMN_VALUE) == n2 && (n5 = propertyModel.getColumnIndex(PropertyModel.COLUMN_DISPLAY_VALUE)) != -1 && (object = propertyModel.getValueAt(n, n5)) != null && !"".equals(string2 = object.toString())) {
                    return string2;
                }
                return object2 == null ? null : object2.toString();
            }
            return null;
        }

        public void updateUI() {
            if (this._resizer != null) {
                this._resizer.dispose();
            }
            this._resizer = new TableResizer(this);
            super.updateUI();
            FocusUtils.setFocusTraversalKeysEnabled((Component)this, (boolean)false);
            ActionListener actionListener = new ActionListener(this){
                private final /* synthetic */ ExtendedTable this$1;
                {
                    this.this$1 = extendedTable;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ListSelectionModel listSelectionModel = this.this$1.getSelectionModel();
                    int n = PropertyInspector.__getAnchorSelectionIndex(listSelectionModel);
                    ListSelectionModel listSelectionModel2 = this.this$1.getColumnModel().getSelectionModel();
                    int n2 = PropertyInspector.__getAnchorSelectionIndex(listSelectionModel2);
                    this.this$1.editCellAt(n, n2);
                }
            };
            KeyStroke keyStroke = KeyStroke.getKeyStroke(113, 0);
            this.registerKeyboardAction(actionListener, keyStroke, 1);
            ActionListener actionListener2 = new ActionListener(this){
                private final /* synthetic */ ExtendedTable this$1;
                {
                    this.this$1 = extendedTable;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = this.this$1.getEditingColumn();
                    int n2 = this.this$1.getEditingRow();
                    if (n != -1 && n2 != -1) {
                        ExtendedTable.access$400(this.this$1).__commitEdit();
                    } else {
                        ListSelectionModel listSelectionModel = this.this$1.getColumnModel().getSelectionModel();
                        int n3 = PropertyInspector.__getAnchorSelectionIndex(listSelectionModel);
                        TableColumn tableColumn = this.this$1.getColumnModel().getColumn(n3);
                        if (tableColumn.getIdentifier() == PropertyModel.COLUMN_DISPLAY_NAME) {
                            ListSelectionModel listSelectionModel2 = this.this$1.getSelectionModel();
                            int n4 = PropertyInspector.__getAnchorSelectionIndex(listSelectionModel2);
                            PropertyModel propertyModel = ExtendedTable.access$400(this.this$1).getPropertyModel();
                            if (PropertyInspector.access$500(ExtendedTable.access$400(this.this$1)).__cellHasChildren(propertyModel, n4)) {
                                boolean bl = !PropertyInspector.access$500(ExtendedTable.access$400(this.this$1)).__isCellExpanded(propertyModel, n4);
                                PropertyInspector.access$500(ExtendedTable.access$400(this.this$1)).__setCellExpanded(propertyModel, n4, bl);
                            }
                        }
                    }
                }
            };
            keyStroke = KeyStroke.getKeyStroke(10, 0);
            this.registerKeyboardAction(actionListener2, keyStroke, 1);
            keyStroke = KeyStroke.getKeyStroke(10, 1);
            this.unregisterKeyboardAction(keyStroke);
            ActionListener actionListener3 = new ActionListener(this){
                private final /* synthetic */ ExtendedTable this$1;
                {
                    this.this$1 = extendedTable;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ListSelectionModel listSelectionModel = this.this$1.getSelectionModel();
                    int n = PropertyInspector.__getAnchorSelectionIndex(listSelectionModel);
                    ListSelectionModel listSelectionModel2 = this.this$1.getColumnModel().getSelectionModel();
                    int n2 = PropertyInspector.__getAnchorSelectionIndex(listSelectionModel2);
                    Rectangle rectangle = this.this$1.getCellRect(n, n2, true);
                    ExtendedTable.access$600(this.this$1, n2, n, rectangle.x + rectangle.width / 3, rectangle.y + rectangle.height / 2);
                }
            };
            keyStroke = KeyStroke.getKeyStroke(121, 1);
            this.registerKeyboardAction(actionListener3, keyStroke, 0);
        }

        public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
            Component component = super.prepareRenderer(tableCellRenderer, n, n2);
            boolean bl = this.isCellSelected(n, n2);
            boolean bl2 = PropertyInspector.__getAnchorSelectionIndex(this.getSelectionModel()) == n;
            boolean bl3 = PropertyInspector.__getAnchorSelectionIndex(this.columnModel.getSelectionModel()) == n2;
            boolean bl4 = bl2 && bl3 && this.hasFocus();
            this._appearance.prepareRenderer(this, bl, bl4, n, n2, component);
            return component;
        }

        public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
            Component component = super.prepareEditor(tableCellEditor, n, n2);
            if (component != null) {
                SwingUtilities.updateComponentTreeUI(component);
            }
            return component;
        }

        public void columnMarginChanged(ChangeEvent changeEvent) {
            PropertyInspector.this.__commitEdit();
            super.columnMarginChanged(changeEvent);
        }

        public void sizeColumnsToFit(int n) {
            if (n == -1) {
                n = this.getColumnCount() - 1;
            }
            super.sizeColumnsToFit(n);
        }

        public boolean editCellAt(int n, int n2, EventObject eventObject) {
            Component component;
            boolean bl = super.editCellAt(n, n2, eventObject);
            if (bl && (component = this.getEditorComponent()) != null && (eventObject == null || eventObject instanceof KeyEvent)) {
                component.requestFocus();
            }
            return bl;
        }

        public void removeEditor() {
            TableCellEditor tableCellEditor = this.getCellEditor();
            if (tableCellEditor != null) {
                boolean bl;
                tableCellEditor.removeCellEditorListener(this);
                boolean bl2 = bl = SwingUtilities.findFocusOwner(this) != null;
                if (this.editorComp != null) {
                    this._focusHelper.remove(this.editorComp);
                }
                if (bl) {
                    this.requestFocus();
                }
                Rectangle rectangle = this.getCellRect(this.editingRow, this.editingColumn, false);
                this.setCellEditor(null);
                this.setEditingColumn(-1);
                this.setEditingRow(-1);
                this.editorComp = null;
                this.repaint(rectangle);
            }
        }

        public void editingStopped(ChangeEvent changeEvent) {
            int n = this.getEditingRow();
            int n2 = this.getEditingColumn();
            Rectangle rectangle = this.getVisibleRect();
            try {
                int n3;
                this._inEditingStopped = true;
                this._real_editingStopped(changeEvent);
                Object var6_5 = null;
                this._inEditingStopped = false;
                if (n >= 0 && n2 >= 0 && n < this.getRowCount() && n2 < this.getColumnCount() && (n3 = this.getSelectedRow()) != n) {
                    this.changeSelection(n, n2, false, false);
                }
                if (rectangle != null) {
                    this.scrollRectToVisible(rectangle);
                }
            }
            catch (Throwable throwable) {
                int n4;
                Object var6_6 = null;
                this._inEditingStopped = false;
                if (n >= 0 && n2 >= 0 && n < this.getRowCount() && n2 < this.getColumnCount() && (n4 = this.getSelectedRow()) != n) {
                    this.changeSelection(n, n2, false, false);
                }
                if (rectangle != null) {
                    this.scrollRectToVisible(rectangle);
                }
                throw throwable;
            }
        }

        public void scrollRectToVisible(Rectangle rectangle) {
            if (!this._inEditingStopped) {
                super.scrollRectToVisible(rectangle);
            }
        }

        private void _real_editingStopped(ChangeEvent changeEvent) {
            Object object;
            int n = this.getEditingColumn();
            if (n == -1) {
                return;
            }
            n = PropertyInspector.this._columnModel.getColumn(n).getModelIndex();
            int n2 = PropertyInspector.this.getPropertyModel().getColumnIndex(PropertyModel.COLUMN_VALUE);
            PropertyModel propertyModel = (PropertyModel)this.getModel();
            int n3 = this.getEditingRow();
            Object object2 = object = propertyModel.getPropertyValue(n3);
            TableCellEditor tableCellEditor = this.getCellEditor();
            if (tableCellEditor != null) {
                object2 = tableCellEditor.getCellEditorValue();
            }
            if (n != n2) {
                if (n == PropertyInspector.this.getPropertyModel().getColumnIndex(PropertyModel.COLUMN_DISPLAY_NAME)) {
                    super.editingCanceled(changeEvent);
                    return;
                }
                try {
                    super.editingStopped(changeEvent);
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    Object object3 = propertyModel.getPropertyID(n3);
                    PropertyEditorFactory propertyEditorFactory = propertyModel.getPropertyEditorFactory(n3);
                    PropertyInspector.this.getInspectorGroup().showErrorMessage(object3, propertyEditorFactory, PropertyInspector.this, throwable, object2);
                }
                propertyModel.invalidateValueData();
                return;
            }
            if (!propertyModel.isSettable(object, object2) && !propertyModel.isDataConflicting(n2, n3)) {
                this.removeEditor();
            } else {
                try {
                    super.editingStopped(changeEvent);
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    Object object4 = propertyModel.getPropertyID(n3);
                    PropertyEditorFactory propertyEditorFactory = propertyModel.getPropertyEditorFactory(n3);
                    PropertyInspector.this.getInspectorGroup().showErrorMessage(object4, propertyEditorFactory, PropertyInspector.this, throwable, object2);
                }
                propertyModel.invalidateValueData();
            }
        }

        public void setIndicies(int n, int n2, int n3, int n4) {
            this._appearance.setIndicies(n, n2, n3, n4);
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            if (!this.isEnabled() || mouseEvent.getID() != 501 || !SwingUtilities.isRightMouseButton(mouseEvent)) {
                return;
            }
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            int n = this.columnAtPoint(point);
            int n2 = this.rowAtPoint(point);
            if (n == -1 || n2 == -1) {
                return;
            }
            this._showMenu(n, n2, mouseEvent.getX(), mouseEvent.getY());
        }

        PropertyInspector __getInspector() {
            return PropertyInspector.this;
        }

        private void _showMenu(int n, int n2, int n3, int n4) {
            TableColumn tableColumn = this.getColumnModel().getColumn(n);
            Object object = tableColumn.getIdentifier();
            PropertyFilterer propertyFilterer = PropertyInspector.this._getPropertyFilterer();
            int n5 = propertyFilterer.getModelIndex(n2);
            JPopupMenu jPopupMenu = null;
            if (n5 >= 0) {
                jPopupMenu = PropertyInspector.this.getMenuForRow(n5, PropertyInspector.this.getUnderlyingPropertyModel(), object);
            } else {
                PropertyGroup propertyGroup = propertyFilterer.getPropertyGroupAtIndex(n5);
                jPopupMenu = PropertyInspector.this.getMenuForPropertyGroup(propertyGroup, PropertyInspector.this.getUnderlyingPropertyModel(), object);
            }
            if (jPopupMenu != null) {
                MenuUtils.showPopupMenu((JPopupMenu)jPopupMenu, (Component)this, (int)n3, (int)n4);
            }
        }

        static /* synthetic */ PropertyInspector access$400(ExtendedTable extendedTable) {
            return extendedTable.PropertyInspector.this;
        }

        static /* synthetic */ void access$600(ExtendedTable extendedTable, int n, int n2, int n3, int n4) {
            extendedTable._showMenu(n, n2, n3, n4);
        }
    }
}

