/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.util.Enumeration;
import java.util.NoSuchElementException;

class IntVector
implements Cloneable {
    private int[] _elementData;
    private int _elementCount;
    private int _capacityIncrement;

    public IntVector() {
        this(0);
    }

    public IntVector(int n) {
        this(n, 0);
    }

    public IntVector(int n, int n2) {
        this._elementData = new int[n];
        this._capacityIncrement = n2;
    }

    public final synchronized void copyInto(int[] nArray) {
        System.arraycopy(this._elementData, 0, nArray, 0, this._elementCount);
    }

    public final synchronized void trimToSize() {
        int n = this._elementData.length;
        if (this._elementCount < n) {
            int[] nArray = this._elementData;
            this._elementData = new int[this._elementCount];
            System.arraycopy(nArray, 0, this._elementData, 0, this._elementCount);
        }
    }

    public final synchronized void ensureCapacity(int n) {
        if (n > this._elementData.length) {
            this._ensureCapacityHelper(n);
        }
    }

    public final synchronized void setSize(int n) {
        if (n > this._elementCount && n > this._elementData.length) {
            this._ensureCapacityHelper(n);
        }
        this._elementCount = n;
    }

    public final int capacity() {
        return this._elementData.length;
    }

    public final int size() {
        return this._elementCount;
    }

    public final boolean isEmpty() {
        return this._elementCount == 0;
    }

    public final synchronized Enumeration elements() {
        return new VectorEnumerator();
    }

    public final boolean contains(int n) {
        return this.indexOf(n, 0) >= 0;
    }

    public final int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public final synchronized int indexOf(int n, int n2) {
        int n3 = n2;
        while (n3 < this._elementCount) {
            if (n == this._elementData[n3]) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public final int lastIndexOf(int n) {
        return this.lastIndexOf(n, this._elementCount - 1);
    }

    public final synchronized int lastIndexOf(int n, int n2) {
        int n3 = n2;
        while (n3 >= 0) {
            if (n == this._elementData[n3]) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public final synchronized int elementAt(int n) {
        if (n >= this._elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this._elementCount);
        }
        return this._elementData[n];
    }

    public final synchronized int firstElement() {
        if (this._elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this._elementData[0];
    }

    public final synchronized int lastElement() {
        if (this._elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this._elementData[this._elementCount - 1];
    }

    public final synchronized void setElementAt(int n, int n2) {
        if (n2 >= this._elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this._elementCount);
        }
        this._elementData[n2] = n;
    }

    public final synchronized void removeElementAt(int n) {
        if (n >= this._elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this._elementCount);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this._elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this._elementData, n + 1, this._elementData, n, n2);
        }
        --this._elementCount;
    }

    public final synchronized void insertElementAt(int n, int n2) {
        int n3 = this._elementCount + 1;
        if (n2 >= n3) {
            throw new ArrayIndexOutOfBoundsException(n2 + " > " + this._elementCount);
        }
        if (n3 > this._elementData.length) {
            this._ensureCapacityHelper(n3);
        }
        System.arraycopy(this._elementData, n2, this._elementData, n2 + 1, this._elementCount - n2);
        this._elementData[n2] = n;
        ++this._elementCount;
    }

    public final synchronized void addElement(int n) {
        int n2 = this._elementCount + 1;
        if (n2 > this._elementData.length) {
            this._ensureCapacityHelper(n2);
        }
        this._elementData[this._elementCount++] = n;
    }

    public final synchronized boolean removeElement(int n) {
        int n2 = this.indexOf(n);
        if (n2 >= 0) {
            this.removeElementAt(n2);
            return true;
        }
        return false;
    }

    public final synchronized void removeAllElements() {
        this._elementCount = 0;
    }

    public synchronized Object clone() {
        try {
            IntVector intVector = (IntVector)super.clone();
            intVector._elementData = new int[this._elementCount];
            System.arraycopy(this._elementData, 0, intVector._elementData, 0, this._elementCount);
            return intVector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.elements();
        stringBuffer.append("[");
        int n2 = 0;
        while (n2 <= n) {
            String string = enumeration.nextElement().toString();
            stringBuffer.append(string);
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void _ensureCapacityHelper(int n) {
        int n2;
        int n3 = this._elementData.length;
        int[] nArray = this._elementData;
        int n4 = n2 = this._capacityIncrement > 0 ? n3 + this._capacityIncrement : n3 * 2;
        if (n2 < n) {
            n2 = n;
        }
        this._elementData = new int[n2];
        System.arraycopy(nArray, 0, this._elementData, 0, this._elementCount);
    }

    private class VectorEnumerator
    implements Enumeration {
        private IntVector _vector;
        private int _count = 0;

        public boolean hasMoreElements() {
            return this._count < IntVector.this._elementCount;
        }

        public Object nextElement() {
            IntVector intVector = IntVector.this;
            synchronized (intVector) {
                if (this._count < IntVector.this._elementCount) {
                    Integer n = new Integer(IntVector.this._elementData[this._count++]);
                    return n;
                }
            }
            throw new NoSuchElementException("VectorEnumerator");
        }
    }
}

