/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.engine;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.URL;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.TopicTree;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.engine.DataEngine;
import oracle.help.library.Book;

public class HHCEngine
extends DataEngine {
    protected StreamTokenizer _st = null;
    protected View _view;
    protected Book _book;
    protected static final String HHC_TOKEN_START = "<";
    protected static final String HHC_TOKEN_END = ">";
    protected static final String HHC_TOKEN_OBJECT = "object";
    protected static final String HHC_TOKEN_ENDOBJECT = "/object";
    protected static final String HHC_TOKEN_SUBTREE = "ul";
    protected static final String HHC_TOKEN_ENDSUBTREE = "/ul";
    protected static final String HHC_TOKEN_SITEMAP = "text/sitemap";
    protected static final String HHC_TOKEN_PARAM = "param";
    protected static final String HHC_TOKEN_PARAMNAME = "name=";
    protected static final String HHC_TOKEN_PARAMVALUE = "value=";
    protected static final String HHC_TOKEN_OBJTYPE = "type=";
    protected static final String HHC_PARAM_NAME = "name";
    protected static final String HHC_PARAM_LOCAL = "local";
    protected static final String HHC_PARAM_KEYWORD = "keyword";
    protected static final String HHC_PARAM_SECTION = "section title";
    protected static final String HHC_PARAM_TYPE = "type";

    public Object createDataObject(View view, String string, URL uRL, String string2) throws IOException {
        if (uRL == null) {
            throw new IllegalArgumentException("Null parameter passed to DataEngine constructor");
        }
        BufferedReader bufferedReader = this._getBufferedReader(uRL, string2);
        return this.createDataObject(view, string, bufferedReader);
    }

    public Object createDataObject(View view, String string, BufferedReader bufferedReader) throws IOException {
        String string2;
        this._view = view;
        if (this._view != null) {
            this._book = this._view.getBook();
        }
        HHCReader hHCReader = new HHCReader(bufferedReader);
        this._st = new StreamTokenizer(hHCReader);
        this._st.wordChars(47, 47);
        this._st.wordChars(61, 61);
        this._st.wordChars(48, 57);
        this._st.quoteChar(34);
        this._st.ordinaryChar(39);
        TopicTree topicTree = new TopicTree(this._book, string);
        TopicTreeNode topicTreeNode = topicTree.getRoot();
        while ((string2 = this.readToken()) != null) {
            if (!string2.equals(HHC_TOKEN_START)) continue;
            string2 = this.readToken();
            if (string2.equalsIgnoreCase(HHC_TOKEN_OBJECT)) {
                this.readObject(this._view, topicTreeNode);
                continue;
            }
            if (string2.equalsIgnoreCase(HHC_TOKEN_SUBTREE)) {
                if (topicTreeNode.getNumChildren() <= 0) continue;
                topicTreeNode = topicTreeNode.getChildByIndex(topicTreeNode.getNumChildren() - 1);
                continue;
            }
            if (!string2.equalsIgnoreCase(HHC_TOKEN_ENDSUBTREE) || topicTreeNode.getParent() == null) continue;
            topicTreeNode = topicTreeNode.getParent();
        }
        return topicTree;
    }

    protected void readObject(View view, TopicTreeNode topicTreeNode) throws IOException {
        String string;
        String string2 = null;
        String string3 = null;
        SimpleTopic simpleTopic = null;
        TopicTreeNode topicTreeNode2 = null;
        while (!(string = this.readToken()).equals(HHC_TOKEN_END)) {
            if (!string.equals(HHC_TOKEN_OBJTYPE) || (string = this.readToken()).equalsIgnoreCase(HHC_TOKEN_SITEMAP)) continue;
            return;
        }
        while (true) {
            if (!(string = this.readToken()).equals(HHC_TOKEN_START)) {
                continue;
            }
            string = this.readToken();
            if (string.equalsIgnoreCase(HHC_TOKEN_ENDOBJECT)) break;
            if (!string.equalsIgnoreCase(HHC_TOKEN_PARAM)) continue;
            string2 = null;
            string3 = null;
            string = this.readToken();
            while (!string.equals(HHC_TOKEN_END)) {
                if (string.equalsIgnoreCase(HHC_TOKEN_PARAMNAME)) {
                    string2 = this.readToken();
                } else if (string.equalsIgnoreCase(HHC_TOKEN_PARAMVALUE)) {
                    string3 = this.readToken();
                }
                string = this.readToken();
            }
            if (string2 == null || string3 == null) continue;
            if (string2.equalsIgnoreCase(HHC_PARAM_NAME)) {
                simpleTopic = new SimpleTopic(string3, this._book);
                topicTreeNode2 = new TopicTreeNode(this._view, simpleTopic);
                continue;
            }
            if (!string2.equalsIgnoreCase(HHC_PARAM_LOCAL)) continue;
            SimpleURLTarget simpleURLTarget = new SimpleURLTarget(this._view, string3);
            if (simpleTopic == null) continue;
            simpleTopic.setTarget(simpleURLTarget);
        }
        if (topicTreeNode2 != null) {
            topicTreeNode.addChild(topicTreeNode2);
        }
    }

    protected String readToken() throws IOException {
        int n = this._st.nextToken();
        switch (n) {
            case -3: 
            case 34: {
                return this._st.sval;
            }
            case -1: {
                return null;
            }
        }
        return "" + (char)n;
    }

    private class HHCReader
    extends Reader {
        Reader _realReader;
        boolean _wasBackSlash = false;

        public HHCReader(Reader reader) {
            this._realReader = reader;
        }

        public int read() throws IOException {
            int n;
            if (this._wasBackSlash) {
                n = 92;
                this._wasBackSlash = false;
            } else {
                n = this._realReader.read();
                if ((char)n == '\\') {
                    this._wasBackSlash = true;
                }
            }
            return n;
        }

        public int read(char[] cArray) throws IOException {
            return this.read(cArray, 0, cArray.length);
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = n;
            int n4 = 0;
            int n5 = 0;
            while (n4 < n2 && n4 + n3 < cArray.length) {
                n5 = this.read();
                if (n5 == -1) break;
                cArray[n3 + n4] = (char)n5;
                ++n4;
            }
            if (n4 == 0 && n5 == -1) {
                return -1;
            }
            return n4;
        }

        public long skip(long l) throws IOException {
            return super.skip(l);
        }

        public boolean ready() throws IOException {
            return this._realReader.ready();
        }

        public boolean markSupported() {
            return this._realReader.markSupported();
        }

        public void mark(int n) throws IOException {
            this._realReader.mark(n);
        }

        public void reset() throws IOException {
            this._wasBackSlash = false;
            this._realReader.reset();
        }

        public void close() throws IOException {
            this._realReader.close();
        }
    }
}

