/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.binding;

import java.awt.Component;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.adf.model.binding.DCDataControl;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.adf.model.binding.DCUtil;
import oracle.adf.model.generic.RowImpl;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeHints;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InsertEvent;
import oracle.jbo.InvalidOperException;
import oracle.jbo.InvalidParamException;
import oracle.jbo.JboException;
import oracle.jbo.NavigationEvent;
import oracle.jbo.RangeRefreshEvent;
import oracle.jbo.Row;
import oracle.jbo.RowIterator;
import oracle.jbo.RowNotAvailableException;
import oracle.jbo.RowSetIterator;
import oracle.jbo.RowSetListener;
import oracle.jbo.RowSetManagementEvent;
import oracle.jbo.RowSetManagementListener;
import oracle.jbo.ScrollEvent;
import oracle.jbo.UpdateEvent;
import oracle.jbo.ViewCriteria;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JboAbstractMap;
import oracle.jbo.domain.TypeFactory;
import oracle.jbo.uicli.binding.JUCtrlAttrsBinding;
import oracle.jbo.uicli.binding.JUCtrlListBindingChangeEvent;
import oracle.jbo.uicli.binding.JUCtrlListBindingChangeListener;
import oracle.jbo.uicli.binding.JUCtrlValueBinding;
import oracle.jbo.uicli.binding.JUIteratorBinding;

public class JUCtrlListBinding
extends JUCtrlAttrsBinding
implements RowSetManagementListener,
RowSetListener {
    public static int LIST_OPER_SET_ATTRIBUTE = 0;
    public static int LIST_OPER_NAVIGATE = 1;
    private int mListOperMode;
    protected boolean mSingleAttrList;
    public static final int LIST_ADD_NULL_UNINIT = -1;
    public static final int LIST_ADD_NULL_NOWHERE = 0;
    public static final int LIST_ADD_NULL_AT_START = 1;
    public static final int LIST_ADD_NULL_AT_END = 2;
    protected int mNullValueFlag;
    private int mNullValueIndex;
    protected Object[] mValueList;
    private int mSelectedIndex;
    private boolean mListNotExecuting;
    protected String[] mListAttrNames;
    protected String[] mListDisplayAttrNames;
    private AttributeDef[] mDisplayAttrs;
    private static final String ATTR_SELECTED_INDEX = "selectedIndex";
    protected DCIteratorBinding mListIterBinding;
    protected boolean mStaticList;
    private boolean mListPrepared;
    protected AttributeDef mFirstDisplayAttr;
    private static final String ATTR_DISPLAY_HINTS = "displayHints";
    private static final String ATTR_DISPLAY_DATA = "displayData";
    public static final String LISTITEM_Selected = "selected";
    public static final String LISTITEM_Index = "index";
    public static final String LISTITEM_Prompt = "prompt";
    public static final String LISTITEM_DisplayValues = "displayValues";
    public static final String LISTITEM_SelectedIndex = "selectedIndex";
    public static final String DH_LABEL = "label";
    public static final String DH_TOOLTIP = "tooltip";
    public static final String DH_DISPLAY_HINT = "displayHint";
    public static final String DH_DISPLAY_HEIGHT = "displayHeight";
    public static final String DH_DISPLAY_WIDTH = "displayWidth";
    public static final String DH_CONTROL_TYPE = "controlType";
    public static final String DH_FORMAT = "format";
    JUCtrlListBinding thisBindingObj;
    JUCtrlListBindingItemRef[] currentSetRef;
    public static final int LOV_SRC_ATTRNAMES = 0;
    public static final int LOV_SRC_ROW_DATA = 1;
    public static final int LOV_SRC_EL_EXPR = 2;
    private int mLovSrcOption;
    private ArrayList listenerList;
    private transient Object valueNotFound;
    private static /* synthetic */ Class class$java$lang$Integer;
    private static /* synthetic */ Class class$oracle$jbo$uicli$UIMessageBundle;
    private static /* synthetic */ Class class$oracle$jbo$uicli$binding$JUVariableIteratorBinding;

    private /* synthetic */ void $init$() {
        this.mListOperMode = LIST_OPER_SET_ATTRIBUTE;
        this.mSingleAttrList = true;
        this.mNullValueFlag = -1;
        this.mNullValueIndex = -1;
        this.mValueList = null;
        this.mSelectedIndex = -1;
        this.mListNotExecuting = true;
        this.mListIterBinding = null;
        this.mStaticList = false;
        this.mListPrepared = false;
        this.thisBindingObj = null;
        this.listenerList = null;
        this.valueNotFound = null;
    }

    protected JUCtrlListBinding() {
        this.$init$();
    }

    public JUCtrlListBinding(Object object, DCIteratorBinding dCIteratorBinding, String[] stringArray, int n) {
        super(object, dCIteratorBinding, stringArray);
        this.$init$();
        this.mListAttrNames = stringArray;
        this.mListDisplayAttrNames = stringArray;
        this.mListOperMode = n;
        if (n == LIST_OPER_NAVIGATE) {
            this.mListIterBinding = dCIteratorBinding;
            this.mListDisplayAttrNames = stringArray;
            if (dCIteratorBinding != null) {
                dCIteratorBinding.setAllowFindMode(false);
            }
        }
        this.mSingleAttrList = stringArray == null || stringArray.length == 1;
    }

    public JUCtrlListBinding(Object object, DCIteratorBinding dCIteratorBinding, String[] stringArray, Object[] objectArray) {
        super(object, dCIteratorBinding, stringArray);
        this.$init$();
        this.mListAttrNames = stringArray;
        this.mListDisplayAttrNames = stringArray;
        this.mStaticList = true;
        this.mListPrepared = false;
        this.setValueList(objectArray);
        this.mSingleAttrList = stringArray == null || stringArray.length == 1;
    }

    protected JUCtrlListBinding(Object object, DCIteratorBinding dCIteratorBinding, String[] stringArray, DCIteratorBinding dCIteratorBinding2, String[] stringArray2, String[] stringArray3) {
        super(object, dCIteratorBinding, stringArray);
        this.$init$();
        if (stringArray2 == null) {
            throw new InvalidParamException("JUCtrlListBinding()", "listAttrNames", (Object)"", "Edit list binding definition and fill in the list details.");
        }
        if (stringArray3 == null) {
            stringArray3 = stringArray2;
        }
        if (stringArray3 == null) {
            stringArray3 = this.getAttributeNames();
            stringArray2 = stringArray3;
        }
        this.mListAttrNames = stringArray2;
        this.mListDisplayAttrNames = stringArray3;
        this.mListIterBinding = dCIteratorBinding2;
        if (dCIteratorBinding2 != null) {
            dCIteratorBinding2.setAllowFindMode(false);
        }
        if (stringArray2 != null && stringArray2.length > 0) {
            int n = stringArray2.length;
            String string = stringArray2[0];
            if (n == 1 && "DataProvider".equalsIgnoreCase(string)) {
                this.mLovSrcOption = 1;
            } else if (n > 0 && DCUtil.isElExpr((String)string)) {
                this.mLovSrcOption = 2;
            }
        }
        this.mSingleAttrList = stringArray3 != null && stringArray3.length == 1 && stringArray.length == 1 && stringArray3[0].equals(stringArray[0]) && stringArray2.length == 1 && stringArray3[0].equals(stringArray2[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setupListItems(boolean bl, boolean bl2) {
        boolean bl3 = true;
        try {
            block26: {
                RowSetIterator rowSetIterator;
                if (this.mStaticList) {
                    if (this.mValueList == null) {
                        this.mValueList = new Object[0];
                    } else if (!this.mListPrepared) {
                        this.convertValueList();
                    }
                    Object var14_4 = null;
                    this.mListPrepared = bl3;
                    return;
                }
                RowSetIterator rowSetIterator2 = rowSetIterator = this.mListIterBinding != null ? this.mListIterBinding.getRowSetIterator() : null;
                if (this.mSingleAttrList) {
                    this.setValueList(this.getAttrValuesFromRSI());
                    this.convertValueList();
                } else {
                    boolean bl4 = false;
                    try {
                        block25: {
                            try {
                                RowSetIterator rowSetIterator3;
                                if (rowSetIterator == null && this.mListAttrNames.length > 0 && (rowSetIterator3 = this.getIteratorBinding().getRowSetIterator()) != null && rowSetIterator3.getRowSet() != null) {
                                    rowSetIterator = rowSetIterator3.getRowSet().createRowSetIterator(null);
                                    bl4 = true;
                                }
                                if (rowSetIterator != null) {
                                    if (this.mListIterBinding == null || this.mListIterBinding.getRangeSize() < 2) {
                                        rowSetIterator.setRangeSize(-1);
                                    }
                                    Object[] objectArray = null;
                                    try {
                                        if (this.mListIterBinding != null && this.mListIterBinding.refreshIfNeeded()) {
                                            objectArray = rowSetIterator.getAllRowsInRange();
                                        }
                                    }
                                    catch (RowNotAvailableException rowNotAvailableException) {
                                        bl3 = false;
                                        Object var12_14 = null;
                                        if (bl4) {
                                            rowSetIterator.closeRowSetIterator();
                                        }
                                        Object var14_5 = null;
                                        this.mListPrepared = bl3;
                                        return;
                                    }
                                    catch (InvalidOperException invalidOperException) {
                                        bl3 = false;
                                        Object var12_15 = null;
                                        if (bl4) {
                                            rowSetIterator.closeRowSetIterator();
                                        }
                                        Object var14_6 = null;
                                        this.mListPrepared = bl3;
                                        return;
                                    }
                                    if (this.hasNullValue()) {
                                        this.addNullAndSetValueList(objectArray);
                                    } else {
                                        this.mNullValueIndex = -1;
                                        this.setValueList(objectArray);
                                    }
                                    rowSetIterator.addListener((Object)this);
                                    if (rowSetIterator == null) break block25;
                                    rowSetIterator.addManagementListener((RowSetManagementListener)this);
                                    break block25;
                                }
                                this.setValueList(new Object[0]);
                            }
                            catch (Exception exception) {
                                Diagnostic.printStackTrace((Throwable)exception);
                                this.reportException(exception);
                                Object var12_17 = null;
                                if (bl4) {
                                    rowSetIterator.closeRowSetIterator();
                                }
                                break block26;
                            }
                        }
                        Object var12_16 = null;
                        if (!bl4) break block26;
                    }
                    catch (Throwable throwable) {
                        Object var12_18 = null;
                        if (!bl4) throw throwable;
                        rowSetIterator.closeRowSetIterator();
                        throw throwable;
                    }
                    rowSetIterator.closeRowSetIterator();
                }
            }
            if (this.currentSetRef != null && this.mValueList != null) {
                this.currentSetRef = new JUCtrlListBindingItemRef[this.mValueList.length];
            }
        }
        catch (Throwable throwable) {
            Object var14_8 = null;
            this.mListPrepared = bl3;
            throw throwable;
        }
        Object var14_7 = null;
        this.mListPrepared = bl3;
    }

    public DCIteratorBinding getListIterBinding() {
        return this.mListIterBinding;
    }

    public int getListOperMode() {
        return this.mListOperMode;
    }

    void setListDisplayAttrNames(String[] stringArray) {
        this.mListDisplayAttrNames = stringArray;
    }

    public String[] getListDisplayAttrNames() {
        return this.mListDisplayAttrNames;
    }

    public void setListOperMode(int n) {
        this.mListOperMode = n;
    }

    void setSingleAttrList(boolean bl) {
        this.mSingleAttrList = bl;
    }

    public boolean isSingleAttrList() {
        return this.mSingleAttrList;
    }

    void setLovSourceOption(int n) {
        this.mLovSrcOption = n;
    }

    public void setValueList(Object[] objectArray) {
        this.mValueList = objectArray;
    }

    public void addNullAndSetValueList(Object[] objectArray) {
        int n;
        int n2 = objectArray == null ? 0 : objectArray.length;
        Object[] objectArray2 = new Object[n2 + 1];
        if (this.mNullValueFlag == 1) {
            this.mNullValueIndex = 0;
            objectArray2[0] = this.getNullValueString();
            n = 1;
        } else {
            this.mNullValueIndex = n2;
            objectArray2[n2] = this.getNullValueString();
            n = 0;
        }
        if (objectArray != null) {
            System.arraycopy(objectArray, 0, objectArray2, n, n2);
        }
        this.setValueList(objectArray2);
    }

    public boolean hasNullValue() {
        return this.getNullValueFlag() > 0;
    }

    public int getNullValueIndex() {
        return this.mNullValueIndex;
    }

    protected final int getNullValueFlag() {
        return this.mNullValueFlag;
    }

    protected void setNullValueProperties(int n) {
        if (this.mListOperMode != LIST_OPER_NAVIGATE) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: {
                    this.mNullValueFlag = n;
                    break;
                }
                default: {
                    if (Diagnostic.isOn()) {
                        Diagnostic.println((String)"Ignoring improper flag sent in for setNullValueFlag.");
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else {
            Diagnostic.println((String)"Ignoring improper flag sent in for setNullValueFlag for navigation list.");
        }
    }

    public void convertValueList() {
        Class clazz;
        AttributeDef[] attributeDefArray;
        if (this.mSingleAttrList && (attributeDefArray = this.getAttributeDefs()) != null && attributeDefArray.length > 0 && (clazz = attributeDefArray[0].getJavaType()) != null && this.mValueList != null) {
            boolean bl = this.hasNullValue();
            int n = this.mValueList.length;
            int n2 = 0;
            Object[] objectArray = new Object[n];
            if (bl) {
                if (this.mNullValueFlag == 1) {
                    this.mNullValueIndex = 0;
                    n2 = 1;
                    objectArray[0] = this.mValueList[0];
                    this.setNullValueString(objectArray[0] != null ? objectArray[0].toString() : this.getNullValueString());
                } else {
                    --n;
                }
            }
            while (n2 < n) {
                Object object = this.mValueList[n2];
                objectArray[n2] = object != null && !clazz.isInstance(object) ? TypeFactory.getInstance((Class)clazz, (Object)object) : object;
                ++n2;
            }
            if (bl && this.mNullValueFlag == 2) {
                this.mNullValueIndex = n2;
                objectArray[n2] = this.mValueList[n2];
                this.setNullValueString(objectArray[n2] != null ? objectArray[n2].toString() : this.getNullValueString());
            }
            this.mValueList = objectArray;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAttrValueAccesible(Row row) {
        if (row != null) {
            return true;
        }
        JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
        if (jUIteratorBinding == null) return false;
        Class clazz = jUIteratorBinding.getClass();
        Class clazz2 = class$oracle$jbo$uicli$binding$JUVariableIteratorBinding;
        if (clazz2 == null) {
            clazz2 = class$oracle$jbo$uicli$binding$JUVariableIteratorBinding = JUCtrlListBinding.class$("oracle.jbo.uicli.binding.JUVariableIteratorBinding");
        }
        if (clazz != clazz2) return false;
        return true;
    }

    public int getSelectedIndex() {
        Row row;
        if (this.getControl() == null && this.isAttrValueAccesible(row = this.getCurrentRow())) {
            this.updateValuesFromRow(row);
        }
        return this.mSelectedIndex;
    }

    public void setSelectedIndex(int n) {
        RowIterator rowIterator;
        this.setSelectedIndexValue(n);
        if (this.mListOperMode != LIST_OPER_NAVIGATE) {
            this.setAttributeFromValueList(this.mSelectedIndex);
        } else if (n >= 0 && (rowIterator = this.getRowIterator()) != null && this.getIteratorBinding().getCurrentRowIndexInRange() != n) {
            this.getBindingContainer().callBeforeRowNavigated(this.getIteratorBinding());
            rowIterator.setCurrentRowAtRangeIndex(n);
        }
    }

    protected void setSelectedIndexValue(int n) {
        this.mSelectedIndex = n;
    }

    protected int getSelectedIndexValue() {
        return this.mSelectedIndex;
    }

    public Object getValueAt(int n) {
        return this.getAttribute(n);
    }

    public Object[] getValueList() {
        return this.mValueList;
    }

    public Iterator getDisplayListIterator() {
        ArrayList arrayList = new ArrayList();
        if (this.mSingleAttrList) {
            // empty if block
        }
        return arrayList.iterator();
    }

    public Object getSelectedValue() {
        return this.getValueFromList(this.mSelectedIndex);
    }

    Object getLovRowData(Row row, String string) {
        Object object = null;
        if (row != null) {
            switch (this.mLovSrcOption) {
                case 0: {
                    object = row.getAttribute(string);
                    break;
                }
                case 1: {
                    object = ((RowImpl)row).getDataProvider();
                    break;
                }
                default: {
                    object = DCUtil.elEvaluate(this.getBindingContainer().getBindingContext(), row, string);
                }
            }
        }
        return object;
    }

    protected boolean matchTargetWithLov(Row row, Row row2) {
        if (row == row2) {
            return true;
        }
        AttributeDef[] attributeDefArray = this.getAttributeDefs();
        boolean bl = true;
        int n = 0;
        while (n < attributeDefArray.length) {
            Object object = this.mLovSrcOption != 1 ? row.getAttribute(attributeDefArray[n].getIndex()) : row.getAttribute(attributeDefArray[n].getName());
            Object object2 = this.getLovRowData(row2, this.mListAttrNames[n]);
            if (!(object == null ? object2 == null : object.equals(object2) || object2 != null && object.getClass() != object2.getClass() && object.equals(TypeFactory.getInstance((Class)attributeDefArray[n].getJavaType(), (Object)object2)))) {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }

    protected int setListValueAsSelected(Object object) {
        boolean bl = false;
        if (this.mValueList != null) {
            int n = 0;
            while (n < this.mValueList.length) {
                if (object == this.mValueList[n]) {
                    this.mSelectedIndex = n;
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        if (!bl) {
            this.mSelectedIndex = -1;
        }
        return this.mSelectedIndex;
    }

    public Object findMatchingListValue(Object object) {
        return this.findAndUpdateSelectedIndex(object, false);
    }

    protected Object findAndUpdateSelectedIndex(Object object, boolean bl) {
        int n = this.findListIndex(object);
        Object object2 = null;
        if (n >= 0) {
            object2 = this.mValueList[n];
        }
        if (bl) {
            this.mSelectedIndex = n;
        }
        return object2;
    }

    public int findListIndex(Object object) {
        if (this.mValueList == null) {
            return -1;
        }
        int n = -1;
        if (this.mSingleAttrList) {
            AttributeDef[] attributeDefArray = this.getAttributeDefs();
            Class clazz = null;
            Class<?> clazz2 = null;
            if (attributeDefArray != null && attributeDefArray.length > 0) {
                clazz = attributeDefArray[0].getJavaType();
            }
            if (object != null) {
                clazz2 = object.getClass();
            }
            boolean bl = this.hasNullValue();
            int n2 = 0;
            while (n2 < this.mValueList.length) {
                block53: {
                    Object object2 = this.mValueList[n2];
                    if (object == object2) {
                        n = n2;
                        break;
                    }
                    if (object == null) {
                        if (object2 == null || bl && object2 == this.getNullValueString()) {
                            n = n2;
                            break;
                        }
                    } else if (clazz2.isInstance(object2)) {
                        if (object.equals(object2)) {
                            n = n2;
                            break;
                        }
                    } else {
                        if (clazz != null) {
                            try {
                                Object object3 = TypeFactory.getInstance((Class)clazz, (Object)object);
                                if (!object3.equals(object2)) break block53;
                                n = n2;
                                break;
                            }
                            catch (JboException jboException) {
                                if (this.getIteratorBinding().isFindMode()) {
                                    n = -1;
                                    break;
                                }
                                throw jboException;
                            }
                        }
                        if (object.equals(object2)) {
                            n = n2;
                            break;
                        }
                    }
                }
                ++n2;
            }
        } else {
            if (this.mListIterBinding != null) {
                boolean bl = true;
                RowSetIterator rowSetIterator = this.mListIterBinding.getRowSetIterator();
                if (rowSetIterator != null) {
                    Row row = rowSetIterator.getRowAtRangeIndex(0);
                    Row row2 = null;
                    if (this.mValueList != null && this.mValueList.length > 0) {
                        if (this.mNullValueIndex != 0) {
                            row2 = (Row)this.mValueList[0];
                        } else if (this.mValueList.length > 1) {
                            row2 = (Row)this.mValueList[1];
                        }
                    }
                    if (row != row2) {
                        this.setupListItems(true, false);
                        bl = false;
                    }
                }
                if (!(!bl || rowSetIterator != null && rowSetIterator.getCurrentRowSlot() == 0 || !this.mListNotExecuting || rowSetIterator != null && rowSetIterator.getRowSet() != null && rowSetIterator.getRowSet().isExecuted())) {
                    try {
                        this.mListNotExecuting = false;
                        this.mListIterBinding.executeQueryIfNeeded();
                        Object var25_15 = null;
                        this.mListNotExecuting = true;
                    }
                    catch (Throwable throwable) {
                        Object var25_16 = null;
                        this.mListNotExecuting = true;
                        throw throwable;
                    }
                }
            }
            if (object instanceof Row) {
                Row row = (Row)object;
                int n3 = 0;
                while (n3 < this.mValueList.length) {
                    Row row3;
                    Row row4 = row3 = n3 != this.mNullValueIndex ? (Row)this.mValueList[n3] : null;
                    if (object == null) {
                        if (row3 == null) {
                            n = n3;
                            break;
                        }
                    } else if (this.matchTargetWithLov(row, row3)) {
                        n = n3;
                        break;
                    }
                    ++n3;
                }
            } else {
                if (this.mFirstDisplayAttr == null) {
                    if (this.mListDisplayAttrNames.length > 0 && this.mListIterBinding != null) {
                        AttributeDef[] attributeDefArray = this.mListIterBinding.getAttributeDefs(this.mListDisplayAttrNames);
                        int n4 = 0;
                        while (n4 < attributeDefArray.length) {
                            if (this.mListDisplayAttrNames[0].equals(attributeDefArray[n4].getName())) {
                                this.mFirstDisplayAttr = attributeDefArray[n4];
                                break;
                            }
                            ++n4;
                        }
                    }
                    if (this.mFirstDisplayAttr == null) {
                        this.mFirstDisplayAttr = this.getAttributeDef(0);
                    }
                }
                if (object == this.getNullValueString()) {
                    n = this.mNullValueIndex;
                } else {
                    Class clazz = this.mFirstDisplayAttr.getJavaType();
                    int n5 = 0;
                    while (n5 < this.mValueList.length) {
                        block54: {
                            Row row;
                            Row row5 = row = n5 != this.mNullValueIndex ? (Row)this.mValueList[n5] : null;
                            if (object == null) {
                                if (row == null) {
                                    n = n5;
                                    break;
                                }
                                if (row.getAttribute(0) == null) {
                                    n = n5;
                                    break;
                                }
                            } else if (row != null) {
                                try {
                                    Object object4 = TypeFactory.getInstance((Class)clazz, (Object)object);
                                    if (object4 == null || !object4.equals(row.getAttribute(this.mFirstDisplayAttr.getIndex()))) break block54;
                                    n = n5;
                                    break;
                                }
                                catch (JboException jboException) {
                                    if (this.getIteratorBinding().isFindMode()) {
                                        n = -1;
                                        break;
                                    }
                                    throw jboException;
                                }
                            }
                        }
                        ++n5;
                    }
                }
            }
        }
        if (n < 0) {
            this.notifyValueNotFound(object);
        }
        return n;
    }

    private void notifyValueNotFound(Object object) {
        if (!(this.listenerList == null || object != null && object.equals(this.valueNotFound))) {
            this.valueNotFound = object;
            JUCtrlListBindingChangeEvent jUCtrlListBindingChangeEvent = new JUCtrlListBindingChangeEvent(this, object);
            int n = 0;
            while (n < this.listenerList.size()) {
                ((JUCtrlListBindingChangeListener)this.listenerList.get(n)).valueNotFound(jUCtrlListBindingChangeEvent);
                ++n;
            }
        }
    }

    public String toString() {
        String string = String.valueOf(this.getSelectedIndex());
        return string != null ? string.toString() : "";
    }

    public Object findValue(Object object) {
        if (this.mValueList == null || this.mValueList.length == 0) {
            return null;
        }
        return this.getValueFromList(this.findListIndex(object));
    }

    public Object getValueFromList(int n) {
        if (n >= 0 && n < this.mValueList.length) {
            return this.mValueList[n];
        }
        return null;
    }

    protected boolean isViewInitialized() {
        return true;
    }

    protected boolean isControlQueriable() {
        JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
        if (jUIteratorBinding != null && jUIteratorBinding.getDataControl() != null && !jUIteratorBinding.getDataControl().isJClientApp()) {
            return jUIteratorBinding.isFindModeAllowed();
        }
        return false;
    }

    public void updateValuesFromRow(Row row) {
        RowSetIterator rowSetIterator;
        DCDataControl dCDataControl;
        if (this.mValueList == null || !this.isViewInitialized() || !this.mListPrepared) {
            this.setupListItems(true, false);
        } else if (!(this.mListIterBinding == null || (dCDataControl = this.mListIterBinding.getDataControl()) == null || !dCDataControl.syncNeeded() || (rowSetIterator = this.mListIterBinding.getRowSetIterator()) != null && rowSetIterator.getCurrentRowSlot() == 0 || rowSetIterator != null && rowSetIterator.getRowSet() != null && rowSetIterator.getRowSet().isExecuted())) {
            Diagnostic.println((String)"List iterator has not been synced yet.");
            return;
        }
        if (this.mSingleAttrList) {
            Object object = this.getControl();
            boolean bl = false;
            if (object instanceof Component) {
                bl = this.mListOperMode == LIST_OPER_NAVIGATE && ((Component)object).isEnabled();
            }
            super.updateValuesFromRow(row);
            if (bl) {
                super.setControlEnabled(bl);
            }
            if (row != null) {
                this.setValueAt(row.getAttribute(this.getAttributeDef().getIndex()), 0);
            } else {
                this.setValueAt(this.getAttribute(), 0);
            }
        } else {
            Object object;
            this.setValueAt(row, -1);
            if (this.mListOperMode != LIST_OPER_NAVIGATE && (object = this.getControl()) instanceof Component) {
                boolean bl = true;
                int n = this.getAttributeCount();
                --n;
                while (bl && n >= 0) {
                    bl &= this.isAttributeUpdateable(n);
                    --n;
                }
                Component component = (Component)object;
                boolean bl2 = component.isEnabled();
                if (bl2 != bl) {
                    super.setControlEnabled(bl);
                }
            }
        }
    }

    protected void setTargetAttrsFromLovRow(Row row, Row row2) {
        AttributeDef[] attributeDefArray = this.getAttributeDefs();
        int n = this.mListAttrNames.length;
        int n2 = 0;
        while (n2 < n) {
            this.setAttributeInRow(row, attributeDefArray[n2], this.getLovRowData(row2, this.mListAttrNames[n2]));
            ++n2;
        }
        if (this.getIteratorBinding().getDataControl().isClientTier()) {
            JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
            int[] nArray = new int[n];
            --n;
            while (n >= 0) {
                nArray[n] = attributeDefArray[n].getIndex();
                --n;
            }
            jUIteratorBinding.rowUpdated(new UpdateEvent(jUIteratorBinding.getRowSetIterator(), row, -1, nArray));
        }
    }

    public void setAttributeFromValueList(int n) {
        try {
            Row row;
            if (this.getIteratorBinding() != null && this.isAttrValueAccesible(row = this.getCurrentRow())) {
                this.updateTargetFromSelectedValue(this.getValueFromList(n));
            }
        }
        catch (Exception exception) {
            this.reportException(exception);
        }
    }

    protected void updateTargetFromSelectedValue(Object object) {
        if (!this.isSingleAttrList()) {
            Row row;
            if (!(object instanceof Row) && object != null) {
                if ((object = this.findMatchingListValue(object)) == this.getNullValueString()) {
                    object = null;
                } else if (object == null && !this.getIteratorBinding().isFindMode()) {
                    Class clazz = class$oracle$jbo$uicli$UIMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$uicli$UIMessageBundle = JUCtrlListBinding.class$("oracle.jbo.uicli.UIMessageBundle");
                    }
                    this.reportException((Exception)((Object)new JboException(clazz, "34004", null)));
                }
            }
            if (this.getIteratorBinding() != null && (row = this.getCurrentRow()) != null) {
                this.setTargetAttrsFromLovRow(row, (Row)object);
            }
        } else {
            if (object == this.getNullValueString()) {
                object = null;
            }
            this.setAttribute(0, object);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object[] getAttrValuesFromRSI() {
        Object[] objectArray;
        RowSetIterator rowSetIterator;
        boolean bl;
        block17: {
            Object[] objectArray2;
            block16: {
                Object[] objectArray3;
                block15: {
                    bl = false;
                    rowSetIterator = this.mListIterBinding != null ? this.mListIterBinding.getRowSetIterator() : null;
                    String[] stringArray = this.mListAttrNames;
                    JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
                    try {
                        try {
                            int n = 0;
                            if (rowSetIterator == null) {
                                if (jUIteratorBinding == null) {
                                    objectArray3 = new Object[]{};
                                    Object var18_7 = null;
                                    if (!bl) return objectArray3;
                                    break block15;
                                }
                                RowSetIterator rowSetIterator2 = jUIteratorBinding.getRowSetIterator();
                                if (rowSetIterator2 == null) {
                                    objectArray2 = new Object[]{};
                                    break block16;
                                }
                                if (rowSetIterator2.getRowSet() != null) {
                                    rowSetIterator = rowSetIterator2.getRowSet().createRowSetIterator(null);
                                    bl = true;
                                }
                                if (stringArray != null) {
                                    AttributeDef[] attributeDefArray = jUIteratorBinding.getAttributeDefs(stringArray);
                                    int n2 = n = attributeDefArray != null && attributeDefArray.length > 0 ? attributeDefArray[0].getIndex() : 0;
                                }
                            }
                            if (rowSetIterator != null) {
                                if (this.mListIterBinding == null || this.mListIterBinding.getRangeSize() < 2) {
                                    if (this.mListIterBinding != null) {
                                        this.mListIterBinding.setRangeSize(-1);
                                    } else {
                                        rowSetIterator.setRangeSize(-1);
                                    }
                                }
                                Row[] rowArray = rowSetIterator.getAllRowsInRange();
                                if (stringArray != null && this.mListIterBinding != null) {
                                    AttributeDef[] attributeDefArray = this.mListIterBinding.getAttributeDefs(stringArray);
                                    n = attributeDefArray != null && attributeDefArray.length > 0 ? attributeDefArray[0].getIndex() : 0;
                                }
                                Object[] objectArray4 = new Object[rowArray.length];
                                int n3 = 0;
                                while (true) {
                                    if (n3 >= objectArray4.length) break;
                                    objectArray4[n3] = rowArray[n3].getAttribute(n);
                                    ++n3;
                                }
                                rowSetIterator.addListener((Object)this);
                                Object[] objectArray5 = objectArray4;
                                Object var18_9 = null;
                                if (!bl) return objectArray5;
                                rowSetIterator.closeRowSetIterator();
                                return objectArray5;
                            }
                            objectArray = new Object[]{};
                            break block17;
                        }
                        catch (Exception exception) {
                            Diagnostic.printStackTrace((Throwable)exception);
                            jUIteratorBinding.getBindingContainer().reportException(exception);
                            Object var18_11 = null;
                            if (!bl) return null;
                            rowSetIterator.closeRowSetIterator();
                            return null;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var18_12 = null;
                        if (!bl) throw throwable;
                        rowSetIterator.closeRowSetIterator();
                        throw throwable;
                    }
                }
                rowSetIterator.closeRowSetIterator();
                return objectArray3;
            }
            Object var18_8 = null;
            if (!bl) return objectArray2;
            rowSetIterator.closeRowSetIterator();
            return objectArray2;
        }
        Object var18_10 = null;
        if (!bl) return objectArray;
        rowSetIterator.closeRowSetIterator();
        return objectArray;
    }

    public void rangeRefreshed(RangeRefreshEvent rangeRefreshEvent) {
        this.setupListItems(true, (this.getIteratorBinding() != null && this.getIteratorBinding().isSuspendRowSetEventsHandling()) ^ true);
    }

    public void rowInserted(InsertEvent insertEvent) {
        if (this.getIteratorBinding() != null && this.getIteratorBinding().isSuspendRowSetEventsHandling()) {
            return;
        }
        this.setupListItems(true, true);
    }

    public void rowDeleted(DeleteEvent deleteEvent) {
        if (this.getIteratorBinding() != null && this.getIteratorBinding().isSuspendRowSetEventsHandling()) {
            return;
        }
        this.setupListItems(true, true);
    }

    public void rowUpdated(UpdateEvent updateEvent) {
        if (this.getIteratorBinding() != null && this.getIteratorBinding().isSuspendRowSetEventsHandling()) {
            return;
        }
        this.setupListItems(true, true);
    }

    public void navigated(NavigationEvent navigationEvent) {
    }

    public void rangeScrolled(ScrollEvent scrollEvent) {
        if (this.getIteratorBinding() != null && this.getIteratorBinding().isSuspendRowSetEventsHandling()) {
            return;
        }
        Object object = scrollEvent.getSource();
        if (object instanceof RowSetIterator && ((RowSetIterator)object).getRangeSize() > 1) {
            this.setupListItems(true, true);
        }
    }

    public void iteratorReset(RowSetManagementEvent rowSetManagementEvent) {
    }

    public void iteratorClosed(RowSetManagementEvent rowSetManagementEvent) {
        if (!this.mStaticList) {
            this.mListPrepared = false;
            this.mValueList = null;
        }
    }

    public void removeBindingChangeListener(JUCtrlListBindingChangeListener jUCtrlListBindingChangeListener) {
        if (this.listenerList != null) {
            this.listenerList.remove(jUCtrlListBindingChangeListener);
        }
    }

    public void release(int n) {
        RowSetIterator rowSetIterator;
        RowSetIterator rowSetIterator2 = rowSetIterator = this.mListIterBinding != null && this.mListIterBinding.isBound() && this.mListIterBinding.hasRSI() ? this.mListIterBinding.getRowSetIterator() : null;
        if (rowSetIterator != null) {
            rowSetIterator.removeListener((Object)this);
            rowSetIterator.removeManagementListener((RowSetManagementListener)this);
        }
        if (!this.mStaticList) {
            this.mListPrepared = false;
            this.mValueList = null;
        }
        super.release(n);
    }

    public void setDataValueAt(Object object, int n) {
    }

    public void setValueAt(Object object, int n) {
        if (this.getControl() == null) {
            this.mSelectedIndex = this.findListIndex(object);
        }
    }

    public void addBindingChangeListener(JUCtrlListBindingChangeListener jUCtrlListBindingChangeListener) {
        if (this.listenerList == null) {
            this.listenerList = new ArrayList();
        }
        this.listenerList.add(jUCtrlListBindingChangeListener);
    }

    public void addControlToPanel(Object object, Object object2, Object object3) {
    }

    public Object put(Object object, Object object2) {
        String string;
        if (object instanceof String && "selectedIndex" == (string = ((String)object).intern())) {
            Object object3 = this.getInputValue();
            this.setInputValue(object2);
            return object3;
        }
        return super.put(object, object2);
    }

    public Object getInputValue() {
        this.getError();
        if (this.mErrExc != null) {
            return this.mInputVal;
        }
        int n = this.getSelectedIndex();
        if (this.mInputVal != null && (n == -1 || n == this.mNullValueIndex)) {
            return this.mInputVal;
        }
        return new Integer(n);
    }

    public void setInputValue(Object object) {
        try {
            this.mInputVal = object;
            this.mHasInputVal = true;
            if (object != null) {
                try {
                    Class clazz = class$java$lang$Integer;
                    if (clazz == null) {
                        clazz = class$java$lang$Integer = JUCtrlListBinding.class$("java.lang.Integer");
                    }
                    Integer n = (Integer)TypeFactory.getInstance((Class)clazz, (Object)object);
                    this.setSelectedIndex(n);
                }
                catch (Exception exception) {
                    this.setSelectedIndex(this.findListIndex(object));
                }
            } else {
                this.setSelectedIndex(-1);
            }
        }
        catch (JboException jboException) {
            if (Diagnostic.isOn()) {
                Diagnostic.println((String)("CtrlAttrs: Caching exception :" + (Object)((Object)jboException)));
            }
            this.setError(jboException, object);
        }
    }

    public List getDisplayData() {
        this.thisBindingObj = this;
        if (this.mValueList == null) {
            this.setupListItems(true, true);
        }
        if (this.mValueList != null) {
            this.currentSetRef = new JUCtrlListBindingItemRef[this.mValueList.length];
            return new 1();
        }
        return null;
    }

    public List getDisplayHints() {
        AttributeDef[] attributeDefArray = this.getDisplayAttributeDefs();
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < attributeDefArray.length) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(10);
            AttributeHints attributeHints = attributeDefArray[n].getUIHelper();
            hashMap.put(DH_LABEL, attributeHints.getLabel(this.getLocaleContext()));
            hashMap.put(DH_TOOLTIP, attributeHints.getTooltip(this.getLocaleContext()));
            hashMap.put(DH_DISPLAY_HINT, attributeHints.getDisplayHint(this.getLocaleContext()));
            hashMap.put(DH_DISPLAY_HEIGHT, new Integer(attributeHints.getDisplayHeight(this.getLocaleContext())));
            hashMap.put(DH_DISPLAY_WIDTH, new Integer(attributeHints.getDisplayWidth(this.getLocaleContext())));
            hashMap.put(DH_CONTROL_TYPE, new Integer(attributeHints.getControlType(this.getLocaleContext())));
            hashMap.put(DH_FORMAT, attributeHints.getFormat(this.getLocaleContext()));
            arrayList.add(hashMap);
            ++n;
        }
        return arrayList;
    }

    protected Object internalGet(String string) {
        if (ATTR_DISPLAY_DATA == (string = string.intern())) {
            this.mInternalGet_KeyResolved = true;
            return this.getDisplayData();
        }
        if (ATTR_DISPLAY_HINTS == string) {
            this.mInternalGet_KeyResolved = true;
            return this.getDisplayHints();
        }
        return super.internalGet(string);
    }

    protected AttributeDef[] getDisplayAttributeDefs() {
        if (this.mDisplayAttrs == null) {
            AttributeDef[] attributeDefArray = null;
            if (this.getListOperMode() == LIST_OPER_NAVIGATE) {
                attributeDefArray = this.getAttributeDefs();
            } else if (this.mListIterBinding != null) {
                ArrayList<AttributeDef> arrayList = null;
                int n = 0;
                DCIteratorBinding dCIteratorBinding = this.mListIterBinding;
                String[] stringArray = this.mListDisplayAttrNames;
                if (stringArray == null) {
                    ArrayList<String> arrayList2 = null;
                    AttributeDef[] attributeDefArray2 = dCIteratorBinding.getAttributeDefs();
                    int n2 = attributeDefArray2.length;
                    arrayList = new ArrayList(n2);
                    arrayList2 = new ArrayList<String>(n2);
                    n = 0;
                    while (n < n2) {
                        AttributeDef attributeDef = attributeDefArray2[n];
                        byte by = attributeDef.getAttributeKind();
                        if (by != 6 && by != 2) {
                            arrayList2.add(attributeDef.getName());
                            arrayList.add(attributeDef);
                        }
                        ++n;
                    }
                    stringArray = arrayList2.toArray(new String[arrayList2.size()]);
                } else if (dCIteratorBinding != null) {
                    AttributeDef[] attributeDefArray3 = dCIteratorBinding.getAttributeDefs(stringArray);
                    int n3 = attributeDefArray3.length;
                    arrayList = new ArrayList(n3);
                    n = 0;
                    while (n < n3) {
                        arrayList.add(attributeDefArray3[n]);
                        ++n;
                    }
                } else {
                    arrayList = new ArrayList<AttributeDef>(0);
                }
                attributeDefArray = arrayList.toArray(new AttributeDef[arrayList.size()]);
            }
            this.mDisplayAttrs = attributeDefArray;
        }
        return this.mDisplayAttrs;
    }

    public boolean processNewInputValue(Object object) {
        JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
        if (jUIteratorBinding != null) {
            jUIteratorBinding.prepareForInput();
        }
        Object object2 = this.getInputValue();
        try {
            Class clazz = class$java$lang$Integer;
            if (clazz == null) {
                clazz = class$java$lang$Integer = JUCtrlListBinding.class$("java.lang.Integer");
            }
            object = (Integer)TypeFactory.getInstance((Class)clazz, (Object)object);
        }
        catch (Exception exception) {
            object = new Integer(this.findListIndex(object2));
        }
        return object.equals(object2) ^ true;
    }

    protected void setStaticList(boolean bl) {
        this.mStaticList = bl;
    }

    public void filterList(Map map) {
        Row[] rowArray;
        if (map == null || map.size() == 0) {
            return;
        }
        DCIteratorBinding dCIteratorBinding = this.getListIterBinding();
        RowSetIterator rowSetIterator = dCIteratorBinding.getRowSetIterator();
        ViewCriteria viewCriteria = dCIteratorBinding.getDataControl().createViewCriteria(dCIteratorBinding);
        Row row = viewCriteria.createRow();
        viewCriteria.insertRow(row);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = map.get(string);
            if (v == null) continue;
            String string2 = v.toString().trim();
            if (!string2.endsWith("%") && !string2.endsWith("*")) {
                string2 = string2 + '*';
            }
            row.setAttribute(string, (Object)string2);
        }
        dCIteratorBinding.getDataControl().applyViewCriteria(viewCriteria, dCIteratorBinding, rowSetIterator);
        dCIteratorBinding.executeQuery();
        if (dCIteratorBinding.getDataControl().syncNeeded()) {
            this.getBindingContainer().refreshControl();
        }
        if ((rowArray = dCIteratorBinding.getAllRowsInRange()).length == 1) {
            if (this.getNullValueIndex() == 0) {
                this.setSelectedIndex(1);
            } else {
                this.setSelectedIndex(0);
            }
        }
        if ((viewCriteria = dCIteratorBinding.getViewCriteria()).getRowCount() > 0) {
            viewCriteria.first().remove();
        }
    }

    public boolean isUpdateable() {
        if (this.mListOperMode != LIST_OPER_NAVIGATE) {
            return super.isUpdateable();
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public final class 1
    extends AbstractList {
        public Object get(int n) {
            if (n < JUCtrlListBinding.this.mValueList.length && JUCtrlListBinding.this.currentSetRef[n] == null) {
                JUCtrlListBinding.this.currentSetRef[n] = new JUCtrlListBindingItemRef(n);
            }
            return JUCtrlListBinding.this.currentSetRef[n];
        }

        public int size() {
            return JUCtrlListBinding.this.mValueList.length;
        }
    }

    public class JUCtrlListBindingItemRef
    extends JboAbstractMap {
        int mIndex;

        private /* synthetic */ void $init$() {
            this.mIndex = -1;
        }

        JUCtrlListBindingItemRef(int n) {
            this.$init$();
            this.mIndex = n;
        }

        public Object get(Object object) {
            if (object instanceof String) {
                String string = ((String)object).intern();
                if (JUCtrlListBinding.LISTITEM_Selected == string) {
                    return this.mIndex == JUCtrlListBinding.this.thisBindingObj.mSelectedIndex;
                }
                if (JUCtrlListBinding.LISTITEM_Index == string) {
                    return String.valueOf(this.mIndex);
                }
                if (JUCtrlListBinding.LISTITEM_Prompt == string) {
                    return this.getMergedPrompt();
                }
                if (JUCtrlListBinding.LISTITEM_DisplayValues == string) {
                    return this.getDisplayValues();
                }
                if ("selectedIndex" == string) {
                    return String.valueOf(JUCtrlListBinding.this.thisBindingObj.mSelectedIndex);
                }
            }
            return null;
        }

        String getMergedPrompt() {
            return JUCtrlValueBinding.getMergedAttributeValues(this.getDisplayValues());
        }

        List getDisplayValues() {
            Object object = JUCtrlListBinding.this.thisBindingObj.mValueList[this.mIndex];
            if (object instanceof Row) {
                return JUCtrlListBinding.this.thisBindingObj.getAttributes((Row)object, JUCtrlListBinding.this.getDisplayAttributeDefs());
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(object);
            return arrayList;
        }
    }
}

