/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.worker;

import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import oracle.bali.ewt.event.PropertyChanger;
import oracle.bali.ewt.model.ObjectModel;
import oracle.bali.ewt.worker.CanceledException;
import oracle.bali.ewt.worker.InvocationContext;
import oracle.bali.ewt.worker.Worker;
import oracle.bali.ewt.worker.WorkerQueue;
import oracle.bali.ewt.worker.WorkerStatusListener;
import oracle.bali.ewt.worker.WorkerUtils;
import oracle.bali.share.collection.CompoundEnumeration;
import oracle.bali.share.collection.SingleItemEnumeration;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.util.BooleanUtils;

public abstract class AbstractWorkerQueue
implements WorkerQueue {
    private static final int _STATE_QUEUED = 0;
    private static final int _STATE_RUNNING = 1;
    private static final int _STATE_COMPLETED = 2;
    private static final int _DEBUG_OUTPUT_NONE = 0;
    private static final int _DEBUG_OUTPUT_FAILURES = 1;
    private static final int _DEBUG_OUTPUT_VERBOSE = 2;
    private static final int _DEBUG_OUTPUT_LEVEL = 0;
    ListenerManager __statusListeners;
    private PropertyChanger _propertyChanger;
    private int _queueRefCount = 0;

    protected AbstractWorkerQueue() {
    }

    public abstract boolean isInWorkerQueueThread();

    public final InvocationContext invokeLater(Worker worker, Dictionary dictionary, WorkerStatusListener workerStatusListener) {
        return this._queueWorker(worker, dictionary, false, workerStatusListener);
    }

    public final InvocationContext invokeAndWait(Worker worker, Dictionary dictionary, WorkerStatusListener workerStatusListener) {
        return this._queueWorker(worker, dictionary, true, workerStatusListener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertyChanger == null) {
            this._propertyChanger = new PropertyChanger(this);
        }
        this._propertyChanger.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertyChanger.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addWorkerStatusListener(WorkerStatusListener workerStatusListener) {
        if (this.__statusListeners == null) {
            this.__statusListeners = new ListenerManager();
        }
        this.__statusListeners.addListener((EventListener)workerStatusListener);
    }

    public synchronized void removeWorkerStatusListener(WorkerStatusListener workerStatusListener) {
        this.__statusListeners.removeListener((EventListener)workerStatusListener);
    }

    public final boolean isBusy() {
        return this._queueRefCount > 0;
    }

    protected abstract void invokeLater(Runnable var1);

    protected abstract void invokeAndWait(Runnable var1) throws InterruptedException, Throwable;

    static InvocationContext __runWorkerImmediately(Worker worker, Dictionary dictionary, WorkerStatusListener workerStatusListener) {
        WorkerContext workerContext = new WorkerContext(worker, dictionary, workerStatusListener, false, null);
        SingleItemEnumeration singleItemEnumeration = null;
        if (workerStatusListener != null) {
            workerStatusListener.workerPrepared(workerContext);
            singleItemEnumeration = new SingleItemEnumeration((Object)workerStatusListener);
        }
        AbstractWorkerQueue._runWorker(workerContext, singleItemEnumeration, null);
        return workerContext;
    }

    private static void _runWorker(InvocationContext invocationContext, Enumeration enumeration, Throwable throwable) {
        WorkerStatusListener workerStatusListener;
        Vector<WorkerStatusListener> vector = null;
        if (enumeration != null) {
            vector = new Vector<WorkerStatusListener>(7);
            while (enumeration.hasMoreElements()) {
                workerStatusListener = (WorkerStatusListener)enumeration.nextElement();
                vector.addElement(workerStatusListener);
            }
        }
        if (throwable == null) {
            try {
                Worker worker = invocationContext.getWorker();
                if (!worker.isEnabled()) {
                    throw new IllegalStateException("Attempt to run disabled Worker:" + worker);
                }
                if (vector != null) {
                    enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        workerStatusListener = (WorkerStatusListener)enumeration.nextElement();
                        workerStatusListener.workerPrerun(invocationContext);
                    }
                }
                Object object = worker.run(invocationContext);
                invocationContext.putValue(InvocationContext.RESULT, object);
                if (vector != null) {
                    enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        workerStatusListener = (WorkerStatusListener)enumeration.nextElement();
                        workerStatusListener.workerSucceeded(invocationContext);
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
        }
        if (throwable != null) {
            if (throwable instanceof CanceledException) {
                AbstractWorkerQueue._setCanceled(invocationContext, true);
            }
            invocationContext.putValue(InvocationContext.FAILURE_CAUSE, throwable);
            AbstractWorkerQueue._printWorkerFailure(invocationContext.getWorker(), throwable);
            if (vector != null) {
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    workerStatusListener = (WorkerStatusListener)enumeration.nextElement();
                    workerStatusListener.workerFailed(invocationContext);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private InvocationContext _queueWorker(Worker var1_1, Dictionary var2_2, boolean var3_3, WorkerStatusListener var4_4) {
        block9: {
            var5_5 = new WorkerContext(var1_1, var2_2, var4_4, var3_3, this);
            this._workerQueued(var1_1);
            if (this.__statusListeners != null && (var6_6 = this.__statusListeners.getListeners()) != null) {
                while (var6_6.hasMoreElements()) {
                    var7_8 = (WorkerStatusListener)var6_6.nextElement();
                    var7_8.workerPrepared(var5_5);
                }
            }
            if (var4_4 != null) {
                var4_4.workerPrepared(var5_5);
            }
            if (var3_3) {
                block10: {
                    try {
                        this.invokeAndWait(var5_5);
                        break block9;
                    }
                    catch (Throwable var6_7) {
                        AbstractWorkerQueue._printWorkerFailure(var1_1, var6_7);
                        var5_5.putValue(InvocationContext.FAILURE_CAUSE, var6_7);
                        if (this.__statusListeners == null || (var7_8 = this.__statusListeners.getListeners()) == null) break block10;
                        ** while (var7_8.hasMoreElements())
                    }
lbl-1000:
                    // 1 sources

                    {
                        var8_9 = (WorkerStatusListener)var7_8.nextElement();
                        var8_9.workerFailed(var5_5);
                        continue;
                    }
                }
                if (var4_4 != null) {
                    var4_4.workerFailed(var5_5);
                }
                this.__workerCompleted(var1_1);
            } else {
                this.invokeLater(var5_5);
            }
        }
        return var5_5;
    }

    private void _workerQueued(Worker worker) {
        if (this._queueRefCount == 0 && this._propertyChanger != null) {
            this._propertyChanger.firePropertyChange("Busy", true);
        }
        ++this._queueRefCount;
    }

    void __workerCompleted(Worker worker) {
        --this._queueRefCount;
        if (this._queueRefCount == 0 && this._propertyChanger != null) {
            this._propertyChanger.firePropertyChange("Busy", false);
        }
    }

    private static void _debugPrint(String string, int n) {
        if (n <= 0) {
            System.out.println(string);
        }
    }

    private static void _printWorkerFailure(Worker worker, Throwable throwable) {
        int n;
        int n2 = n = throwable instanceof CanceledException ? 2 : 1;
        if (n <= 0) {
            System.err.println(worker.getValue(Worker.WORKER_COMMAND) + " failed with exception:" + throwable);
            throwable.printStackTrace(System.err);
        }
    }

    private static void _setCanceled(InvocationContext invocationContext, boolean bl) {
        invocationContext.putValue(InvocationContext.CANCELED, BooleanUtils.getBoolean((boolean)bl));
    }

    private static class WorkerContext
    implements Runnable,
    InvocationContext {
        private Worker _worker;
        private WorkerStatusListener _listener;
        private boolean _blocks;
        private boolean _cancelRequested;
        private int _runningState = 0;
        private Dictionary _parameters;
        private AbstractWorkerQueue _queue;

        public WorkerContext(Worker worker, Dictionary dictionary, WorkerStatusListener workerStatusListener, boolean bl, AbstractWorkerQueue abstractWorkerQueue) {
            if (worker == null) {
                throw new IllegalArgumentException();
            }
            if (dictionary == null) {
                throw new IllegalArgumentException();
            }
            this._worker = worker;
            this._parameters = dictionary;
            this._listener = workerStatusListener;
            this._blocks = bl;
            this._queue = abstractWorkerQueue;
            if (WorkerUtils.getQueueLocationsSaved()) {
                this.putValue(InvocationContext.QUEUE_LOCATION, new Throwable());
            }
            AbstractWorkerQueue._setCanceled(this, false);
        }

        public Worker getWorker() {
            return this._worker;
        }

        public WorkerQueue getWorkerQueue() {
            return this._queue;
        }

        public void putValue(Object object, Object object2) {
            if (object2 == null) {
                object2 = WorkerUtils.PARAMETER_NULL;
            } else if (object2 == InvocationContext.UNDEFINED) {
                object2 = null;
            }
            this._parameters.put(object, object2);
        }

        private Object _getValue(Object object) {
            InvocationContext invocationContext;
            Object object2 = this._parameters.get(object);
            if (object2 == null) {
                object2 = InvocationContext.UNDEFINED;
            }
            if (object2 == WorkerUtils.PARAMETER_NULL) {
                object2 = null;
            } else if (object2 instanceof ObjectModel) {
                object2 = ((ObjectModel)object2).getObject();
            }
            if (object2 == InvocationContext.UNDEFINED) {
                object2 = this._worker.getDefaultParameterValue(object);
            }
            if (object2 == InvocationContext.UNDEFINED && !InvocationContext.PARENT_CONTEXT.equals(object) && (invocationContext = (InvocationContext)this.getValue(InvocationContext.PARENT_CONTEXT, null)) != null) {
                object2 = invocationContext.getValue(object, InvocationContext.UNDEFINED);
            }
            return object2;
        }

        public Object getValue(Object object, Object object2) {
            Object object3 = this._getValue(object);
            if (InvocationContext.UNDEFINED == object3) {
                return object2;
            }
            return object3;
        }

        public synchronized boolean cancel() {
            this._cancelRequested = true;
            return this._runningState == 0;
        }

        public boolean isCancelRequested() {
            return this._cancelRequested;
        }

        public void run() {
            Object var1_1 = null;
            WorkerContext workerContext = this;
            synchronized (workerContext) {
                if (this._cancelRequested) {
                    this._runningState = 2;
                }
            }
            this._runMaybeBlocked();
        }

        private void _runMaybeBlocked() {
            if (this._blocks) {
                WorkerContext workerContext = this;
                synchronized (workerContext) {
                    this._run();
                    this.notify();
                }
            } else {
                this._run();
            }
        }

        private void _run() {
            CanceledException canceledException = null;
            if (this._runningState == 2) {
                canceledException = new CanceledException(this._worker);
            } else {
                this._runningState = 1;
            }
            Enumeration enumeration = null;
            if (this._queue.__statusListeners != null) {
                enumeration = this._queue.__statusListeners.getListeners();
            }
            if (this._listener != null) {
                SingleItemEnumeration singleItemEnumeration = new SingleItemEnumeration((Object)this._listener);
                enumeration = enumeration != null ? new CompoundEnumeration(enumeration, (Enumeration)singleItemEnumeration) : singleItemEnumeration;
            }
            AbstractWorkerQueue._runWorker(this, enumeration, canceledException);
            this._runningState = 2;
            this._queue.__workerCompleted(this._worker);
        }
    }
}

