/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.util;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.Method;
import java.text.AttributedCharacterIterator;
import javax.swing.AbstractButton;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.ewt.util.FocusUtils;
import oracle.bali.ewt.util.WindowUtils;

public class MenuUtils {
    static Object _sLock = new Object();
    static Tracker _sTracker;
    private static Method _sGetScreenInsets;
    private static boolean _sGetScreenInsetsAvailable;
    static /* synthetic */ Class class$java$awt$GraphicsConfiguration;
    static /* synthetic */ Class class$java$awt$Toolkit;

    public static Dimension getBoundingSize(Component component) {
        return component.getToolkit().getScreenSize();
    }

    public static boolean willPopupFit(JPopupMenu jPopupMenu, Component component) {
        Dimension dimension = jPopupMenu.getPreferredSize();
        Dimension dimension2 = MenuUtils.getBoundingSize(component);
        return dimension.width <= dimension2.width && dimension.height <= dimension2.height;
    }

    public static void showPopupMenu(JPopupMenu jPopupMenu, Component component, int n, int n2) {
        Window window;
        Point point = MenuUtils.getPopupMenuLocation(jPopupMenu, component, n, n2);
        n = point.x;
        n2 = point.y;
        if (component != null && (window = WindowUtils.getWindow(component)) != null) {
            Component component2 = window.getFocusOwner();
            if (component2 == null && component.isFocusTraversable()) {
                component.requestFocus();
                component2 = component;
            }
            if (FocusUtils.areNewFocusAPIsAvailable() && component2 != component) {
                component.requestFocus();
                component2 = component;
            }
            if (component2 != null) {
                Object object = _sLock;
                synchronized (object) {
                    _sTracker = new Tracker(component2, jPopupMenu);
                }
            }
        }
        jPopupMenu.show(component, n, n2);
    }

    public static Point getPopupMenuLocation(JPopupMenu jPopupMenu, Component component, int n, int n2) {
        Point point = new Point();
        if (component != null) {
            try {
                point = component.getLocationOnScreen();
            }
            catch (Exception exception) {
                // empty catch block
            }
            n += point.x;
            n2 += point.y;
        }
        Dimension dimension = jPopupMenu.getPreferredSize();
        Point point2 = new Point(n + dimension.width, n2 + dimension.height);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        int n3 = 0;
        if (n3 < graphicsDeviceArray.length) {
            GraphicsConfiguration graphicsConfiguration = graphicsDeviceArray[n3].getDefaultConfiguration();
            Rectangle rectangle = graphicsConfiguration.getBounds();
            if (rectangle.contains(n, n2)) {
                // empty if block
            }
            Insets insets = MenuUtils.getScreenInsets(graphicsConfiguration);
            rectangle.width -= insets.right;
            rectangle.height -= insets.bottom;
            int n4 = 0;
            int n5 = 0;
            if (point2.x > rectangle.x + rectangle.width) {
                n4 = -dimension.width - 5;
            }
            if (point2.y > rectangle.y + rectangle.height) {
                n5 = rectangle.y + rectangle.height - point2.y;
            }
            return new Point(n + n4 - point.x, n2 + n5 - point.y);
        }
        return new Point(n - point.x, n2 - point.y);
    }

    public static Insets getScreenInsets(GraphicsConfiguration graphicsConfiguration) {
        Insets insets = null;
        if (_sGetScreenInsetsAvailable) {
            try {
                Object[] objectArray;
                if (_sGetScreenInsets == null) {
                    objectArray = new Class[]{class$java$awt$GraphicsConfiguration == null ? (class$java$awt$GraphicsConfiguration = MenuUtils.class$("java.awt.GraphicsConfiguration")) : class$java$awt$GraphicsConfiguration};
                    _sGetScreenInsets = (class$java$awt$Toolkit == null ? (class$java$awt$Toolkit = MenuUtils.class$("java.awt.Toolkit")) : class$java$awt$Toolkit).getMethod("getScreenInsets", (Class<?>[])objectArray);
                }
                objectArray = new Object[]{graphicsConfiguration};
                insets = (Insets)_sGetScreenInsets.invoke((Object)Toolkit.getDefaultToolkit(), objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                _sGetScreenInsetsAvailable = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (insets == null) {
            insets = _sGetScreenInsetsAvailable ? new Insets(0, 0, 0, 0) : new Insets(0, 0, 32, 0);
        }
        return insets;
    }

    private MenuUtils() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _sGetScreenInsetsAvailable = true;
    }

    private static class Tracker
    implements AWTEventListener,
    KeyListener,
    PopupMenuListener {
        private FocusManager _focusManager;
        private Component _component;
        private JPopupMenu _popup;
        private boolean _keyListener;

        public Tracker(Component component, JPopupMenu jPopupMenu) {
            Tracker tracker = _sTracker;
            if (tracker != null) {
                tracker._detach();
            }
            if (!FocusUtils.areNewFocusAPIsAvailable()) {
                this._focusManager = FocusManager.getCurrentManager();
                FocusManager.disableSwingFocusManager();
                try {
                    long l = 2056L;
                    component.getToolkit().addAWTEventListener(this, l);
                    this._keyListener = false;
                }
                catch (Exception exception) {
                    this._keyListener = true;
                    component.addKeyListener(this);
                }
            }
            this._component = component;
            this._popup = jPopupMenu;
            jPopupMenu.addPopupMenuListener(this);
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            int n = aWTEvent.getID();
            switch (n) {
                case 401: {
                    this.keyPressed((KeyEvent)aWTEvent);
                    break;
                }
                case 402: {
                    this.keyReleased((KeyEvent)aWTEvent);
                    break;
                }
                case 400: {
                    this.keyTyped((KeyEvent)aWTEvent);
                    break;
                }
                case 1100: {
                    this.inputMethodTextChanged((InputMethodEvent)aWTEvent);
                }
            }
        }

        public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
            AttributedCharacterIterator attributedCharacterIterator = inputMethodEvent.getText();
            char c = attributedCharacterIterator.first();
            KeyEvent keyEvent = new KeyEvent((Component)inputMethodEvent.getSource(), 400, 0L, 0, 0, c);
            this._tryOtherKeys(keyEvent);
            inputMethodEvent.consume();
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 27) {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                if (menuElementArray.length > 4) {
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 2];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length - 2);
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                } else {
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                }
            } else if (n == 18) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            } else if (n == 38 || n == 40) {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                if (menuElementArray != null && menuElementArray.length >= 2) {
                    int n2 = menuElementArray.length;
                    MenuElement menuElement = menuElementArray[n2 - 1];
                    MenuElement[] menuElementArray3 = menuElementArray[n2 - 2].getSubElements();
                    int n3 = 0;
                    while (n3 < menuElementArray3.length) {
                        if (menuElementArray3[n3] == menuElement) break;
                        ++n3;
                    }
                    if (n3 == menuElementArray3.length) {
                        n3 = 0;
                    } else {
                        n3 = n == 40 ? ++n3 : (n3 += menuElementArray3.length - 1);
                        n3 %= menuElementArray3.length;
                    }
                    menuElementArray[n2 - 1] = menuElementArray3[n3];
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                }
            } else if (n == 10) {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                if (menuElementArray != null && menuElementArray.length > 0) {
                    MenuElement menuElement = menuElementArray[menuElementArray.length - 1];
                    if (menuElement instanceof JMenu) {
                        JPopupMenu jPopupMenu = ((JMenu)menuElement).getPopupMenu();
                        MenuElement[] menuElementArray4 = jPopupMenu.getSubElements();
                        if (menuElementArray4 != null && menuElementArray4.length > 0) {
                            MenuElement[] menuElementArray5 = new MenuElement[menuElementArray.length + 2];
                            System.arraycopy(menuElementArray, 0, menuElementArray5, 0, menuElementArray.length);
                            menuElementArray5[menuElementArray.length] = jPopupMenu;
                            menuElementArray5[menuElementArray.length + 1] = menuElementArray4[0];
                            MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray5);
                        }
                    } else {
                        Component component = menuElement.getComponent();
                        if (component instanceof AbstractButton) {
                            ((AbstractButton)component).doClick(0);
                        }
                        MenuSelectionManager.defaultManager().clearSelectedPath();
                    }
                }
            } else {
                this._tryOtherKeys(keyEvent);
            }
            keyEvent.consume();
        }

        public void keyTyped(KeyEvent keyEvent) {
            this._tryOtherKeys(keyEvent);
            keyEvent.consume();
        }

        public void keyReleased(KeyEvent keyEvent) {
            this._tryOtherKeys(keyEvent);
            keyEvent.consume();
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            if (FocusUtils.areNewFocusAPIsAvailable()) {
                this._component.requestFocus();
            }
            this._detach();
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        private void _tryOtherKeys(KeyEvent keyEvent) {
            MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
            if (keyEvent.isConsumed()) {
                return;
            }
            Component[] componentArray = this._popup.getComponents();
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
            int n = 0;
            while (n < componentArray.length) {
                ActionListener actionListener;
                if (componentArray[n] instanceof JComponent && (actionListener = ((JComponent)componentArray[n]).getActionForKeyStroke(keyStroke)) != null) {
                    ActionEvent actionEvent = new ActionEvent(componentArray[n], 1001, null, keyEvent.getModifiers());
                    actionListener.actionPerformed(actionEvent);
                }
                ++n;
            }
        }

        private void _detach() {
            Object object = _sLock;
            synchronized (object) {
                Tracker tracker = _sTracker;
                if (tracker == this) {
                    _sTracker = null;
                    if (!FocusUtils.areNewFocusAPIsAvailable()) {
                        if (this._keyListener) {
                            this._component.removeKeyListener(this);
                        } else {
                            this._component.getToolkit().removeAWTEventListener(this);
                        }
                    }
                    this._popup.removePopupMenuListener(this);
                    if (!FocusUtils.areNewFocusAPIsAvailable()) {
                        FocusManager.setCurrentManager(this._focusManager);
                    }
                    this._popup = null;
                    this._component = null;
                    this._focusManager = null;
                }
            }
        }
    }
}

