/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.font;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.font.TextAttribute;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.border.TitledPane;
import oracle.bali.ewt.chooser.color.ColorChoice;
import oracle.bali.ewt.chooser.font.FontPreviewArea;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.graphics.IconStrip;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.share.util.IntegerUtils;

public class FontPane
extends LWComponent
implements Accessible {
    public static final String PROPERTY_FONT_NAME = "fontName";
    public static final String PROPERTY_FONT_SIZE = "fontSize";
    public static final String PROPERTY_FONT_STYLE = "fontStyle";
    public static final String PROPERTY_FONT_BASELINE_STYLE = "fontBaselineStyle";
    public static final String PROPERTY_FONT_WIDTH = "fontWidth";
    public static final String PROPERTY_FONT_HORIZONTAL_ALIGNMENT = "fontHorizontalAlignment";
    public static final String PROPERTY_FONT_VERTICAL_ALIGNMENT = "fontVerticalAlignment";
    public static final String PROPERTY_ACTUAL_FONT_SIZE_USED = "actualFontSizeUsed";
    public static final String PROPERTY_FONT_COLOR = "fontColor";
    public static final String PROPERTY_FONT_BACKGROUND_COLOR = "fontBackgroundColor";
    public static final String PROPERTY_BORDER_COLOR = "borderColor";
    public static final String PROPERTY_COLOR_COMPONENT_MASK = "colorComponentMask";
    public static final String PROPERTY_STYLE_BUTTON_MASK = "styleButtonMask";
    public static final String PROPERTY_ALIGNMENT_BUTTON_MASK = "alignmentButtonMask";
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_UNDERLINE = 4;
    public static final int STYLE_STRIKETHROUGH = 8;
    public static final int BASELINE_STYLE_REGULAR = 1;
    public static final int BASELINE_STYLE_SUPERSCRIPT = 2;
    public static final int BASELINE_STYLE_SUBSCRIPT = 3;
    public static final int WIDTH_NORMAL = 2;
    public static final int WIDTH_CONDENSED = 0;
    public static final int WIDTH_SEMI_CONDENSED = 1;
    public static final int WIDTH_EXTENDED = 4;
    public static final int WIDTH_SEMI_EXTENDED = 3;
    public static final int HORIZONTAL_ALIGNMENT_FULL = 100;
    public static final int HORIZONTAL_ALIGNMENT_LEFT = 2;
    public static final int HORIZONTAL_ALIGNMENT_CENTER = 0;
    public static final int HORIZONTAL_ALIGNMENT_RIGHT = 4;
    public static final int HORIZONTAL_ALIGNMENT_START = 10;
    public static final int HORIZONTAL_ALIGNMENT_END = 11;
    public static final int VERTICAL_ALIGNMENT_TOP = 1;
    public static final int VERTICAL_ALIGNMENT_MIDDLE = 0;
    public static final int VERTICAL_ALIGNMENT_BOTTOM = 3;
    public static final int BUTTON_STYLE_BOLD = 1;
    public static final int BUTTON_STYLE_ITALIC = 2;
    public static final int BUTTON_STYLE_UNDERLINE = 4;
    public static final int BUTTON_STYLE_STRIKETHROUGH = 8;
    public static final int BUTTON_STYLE_SUPERSCRIPT = 16;
    public static final int BUTTON_STYLE_SUBSCRIPT = 32;
    public static final int BUTTON_ALIGNMENT_FULL = 1;
    public static final int BUTTON_ALIGNMENT_LEFT = 2;
    public static final int BUTTON_ALIGNMENT_CENTER = 4;
    public static final int BUTTON_ALIGNMENT_RIGHT = 8;
    public static final int BUTTON_ALIGNMENT_START = 16;
    public static final int BUTTON_ALIGNMENT_END = 32;
    public static final int BUTTON_ALIGNMENT_TOP = 64;
    public static final int BUTTON_ALIGNMENT_MIDDLE = 128;
    public static final int BUTTON_ALIGNMENT_BOTTOM = 256;
    public static final int COLOR_COMPONENT_FOREGROUND = 1;
    public static final int COLOR_COMPONENT_BACKGROUND = 2;
    public static final int COLOR_COMPONENT_BORDER = 4;
    public static final int BUTTON_OK = 1;
    public static final int BUTTON_CANCEL = 2;
    public static final int DEFAULT_MAXIMUM_FONT_SIZE = 512;
    public static final int NONE_SELECTED_STATE = -1;
    private static final int _MIN_EXAMPLE_HEIGHT = 150;
    static final int _sACCESSIBLE_CHILD_COUNT = 22;
    private static final String _RESOURCE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _ACCESS_RESOURCE = "oracle.bali.ewt.resource.AccessibilityBundle";
    private static final String _LEFT_CONSTRAINT = "left";
    private static final String _KEY_FONT = "FONTPANE.FONT";
    private static final String _KEY_SIZE = "FONTPANE.SIZE";
    private static final String _KEY_STYLE = "FONTPANE.STYLE";
    private static final String _KEY_WIDTH = "FONTPANE.WIDTH";
    private static final String _KEY_COLOR = "FONTPANE.COLOR";
    private static final String _KEY_ALIGNMENT = "FONTPANE.ALIGNMENT";
    private static final String _KEY_SHOW_ACTUAL = "FONTPANE.SHOW_ACTUAL";
    private static final String _KEY_EXAMPLE = "FONTPANE.EXAMPLE";
    private static final String _KEY_JUSTIFY_FULL = "FONTPANE.JUSTIFY_FULL";
    private static final String _KEY_JUSTIFY_LEFT = "FONTPANE.JUSTIFY_LEFT";
    private static final String _KEY_JUSTIFY_CENTER = "FONTPANE.JUSTIFY_CENTER";
    private static final String _KEY_JUSTIFY_RIGHT = "FONTPANE.JUSTIFY_RIGHT";
    private static final String _KEY_JUSTIFY_TOP = "FONTPANE.JUSTIFY_TOP";
    private static final String _KEY_JUSTIFY_MIDDLE = "FONTPANE.JUSTIFY_MIDDLE";
    private static final String _KEY_JUSTIFY_BOTTOM = "FONTPANE.JUSTIFY_BOTTOM";
    private static final String _KEY_JUSTIFY_START = "FONTPANE.JUSTIFY_START";
    private static final String _KEY_JUSTIFY_END = "FONTPANE.JUSTIFY_END";
    private static final String _KEY_BOLD = "FONTPANE.BOLD";
    private static final String _KEY_ITALIC = "FONTPANE.ITALIC";
    private static final String _KEY_UNDERLINE = "FONTPANE.UNDERLINE";
    private static final String _KEY_STRIKETHRU = "FONTPANE.STRIKETHRU";
    private static final String _KEY_SUPERSCRIPT = "FONTPANE.SUPERSCRIPT";
    private static final String _KEY_SUBSCRIPT = "FONTPANE.SUBSCRIPT";
    private static final String _KEY_CONDENSED = "FONTPANE.CONDENSED";
    private static final String _KEY_SEMI_CONDENSED = "FONTPANE.SEMI_CONDENSED";
    private static final String _KEY_NORMAL = "FONTPANE.NORMAL";
    private static final String _KEY_SEMI_EXPANDED = "FONTPANE.SEMI_EXPANDED";
    private static final String _KEY_EXPANDED = "FONTPANE.EXPANDED";
    private static final String _KEY_TEXT_COLOR = "FONTPANE.TEXT_COLOR";
    private static final String _KEY_BACKGROUND_COLOR = "FONTPANE.BACKGROUND_COLOR";
    private static final String _KEY_BORDER_COLOR = "FONTPANE.BORDER_COLOR";
    private static final String _KEY_EXAMPLE_TEXT = "FONTPANE.EXAMPLE_TEXT";
    private static final int _ICON_BOLD = 0;
    private static final int _ICON_ITALIC = 1;
    private static final int _ICON_UNDERLINE = 2;
    private static final int _ICON_STRIKETHROUGH = 3;
    private static final int _ICON_SUPERSCRIPT = 4;
    private static final int _ICON_SUBSCRIPT = 5;
    private static final int _ICON_COLOR = 6;
    private static final int _ICON_FULL_JUSTIFY = 7;
    private static final int _ICON_LEFT_JUSTIFY = 8;
    private static final int _ICON_CENTER_JUSTIFY = 9;
    private static final int _ICON_RIGHT_JUSTIFY = 10;
    private static final int _ICON_TOP_JUSTIFY = 11;
    private static final int _ICON_MIDDLE_JUSTIFY = 12;
    private static final int _ICON_BOTTOM_JUSTIFY = 13;
    private static final int _ICON_START_JUSTIFY = 14;
    private static final int _ICON_END_JUSTIFY = 15;
    private static final int _ICON_COUNT = 16;
    private static final int _JDK_1_1_DEFAULT_STYLE_BUTTONS = 3;
    private static final int _JDK_1_2_DEFAULT_STYLE_BUTTONS = 63;
    private static final int _DEFAULT_ALIGNMENT_BUTTONS = 462;
    private static final int _DEFAULT_COLOR_BUTTONS = 3;
    private static final Object[] _SIZES = new Object[]{IntegerUtils.getInteger((int)8), IntegerUtils.getInteger((int)9), IntegerUtils.getInteger((int)10), IntegerUtils.getInteger((int)11), IntegerUtils.getInteger((int)12), IntegerUtils.getInteger((int)14), IntegerUtils.getInteger((int)16), IntegerUtils.getInteger((int)18), IntegerUtils.getInteger((int)20), IntegerUtils.getInteger((int)22), IntegerUtils.getInteger((int)24), IntegerUtils.getInteger((int)26), IntegerUtils.getInteger((int)28), IntegerUtils.getInteger((int)36), IntegerUtils.getInteger((int)48), IntegerUtils.getInteger((int)72)};
    private static IconStrip _sIconStrip;
    private static IconStrip _sDisabledIconStrip;
    private static final Insets _sBORDER_COLOR_INSETS;
    private static final Insets _sDEFAULT_INSETS;
    private static final Insets _sLABEL_INSETS;
    private static final Insets _sSEPARATOR_INSETS;
    private String _laggingFontName;
    private int _laggingFontSize;
    private int _laggingFontStyle;
    private int _laggingFontBaselineStyle;
    private int _laggingFontWidth;
    private int _laggingFontHorizontalAlignment;
    private int _laggingFontVerticalAlignment;
    private Color _laggingFontColor;
    private Color _laggingFontBackgroundColor;
    private Color _laggingBorderColor;
    private int _maximumFontSize;
    private JComboBox _fontNames;
    private JComboBox _sizes;
    private JComboBox _widths;
    private JToggleButton _bold;
    private JToggleButton _italic;
    private JToggleButton _underline;
    private JToggleButton _strikeThrough;
    private JToggleButton _superscript;
    private JToggleButton _subscript;
    private JToggleButton _fullJustify;
    private JToggleButton _leftJustify;
    private JToggleButton _centerJustify;
    private JToggleButton _rightJustify;
    private JToggleButton _startJustify;
    private JToggleButton _endJustify;
    private JToggleButton _topJustify;
    private JToggleButton _middleJustify;
    private JToggleButton _bottomJustify;
    private JToggleButton _noneHorizontal;
    private JToggleButton _noneVertical;
    private JLabel _styleLabel;
    private JLabel _widthLabel;
    private JLabel _fontLabel;
    private JLabel _sizeLabel;
    private JLabel _exampleLabel;
    private TitledPane _alignmentComponent;
    private TitledPane _colorComponent;
    private ColorChoice _textColor;
    private ColorChoice _backgroundColor;
    private ColorChoice _borderColor;
    private JLabel _textColorLabel;
    private JLabel _backgroundColorLabel;
    private JLabel _borderColorLabel;
    private JCheckBox _showFontSize;
    private JPanel _exampleArea;
    private FontPreviewArea _exampleComponent;
    private JPanel _clientContainer;
    private int _originalFontWidth = -2;
    private boolean _fontColorSet;
    private boolean _fontBackgroundColorSet;
    private boolean _fontBorderColorSet;
    private static final String _BOLD_NAME = "Style Bold";
    private static final String _ITALIC_NAME = "Style Italic";
    private static final String _UNDERLINE_NAME = "Style Underline";
    private static final String _STRIKETHRU_NAME = "Style Strikethrough";
    private static final String _SUPERSCRIPT_NAME = "Style Superscript";
    private static final String _SUBSCRIPT_NAME = "Style Subscript";
    private static final String _TEXT_COLOR_NAME = "Text Color";
    private static final String _BACKGROUND_COLOR_NAME = "Background Color";
    private static final String _BORDER_COLOR_NAME = "Border Color";
    private static final String _JUSTIFY_FULL_NAME = "Full Alignment";
    private static final String _JUSTIFY_LEFT_NAME = "Left Horizontal Alignment";
    private static final String _JUSTIFY_CENTER_NAME = "Center Horizontal Alignment";
    private static final String _JUSTIFY_RIGHT_NAME = "Right Horizontal Alignment";
    private static final String _JUSTIFY_TOP_NAME = "Top Vertical Alignment";
    private static final String _JUSTIFY_MIDDLE_NAME = "Middle Vertical Alignment";
    private static final String _JUSTIFY_BOTTOM_NAME = "Bottom Vertical Alignment";
    private static final String _JUSTIFY_START_NAME = "Start Horizontal Alignment";
    private static final String _JUSTIFY_END_NAME = "End Horizontal Alignment";
    private static final String _FONT_NAME = "Font_Name_ComboBox";
    private static final String _SIZE_NAME = "Font_Size_ComboBox";
    private static final String _WIDTH_NAME = "Font_Width_ComboBox";
    private static final String _ACTUAL_SIZE_NAME = "Actual_Font_Size_CheckBox";
    static /* synthetic */ Class class$oracle$bali$ewt$chooser$font$FontPane;

    public static int showDialog(Component component, FontPane fontPane) {
        return FontPane.showDialog(component, fontPane, null, false);
    }

    public static int showDialog(Component component, FontPane fontPane, String string, boolean bl) {
        if (fontPane == null) {
            throw new IllegalArgumentException("FontPane must be non-null");
        }
        JEWTDialog jEWTDialog = JEWTDialog.createDialog(component, string, 7);
        Locale locale = LocaleUtils.getDefaultableLocale((Component)fontPane);
        jEWTDialog.setLocale(locale);
        jEWTDialog.setContent(fontPane);
        jEWTDialog.setCenterOver(component);
        jEWTDialog.setResizable(bl);
        int n = jEWTDialog.runDialog() ? 1 : 2;
        jEWTDialog.dispose();
        return n;
    }

    public FontPane() {
        UIListener uIListener = new UIListener();
        this._exampleComponent = this.createFontPreviewArea();
        this._fontNames = new JComboBox();
        this._fontNames.setEditable(false);
        this._fontNames.addItemListener(uIListener);
        this._setFontName();
        this._fontLabel = new JLabel();
        this._fontLabel.setLabelFor(this._fontNames);
        this._sizes = new JComboBox(_SIZES){

            public void updateUI() {
                this.setEditable(false);
                super.updateUI();
                this.setEditable(true);
            }
        };
        NumberEditor numberEditor = new NumberEditor();
        this._maximumFontSize = 512;
        numberEditor.setMaximum(this._maximumFontSize);
        this._sizes.setEditor(numberEditor);
        this._sizes.setEditable(true);
        this._sizes.addItemListener(uIListener);
        this._sizeLabel = new JLabel();
        this._sizeLabel.setLabelFor(numberEditor);
        this._sizes.putClientProperty("labeledBy", this._sizeLabel);
        this._styleLabel = new JLabel();
        this._bold = new JToggleButton();
        this._bold.setIcon(FontPane._createIcon(0));
        this._bold.setDisabledIcon(FontPane._createDisabledIcon(0));
        this._bold.addItemListener(uIListener);
        this._italic = new JToggleButton();
        this._italic.setIcon(FontPane._createIcon(1));
        this._italic.setDisabledIcon(FontPane._createDisabledIcon(1));
        this._italic.addItemListener(uIListener);
        this._underline = new JToggleButton();
        this._underline.setIcon(FontPane._createIcon(2));
        this._underline.setDisabledIcon(FontPane._createDisabledIcon(2));
        this._underline.addItemListener(uIListener);
        this._strikeThrough = new JToggleButton();
        this._strikeThrough.setIcon(FontPane._createIcon(3));
        this._strikeThrough.setDisabledIcon(FontPane._createDisabledIcon(3));
        this._strikeThrough.addItemListener(uIListener);
        this._superscript = new JToggleButton();
        this._superscript.setIcon(FontPane._createIcon(4));
        this._superscript.setDisabledIcon(FontPane._createDisabledIcon(4));
        this._superscript.addItemListener(uIListener);
        this._subscript = new JToggleButton();
        this._subscript.setIcon(FontPane._createIcon(5));
        this._subscript.setDisabledIcon(FontPane._createDisabledIcon(5));
        this._subscript.addItemListener(uIListener);
        this._widths = new JComboBox();
        this._widths.addItemListener(uIListener);
        this._widthLabel = new JLabel();
        this._widthLabel.setLabelFor(this._widths);
        this._colorComponent = new TitledPane();
        this._colorComponent.setTitle(new JLabel());
        this._textColor = new ColorChoice();
        this._textColor.addPropertyChangeListener(uIListener);
        this._textColorLabel = new JLabel();
        this._textColorLabel.setLabelFor(this._textColor);
        this._backgroundColor = new ColorChoice();
        this._backgroundColor.addPropertyChangeListener(uIListener);
        this._backgroundColorLabel = new JLabel();
        this._backgroundColorLabel.setLabelFor(this._backgroundColor);
        this._borderColor = new ColorChoice();
        this._borderColor.addPropertyChangeListener(uIListener);
        this._borderColorLabel = new JLabel();
        this._borderColorLabel.setLabelFor(this._borderColor);
        this._alignmentComponent = new TitledPane();
        this._alignmentComponent.setTitle(new JLabel());
        this._fullJustify = new JToggleButton();
        this._fullJustify.setIcon(FontPane._createIcon(7));
        this._fullJustify.setDisabledIcon(FontPane._createDisabledIcon(7));
        this._fullJustify.addItemListener(uIListener);
        this._leftJustify = new JToggleButton();
        this._leftJustify.setIcon(FontPane._createIcon(8));
        this._leftJustify.setDisabledIcon(FontPane._createDisabledIcon(8));
        this._leftJustify.addItemListener(uIListener);
        this._centerJustify = new JToggleButton();
        this._centerJustify.setIcon(FontPane._createIcon(9));
        this._centerJustify.setDisabledIcon(FontPane._createDisabledIcon(9));
        this._centerJustify.addItemListener(uIListener);
        this._rightJustify = new JToggleButton();
        this._rightJustify.setIcon(FontPane._createIcon(10));
        this._rightJustify.setDisabledIcon(FontPane._createDisabledIcon(10));
        this._rightJustify.addItemListener(uIListener);
        this._startJustify = new JToggleButton();
        this._startJustify.setIcon(FontPane._createIcon(14));
        this._startJustify.setDisabledIcon(FontPane._createDisabledIcon(14));
        this._startJustify.addItemListener(uIListener);
        this._endJustify = new JToggleButton();
        this._endJustify.setIcon(FontPane._createIcon(15));
        this._endJustify.setDisabledIcon(FontPane._createDisabledIcon(15));
        this._endJustify.addItemListener(uIListener);
        this._noneHorizontal = new JToggleButton();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._fullJustify);
        buttonGroup.add(this._leftJustify);
        buttonGroup.add(this._centerJustify);
        buttonGroup.add(this._rightJustify);
        buttonGroup.add(this._startJustify);
        buttonGroup.add(this._endJustify);
        buttonGroup.add(this._noneHorizontal);
        this._leftJustify.setSelected(true);
        this._laggingFontHorizontalAlignment = 2;
        this._topJustify = new JToggleButton();
        this._topJustify.setIcon(FontPane._createIcon(11));
        this._topJustify.setDisabledIcon(FontPane._createDisabledIcon(11));
        this._topJustify.addItemListener(uIListener);
        this._middleJustify = new JToggleButton();
        this._middleJustify.setIcon(FontPane._createIcon(12));
        this._middleJustify.setDisabledIcon(FontPane._createDisabledIcon(12));
        this._middleJustify.addItemListener(uIListener);
        this._bottomJustify = new JToggleButton();
        this._bottomJustify.setIcon(FontPane._createIcon(13));
        this._bottomJustify.setDisabledIcon(FontPane._createDisabledIcon(13));
        this._bottomJustify.addItemListener(uIListener);
        this._noneVertical = new JToggleButton();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this._topJustify);
        buttonGroup2.add(this._middleJustify);
        buttonGroup2.add(this._bottomJustify);
        buttonGroup2.add(this._noneVertical);
        this._middleJustify.setSelected(true);
        this._laggingFontVerticalAlignment = 0;
        this._exampleLabel = new JLabel();
        this._showFontSize = new JCheckBox();
        this._showFontSize.setSelected(true);
        this._showFontSize.addItemListener(uIListener);
        this._setButtonNames();
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = _sLABEL_INSETS;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this._fontLabel, gridBagConstraints);
        jPanel.add(this._fontLabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(10, 0));
        jPanel2.add("West", this._fontNames);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(3, 0));
        jPanel3.add("West", this._sizeLabel);
        jPanel3.add("East", this._sizes);
        jPanel2.add("East", jPanel3);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = _sDEFAULT_INSETS;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = _sLABEL_INSETS;
        gridBagLayout.setConstraints(this._styleLabel, gridBagConstraints);
        jPanel.add(this._styleLabel);
        JPanel jPanel4 = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = _sDEFAULT_INSETS;
        gridBagConstraints2.anchor = 17;
        jPanel4.setLayout(gridBagLayout2);
        gridBagLayout2.setConstraints(this._bold, gridBagConstraints2);
        jPanel4.add(this._bold);
        gridBagLayout2.setConstraints(this._italic, gridBagConstraints2);
        jPanel4.add(this._italic);
        gridBagLayout2.setConstraints(this._underline, gridBagConstraints2);
        jPanel4.add(this._underline);
        gridBagLayout2.setConstraints(this._strikeThrough, gridBagConstraints2);
        jPanel4.add(this._strikeThrough);
        gridBagConstraints2.insets = _sSEPARATOR_INSETS;
        gridBagLayout2.setConstraints(this._superscript, gridBagConstraints2);
        jPanel4.add(this._superscript);
        gridBagConstraints2.insets = _sDEFAULT_INSETS;
        gridBagConstraints2.gridwidth = 0;
        gridBagLayout2.setConstraints(this._subscript, gridBagConstraints2);
        jPanel4.add(this._subscript);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = _sDEFAULT_INSETS;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel.add(jPanel4);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = _sLABEL_INSETS;
        gridBagLayout.setConstraints(this._widthLabel, gridBagConstraints);
        jPanel.add(this._widthLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = _sDEFAULT_INSETS;
        gridBagLayout.setConstraints(this._widths, gridBagConstraints);
        jPanel.add(this._widths);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this._colorComponent, gridBagConstraints);
        jPanel.add(this._colorComponent);
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        JPanel jPanel5 = new JPanel(gridBagLayout3);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = _sLABEL_INSETS;
        gridBagConstraints3.anchor = 17;
        gridBagLayout3.setConstraints(this._textColorLabel, gridBagConstraints3);
        jPanel5.add(this._textColorLabel);
        gridBagConstraints3.insets = _sDEFAULT_INSETS;
        gridBagLayout3.setConstraints(this._textColor, gridBagConstraints3);
        jPanel5.add(this._textColor);
        JPanel jPanel6 = new JPanel(new BorderLayout(3, 3));
        jPanel6.add("West", this._borderColorLabel);
        jPanel6.add("East", this._borderColor);
        gridBagConstraints3.insets = _sBORDER_COLOR_INSETS;
        gridBagConstraints3.gridwidth = 0;
        gridBagLayout3.setConstraints(jPanel6, gridBagConstraints3);
        jPanel5.add(jPanel6);
        gridBagConstraints3.insets = _sLABEL_INSETS;
        gridBagConstraints3.gridwidth = 1;
        gridBagLayout3.setConstraints(this._backgroundColorLabel, gridBagConstraints3);
        jPanel5.add(this._backgroundColorLabel);
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.insets = _sDEFAULT_INSETS;
        gridBagLayout3.setConstraints(this._backgroundColor, gridBagConstraints3);
        jPanel5.add(this._backgroundColor);
        JPanel jPanel7 = new JPanel(new BorderLayout());
        jPanel7.add("West", jPanel5);
        this._colorComponent.setContent(jPanel7);
        this._clientContainer = new JPanel();
        this._clientContainer.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(gridBagLayout4);
        jPanel8.setBorder(new EmptyBorder(3, 0, 0, 0));
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.insets = _sDEFAULT_INSETS;
        gridBagConstraints4.anchor = 17;
        gridBagLayout4.setConstraints(this._fullJustify, gridBagConstraints4);
        jPanel8.add(this._fullJustify);
        gridBagLayout4.setConstraints(this._leftJustify, gridBagConstraints4);
        jPanel8.add(this._leftJustify);
        gridBagLayout4.setConstraints(this._centerJustify, gridBagConstraints4);
        jPanel8.add(this._centerJustify);
        gridBagLayout4.setConstraints(this._rightJustify, gridBagConstraints4);
        jPanel8.add(this._rightJustify);
        gridBagConstraints4.insets = _sSEPARATOR_INSETS;
        gridBagLayout4.setConstraints(this._topJustify, gridBagConstraints4);
        jPanel8.add(this._topJustify);
        gridBagConstraints4.insets = _sDEFAULT_INSETS;
        gridBagLayout4.setConstraints(this._middleJustify, gridBagConstraints4);
        jPanel8.add(this._middleJustify);
        gridBagLayout4.setConstraints(this._bottomJustify, gridBagConstraints4);
        jPanel8.add(this._bottomJustify);
        gridBagConstraints4.insets = _sSEPARATOR_INSETS;
        gridBagLayout4.setConstraints(this._startJustify, gridBagConstraints4);
        jPanel8.add(this._startJustify);
        gridBagConstraints4.insets = _sDEFAULT_INSETS;
        gridBagConstraints4.gridwidth = 0;
        gridBagLayout4.setConstraints(this._endJustify, gridBagConstraints4);
        jPanel8.add(this._endJustify);
        JPanel jPanel9 = new JPanel(new BorderLayout());
        jPanel9.add("West", jPanel8);
        this._alignmentComponent.setContent(jPanel9);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this._alignmentComponent, gridBagConstraints);
        jPanel.add(this._alignmentComponent);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BorderLayout(0, 3));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BorderLayout(0, 3));
        jPanel11.add("West", jPanel);
        jPanel10.add("North", jPanel11);
        jPanel10.add("Center", this._clientContainer);
        this._exampleArea = new JPanel();
        this._exampleArea.setLayout(new BorderLayout(0, 3));
        this._exampleArea.add("North", this._exampleLabel);
        this._exampleArea.add("Center", this._exampleComponent);
        this._exampleArea.add("South", this._showFontSize);
        this.setLayout(new FontPaneLayout());
        this.add(_LEFT_CONSTRAINT, jPanel10);
        this.add(this._exampleArea);
        String string = System.getProperty("java.version");
        boolean bl = string == null ? false : string.startsWith("1.1");
        int n = bl ? 3 : 63;
        int n2 = 462;
        int n3 = 3;
        this.setStyleButtonMask(n);
        this.setAlignmentButtonMask(n2);
        this.setColorComponentMask(n3);
        this.setWidthVisible(false);
        this.setFontSize(12);
    }

    public String[] getFontNames() {
        int n = this._fontNames.getItemCount();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this._fontNames.getItemAt(n2).toString();
            ++n2;
        }
        return stringArray;
    }

    public void setFontNames(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        }
        this._fontNames.setModel(new DefaultComboBoxModel<String>(stringArray));
        if (this._fontNames.getModel().getSize() > 0) {
            this._fontNames.setSelectedIndex(0);
        }
    }

    public String getFontName() {
        return (String)this._fontNames.getSelectedItem();
    }

    public void setFontName(String string) {
        if (string != null) {
            int n = this._fontNames.getItemCount();
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                if (this._fontNames.getItemAt(n2).equals(string)) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                throw new IllegalArgumentException("font name not found: " + string);
            }
        }
        this._fontNames.setSelectedItem(string);
    }

    public int getFontSize() {
        int n = -1;
        Object object = this._sizes.getSelectedItem();
        if (object instanceof Number) {
            n = ((Number)object).intValue();
        }
        return n;
    }

    public void setFontSize(int n) {
        if (n > this._maximumFontSize) {
            throw new IllegalArgumentException("Specified font size(" + n + ") is greater than the maximum font size(" + this._maximumFontSize + ")");
        }
        if (n == -1) {
            this._sizes.setSelectedItem(null);
        } else {
            this._sizes.setSelectedItem(IntegerUtils.getInteger((int)n));
        }
        this.updateExampleFont();
    }

    public void setMaximumFontSize(int n) {
        if (n != this._maximumFontSize) {
            if (this.getFontSize() > n) {
                this.setFontSize(n);
            }
            this._maximumFontSize = n;
            ((NumberEditor)this._sizes.getEditor()).setMaximum(this._maximumFontSize);
        }
    }

    public int getMaximumFontSize() {
        return this._maximumFontSize;
    }

    public void setFontStyle(int n) {
        boolean bl = (n & 1) != 0;
        this._bold.setSelected(bl);
        boolean bl2 = (n & 2) != 0;
        this._italic.setSelected(bl2);
        boolean bl3 = (n & 4) != 0;
        this._underline.setSelected(bl3);
        boolean bl4 = (n & 8) != 0;
        this._strikeThrough.setSelected(bl4);
        this._exampleComponent.setFontStyle(n);
        this._laggingFontStyle = n;
    }

    public int getFontStyle() {
        int n = 0;
        if (this._bold.isSelected()) {
            n |= 1;
        }
        if (this._italic.isSelected()) {
            n |= 2;
        }
        if (this._underline.isSelected()) {
            n |= 4;
        }
        if (this._strikeThrough.isSelected()) {
            n |= 8;
        }
        return n;
    }

    public void setFontBaselineStyle(int n) {
        switch (n) {
            case 2: {
                this._superscript.setSelected(true);
                this._subscript.setSelected(false);
                this._exampleComponent.setBaselineVisible(true);
                break;
            }
            case 3: {
                this._subscript.setSelected(true);
                this._superscript.setSelected(false);
                this._exampleComponent.setBaselineVisible(true);
                break;
            }
            case 1: {
                this._superscript.setSelected(false);
                this._subscript.setSelected(false);
                this._exampleComponent.setBaselineVisible(this._superscript.isVisible() | this._subscript.isVisible());
                break;
            }
        }
        this._laggingFontBaselineStyle = n;
    }

    public int getFontBaselineStyle() {
        if (this._superscript.isSelected()) {
            return 2;
        }
        if (this._subscript.isSelected()) {
            return 3;
        }
        return 1;
    }

    public void setFontWidth(int n) {
        if ((n < 0 || n > 4) && n != -1) {
            n = 2;
        }
        if (this._widths.getItemCount() > 0) {
            this._widths.setSelectedIndex(n);
        } else {
            this._originalFontWidth = n;
        }
        this._laggingFontWidth = n;
    }

    public int getFontWidth() {
        if (this._widths.getItemCount() > 0) {
            return this._widths.getSelectedIndex();
        }
        if (this._originalFontWidth != -2) {
            return this._originalFontWidth;
        }
        return 2;
    }

    public void setFontColor(Color color) {
        Color color2 = this.getFontColor();
        color = FontPane._trySetColorChoice(this._textColor, color);
        this._exampleComponent.setFontColor(color);
        this.firePropertyChange(PROPERTY_FONT_COLOR, color2, color);
        this._laggingFontColor = color;
        this._fontColorSet = true;
    }

    public Color getFontColor() {
        return this._textColor.getSelectedColor();
    }

    public void setFontBackgroundColor(Color color) {
        Color color2 = this.getFontBackgroundColor();
        color = FontPane._trySetColorChoice(this._backgroundColor, color);
        this._exampleComponent.setFontBackgroundColor(color);
        this.firePropertyChange(PROPERTY_FONT_BACKGROUND_COLOR, color2, color);
        this._laggingFontBackgroundColor = color;
        this._fontBackgroundColorSet = true;
    }

    public Color getFontBackgroundColor() {
        return this._backgroundColor.getSelectedColor();
    }

    public void setBorderColor(Color color) {
        Color color2 = this.getBorderColor();
        color = FontPane._trySetColorChoice(this._borderColor, color);
        this._exampleComponent.setFontBorderColor(color);
        this.firePropertyChange(PROPERTY_BORDER_COLOR, color2, color);
        this._laggingBorderColor = color;
        this._fontBorderColorSet = true;
    }

    public Color getBorderColor() {
        return this._borderColor.getSelectedColor();
    }

    public void setFontHorizontalAlignment(int n) {
        switch (n) {
            case 100: {
                this._fullJustify.setSelected(true);
                break;
            }
            case 2: {
                this._leftJustify.setSelected(true);
                break;
            }
            case 0: {
                this._centerJustify.setSelected(true);
                break;
            }
            case 4: {
                this._rightJustify.setSelected(true);
                break;
            }
            case 10: {
                this._startJustify.setSelected(true);
                break;
            }
            case 11: {
                this._endJustify.setSelected(true);
                break;
            }
            case -1: {
                this._noneHorizontal.setSelected(true);
                break;
            }
        }
        this._laggingFontHorizontalAlignment = n;
        this._exampleComponent.setFontHorizontalAlignment(n);
    }

    public int getFontHorizontalAlignment() {
        if (this._fullJustify.isSelected()) {
            return 100;
        }
        if (this._leftJustify.isSelected()) {
            return 2;
        }
        if (this._centerJustify.isSelected()) {
            return 0;
        }
        if (this._rightJustify.isSelected()) {
            return 4;
        }
        if (this._startJustify.isSelected()) {
            return 10;
        }
        if (this._endJustify.isSelected()) {
            return 11;
        }
        if (this._noneHorizontal.isSelected()) {
            return -1;
        }
        return 0;
    }

    public void setFontVerticalAlignment(int n) {
        switch (n) {
            case 1: {
                this._topJustify.setSelected(true);
                break;
            }
            case 0: {
                this._middleJustify.setSelected(true);
                break;
            }
            case 3: {
                this._bottomJustify.setSelected(true);
                break;
            }
            case -1: {
                this._noneVertical.setSelected(true);
                break;
            }
        }
        this._laggingFontVerticalAlignment = n;
        this._exampleComponent.setFontVerticalAlignment(n);
    }

    public int getFontVerticalAlignment() {
        if (this._topJustify.isSelected()) {
            return 1;
        }
        if (this._middleJustify.isSelected()) {
            return 0;
        }
        if (this._bottomJustify.isSelected()) {
            return 3;
        }
        if (this._noneVertical.isSelected()) {
            return -1;
        }
        return 0;
    }

    public void setStyleButtonMask(int n) {
        int n2 = this.getStyleButtonMask();
        this._bold.setVisible((n & 1) != 0);
        this._italic.setVisible((n & 2) != 0);
        this._underline.setVisible((n & 4) != 0);
        this._strikeThrough.setVisible((n & 8) != 0);
        boolean bl = (n & 0x10) != 0;
        boolean bl2 = (n & 0x20) != 0;
        this._superscript.setVisible(bl);
        this._subscript.setVisible(bl2);
        this._exampleComponent.setBaselineVisible(bl | bl2 | this._superscript.isSelected() | this._subscript.isSelected());
        this._styleLabel.setVisible(n != 0);
        this.firePropertyChange(PROPERTY_STYLE_BUTTON_MASK, n2, n);
        this.revalidate();
    }

    public int getStyleButtonMask() {
        int n = 0;
        if (this._bold.isVisible()) {
            n |= 1;
        }
        if (this._italic.isVisible()) {
            n |= 2;
        }
        if (this._underline.isVisible()) {
            n |= 4;
        }
        if (this._strikeThrough.isVisible()) {
            n |= 8;
        }
        if (this._superscript.isVisible()) {
            n |= 0x10;
        }
        if (this._subscript.isVisible()) {
            n |= 0x20;
        }
        return n;
    }

    public void setWidthVisible(boolean bl) {
        this._widths.setVisible(bl);
        this._widthLabel.setVisible(bl);
        this.revalidate();
    }

    public boolean isWidthVisible() {
        return this._widths.isVisible();
    }

    public void setColorComponentMask(int n) {
        int n2 = this.getColorComponentMask();
        boolean bl = (n & 1) != 0;
        boolean bl2 = (n & 2) != 0;
        boolean bl3 = (n & 4) != 0;
        this._textColor.setVisible(bl);
        this._textColorLabel.setVisible(bl);
        this._backgroundColor.setVisible(bl2);
        this._backgroundColorLabel.setVisible(bl2);
        this._borderColor.setVisible(bl3);
        this._borderColorLabel.setVisible(bl3);
        this._exampleComponent.setFontBorderVisible(bl3);
        this._colorComponent.setVisible(bl || bl2 || bl3);
        this.firePropertyChange(PROPERTY_COLOR_COMPONENT_MASK, n2, n);
        this.revalidate();
    }

    public int getColorComponentMask() {
        int n = 0;
        if (this._textColor.isVisible()) {
            n |= 1;
        }
        if (this._backgroundColor.isVisible()) {
            n |= 2;
        }
        if (this._borderColor.isVisible()) {
            n |= 4;
        }
        return n;
    }

    public void setAlignmentButtonMask(int n) {
        int n2 = this.getAlignmentButtonMask();
        this._fullJustify.setVisible((n & 1) != 0);
        this._leftJustify.setVisible((n & 2) != 0);
        this._centerJustify.setVisible((n & 4) != 0);
        this._rightJustify.setVisible((n & 8) != 0);
        this._startJustify.setVisible((n & 0x10) != 0);
        this._endJustify.setVisible((n & 0x20) != 0);
        this._topJustify.setVisible((n & 0x40) != 0);
        this._middleJustify.setVisible((n & 0x80) != 0);
        this._bottomJustify.setVisible((n & 0x100) != 0);
        this._alignmentComponent.setVisible(n != 0);
        this.firePropertyChange(PROPERTY_ALIGNMENT_BUTTON_MASK, n2, n);
        this.revalidate();
    }

    public int getAlignmentButtonMask() {
        int n = 0;
        if (this._fullJustify.isVisible()) {
            n |= 1;
        }
        if (this._leftJustify.isVisible()) {
            n |= 2;
        }
        if (this._centerJustify.isVisible()) {
            n |= 4;
        }
        if (this._rightJustify.isVisible()) {
            n |= 8;
        }
        if (this._startJustify.isVisible()) {
            n |= 0x10;
        }
        if (this._endJustify.isVisible()) {
            n |= 0x20;
        }
        if (this._topJustify.isVisible()) {
            n |= 0x40;
        }
        if (this._middleJustify.isVisible()) {
            n |= 0x80;
        }
        if (this._bottomJustify.isVisible()) {
            n |= 0x100;
        }
        return n;
    }

    public void setExtraComponent(Component component) {
        Component component2 = this.getExtraComponent();
        if (component2 != null) {
            this._clientContainer.remove(component2);
        }
        if (component != null) {
            this._clientContainer.add("West", component);
            component.setEnabled(this.isEnabled());
        }
        this.revalidate();
    }

    public Component getExtraComponent() {
        int n = this._clientContainer.getComponentCount();
        return n < 1 ? null : this._clientContainer.getComponent(0);
    }

    public void setPreviewAreaVisible(boolean bl) {
        this._exampleArea.setVisible(bl);
        this.revalidate();
        this.repaint();
    }

    public boolean isPreviewAreaVisible() {
        return this._exampleArea.isVisible();
    }

    public Font getCurrentFont() {
        String string = this.getFontName();
        int n = this.getFontSize();
        if (string == null || n == -1) {
            return null;
        }
        boolean bl = this._bold.isSelected();
        boolean bl2 = this._italic.isSelected();
        int n2 = 0;
        if (bl) {
            n2 |= 1;
        }
        if (bl2) {
            n2 |= 2;
        }
        return new Font(string, n2, n);
    }

    public void setCurrentFont(Font font) {
        if (font == null) {
            this.setFontName(null);
            this.setFontStyle(0);
            this.setFontSize(-1);
        } else {
            int n;
            String string = font.getName();
            this._fontNames.setSelectedItem(string);
            this._laggingFontName = string;
            int n2 = font.getSize();
            if (n2 > this._maximumFontSize) {
                throw new IllegalArgumentException("Specified font size(" + n2 + ") is greater than the maximum font size(" + this._maximumFontSize + ")");
            }
            this._sizes.setSelectedItem(IntegerUtils.getInteger((int)n2));
            this._laggingFontSize = n2;
            this._laggingFontStyle = n = font.getStyle();
            boolean bl = (n & 1) != 0;
            this._bold.setSelected(bl);
            boolean bl2 = (n & 2) != 0;
            this._italic.setSelected(bl2);
            this._setExampleFont(font);
        }
    }

    public Font getFontWithAttributes() {
        Color color;
        String string = this.getFontName();
        int n = this.getFontSize();
        if (string == null || n == -1) {
            return null;
        }
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>(11);
        hashMap.put(TextAttribute.FAMILY, string);
        if (this._bold.isSelected()) {
            hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (this._italic.isSelected()) {
            hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        if (this._underline.isSelected()) {
            hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (this._strikeThrough.isSelected()) {
            hashMap.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        hashMap.put(TextAttribute.SIZE, new Float(n));
        if (this._superscript.isSelected()) {
            hashMap.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
        } else if (this._subscript.isSelected()) {
            hashMap.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
        }
        int n2 = this.getFontWidth();
        switch (n2) {
            case 0: {
                hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_CONDENSED);
                break;
            }
            case 4: {
                hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_EXTENDED);
                break;
            }
            case 1: {
                hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_CONDENSED);
                break;
            }
            case 3: {
                hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_EXTENDED);
            }
        }
        Color color2 = this.getFontColor();
        if (color2 != null) {
            hashMap.put(TextAttribute.FOREGROUND, color2);
        }
        if ((color = this.getFontBackgroundColor()) != null) {
            hashMap.put(TextAttribute.BACKGROUND, color);
        }
        if (this._fullJustify.isSelected()) {
            hashMap.put(TextAttribute.JUSTIFICATION, TextAttribute.JUSTIFICATION_FULL);
        }
        return new Font(hashMap);
    }

    public void setFontWithAttributes(Font font) {
        boolean bl = false;
        Map<TextAttribute, ?> map = null;
        if (font == null) {
            bl = true;
        } else {
            map = font.getAttributes();
            if (map == null) {
                bl = true;
            }
        }
        if (bl) {
            this.setFontName(null);
            this.setFontStyle(0);
            this.setFontSize(-1);
            this.setFontBaselineStyle(1);
            this.setFontWidth(-1);
            this.setFontColor(null);
            this.setFontBackgroundColor(null);
            this.setFontHorizontalAlignment(-1);
        } else {
            Object object;
            String string = font.getName();
            this.setFontName(string);
            int n = 0;
            if (font.isBold()) {
                n |= 1;
            }
            if (font.isItalic()) {
                n |= 2;
            }
            if (TextAttribute.UNDERLINE_ON.equals(object = map.get(TextAttribute.UNDERLINE))) {
                n |= 4;
            }
            if (TextAttribute.STRIKETHROUGH_ON.equals(object = map.get(TextAttribute.STRIKETHROUGH))) {
                n |= 8;
            }
            this.setFontStyle(n);
            this.setFontSize(font.getSize());
            int n2 = 1;
            object = map.get(TextAttribute.SUPERSCRIPT);
            if (TextAttribute.SUPERSCRIPT_SUB.equals(object)) {
                n2 = 3;
            } else if (TextAttribute.SUPERSCRIPT_SUPER.equals(object)) {
                n2 = 2;
            }
            this.setFontBaselineStyle(n2);
            int n3 = 2;
            object = map.get(TextAttribute.WIDTH);
            if (TextAttribute.WIDTH_CONDENSED.equals(object)) {
                n3 = 0;
            } else if (TextAttribute.WIDTH_EXTENDED.equals(object)) {
                n3 = 4;
            } else if (TextAttribute.WIDTH_SEMI_CONDENSED.equals(object)) {
                n3 = 1;
            } else if (TextAttribute.WIDTH_SEMI_EXTENDED.equals(object)) {
                n3 = 3;
            }
            this.setFontWidth(n3);
            object = map.get(TextAttribute.FOREGROUND);
            if (object == null) {
                object = this.getUIDefaults().getColor(LookAndFeel.TEXT_TEXT);
            }
            this.setFontColor((Color)object);
            object = map.get(TextAttribute.BACKGROUND);
            if (object == null) {
                object = this.getUIDefaults().getColor(LookAndFeel.TEXT);
            }
            this.setFontBackgroundColor((Color)object);
            object = map.get(TextAttribute.JUSTIFICATION);
            if (TextAttribute.JUSTIFICATION_FULL.equals(object)) {
                this.setFontHorizontalAlignment(100);
            }
            this._setExampleFont(font);
        }
    }

    public void setActualFontSizeVisible(boolean bl) {
        if (bl != this._showFontSize.isVisible()) {
            this._showFontSize.setVisible(bl);
            this.revalidate();
        }
    }

    public boolean isActualFontSizeVisible() {
        return this._showFontSize == null ? false : this._showFontSize.isVisible();
    }

    public void setActualFontSizeUsed(boolean bl) {
        if (bl != this._showFontSize.isSelected()) {
            this._showFontSize.setSelected(bl);
            this.updateExampleFont();
        }
    }

    public boolean isActualFontSizeUsed() {
        return this._showFontSize == null ? true : this._showFontSize.isSelected();
    }

    public ColorChoice getFontColorChoice() {
        return this._textColor;
    }

    public ColorChoice getFontBackgroundColorChoice() {
        return this._backgroundColor;
    }

    public ColorChoice getBorderColorChoice() {
        return this._borderColor;
    }

    public void addNotify() {
        super.addNotify();
        this._updateLabels(this.getLocale());
        if (!this._fontColorSet) {
            FontPane._trySetColorChoice(this._textColor, this._exampleComponent.getFontColor());
        }
        if (!this._fontBackgroundColorSet) {
            FontPane._trySetColorChoice(this._backgroundColor, this._exampleComponent.getFontBackgroundColor());
        }
        if (!this._fontBorderColorSet) {
            FontPane._trySetColorChoice(this._borderColor, this._exampleComponent.getFontBorderColor());
        }
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this._fontLabel != null) {
            this._updateLabels(locale);
        }
        if (this._exampleComponent != null) {
            this._exampleComponent.setLocale(locale);
        }
        if (this._textColor != null) {
            this._textColor.setLocale(locale);
        }
        if (this._backgroundColor != null) {
            this._backgroundColor.setLocale(locale);
        }
        if (this._borderColor != null) {
            this._borderColor.setLocale(locale);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleFontPane();
        }
        return this.accessibleContext;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._fontNames.setEnabled(bl);
        this._sizes.setEnabled(bl);
        this._bold.setEnabled(bl);
        this._italic.setEnabled(bl);
        this._underline.setEnabled(bl);
        this._strikeThrough.setEnabled(bl);
        this._superscript.setEnabled(bl);
        this._subscript.setEnabled(bl);
        this._widths.setEnabled(bl);
        this._textColor.setEnabled(bl);
        this._backgroundColor.setEnabled(bl);
        this._borderColor.setEnabled(bl);
        this._fullJustify.setEnabled(bl);
        this._leftJustify.setEnabled(bl);
        this._centerJustify.setEnabled(bl);
        this._rightJustify.setEnabled(bl);
        this._startJustify.setEnabled(bl);
        this._endJustify.setEnabled(bl);
        this._topJustify.setEnabled(bl);
        this._middleJustify.setEnabled(bl);
        this._bottomJustify.setEnabled(bl);
        this._showFontSize.setEnabled(bl);
        if (this.getExtraComponent() != null) {
            this.getExtraComponent().setEnabled(bl);
        }
        this._styleLabel.setEnabled(bl);
        this._widthLabel.setEnabled(bl);
        this._fontLabel.setEnabled(bl);
        this._sizeLabel.setEnabled(bl);
        this._alignmentComponent.getTitle().setEnabled(bl);
        this._colorComponent.getTitle().setEnabled(bl);
        this._textColorLabel.setEnabled(bl);
        this._backgroundColorLabel.setEnabled(bl);
        this._borderColorLabel.setEnabled(bl);
        this._exampleComponent.setEnabled(bl);
        this._exampleLabel.setEnabled(bl);
    }

    public static String getPreviewText(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE, locale);
        return resourceBundle.getString(_KEY_EXAMPLE_TEXT);
    }

    public static String[] getDisplayableFonts() {
        return FontPane.getDisplayableFonts(FontPane.getPreviewText(Locale.getDefault()));
    }

    public static String[] getDisplayableFonts(String string) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        if (string == null) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (new Font(stringArray[n2], 0, 12).canDisplayUpTo(string) == -1) {
                stringArray2[n++] = stringArray[n2];
            }
            ++n2;
        }
        String[] stringArray3 = new String[n];
        System.arraycopy(stringArray2, 0, stringArray3, 0, n);
        return stringArray3;
    }

    protected FontPreviewArea createFontPreviewArea() {
        return new FontPreviewArea();
    }

    Component __getFirstFocusComponent() {
        return this._fontNames;
    }

    void updateExampleFont() {
        this._setExampleFont(this.getCurrentFont());
    }

    void fireEvent(Object object, boolean bl) {
        if (object == this._fontNames) {
            if (bl) {
                this.firePropertyChange(PROPERTY_FONT_NAME, this._laggingFontName, this.getFontName());
                this._laggingFontName = this.getFontName();
            }
        } else if (object == this._sizes) {
            if (bl) {
                this.firePropertyChange(PROPERTY_FONT_SIZE, this._laggingFontSize, this.getFontSize());
                this._laggingFontSize = this.getFontSize();
            }
        } else if (object == this._bold || object == this._italic || object == this._underline || object == this._strikeThrough) {
            int n = this.getFontStyle();
            this._exampleComponent.setFontStyle(n);
            this.firePropertyChange(PROPERTY_FONT_STYLE, this._laggingFontStyle, n);
            this._laggingFontStyle = n;
        } else if (object == this._superscript || object == this._subscript) {
            if (bl) {
                if (object == this._superscript) {
                    this._subscript.setSelected(false);
                } else {
                    this._superscript.setSelected(false);
                }
            }
            int n = this.getFontBaselineStyle();
            this._exampleComponent.setFontBaselineStyle(n);
            this.firePropertyChange(PROPERTY_FONT_BASELINE_STYLE, this._laggingFontBaselineStyle, n);
            this._laggingFontBaselineStyle = n;
        } else if (object == this._widths) {
            if (bl) {
                this.firePropertyChange(PROPERTY_FONT_WIDTH, this._laggingFontWidth, this.getFontWidth());
                this._exampleComponent.setFontWidth(this.getFontWidth());
                this._laggingFontWidth = this.getFontWidth();
            }
        } else if (object == this._fullJustify || object == this._leftJustify || object == this._rightJustify || object == this._centerJustify || object == this._startJustify || object == this._endJustify) {
            if (bl) {
                int n = this.getFontHorizontalAlignment();
                this._exampleComponent.setFontHorizontalAlignment(n);
                this.firePropertyChange(PROPERTY_FONT_HORIZONTAL_ALIGNMENT, this._laggingFontHorizontalAlignment, n);
                this._laggingFontHorizontalAlignment = n;
            }
        } else if (object == this._topJustify || object == this._bottomJustify || object == this._middleJustify) {
            if (bl) {
                int n = this.getFontVerticalAlignment();
                this._exampleComponent.setFontVerticalAlignment(n);
                this.firePropertyChange(PROPERTY_FONT_VERTICAL_ALIGNMENT, this._laggingFontVerticalAlignment, n);
                this._laggingFontVerticalAlignment = n;
            }
        } else if (object == this._showFontSize) {
            this.firePropertyChange(PROPERTY_ACTUAL_FONT_SIZE_USED, new Boolean(!this.isActualFontSizeUsed()), new Boolean(this.isActualFontSizeUsed()));
        } else if (object == this._textColor) {
            Color color = this._textColor.getSelectedColor();
            this._exampleComponent.setFontColor(color);
            this.firePropertyChange(PROPERTY_FONT_COLOR, this._laggingFontColor, color);
            this._laggingFontColor = color;
        } else if (object == this._borderColor) {
            Color color = this._borderColor.getSelectedColor();
            this._exampleComponent.setFontBorderColor(color);
            this.firePropertyChange(PROPERTY_BORDER_COLOR, this._laggingBorderColor, color);
            this._laggingBorderColor = color;
        } else if (object == this._backgroundColor) {
            Color color = this._backgroundColor.getSelectedColor();
            this._exampleComponent.setFontBackgroundColor(color);
            this.firePropertyChange(PROPERTY_FONT_BACKGROUND_COLOR, this._laggingFontBackgroundColor, color);
            this._laggingFontBackgroundColor = color;
        }
    }

    private static Icon _createIcon(int n) {
        if (_sIconStrip == null) {
            Image image = ImageUtils.getImageResource(class$oracle$bali$ewt$chooser$font$FontPane == null ? (class$oracle$bali$ewt$chooser$font$FontPane = FontPane.class$("oracle.bali.ewt.chooser.font.FontPane")) : class$oracle$bali$ewt$chooser$font$FontPane, "icons/fontstrip.gif");
            _sIconStrip = new IconStrip(image, 16, false);
        }
        return _sIconStrip.getIcon(n);
    }

    private static Icon _createDisabledIcon(int n) {
        if (_sDisabledIconStrip == null) {
            Image image = ImageUtils.getImageResource(class$oracle$bali$ewt$chooser$font$FontPane == null ? (class$oracle$bali$ewt$chooser$font$FontPane = FontPane.class$("oracle.bali.ewt.chooser.font.FontPane")) : class$oracle$bali$ewt$chooser$font$FontPane, "icons/fontstrip.gif");
            _sDisabledIconStrip = new IconStrip(image, 16, true);
        }
        return _sDisabledIconStrip.getIcon(n);
    }

    private static Color _trySetColorChoice(ColorChoice colorChoice, Color color) {
        try {
            boolean bl = ColorChoice.isColorInPalette(colorChoice.getColorPalette(), color);
            colorChoice.setSelectedColor(color, !bl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            color = colorChoice.getClosestColor(color);
            colorChoice.setSelectedColor(color);
        }
        return color;
    }

    private static void _setText(JToggleButton jToggleButton, String string, String string2) {
        jToggleButton.setToolTipText(string);
        jToggleButton.getAccessibleContext().setAccessibleName(string2);
        jToggleButton.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
    }

    private void _setExampleFont(Font font) {
        int n = this.getFontSize();
        if (!this.isActualFontSizeUsed() || n == -1) {
            n = 12;
        }
        if (font != null) {
            font = new Font(font.getName(), font.getStyle(), n);
        } else {
            int n2 = 0;
            if (this._bold.isSelected()) {
                n2 |= 1;
            }
            if (this._italic.isSelected()) {
                n2 |= 2;
            }
            font = new Font(null, n2, n);
        }
        this._exampleComponent.setCurrentFont(font);
    }

    private void _setButtonNames() {
        this._bold.setName(_BOLD_NAME);
        this._italic.setName(_ITALIC_NAME);
        this._underline.setName(_UNDERLINE_NAME);
        this._strikeThrough.setName(_STRIKETHRU_NAME);
        this._superscript.setName(_SUPERSCRIPT_NAME);
        this._subscript.setName(_SUBSCRIPT_NAME);
        this._textColor.setName(_TEXT_COLOR_NAME);
        this._backgroundColor.setName(_BACKGROUND_COLOR_NAME);
        this._borderColor.setName(_BORDER_COLOR_NAME);
        this._fullJustify.setName(_JUSTIFY_FULL_NAME);
        this._leftJustify.setName(_JUSTIFY_LEFT_NAME);
        this._centerJustify.setName(_JUSTIFY_CENTER_NAME);
        this._rightJustify.setName(_JUSTIFY_RIGHT_NAME);
        this._topJustify.setName(_JUSTIFY_TOP_NAME);
        this._middleJustify.setName(_JUSTIFY_MIDDLE_NAME);
        this._bottomJustify.setName(_JUSTIFY_BOTTOM_NAME);
        this._startJustify.setName(_JUSTIFY_START_NAME);
        this._endJustify.setName(_JUSTIFY_END_NAME);
        this._fontNames.setName(_FONT_NAME);
        this._sizes.setName(_SIZE_NAME);
        this._widths.setName(_WIDTH_NAME);
        this._showFontSize.setName(_ACTUAL_SIZE_NAME);
    }

    private void _updateLabels(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE, locale);
        ResourceBundle resourceBundle2 = ResourceBundle.getBundle(_ACCESS_RESOURCE, locale);
        String string = resourceBundle.getString(_KEY_FONT);
        this._fontLabel.setText(StringUtils.stripMnemonic((String)string));
        this._fontLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        string = resourceBundle.getString(_KEY_SIZE);
        this._sizeLabel.setText(StringUtils.stripMnemonic((String)string));
        this._sizeLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this._styleLabel.setText(resourceBundle.getString(_KEY_STYLE));
        FontPane._setText(this._bold, resourceBundle.getString(_KEY_BOLD), resourceBundle2.getString(_KEY_BOLD));
        FontPane._setText(this._italic, resourceBundle.getString(_KEY_ITALIC), resourceBundle2.getString(_KEY_ITALIC));
        FontPane._setText(this._underline, resourceBundle.getString(_KEY_UNDERLINE), resourceBundle2.getString(_KEY_UNDERLINE));
        FontPane._setText(this._strikeThrough, resourceBundle.getString(_KEY_STRIKETHRU), resourceBundle2.getString(_KEY_STRIKETHRU));
        FontPane._setText(this._superscript, resourceBundle.getString(_KEY_SUPERSCRIPT), resourceBundle2.getString(_KEY_SUPERSCRIPT));
        FontPane._setText(this._subscript, resourceBundle.getString(_KEY_SUBSCRIPT), resourceBundle2.getString(_KEY_SUBSCRIPT));
        int n = this._widths.getSelectedIndex();
        if (this._widths.getItemCount() > 0) {
            this._widths.removeAllItems();
        }
        this._widths.addItem(resourceBundle.getString(_KEY_CONDENSED));
        this._widths.addItem(resourceBundle.getString(_KEY_SEMI_CONDENSED));
        this._widths.addItem(resourceBundle.getString(_KEY_NORMAL));
        this._widths.addItem(resourceBundle.getString(_KEY_SEMI_EXPANDED));
        this._widths.addItem(resourceBundle.getString(_KEY_EXPANDED));
        if (this._originalFontWidth != -2) {
            n = this._originalFontWidth;
            this._originalFontWidth = -2;
        } else if (n == -1) {
            n = 2;
        }
        this._widths.setSelectedIndex(n);
        string = resourceBundle.getString(_KEY_WIDTH);
        this._widthLabel.setText(StringUtils.stripMnemonic((String)string));
        this._widthLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        JLabel jLabel = (JLabel)this._colorComponent.getTitle();
        jLabel.setText(resourceBundle.getString(_KEY_COLOR));
        string = resourceBundle.getString(_KEY_TEXT_COLOR);
        this._textColorLabel.setText(StringUtils.stripMnemonic((String)string));
        this._textColorLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        string = resourceBundle.getString(_KEY_BACKGROUND_COLOR);
        this._backgroundColorLabel.setText(StringUtils.stripMnemonic((String)string));
        this._backgroundColorLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        string = resourceBundle.getString(_KEY_BORDER_COLOR);
        this._borderColorLabel.setText(StringUtils.stripMnemonic((String)string));
        this._borderColorLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        jLabel = (JLabel)this._alignmentComponent.getTitle();
        jLabel.setText(resourceBundle.getString(_KEY_ALIGNMENT));
        FontPane._setText(this._fullJustify, resourceBundle.getString(_KEY_JUSTIFY_FULL), resourceBundle2.getString(_KEY_JUSTIFY_FULL));
        FontPane._setText(this._leftJustify, resourceBundle.getString(_KEY_JUSTIFY_LEFT), resourceBundle2.getString(_KEY_JUSTIFY_LEFT));
        FontPane._setText(this._centerJustify, resourceBundle.getString(_KEY_JUSTIFY_CENTER), resourceBundle2.getString(_KEY_JUSTIFY_CENTER));
        FontPane._setText(this._rightJustify, resourceBundle.getString(_KEY_JUSTIFY_RIGHT), resourceBundle2.getString(_KEY_JUSTIFY_RIGHT));
        FontPane._setText(this._startJustify, resourceBundle.getString(_KEY_JUSTIFY_START), resourceBundle2.getString(_KEY_JUSTIFY_START));
        FontPane._setText(this._endJustify, resourceBundle.getString(_KEY_JUSTIFY_END), resourceBundle2.getString(_KEY_JUSTIFY_END));
        FontPane._setText(this._topJustify, resourceBundle.getString(_KEY_JUSTIFY_TOP), resourceBundle2.getString(_KEY_JUSTIFY_TOP));
        FontPane._setText(this._middleJustify, resourceBundle.getString(_KEY_JUSTIFY_MIDDLE), resourceBundle2.getString(_KEY_JUSTIFY_MIDDLE));
        FontPane._setText(this._bottomJustify, resourceBundle.getString(_KEY_JUSTIFY_BOTTOM), resourceBundle2.getString(_KEY_JUSTIFY_BOTTOM));
        this._exampleLabel.setText(resourceBundle.getString(_KEY_EXAMPLE));
        string = resourceBundle.getString(_KEY_SHOW_ACTUAL);
        this._showFontSize.setText(StringUtils.stripMnemonic((String)string));
        this._showFontSize.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
    }

    private void _setFontName() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        this.setFontNames(stringArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _sBORDER_COLOR_INSETS = new Insets(0, 10, 6, 2);
        _sDEFAULT_INSETS = new Insets(0, 0, 6, 2);
        _sLABEL_INSETS = new Insets(0, 0, 6, 3);
        _sSEPARATOR_INSETS = new Insets(0, 6, 6, 3);
    }

    private class NonNullSelComboBox
    extends JComboBox {
        public NonNullSelComboBox() {
        }

        public NonNullSelComboBox(Object[] objectArray) {
            super(objectArray);
        }

        public void setSelectedItem(Object object) {
            if (object != null) {
                super.setSelectedItem(object);
            }
        }
    }

    private static class NumberEditor
    extends NumberTextField
    implements ComboBoxEditor {
        private int _maximumValue;

        public NumberEditor() {
            this.setColumns(3);
            this.setBorder(null);
            this.setSigned(false);
            this.setDecimal(false);
        }

        public void setBorder(Border border) {
        }

        public Component getEditorComponent() {
            return this;
        }

        public void setItem(Object object) {
            String string = object == null ? null : object.toString();
            this.setText(string);
        }

        public Object getItem() {
            return this.getNumber();
        }

        public void selectAll() {
            super.selectAll();
            this.requestFocus();
        }

        public void addActionListener(ActionListener actionListener) {
            super.addActionListener(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            super.removeActionListener(actionListener);
        }

        public void setMaximum(int n) {
            this._maximumValue = n;
        }

        protected boolean validateNumber(Number number) {
            return number.intValue() <= this._maximumValue;
        }
    }

    private class FontPaneLayout
    implements LayoutManager {
        private final int _OFFSET = 10;
        private Component _left;

        private FontPaneLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
            if (FontPane._LEFT_CONSTRAINT.equals(string)) {
                this._left = component;
            }
        }

        public void removeLayoutComponent(Component component) {
            if (this._left == component) {
                this._left = null;
            }
        }

        public Dimension preferredLayoutSize(Container container) {
            Cloneable cloneable;
            Dimension dimension = new Dimension(this._left.getPreferredSize());
            if (FontPane.this.isPreviewAreaVisible()) {
                dimension.width += 10;
                cloneable = FontPane.this._exampleArea.getPreferredSize();
                ((Dimension)cloneable).width += 8;
                if (((Dimension)cloneable).height < 150) {
                    ((Dimension)cloneable).height = 150;
                }
                if (((Dimension)cloneable).width < dimension.height) {
                    ((Dimension)cloneable).width = dimension.height;
                }
                dimension.width += ((Dimension)cloneable).width;
                dimension.height = Math.max(dimension.height, ((Dimension)cloneable).height);
            }
            cloneable = container.getInsets();
            dimension.width += cloneable.left + cloneable.right;
            dimension.height += cloneable.top + cloneable.bottom;
            return dimension;
        }

        public Dimension minimumLayoutSize(Container container) {
            Cloneable cloneable;
            Dimension dimension = new Dimension(this._left.getMinimumSize());
            if (FontPane.this.isPreviewAreaVisible()) {
                dimension.width += 10;
                cloneable = FontPane.this._exampleArea.getMinimumSize();
                if (((Dimension)cloneable).height < 150) {
                    ((Dimension)cloneable).height = 150;
                }
                if (((Dimension)cloneable).width < dimension.height) {
                    ((Dimension)cloneable).width = dimension.height;
                }
                dimension.width += ((Dimension)cloneable).width;
                dimension.height = Math.max(dimension.height, ((Dimension)cloneable).height);
            }
            cloneable = container.getInsets();
            dimension.width += cloneable.left + cloneable.right;
            dimension.height += cloneable.top + cloneable.bottom;
            return dimension;
        }

        public void layoutContainer(Container container) {
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            dimension.width -= insets.left + insets.right;
            dimension.height -= insets.top + insets.bottom;
            Dimension dimension2 = new Dimension(this._left.getPreferredSize());
            Dimension dimension3 = null;
            Dimension dimension4 = null;
            int n = 0;
            if (FontPane.this.isPreviewAreaVisible()) {
                dimension3 = FontPane.this._exampleArea.getPreferredSize();
                dimension4 = FontPane.this._exampleArea.getMinimumSize();
                n = 10;
            } else {
                dimension3 = dimension4 = new Dimension(0, 0);
            }
            if (dimension2.width + dimension3.width + n < dimension.width) {
                dimension3.width = dimension.width - dimension2.width;
                if (dimension3.width < dimension4.width) {
                    dimension2.width -= dimension3.width - dimension4.width;
                    dimension3.width = dimension4.width;
                }
            }
            this._left.setBounds(insets.left, insets.top, dimension2.width, dimension.height);
            if (FontPane.this.isPreviewAreaVisible()) {
                int n2 = insets.left + dimension2.width + 10;
                int n3 = dimension.width - n2;
                FontPane.this._exampleArea.setBounds(n2, insets.top, n3, dimension.height);
            } else {
                FontPane.this._exampleArea.setBounds(0, 0, 0, 0);
            }
        }
    }

    private class UIListener
    implements ItemListener,
    PropertyChangeListener {
        private UIListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl = itemEvent.getStateChange() == 1;
            FontPane.this.fireEvent(itemEvent.getSource(), bl);
            FontPane.this.updateExampleFont();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("selectedColor".equals(string)) {
                FontPane.this.fireEvent(propertyChangeEvent.getSource(), true);
            }
            FontPane.this.updateExampleFont();
        }
    }

    private class AccessibleFontPane
    extends JComponent.AccessibleJComponent {
        public AccessibleFontPane() {
            super(FontPane.this);
        }
    }
}

