/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.domain;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Hashtable;
import oracle.jbo.JboException;
import oracle.jbo.Transaction;
import oracle.jbo.common.JboTypeMap;
import oracle.jbo.common.UnknownSQLTypeException;
import oracle.jbo.domain.DomainInterface;
import oracle.jbo.domain.DomainOwnerInterface;
import oracle.jbo.domain.XMLDomainFactory;
import oracle.jbo.domain.XMLDomainReaderFactory;
import oracle.jbo.domain.XMLDomainWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NullValue
implements Serializable,
XMLDomainWriter,
DomainInterface {
    static final long serialVersionUID = 6384347001003884267L;
    static final String STR_NULL = "null";
    private int mSQLTypeId;
    private static final String XMLSIG = "%null%|";

    public NullValue() {
        this.mSQLTypeId = 12;
    }

    public NullValue(int n) {
        this.mSQLTypeId = n != 0 ? n : 12;
    }

    public NullValue(String string) {
        this.mSQLTypeId = string != null && string.startsWith(XMLSIG) ? Integer.parseInt(string.substring(XMLSIG.length()), 10) : JboTypeMap.sqlTypeToSQLTypeId(string);
        if (this.mSQLTypeId == 0) {
            throw new UnknownSQLTypeException(string);
        }
    }

    public int getSQLTypeId() {
        return this.mSQLTypeId;
    }

    public String getSQLType() {
        return JboTypeMap.sqlTypeIdToSQLType(this.mSQLTypeId);
    }

    public Object getData() {
        return null;
    }

    public void setContext(DomainOwnerInterface domainOwnerInterface, Transaction transaction, Object object) {
    }

    public String toString() {
        return STR_NULL;
    }

    public int hashCode() {
        return -47;
    }

    public boolean equals(Object object) {
        NullValue nullValue;
        if (object == null) {
            return true;
        }
        return object instanceof NullValue && (nullValue = (NullValue)object).getSQLTypeId() == this.getSQLTypeId();
    }

    public String printXMLDefinition(Hashtable hashtable, PrintWriter printWriter, boolean bl) {
        return "#PCDATA";
    }

    public Node getXMLContentNode(Document document) {
        return document.createCDATASection(XMLSIG + this.mSQLTypeId);
    }

    public Node getSerializedDomainXML(Document document) {
        return document.createTextNode(this.toString());
    }

    public static XMLDomainReaderFactory getXMLDomainFactory(Class clazz) {
        return new 1facClass();
    }

    public static class 1facClass
    implements XMLDomainFactory,
    XMLDomainReaderFactory {
        public DomainInterface createDomainFromXMLElement(Element element) {
            try {
                String string;
                Node node = element.getFirstChild();
                if (node != null && (string = node.getNodeValue()) != null) {
                    if (NullValue.STR_NULL.equals(string)) {
                        NullValue nullValue = new NullValue();
                        return nullValue;
                    }
                    NullValue nullValue = new NullValue(string);
                    return nullValue;
                }
            }
            catch (JboException jboException) {
                throw jboException;
            }
            catch (Exception exception) {
                throw new JboException(exception);
            }
            return null;
        }

        public Object createDomainFromSerializedXML(Element element) {
            try {
                String string;
                Node node = element.getFirstChild();
                if (node != null && (string = node.getNodeValue()) != null) {
                    if (NullValue.STR_NULL.equals(string)) {
                        NullValue nullValue = new NullValue();
                        return nullValue;
                    }
                    NullValue nullValue = new NullValue(string);
                    return nullValue;
                }
            }
            catch (JboException jboException) {
                throw jboException;
            }
            catch (Exception exception) {
                throw new JboException(exception);
            }
            return null;
        }

        1facClass() {
        }
    }
}

