/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import oracle.jbo.ConnectionMetadata;
import oracle.jbo.JboException;
import oracle.jbo.SessionData;
import oracle.jbo.common.SvcMsgRequestParams;
import oracle.jbo.common.ampool.AMStatistics;
import oracle.jbo.common.ampool.SessionCookie;

public class ApplicationPoolSvcMsgContext
implements Serializable {
    static final long serialVersionUID = 6528546318655238306L;
    public static final byte JDBC_DATASOURCE_CONNECTION_TYPE = 0;
    public static final byte JDBC_URL_CONNECTION_TYPE = 1;
    public static final byte JDBC_NULL_CONNECTION_TYPE = 2;
    public static final int STATUS_INITIALIZED = 1;
    public static final int STATUS_CONNECT_ERROR = 2;
    public static final int STATUS_MT_ERROR = 4;
    public static final int STATUS_SUCCESS = 8;
    public static final int STATUS_AUTH_ERROR = 16;
    private ArrayList mRequestList;
    private ArrayList mRtnEventList;
    private byte[] mRtnClientData;
    private int mRtnPassivationId;
    private int mRtnMostRecentStackId;
    private ConnectionMetadata mRtnConnectionMetadata;
    private SessionData mRtnSessionData;
    private int mRtnReservedPassivationId;
    private AMStatistics mRtnStatistics;
    private boolean mIsApplicationModuleRemoved;
    private boolean mIsApplicationModuleConnected;
    private boolean mIsRetainState;
    private byte mJDBCConnectionType;
    private String mJDBCDataSourceName;
    private String mJDBCDataSourceUser;
    private String mJDBCDataSourcePassword;
    private String mJDBCConnectString;
    private Properties mJDBCProperties;
    private SessionCookie mSessionCookie;
    private boolean mIgnorePiggyback;
    private boolean mBoundToWorkingSet;
    private int mJDBCConnectCount;
    private JboException mJDBCConnectException;
    private JboException mAuthException;
    private int mRequestPointer;
    private int mStatus;
    public static final int POOL_REQ_PASSIVATE_STATE = 2;
    public static final int POOL_REQ_ACTIVATE_STATE = 3;
    public static final int POOL_REQ_REMOVE_STATE = 4;
    public static final int POOL_REQ_RESET_STATE = 5;
    public static final int POOL_REQ_PREPARE_SESSION = 6;
    public static final int POOL_REQ_HINT_PREPARE_SESSION = 7;
    public static final int POOL_REQ_CONNECT = 8;
    public static final int POOL_REQ_DISCONNECT = 9;
    public static final int POOL_REQ_RECONNECT = 10;
    public static final int POOL_REQ_REMOVE = 11;
    public static final int POOL_REQ_RESERVE_PASSIVATION_ID = 12;
    public static final int POOL_REQ_SET_BUNDLED_EXCEPTION_MODE = 13;
    public static final int POOL_REQ_GET_AM_STATS = 14;
    public static final int POOL_EVENT_CONNECT = 1;
    public static final int POOL_EVENT_FAILOVER = 2;
    public static final int POOL_EVENT_DISCONNECT_FAILOVER = 3;
    public static final int POOL_EVENT_PREPARE_SESSION = 4;
    public static final int POOL_EVENT_REMOVE = 5;
    public static final int POOL_EVENT_ACTIVATE = 6;
    public static final int POOL_EVENT_RESERVE_PASSIVATION_ID = 7;
    public static final int POOL_EVENT_AMSTATS_UPDATE = 8;

    private /* synthetic */ void $init$() {
        this.mRequestList = null;
        this.mRtnEventList = null;
        this.mRtnClientData = null;
        this.mRtnPassivationId = -1;
        this.mRtnMostRecentStackId = -1;
        this.mRtnConnectionMetadata = null;
        this.mRtnSessionData = null;
        this.mRtnReservedPassivationId = -1;
        this.mRtnStatistics = null;
        this.mIsApplicationModuleRemoved = false;
        this.mIsApplicationModuleConnected = false;
        this.mIsRetainState = false;
        this.mJDBCConnectionType = 1;
        this.mJDBCDataSourceName = null;
        this.mJDBCDataSourceUser = null;
        this.mJDBCDataSourcePassword = null;
        this.mJDBCConnectString = null;
        this.mJDBCProperties = null;
        this.mSessionCookie = null;
        this.mIgnorePiggyback = false;
        this.mBoundToWorkingSet = false;
        this.mJDBCConnectCount = 0;
        this.mJDBCConnectException = null;
        this.mAuthException = null;
        this.mRequestPointer = -1;
        this.mStatus = 1;
    }

    public final SvcMsgRequestParams getRequest() {
        if (this.mRequestList != null && this.mRequestPointer + 1 < this.mRequestList.size()) {
            return (SvcMsgRequestParams)this.mRequestList.get(this.mRequestPointer + 1);
        }
        return null;
    }

    public final void incrementRequestPointer() {
        ++this.mRequestPointer;
    }

    public final void resetRequestPointer() {
        this.mRequestPointer = -1;
        this.mStatus = 1;
    }

    public final void resetRequestPointer(int n) {
        this.mRequestPointer = n;
        this.mStatus = 1;
    }

    public final int getRequestPointer() {
        return this.mRequestPointer;
    }

    public final int getStatus() {
        return this.mStatus;
    }

    public final void setStatus(int n) {
        this.mStatus = n;
    }

    public final void addRtnEvent(int n) {
        if (this.mRtnEventList == null) {
            this.mRtnEventList = new ArrayList(3);
        }
        this.mRtnEventList.add(new Integer(n));
    }

    public final void replaceRtnEvent(int n, int n2) {
        if (this.mRtnEventList != null) {
            this.mRtnEventList.set(n, new Integer(n2));
        }
    }

    public final ArrayList getRtnEventList() {
        return this.mRtnEventList;
    }

    public final void incrementJDBCConnectCount() {
        ++this.mJDBCConnectCount;
    }

    public final int getJDBCConnectCount() {
        return this.mJDBCConnectCount;
    }

    public final byte getJDBCConnectionType() {
        return this.mJDBCConnectionType;
    }

    public final void setJDBCConnectionType(byte by) {
        this.mJDBCConnectionType = by;
    }

    public final void setJDBCDataSourceName(String string) {
        this.mJDBCDataSourceName = string;
    }

    public final String getJDBCDataSourceName() {
        return this.mJDBCDataSourceName;
    }

    public final void setJDBCDataSourceUser(String string) {
        this.mJDBCDataSourceUser = string;
    }

    public final String getJDBCDataSourceUser() {
        return this.mJDBCDataSourceUser;
    }

    public final void setJDBCDataSourcePassword(String string) {
        this.mJDBCDataSourcePassword = string;
    }

    public final String getJDBCDataSourcePassword() {
        return this.mJDBCDataSourcePassword;
    }

    public final SessionCookie getSessionCookie() {
        return this.mSessionCookie;
    }

    public final void setSessionCookie(SessionCookie sessionCookie) {
        this.mSessionCookie = sessionCookie;
    }

    public boolean isRetainState() {
        return this.mIsRetainState;
    }

    public void setRetainState(boolean bl) {
        this.mIsRetainState = bl;
    }

    public final void setJDBCConnectString(String string) {
        this.mJDBCConnectString = string;
    }

    public final String getJDBCConnectString() {
        return this.mJDBCConnectString;
    }

    public final void setJDBCProperties(Properties properties) {
        this.mJDBCProperties = properties;
    }

    public final Properties getJDBCProperties() {
        return this.mJDBCProperties;
    }

    public final void setAuthException(JboException jboException) {
        this.mAuthException = jboException;
    }

    public final JboException getAuthException() {
        return this.mAuthException;
    }

    public final void setJDBCConnectException(Throwable throwable) {
        this.mJDBCConnectException = throwable != null ? new JboException(throwable) : null;
    }

    public final Throwable getJDBCConnectException() {
        if (this.mJDBCConnectException != null) {
            return (Throwable)this.mJDBCConnectException.getDetails()[0];
        }
        return null;
    }

    public final byte[] getRtnClientData() {
        return this.mRtnClientData;
    }

    public final void setRtnClientData(byte[] byArray) {
        this.mRtnClientData = byArray;
    }

    public final void setRtnReservedPassivationId(int n) {
        this.mRtnReservedPassivationId = n;
    }

    public final int getRtnReservedPassivationId() {
        return this.mRtnReservedPassivationId;
    }

    public final int getRtnPassivationId() {
        return this.mRtnPassivationId;
    }

    public final void setRtnPassivationId(int n) {
        this.mRtnPassivationId = n;
    }

    public final AMStatistics getRtnAMStatistics() {
        return this.mRtnStatistics;
    }

    public final void setRtnAMStatistics(AMStatistics aMStatistics) {
        this.mRtnStatistics = aMStatistics;
    }

    public final ConnectionMetadata getRtnConnectionMetadata() {
        return this.mRtnConnectionMetadata;
    }

    public final void setRtnConnectionMetadata(ConnectionMetadata connectionMetadata) {
        this.mRtnConnectionMetadata = connectionMetadata;
    }

    public final int getRtnMostRecentStackId() {
        return this.mRtnMostRecentStackId;
    }

    public final void setRtnMostRecentStackId(int n) {
        this.mRtnMostRecentStackId = n;
    }

    public final SessionData getRtnSessionData() {
        return this.mRtnSessionData;
    }

    public final void setRtnSessionData(SessionData sessionData) {
        this.mRtnSessionData = sessionData;
    }

    public final void setApplicationModuleConnected(boolean bl) {
        this.mIsApplicationModuleConnected = true;
    }

    public final boolean isApplicationModuleConnected() {
        return this.mIsApplicationModuleConnected;
    }

    public final void setApplicationModuleRemoved(boolean bl) {
        this.mIsApplicationModuleRemoved = bl;
    }

    public final boolean isApplicationModuleRemoved() {
        return this.mIsApplicationModuleRemoved;
    }

    public final void passivateState(int n, byte[] byArray, int n2) {
        SvcMsgRequestParams svcMsgRequestParams = new SvcMsgRequestParams(2, -1, null);
        svcMsgRequestParams.setIntParams(new int[]{n, n2});
        svcMsgRequestParams.setObjectParam(byArray);
        this.addSvcMsgReq(svcMsgRequestParams);
    }

    public final void reservePassivationId() {
        SvcMsgRequestParams svcMsgRequestParams = new SvcMsgRequestParams(12, -1, null);
        this.addSvcMsgReq(svcMsgRequestParams);
    }

    public final void setBundledExceptionMode(boolean bl) {
        SvcMsgRequestParams svcMsgRequestParams = new SvcMsgRequestParams(13, -1, null);
        svcMsgRequestParams.setBooleanParams(new boolean[]{bl});
        this.addSvcMsgReq(svcMsgRequestParams);
    }

    public final void activateState(int n, SessionData sessionData, int n2) {
        SvcMsgRequestParams svcMsgRequestParams = new SvcMsgRequestParams(3, -1, null);
        svcMsgRequestParams.setIntParams(new int[]{n, n2});
        svcMsgRequestParams.setObjectParam(sessionData);
        this.addSvcMsgReq(svcMsgRequestParams);
    }

    public final void removeState(int n) {
        SvcMsgRequestParams svcMsgRequestParams = new SvcMsgRequestParams(4, -1, null);
        svcMsgRequestParams.setIntParams(new int[]{n});
        this.addSvcMsgReq(svcMsgRequestParams);
    }

    public final void resetState(int n) {
        SvcMsgRequestParams svcMsgRequestParams = new SvcMsgRequestParams(5, -1, null);
        svcMsgRequestParams.setIntParams(new int[]{n});
        this.addSvcMsgReq(svcMsgRequestParams);
    }

    public final void prepareSession(SessionData sessionData) {
        SvcMsgRequestParams svcMsgRequestParams = new SvcMsgRequestParams(6, -1, null);
        svcMsgRequestParams.setObjectParam(sessionData);
        this.addSvcMsgReq(svcMsgRequestParams);
    }

    public final void hintPrepareSession(SessionData sessionData, ConnectionMetadata connectionMetadata) {
        SvcMsgRequestParams svcMsgRequestParams = new SvcMsgRequestParams(7, -1, null);
        svcMsgRequestParams.setObjectParams(new Object[]{sessionData, connectionMetadata});
        this.addSvcMsgReq(svcMsgRequestParams);
    }

    public final void connect() {
        SvcMsgRequestParams svcMsgRequestParams = new SvcMsgRequestParams(8, -1, null);
        this.addSvcMsgReq(svcMsgRequestParams);
    }

    public final void disconnect(boolean bl) {
        SvcMsgRequestParams svcMsgRequestParams = new SvcMsgRequestParams(9, -1, null);
        svcMsgRequestParams.setBooleanParams(new boolean[]{bl});
        this.addSvcMsgReq(svcMsgRequestParams);
    }

    public final void reconnect() {
        SvcMsgRequestParams svcMsgRequestParams = new SvcMsgRequestParams(10, -1, null);
        this.addSvcMsgReq(svcMsgRequestParams);
    }

    public final void getStatistics() {
        SvcMsgRequestParams svcMsgRequestParams = new SvcMsgRequestParams(14, -1, null);
        this.addSvcMsgReq(svcMsgRequestParams);
    }

    public final void removeApplicationModule() {
        this.addSvcMsgReq(new SvcMsgRequestParams(11, -1, null));
    }

    private void addSvcMsgReq(SvcMsgRequestParams svcMsgRequestParams) {
        if (this.mRequestList == null) {
            this.mRequestList = new ArrayList(5);
        }
        this.mRequestList.add(svcMsgRequestParams);
    }

    public final boolean getIgnorePiggyback() {
        return this.mIgnorePiggyback;
    }

    public final void setIgnorePiggyback(boolean bl) {
        this.mIgnorePiggyback = bl;
    }

    public final boolean getBoundToWorkingSet() {
        return this.mBoundToWorkingSet;
    }

    public final void setBoundToWorkingSet(boolean bl) {
        this.mBoundToWorkingSet = bl;
    }

    public ApplicationPoolSvcMsgContext() {
        this.$init$();
    }
}

