/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.playlist;

import ice.debug.Debug;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DOM;
import ice.pilots.playlist.ComponentFactory;
import ice.pilots.playlist.FileInfo;
import ice.pilots.playlist.ListWrapper;
import ice.pilots.playlist.SaveThread;
import ice.pilots.playlist.TextAreaWrapper;
import ice.storm.ContentLoader;
import ice.storm.Pilot;
import ice.storm.Viewport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Panel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ThePilot
extends Pilot
implements PropertyChangeListener {
    String xml;
    Viewport jmfView;
    Viewport infoView;
    Panel panel;
    Panel jmfPanel;
    Panel infoPanel;
    String baseLoc;
    Document doc;
    FileInfo[] tracks;
    ComponentFactory componentFactory;
    ListWrapper list;
    TextAreaWrapper text;
    String fileBase = "c:/temp/mp3/";
    String jmfViewportName = "jmf";
    String infoViewportName = "info";
    String fileBaseURL = "file://localhost/";
    String lastArtist;
    private static final int INFO_ARTIST = 1;
    int lastProgressIndex = -1;
    int nextProgressCounter = 0;

    private static String buildInfoURL(String string, int n) {
        string = string.trim();
        string = string.replace(' ', '+');
        String string2 = "&type=";
        switch (n) {
            case 1: {
                string2 = string2 + "artist";
            }
        }
        String string3 = "http://www.listen.com/search.jsp?value=" + string + string2;
        return string3;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() != this.jmfView) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("jmfEvent")) {
            String string2 = (String)propertyChangeEvent.getNewValue();
            String string3 = (String)propertyChangeEvent.getOldValue();
            if (string2.equals("playerRealized")) {
                this.panel.validate();
            } else if (string2.equals("endOfMedia")) {
                int n = this.list.getSelectedIndex();
                this.playTrack(n + 1);
            }
        }
    }

    public void init(String string) {
        super.init(string);
        String string2 = "ice.pilots.playlist." + string + ".TheFactory";
        try {
            Object obj = Class.forName(string2).newInstance();
            this.componentFactory = (ComponentFactory)obj;
        }
        catch (Exception exception) {
            Debug.ex(exception);
        }
    }

    public Component createComponent() {
        if (this.panel == null) {
            this.panel = new Panel();
            this.panel.setLayout(new BorderLayout());
            Panel panel = new Panel();
            panel.setLayout(new BorderLayout());
            this.list = this.componentFactory.createListWrapper(this, 10);
            panel.add(this.list.getComponent(), "West");
            this.text = this.componentFactory.createTextAreaWrapper(this, 1, 35);
            panel.add(this.text.getComponent(), "East");
            this.jmfPanel = new Panel();
            this.jmfPanel.setLayout(new BorderLayout());
            panel.add((Component)this.jmfPanel, "South");
            this.panel.add((Component)panel, "North");
            this.infoPanel = new Panel();
            this.infoPanel.setLayout(new BorderLayout());
            this.panel.add((Component)this.infoPanel, "Center");
        }
        return this.panel;
    }

    public void listItemDoubleClicked(int n) {
        this.playTrack(n);
    }

    private void fillList() {
        this.list.removeAll();
        int n = 0;
        while (n < this.tracks.length) {
            this.list.add(this.tracks[n].title);
            ++n;
        }
    }

    private void extract() {
        NodeList nodeList;
        NodeList nodeList2 = this.doc.getElementsByTagName("URL");
        if (nodeList2.getLength() == 0) {
            nodeList2 = this.doc.getElementsByTagName("url");
        }
        if (nodeList2.getLength() == 0) {
            return;
        }
        DNode dNode = (DNode)nodeList2.item(0);
        if (dNode != null) {
            this.baseLoc = dNode.getInnerText().trim();
        }
        if ((nodeList2 = this.doc.getElementsByTagName("LOCATION")).getLength() == 0) {
            nodeList2 = this.doc.getElementsByTagName("location");
        }
        if (nodeList2.getLength() == 0) {
            return;
        }
        dNode = (DNode)nodeList2.item(0);
        if (dNode != null) {
            this.baseLoc = this.baseLoc + dNode.getInnerText().trim();
        }
        if ((nodeList = this.doc.getElementsByTagName("TRACK")).getLength() == 0) {
            nodeList = this.doc.getElementsByTagName("track");
        }
        if (nodeList.getLength() == 0) {
            return;
        }
        int n = nodeList.getLength();
        this.tracks = new FileInfo[n];
        int n2 = 0;
        while (n2 < n) {
            Element element = (Element)nodeList.item(n2);
            FileInfo fileInfo = new FileInfo();
            DNode dNode2 = (DNode)element.getFirstChild();
            while (dNode2 != null) {
                String string = dNode2.getNodeName();
                if (string.equalsIgnoreCase("fileName")) {
                    fileInfo.fileName = dNode2.getInnerText();
                } else if (string.equalsIgnoreCase("trackId")) {
                    fileInfo.trackId = dNode2.getInnerText();
                } else if (string.equalsIgnoreCase("artist")) {
                    fileInfo.artist = dNode2.getInnerText();
                } else if (string.equalsIgnoreCase("title")) {
                    fileInfo.title = dNode2.getInnerText();
                } else if (string.equalsIgnoreCase("album")) {
                    fileInfo.album = dNode2.getInnerText();
                } else if (string.equalsIgnoreCase("format")) {
                    fileInfo.format = dNode2.getInnerText();
                } else if (string.equalsIgnoreCase("genre")) {
                    fileInfo.genre = dNode2.getInnerText();
                } else if (string.equalsIgnoreCase("quality")) {
                    fileInfo.quality = dNode2.getInnerText();
                } else if (string.equalsIgnoreCase("size")) {
                    fileInfo.size = dNode2.getInnerText();
                    if (fileInfo.size != null) {
                        fileInfo.size = fileInfo.size.trim();
                        try {
                            fileInfo.intSize = Integer.parseInt(fileInfo.size);
                        }
                        catch (Exception exception) {}
                    }
                } else if (string.equalsIgnoreCase("channels")) {
                    fileInfo.channels = dNode2.getInnerText();
                } else if (string.equalsIgnoreCase("duration")) {
                    fileInfo.duration = dNode2.getInnerText();
                }
                dNode2 = (DNode)dNode2.getNextSibling();
            }
            fileInfo.fileBase = this.fileBase;
            fileInfo.loc = ThePilot.createURL(this.baseLoc, fileInfo.trackId, fileInfo.fileName);
            this.tracks[n2] = fileInfo;
            ++n2;
        }
    }

    private void playTrack(int n) {
        if (n >= this.tracks.length) {
            return;
        }
        FileInfo fileInfo = this.tracks[n];
        if (!fileInfo.saved) {
            return;
        }
        this.list.select(n);
        String string = "";
        if (fileInfo.artist != null) {
            string = string + "Artist: " + fileInfo.artist + "\n";
        }
        if (fileInfo.title != null) {
            string = string + "Track: " + fileInfo.title + "\n";
        }
        if (fileInfo.album != null) {
            string = string + "Album: " + fileInfo.album + "\n";
        }
        if (fileInfo.duration != null) {
            fileInfo.duration = fileInfo.duration.trim();
            try {
                int n2 = Integer.parseInt(fileInfo.duration);
                int n3 = n2 / 60;
                int n4 = n2 - n3 * 60;
                String string2 = n4 < 10 ? "0" + n4 : "" + n4;
                string = string + "Duration: " + n3 + ":" + string2 + "\n";
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (fileInfo.quality != null) {
            string = string + "Quality: " + fileInfo.quality + "\n";
        }
        if (fileInfo.size != null) {
            string = string + "Size: " + fileInfo.size;
        }
        this.text.setText(string);
        String string3 = this.fileBaseURL + fileInfo.fileBase + fileInfo.fileName;
        this.renderContent(string3, null, this.jmfViewportName);
        if (this.lastArtist == null || !this.lastArtist.equals(fileInfo.artist)) {
            string3 = ThePilot.buildInfoURL(fileInfo.artist, 1);
            this.lastArtist = fileInfo.artist;
            this.renderContent(string3, null, this.infoViewportName);
        }
    }

    void progress(int n, int n2) {
        if (n != this.lastProgressIndex) {
            this.nextProgressCounter = 0;
            this.lastProgressIndex = n;
        }
        if (n2 >= this.nextProgressCounter) {
            FileInfo fileInfo = this.tracks[n];
            String string = ": ";
            if (fileInfo.intSize == 0) {
                this.nextProgressCounter += 150000;
                string = string + n2 + " bytes";
            } else {
                int n3 = n2 * 100 / fileInfo.intSize;
                if (n3 >= 100) {
                    this.nextProgressCounter = 99999999;
                    n3 = 100;
                } else {
                    this.nextProgressCounter = (n3 + 5) * fileInfo.intSize / 100;
                }
                string = string + n3 + "%";
            }
            this.list.replaceItem(this.tracks[n].title + string, n);
        }
    }

    private void iterate(int n) {
        if (n >= this.tracks.length) {
            return;
        }
        FileInfo fileInfo = this.tracks[n];
        SaveThread saveThread = new SaveThread(this, fileInfo.loc, fileInfo.fileBase + fileInfo.fileName, n);
        this.firePropertyChange("statusLine", null, "Saving " + fileInfo.fileName);
        saveThread.start();
    }

    public void parse(ContentLoader contentLoader) {
        InputStream inputStream = contentLoader.getInputStream();
        try {
            int n;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            int n2 = 5000;
            int n3 = 0;
            char[] cArray = new char[n2];
            while ((n = inputStreamReader.read()) >= 0) {
                cArray[n3++] = (char)n;
                if (n3 != n2) continue;
                char[] cArray2 = new char[n2 * 2];
                System.arraycopy(cArray, 0, cArray2, 0, n2);
                n2 *= 2;
                cArray = cArray2;
            }
            this.xml = new String(cArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.xml == null) {
            return;
        }
        this.firePropertyChange("location", null, contentLoader.getLocation());
        this.xml = this.xml.trim();
        this.doc = DOM.getInstance().parseEmbeddedDocumentFromString(this.xml);
        this.extract();
        this.fillList();
        this.iterate(0);
        this.jmfView = new Viewport(this.jmfViewportName);
        this.jmfView.setContainer(this.jmfPanel);
        this.jmfView.addPropertyChangeListener(this);
        this.infoView = new Viewport(this.infoViewportName);
        this.infoView.setContainer(this.infoPanel);
        this.addViewportChild(this.jmfView);
        this.addViewportChild(this.infoView);
    }

    private static String createURL(String string, String string2, String string3) {
        int n = string.lastIndexOf("%f");
        String string4 = string.substring(0, n);
        String string5 = string.substring(n + 2);
        string = string4 + string3 + string5;
        n = string.lastIndexOf("%fid");
        string4 = string.substring(0, n);
        string5 = string.substring(n + 4);
        string = string4 + string2 + string5;
        return string;
    }

    void saveDone(int n, boolean bl) {
        if (bl) {
            this.tracks[n].saved = true;
            if (n == 0) {
                this.playTrack(n);
            }
            this.iterate(n + 1);
        }
    }
}

