/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.notsupported;

import ice.pilots.notsupported.MyComponent;
import ice.storm.ContentLoader;
import ice.storm.Hint;
import ice.storm.LPilot;
import ice.storm.Viewport;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;

public class ThePilot
extends LPilot {
    MyComponent myc = null;
    private int width = 100;
    private int height = 50;
    private int BUFFERSIZE = 16384;
    private URL theURL;
    private String contentType;
    private ContentLoader theContentLoader;
    private boolean alreadySaved = false;
    private boolean imagesOffMode = false;
    static final int NOTFOUND_WIDTH = 10;
    static final int NOTFOUND_HEIGHT = 10;

    public void clear(String string) {
        this.contentType = string;
    }

    public void parse(ContentLoader contentLoader) throws IOException {
        this.theContentLoader = contentLoader;
        this.theURL = contentLoader.getURL();
        this.contentType = contentLoader.getContentType();
        String string = this.theURL.toString();
        if (string.indexOf(".gif") != -1 || string.indexOf(".jpg") != -1 || string.indexOf(".jpeg") != -1 || string.indexOf(".png") != -1) {
            this.imagesOffMode = true;
            if (this.myc != null) {
                this.myc.setShowanyThing(false);
            }
        } else if (this.myc != null) {
            this.myc.setShowanyThing(true);
        }
        this.firePropertyChange("location", null, contentLoader.getLocation());
        this.firePropertyChange("title", null, contentLoader.getLocation());
        if (!this.imagesOffMode) {
            Hint hint = new Hint(this, contentLoader);
            hint.setCustomDescription("The content of type \"" + contentLoader.getContentType() + "\" is not supported");
            this.firePropertyChange("hint", null, hint);
        }
        this.refreshViewport();
    }

    public void paint(Graphics graphics) {
        if (this.imagesOffMode) {
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, 9, 9);
            graphics.setColor(Color.red);
            graphics.drawLine(2, 2, 7, 7);
            graphics.drawLine(2, 7, 7, 2);
        } else {
            graphics.setColor(Color.lightGray);
            graphics.fillRect(0, 0, this.width, this.height);
            graphics.setColor(Color.black);
            graphics.setFont(new Font("Serif", 0, 10));
            graphics.drawString("No pilot found for ", 10, 20);
            String string = this.contentType;
            if (string == null) {
                string = "null";
            }
            graphics.drawString(string, 10, 40);
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, this.width - 1, this.height - 1);
        }
    }

    public Component createComponent() {
        if (this.myc != null) {
            return this.myc;
        }
        this.myc = new MyComponent(this);
        return this.myc;
    }

    void doSave() throws IOException {
        Object object;
        Viewport viewport;
        String string;
        int n;
        if (this.alreadySaved || this.imagesOffMode) {
            return;
        }
        URLConnection uRLConnection = this.theContentLoader.getURLConnection();
        String string2 = uRLConnection.getHeaderField("Content-Disposition");
        String string3 = null;
        if (string2 != null && string2.startsWith("atachment".toLowerCase())) {
            n = string2.indexOf("filename", 9);
            int n2 = string2.indexOf("=", n);
            if (n != -1 && n2 != -1) {
                string3 = string2.substring(n2 + 1).trim();
            }
        }
        if (string3 == null && (n = (string3 = this.theURL.getFile()).lastIndexOf(47)) >= 0) {
            string3 = string3.substring(n + 1);
        }
        if ((string = this.chooseFile(viewport = this.getPilotViewport(), string3)) == null) {
            return;
        }
        File file = new File(string);
        if (file.getParent() != null && !((File)(object = new File(file.getParent()))).exists()) {
            ((File)object).mkdirs();
        }
        if (file != null) {
            object = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)object);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.theContentLoader.getInputStream());
            byte[] byArray = new byte[this.BUFFERSIZE];
            int n3 = 1;
            while (n3 > 0) {
                n3 = bufferedInputStream.read(byArray, 0, this.BUFFERSIZE);
                if (n3 <= 0) continue;
                bufferedOutputStream.write(byArray, 0, n3);
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            ((OutputStream)object).flush();
            ((FileOutputStream)object).close();
            bufferedInputStream.close();
            this.alreadySaved = true;
        }
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    private String chooseFile(Viewport viewport, String string) {
        FileDialog fileDialog = new FileDialog(new Frame(), "Select file to Save:", 1);
        if (string != null) {
            fileDialog.setFile(string);
        }
        fileDialog.show();
        if (fileDialog.getFile() == null) {
            return null;
        }
        String string2 = new String(fileDialog.getDirectory() + fileDialog.getFile());
        return string2;
    }
}

