/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.AccessibleHyperPanel;
import ice.pilots.html4.ComponentFactory;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.swing.DocView;
import ice.pilots.html4.swing.Movable;
import ice.pilots.html4.swing.SwingScreenReaderStatusPanel;
import ice.util.Defs;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

class DocPanel
extends JPanel {
    DocView docView;
    int sx = 0;
    int sy = 0;
    int nsx = 0;
    int nsy = 0;
    private int selectButton = 0;
    private int scrollButton = 1;
    private int scrollMouseX = -1;
    private int scrollMouseY = -1;
    private int selectMouseX = -1;
    private int selectMouseY = -1;
    private int scrollHeight = 14;
    private int scrollTimeout = 100;
    private long scrollTimestamp;
    private int lastDraggedY;

    DocPanel(DocView docView) {
        this.docView = docView;
        this.enableEvents(60L);
        this.setLayout(null);
        this.scrollHeight = Defs.sysPropertyInt("ice.pilots.html4.scrollHeight", this.scrollHeight);
        this.scrollTimeout = Defs.sysPropertyInt("ice.pilots.html4.scrollTimeout", this.scrollTimeout);
        String string = Defs.sysProperty("ice.pilots.html4.selectButton");
        this.selectButton = ComponentFactory.parseButton(string, this.selectButton);
        string = Defs.sysProperty("ice.pilots.html4.scrollButton");
        this.scrollButton = ComponentFactory.parseButton(string, this.scrollButton);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isManagingFocus() {
        return true;
    }

    void do_reqReflow() {
        this.docView.getPilot().getStorm().runOnEventThreadLater(new Runnable(){

            public void run() {
                DocPanel.this.revalidate();
                DocPanel.this.repaint();
            }
        }, 0L);
    }

    void scrollLightweightChildren() {
        int n = this.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = this.getComponent(n2);
            if (component != null && component instanceof JComponent) {
                if (component instanceof Movable) {
                    Movable movable = (Movable)((Object)component);
                    ObjectBox objectBox = movable.getBox();
                    if (objectBox != null) {
                        Point point = new Point(0, 0);
                        objectBox.findAbsolutePosition(point);
                        movable.syncDom(point.x - this.sx, point.y - this.sy, objectBox.checkIfVisible());
                    }
                } else if (!component.isVisible()) {
                    component.setVisible(true);
                }
            }
            ++n2;
        }
    }

    public void doLayout() {
        int n;
        this.docView.mouseX = n = this.getSize().width;
        this.reflowImpl(this.docView.mouseX);
    }

    void scroll(int n, int n2) {
        if (!this.docView.canScroll(n, n2)) {
            return;
        }
        this.nsx = n;
        this.nsy = n2;
        this.sx = this.nsx;
        this.sy = this.nsy;
        this.scrollLightweightChildren();
        this.repaint();
    }

    void reflowImpl(int n) {
        long l = System.currentTimeMillis();
        this.docView.docLayout(n, this.getSize().height);
        JScrollBar jScrollBar = this.docView.vbar;
        JScrollBar jScrollBar2 = this.docView.hbar;
        if (jScrollBar != null && this.isVisible()) {
            boolean bl = false;
            int n2 = jScrollBar.getValue();
            int n3 = this.getSize().height;
            int n4 = this.docView.getDocHeight();
            if (n3 >= n4) {
                n3 = n4;
            }
            if (n2 + n3 >= n4) {
                this.sy = this.nsy = (n2 = n4 - n3);
            }
            jScrollBar.setValues(n2, n3, 0, n4);
            jScrollBar.setBlockIncrement(n3);
            jScrollBar.setUnitIncrement(20);
            int n5 = jScrollBar2.getValue();
            int n6 = this.docView.getDocWidth();
            int n7 = this.getSize().width;
            if (n7 >= n6) {
                n7 = n6;
            }
            if (n5 + n7 >= n6) {
                this.sx = this.nsx = (n5 = n6 - n7);
            }
            jScrollBar2.setValues(n5, n7, 0, n6);
            jScrollBar2.setBlockIncrement(n7);
            jScrollBar2.setUnitIncrement(20);
            if (n4 <= n3) {
                if (jScrollBar.isVisible()) {
                    jScrollBar.setVisible(false);
                    bl = true;
                }
            } else if (!jScrollBar.isVisible()) {
                jScrollBar.setVisible(true);
                bl = true;
            }
            if (n6 <= n7) {
                if (jScrollBar2.isVisible()) {
                    jScrollBar2.setVisible(false);
                    bl = true;
                }
            } else if (!jScrollBar2.isVisible()) {
                jScrollBar2.setVisible(true);
                bl = true;
            }
            if (bl) {
                this.do_reqReflow();
            }
        }
        this.docView.docPostLayout();
        l = System.currentTimeMillis() - l;
        this.scrollLightweightChildren();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            SwingScreenReaderStatusPanel swingScreenReaderStatusPanel = new SwingScreenReaderStatusPanel();
            this.docView._panePanel.add((Component)swingScreenReaderStatusPanel, "North");
            swingScreenReaderStatusPanel.setVisible(false);
            this.accessibleContext = new AccessibleHyperPanel(this.docView.getPilot(), super.getAccessibleContext(), swingScreenReaderStatusPanel);
        }
        return this.accessibleContext;
    }

    public void paintComponent(Graphics graphics) {
        long l = System.currentTimeMillis();
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            graphics.setClip(0, 0, this.getSize().width, this.getSize().height);
            rectangle = graphics.getClipBounds();
        }
        this.paintInto(graphics, rectangle);
        this.scrollLightweightChildren();
        l = System.currentTimeMillis() - l;
    }

    private void paintInto(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(Color.white);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.translate(-this.sx, -this.sy);
        graphics.setClip(rectangle.x + this.sx, rectangle.y + this.sy, rectangle.width, rectangle.height);
        this.docView.docPaint(graphics);
        graphics.translate(this.sx, this.sy);
        this.docView.docPaintFixed(graphics);
        graphics.setColor(Color.blue);
        int n = this.docView.mouseX;
        graphics.drawLine(n, 0, n, this.getSize().height);
    }

    private void mouseDragged(MouseEvent mouseEvent) {
        this.lastDraggedY = mouseEvent.getY();
        if (this.isButtonDown(this.scrollButton, mouseEvent)) {
            if (this.scrollMouseX >= 0) {
                int n = this.scrollMouseX - mouseEvent.getX();
                int n2 = this.scrollMouseY - mouseEvent.getY();
                if (Math.abs(n) > Math.abs(n2)) {
                    n2 = 0;
                } else {
                    n = 0;
                }
                this.docView.setScrollPosition(this.sx + n, this.sy + n2);
            }
            this.scrollMouseX = mouseEvent.getX();
            this.scrollMouseY = mouseEvent.getY();
        } else if (this.isButtonDown(this.selectButton, mouseEvent)) {
            if (this.selectMouseX >= 0) {
                int n = 0;
                if (mouseEvent.getY() > this.getSize().height) {
                    n = this.scrollHeight;
                } else if (mouseEvent.getY() < 0) {
                    n = -this.scrollHeight;
                }
                this.scrollAndSelect(n, mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.selectMouseX = mouseEvent.getX();
                this.selectMouseY = mouseEvent.getY();
            }
        }
    }

    private void scrollAndSelect(int n, int n2, int n3) {
        if (n != 0) {
            long l = System.currentTimeMillis();
            if (l - this.scrollTimestamp > (long)this.scrollTimeout) {
                this.docView.setScrollPosition(this.sx, this.sy + n);
                this.scrollTimestamp = l;
                this.selectMouseY -= n;
            }
            DelayedScroll delayedScroll = new DelayedScroll(this, n2, n3, n);
            this.docView.getPilot().getStorm().runOnEventThreadLater(delayedScroll, this.scrollTimeout + 10);
        }
        this.docView.docSetSelection(this.selectMouseX, this.selectMouseY, n2, n3 + n);
    }

    private void verifyScrollTime(DelayedScroll delayedScroll) {
        if (this.selectMouseX != -1 && delayedScroll.dragY == this.lastDraggedY) {
            this.scrollAndSelect(delayedScroll.scr, delayedScroll.selX, delayedScroll.dragY);
        }
    }

    private void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        if (this.isButtonDown(this.selectButton, mouseEvent)) {
            this.docView.docClearSelection();
        }
    }

    private void mouseReleased(MouseEvent mouseEvent) {
        this.scrollMouseX = -1;
        this.selectMouseX = -1;
    }

    private void mouseExited(MouseEvent mouseEvent) {
        this.scrollMouseX = -1;
    }

    private boolean isButtonDown(int n, InputEvent inputEvent) {
        if (n < 0) {
            return false;
        }
        int n2 = inputEvent.getModifiers();
        if (n == 0 && (n2 == 0 || (n2 & 0x10) != 0)) {
            return true;
        }
        return n == 1 && (n2 & 4) != 0;
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (this.docView.onComponentEvent(this, aWTEvent)) {
            super.processEvent(aWTEvent);
            switch (aWTEvent.getID()) {
                case 506: {
                    this.mouseDragged((MouseEvent)aWTEvent);
                    break;
                }
                case 501: {
                    this.mousePressed((MouseEvent)aWTEvent);
                    break;
                }
                case 502: {
                    this.mouseReleased((MouseEvent)aWTEvent);
                    break;
                }
                case 505: {
                    this.mouseExited((MouseEvent)aWTEvent);
                }
            }
        }
    }

    private static class DelayedScroll
    implements Runnable {
        private final DocPanel owner;
        private final int dragY;
        private final int selX;
        private final int scr;

        DelayedScroll(DocPanel docPanel, int n, int n2, int n3) {
            this.owner = docPanel;
            this.dragY = n2;
            this.scr = n3;
            this.selX = n;
        }

        public void run() {
            this.owner.verifyScrollTime(this);
        }
    }
}

