/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.EmbeddedObject;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.ThePilot;
import ice.storm.DocPane;
import ice.storm.Viewport;
import ice.util.Defs;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import org.w3c.dom.events.EventListener;

public abstract class DocPaneXml
extends DocPane {
    private ThePilot _pilot;
    private CSSLayout _cssLayout;
    private boolean _ieEmulation;
    private int _documentId;

    final void bind(ThePilot thePilot, CSSLayout cSSLayout) {
        this._pilot = thePilot;
        this._cssLayout = cSSLayout;
        this._ieEmulation = "ie".equals(Defs.sysProperty("ice.browser.emulation"));
        this._documentId = thePilot.getPilotViewport().getDocumentId();
        this._cssLayout.docPane = this;
    }

    final void do_clear() {
        Viewport viewport = this._pilot.getPilotViewport();
        if (viewport != null) {
            this._documentId = viewport.getDocumentId();
            this.setCursor(0);
            this.reqClear();
        }
    }

    protected abstract void init(int var1);

    protected abstract Component getPaneComponent();

    protected abstract ObjectPainter createFormControl(DElement var1);

    protected abstract ObjectPainter createScroller();

    protected abstract Container createEmbeddedContainer(EmbeddedObject var1, Component var2);

    protected abstract Component createFramesDividerComponent();

    protected abstract void checkAwtTree(ObjectBox var1, Component var2);

    protected final boolean processAwtKeyEvent(Component component, KeyEvent keyEvent, EventListener eventListener) {
        int n;
        char c;
        int n2 = keyEvent.getID();
        int n3 = n2 == 401 ? 9 : (n2 == 402 ? 10 : 8);
        DOMUIEvent dOMUIEvent = null;
        if (this.is_msie_event_emulation()) {
            if (n2 == 400) {
                c = keyEvent.getKeyChar();
                n = c;
            } else {
                int n4;
                n = n4 = keyEvent.getKeyCode();
                c = keyEvent.getKeyChar();
                switch (n4) {
                    case 112: {
                        if (n4 != 112) break;
                        dOMUIEvent = this.createDomUIEvent(23);
                        break;
                    }
                    case 10: {
                        n = 13;
                        break;
                    }
                    case 127: {
                        n = 46;
                        break;
                    }
                    case 155: {
                        n = 45;
                    }
                }
            }
        } else if (n2 == 400) {
            n = 0;
            c = keyEvent.getKeyChar();
        } else {
            n = keyEvent.getKeyCode();
            c = '\u0000';
        }
        DOMUIEvent dOMUIEvent2 = this.createDomUIEvent(n3);
        dOMUIEvent2.setKeyCode(n);
        dOMUIEvent2.setCharCode(c);
        boolean bl = this.uiEvent(dOMUIEvent2, keyEvent, eventListener);
        if (!dOMUIEvent2.isDefaultCancelled() && dOMUIEvent != null) {
            this._cssLayout.handleEvent(dOMUIEvent);
        }
        return bl;
    }

    public final boolean uiEvent(DOMUIEvent dOMUIEvent, InputEvent inputEvent, EventListener eventListener) {
        if (eventListener != null) {
            dOMUIEvent.setAction(eventListener);
        }
        dOMUIEvent.setSystemEvent(inputEvent);
        dOMUIEvent.setAltKey(inputEvent.isAltDown());
        dOMUIEvent.setCtrlKey(inputEvent.isControlDown());
        dOMUIEvent.setShiftKey(inputEvent.isShiftDown());
        int n = inputEvent.getModifiers();
        if ((n & 0x10) != 0) {
            dOMUIEvent.setButton((short)0);
        } else if ((n & 8) != 0) {
            dOMUIEvent.setButton((short)1);
        } else if ((n & 4) != 0) {
            dOMUIEvent.setButton((short)2);
            if (this.is_msie_event_emulation()) {
                dOMUIEvent.typeId = 24;
            }
        }
        Component component = inputEvent.getComponent();
        if (component instanceof ObjectPainter) {
            dOMUIEvent.setObjectPainter((ObjectPainter)((Object)component));
        }
        this._cssLayout.handleEvent(dOMUIEvent);
        switch (dOMUIEvent.typeId) {
            case 8: {
                KeyEvent keyEvent = (KeyEvent)inputEvent;
                keyEvent.setKeyChar((char)dOMUIEvent.getCharCode());
            }
        }
        if (dOMUIEvent.isDefaultCancelled()) {
            inputEvent.consume();
            return false;
        }
        return !dOMUIEvent.isDefaultDone();
    }

    protected abstract void onNodeSelectCall(DNode var1);

    protected abstract void onNodeBlurEvent(DOMUIEvent var1, DNode var2);

    protected abstract void onNodeFocusEvent(DOMUIEvent var1, DNode var2);

    public final boolean checkDocumentId() {
        Viewport viewport = this._pilot.getPilotViewport();
        if (this._pilot.getDocument() == null) {
            return false;
        }
        if (viewport != null && this._documentId == viewport.getDocumentId()) {
            return true;
        }
        if (Debug.trace) {
            Debug.trace("Old id");
        }
        return false;
    }

    public boolean is_msie_event_emulation() {
        return this._ieEmulation;
    }

    public final ThePilot getPilot() {
        return this._pilot;
    }

    public final int getDocWidth() {
        return this._cssLayout.getWidth();
    }

    public final int getDocHeight() {
        return this._cssLayout.getHeight();
    }

    public final void docLayout(int n, int n2) {
        this._cssLayout.layout(n, n2);
    }

    public final void docPostLayout() {
        this._cssLayout.postLayout();
    }

    public final void docClearSelection() {
        this._cssLayout.clearSelection();
    }

    public final void docSetSelection(int n, int n2, int n3, int n4) {
        int n5 = this.getScrollX();
        int n6 = this.getScrollY();
        this._cssLayout.setSelection(n, n2, n3, n4, n5, n6);
    }

    public final boolean docContainsFixedBoxes() {
        return this._cssLayout.containsFixedBoxes();
    }

    public final void docPaint(Graphics graphics) {
        this._cssLayout.paint(graphics);
    }

    public final void docPaintFixed(Graphics graphics) {
        this._cssLayout.paintFixed(graphics);
    }

    public final DOMUIEvent createDomUIEvent(int n) {
        return (DOMUIEvent)this._pilot.getDDocument().createDOMEvent(n);
    }

    public final ObjectPainter getNodePainter(DNode dNode) {
        return this._pilot.getView().getNodePainter(dNode);
    }

    protected final void notifyFocusGain() {
        this._pilot.viewportBecameActive();
        this._cssLayout.getFocusManager().setFrameFocused(true);
    }

    protected final void notifyFocusLost() {
        this._cssLayout.getFocusManager().setFrameFocused(false);
    }
}

