/*
 * Decompiled with CFR 0.152.
 */
package ice.dom.html;

import ice.dom.html.DefaultHTMLElement;
import ice.dom.html.TableCaptionElement;
import ice.dom.html.TableRowElement;
import ice.dom.html.TableSectionElement;
import ice.dom.html.VectorCollection;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DNode;
import ice.storm.DynEnv;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLTableCaptionElement;
import org.w3c.dom.html.HTMLTableElement;
import org.w3c.dom.html.HTMLTableSectionElement;

public class TableElement
extends DefaultHTMLElement
implements HTMLTableElement {
    private static final int Field_caption = 1;
    private static final int Field_rows = 2;
    private static final int Field_tBodies = 3;
    private static final int Field_tFoot = 4;
    private static final int Field_tHead = 5;
    private static final int Method_createCaption = -1;
    private static final int Method_createTFoot = -2;
    private static final int Method_createTHead = -3;
    private static final int Method_deleteCaption = -4;
    private static final int Method_deleteRow = -5;
    private static final int Method_deleteTFoot = -6;
    private static final int Method_deleteTHead = -7;
    private static final int Method_insertRow = -8;

    public TableElement(DDocument dDocument, int n) {
        super(dDocument, n);
    }

    public HTMLTableCaptionElement getCaption() {
        NodeList nodeList = this.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            DNode dNode = (DNode)nodeList.item(n);
            if (dNode instanceof HTMLTableCaptionElement) {
                return (HTMLTableCaptionElement)((Object)dNode);
            }
            ++n;
        }
        return null;
    }

    public void setCaption(HTMLTableCaptionElement hTMLTableCaptionElement) {
        HTMLTableCaptionElement hTMLTableCaptionElement2 = this.getCaption();
        if (hTMLTableCaptionElement2 != null) {
            this.replaceChild(hTMLTableCaptionElement, hTMLTableCaptionElement2);
        } else {
            this.insertBefore(hTMLTableCaptionElement, this.first);
        }
    }

    public HTMLTableSectionElement getTHead() {
        NodeList nodeList = this.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            DNode dNode = (DNode)nodeList.item(n);
            if (dNode instanceof HTMLTableSectionElement && dNode.getNameId() == 85) {
                return (HTMLTableSectionElement)((Object)dNode);
            }
            ++n;
        }
        return null;
    }

    private void do_insertTHead(HTMLTableSectionElement hTMLTableSectionElement) {
        HTMLTableSectionElement hTMLTableSectionElement2 = this.getTFoot();
        if (hTMLTableSectionElement2 != null) {
            this.insertBefore(hTMLTableSectionElement, hTMLTableSectionElement2);
        } else {
            this.insertBefore(hTMLTableSectionElement, this.getTBodies().item(0));
        }
    }

    public void setTHead(HTMLTableSectionElement hTMLTableSectionElement) {
        HTMLTableSectionElement hTMLTableSectionElement2 = this.getTHead();
        if (hTMLTableSectionElement2 != null) {
            this.replaceChild(hTMLTableSectionElement, hTMLTableSectionElement2);
        } else {
            this.do_insertTHead(hTMLTableSectionElement);
        }
    }

    public HTMLTableSectionElement getTFoot() {
        NodeList nodeList = this.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            DNode dNode = (DNode)nodeList.item(n);
            if (dNode instanceof HTMLTableSectionElement && dNode.getNameId() == 83) {
                return (HTMLTableSectionElement)((Object)dNode);
            }
            ++n;
        }
        return null;
    }

    public void setTFoot(HTMLTableSectionElement hTMLTableSectionElement) {
        HTMLTableSectionElement hTMLTableSectionElement2 = this.getTFoot();
        if (hTMLTableSectionElement2 != null) {
            this.replaceChild(hTMLTableSectionElement, hTMLTableSectionElement2);
        } else {
            this.insertBefore(hTMLTableSectionElement, this.getTBodies().item(0));
        }
    }

    public HTMLCollection getRows() {
        Vector<HTMLCollection> vector = new Vector<HTMLCollection>();
        NodeList nodeList = this.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof HTMLTableSectionElement) {
                vector.addElement(((HTMLTableSectionElement)node).getRows());
            }
            ++n;
        }
        return new VectorCollection(vector);
    }

    public HTMLCollection getTBodies() {
        Vector<DNode> vector = new Vector<DNode>();
        NodeList nodeList = this.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            DNode dNode = (DNode)nodeList.item(n);
            if (dNode instanceof HTMLTableSectionElement && dNode.getNameId() == 80) {
                vector.addElement(dNode);
            }
            ++n;
        }
        return new VectorCollection(vector);
    }

    public HTMLElement createTHead() {
        HTMLTableSectionElement hTMLTableSectionElement = this.getTHead();
        if (hTMLTableSectionElement == null) {
            hTMLTableSectionElement = new TableSectionElement(this.doc, 85);
            this.do_insertTHead(hTMLTableSectionElement);
        }
        return hTMLTableSectionElement;
    }

    public void deleteTHead() {
        HTMLTableSectionElement hTMLTableSectionElement = this.getTHead();
        if (hTMLTableSectionElement != null) {
            this.removeChild(hTMLTableSectionElement);
        }
    }

    public HTMLElement createTFoot() {
        HTMLTableSectionElement hTMLTableSectionElement = this.getTFoot();
        if (hTMLTableSectionElement == null) {
            hTMLTableSectionElement = new TableSectionElement(this.doc, 83);
            this.insertBefore(hTMLTableSectionElement, this.getTBodies().item(0));
        }
        return hTMLTableSectionElement;
    }

    public void deleteTFoot() {
        HTMLTableSectionElement hTMLTableSectionElement = this.getTFoot();
        if (hTMLTableSectionElement != null) {
            this.removeChild(hTMLTableSectionElement);
        }
    }

    public HTMLElement createCaption() {
        HTMLTableCaptionElement hTMLTableCaptionElement = this.getCaption();
        if (hTMLTableCaptionElement == null) {
            hTMLTableCaptionElement = new TableCaptionElement(this.doc, 16);
            this.insertBefore(hTMLTableCaptionElement, this.first);
        }
        return hTMLTableCaptionElement;
    }

    public void deleteCaption() {
        HTMLTableCaptionElement hTMLTableCaptionElement = this.getCaption();
        if (hTMLTableCaptionElement != null) {
            this.removeChild(hTMLTableCaptionElement);
        }
    }

    public HTMLElement insertRow(int n) {
        HTMLCollection hTMLCollection = this.getRows();
        int n2 = hTMLCollection.getLength();
        if (n > n2 || n < 0) {
            return null;
        }
        TableRowElement tableRowElement = new TableRowElement(this.doc, 87);
        if (n2 == 0) {
            if (this.getNameId() == 79) {
                TableSectionElement tableSectionElement = new TableSectionElement(this.doc, 80);
                tableSectionElement.appendChild(tableRowElement);
                this.appendChild(tableSectionElement);
            } else {
                this.appendChild(tableRowElement);
            }
        } else if (n2 == n) {
            hTMLCollection.item(n2 - 1).getParentNode().appendChild(tableRowElement);
        } else {
            Node node = hTMLCollection.item(n);
            node.getParentNode().insertBefore(tableRowElement, node);
        }
        return tableRowElement;
    }

    public void deleteRow(int n) {
        HTMLCollection hTMLCollection = this.getRows();
        int n2 = hTMLCollection.getLength();
        if (n >= n2 || n < 0) {
            return;
        }
        Node node = hTMLCollection.item(n);
        node.getParentNode().removeChild(node);
    }

    public Object getDynamicValue(String string, DynEnv dynEnv) {
        int n = TableElement.toDynamicId(string);
        if (n < 0) {
            return dynEnv.wrapMethod(this, string);
        }
        if (n > 0) {
            return this.getDynamicValue(n, dynEnv);
        }
        return super.getDynamicValue(string, dynEnv);
    }

    public int setDynamicValue(String string, Object object, DynEnv dynEnv) {
        int n = TableElement.toDynamicId(string);
        if (n < 0) {
            return 2;
        }
        if (n > 0) {
            return this.setDynamicValue(n, object, dynEnv);
        }
        return super.setDynamicValue(string, object, dynEnv);
    }

    public Object execDynamicMethod(String string, Object[] objectArray, DynEnv dynEnv) {
        int n = TableElement.toDynamicId(string);
        if (n < 0) {
            return this.execDynamicMethod(n, objectArray, dynEnv);
        }
        return super.execDynamicMethod(string, objectArray, dynEnv);
    }

    private Object getDynamicValue(int n, DynEnv dynEnv) {
        switch (n) {
            case 1: {
                return this.getCaption();
            }
            case 2: {
                return this.getRows();
            }
            case 3: {
                return this.getTBodies();
            }
            case 4: {
                return this.getTFoot();
            }
            case 5: {
                return this.getTHead();
            }
        }
        return null;
    }

    private int setDynamicValue(int n, Object object, DynEnv dynEnv) {
        switch (n) {
            case 1: {
                this.setCaption((HTMLTableCaptionElement)dynEnv.toNative(object));
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 2;
            }
            case 4: {
                this.setTFoot((HTMLTableSectionElement)dynEnv.toNative(object));
                return 1;
            }
            case 5: {
                this.setTHead((HTMLTableSectionElement)dynEnv.toNative(object));
                return 1;
            }
        }
        return 2;
    }

    private Object execDynamicMethod(int n, Object[] objectArray, DynEnv dynEnv) {
        switch (n) {
            case -1: {
                return this.createCaption();
            }
            case -2: {
                return this.createTFoot();
            }
            case -3: {
                return this.createTHead();
            }
            case -4: {
                this.deleteCaption();
                break;
            }
            case -5: {
                this.deleteRow(dynEnv.toInt(objectArray, 0));
                break;
            }
            case -6: {
                this.deleteTFoot();
                break;
            }
            case -7: {
                this.deleteTHead();
                break;
            }
            case -8: {
                return this.insertRow(dynEnv.toInt(objectArray, 0));
            }
        }
        return dynEnv.wrapVoid();
    }

    private static int toDynamicId(String string) {
        int n = 0;
        String string2 = null;
        switch (string.length()) {
            case 4: {
                string2 = "rows";
                n = 2;
                break;
            }
            case 5: {
                char c = string.charAt(1);
                if (c == 'F') {
                    string2 = "tFoot";
                    n = 4;
                    break;
                }
                if (c != 'H') break;
                string2 = "tHead";
                n = 5;
                break;
            }
            case 7: {
                char c = string.charAt(0);
                if (c == 'c') {
                    string2 = "caption";
                    n = 1;
                    break;
                }
                if (c != 't') break;
                string2 = "tBodies";
                n = 3;
                break;
            }
            case 9: {
                char c = string.charAt(0);
                if (c == 'd') {
                    string2 = "deleteRow";
                    n = -5;
                    break;
                }
                if (c != 'i') break;
                string2 = "insertRow";
                n = -8;
                break;
            }
            case 11: {
                char c = string.charAt(0);
                if (c == 'c') {
                    c = string.charAt(10);
                    if (c == 'd') {
                        string2 = "createTHead";
                        n = -3;
                        break;
                    }
                    if (c != 't') break;
                    string2 = "createTFoot";
                    n = -2;
                    break;
                }
                if (c != 'd') break;
                c = string.charAt(10);
                if (c == 'd') {
                    string2 = "deleteTHead";
                    n = -7;
                    break;
                }
                if (c != 't') break;
                string2 = "deleteTFoot";
                n = -6;
                break;
            }
            case 13: {
                char c = string.charAt(0);
                if (c == 'c') {
                    string2 = "createCaption";
                    n = -1;
                    break;
                }
                if (c != 'd') break;
                string2 = "deleteCaption";
                n = -4;
            }
        }
        if (string2 != null && (string2 == string || string2.equals(string))) {
            return n;
        }
        return 0;
    }
}

