/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.runtimev2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ResourceBundle;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import oracle.jsp.logger.JspMessages;
import oracle.jsp.parse.DependencyFile;
import oracle.jsp.parse.JspCompilationAuxObj;
import oracle.jsp.parse.JspEncodingException;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.provider.JspCompileException;
import oracle.jsp.provider.JspResourceProvider;
import oracle.jsp.runtime.OracleTagFile;
import oracle.jsp.runtimev2.JspPageTable;
import oracle.jsp.runtimev2.TagFileCompiler;
import oracle.jsp.util.JspUtil;

public class TagFilePageInfo {
    private static final String MSG_FILE = "oracle.jsp.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.LocalStrings");
    private ServletConfig config;
    protected String tagFilePath;
    private String className;
    private String classFilePath;
    private String classAuxFilePath;
    private String tagFileRespositoryRoot;
    private JspResourceProvider rProvider;
    private long srcModifiedWhenLoaded = 0L;
    private JspCompilationAuxObj auxObj = null;
    private OracleTagFile tagFileClassInst = null;
    private TagInfo tagFileTagInfo = null;
    protected long cacheDelay = 1000L;
    private long lastPageCheck = 0L;
    private long lastAccessed;
    private Object compileSync = new Object();

    public TagFilePageInfo(JspPageTable pageTable, String servletpath, ServletConfig config, JspResourceProvider rProvider, String tagFileRespositoryRoot) {
        this.config = config;
        this.rProvider = rProvider;
        if (servletpath == null) {
            throw new IllegalArgumentException(msgs.getString("null_servletpath"));
        }
        this.tagFilePath = servletpath;
        String tagHandlerClassName = JspUtil.getTagHandlerClassName(this.tagFilePath);
        this.className = JspUtil.getFullClassNameFromURL(tagHandlerClassName);
        this.classFilePath = this.className.replace('.', File.separatorChar) + ".class";
        this.classAuxFilePath = this.className.replace('.', File.separatorChar) + ".jpa";
        this.tagFileRespositoryRoot = tagFileRespositoryRoot;
    }

    private static long getLastModified(JspResourceProvider rp, String path) throws FileNotFoundException, IOException {
        return rp.getLastModified(path);
    }

    public synchronized TagInfo getTagFileTagInfo(ClassLoader classLoader, TagLibraryInfo tlib) throws ClassNotFoundException {
        if (this.tagFileTagInfo == null) {
            this.getTagFileClassInst(classLoader);
            if (this.tagFileClassInst != null) {
                return this.tagFileClassInst.getTagInfo(tlib);
            }
        }
        return this.tagFileTagInfo;
    }

    private synchronized void getTagFileClassInst(ClassLoader classLoader) throws ClassNotFoundException {
        if (this.tagFileClassInst == null) {
            Class<?> tagFileClass = classLoader.loadClass(this.className);
            try {
                this.tagFileClassInst = (OracleTagFile)tagFileClass.newInstance();
                this.srcModifiedWhenLoaded = TagFilePageInfo.getLastModified(this.rProvider, this.tagFilePath);
            }
            catch (Exception e) {
                this.srcModifiedWhenLoaded = 0L;
            }
            this.prepareAuxObj();
        }
    }

    public synchronized void destroyTagFileClassInst() {
        if (this.auxObj != null) {
            this.auxObj = null;
        }
        this.tagFileClassInst = null;
        this.tagFileTagInfo = null;
        this.srcModifiedWhenLoaded = 0L;
    }

    protected long getLastAccessed() {
        return this.lastAccessed;
    }

    public String getClassName() {
        return this.className;
    }

    public JspCompilationAuxObj getAuxObj() {
        this.prepareAuxObj();
        return this.auxObj;
    }

    private long getClassFileLastModified() throws FileNotFoundException {
        String path = this.tagFileRespositoryRoot + File.separatorChar + this.classFilePath;
        return this.getFileLastModified(path);
    }

    private long getAuxFileLastModified() throws FileNotFoundException {
        String path = this.tagFileRespositoryRoot + File.separatorChar + this.classAuxFilePath;
        return this.getFileLastModified(path);
    }

    private long getFileLastModified(String path) throws FileNotFoundException {
        File f = new File(path);
        if (!f.exists()) {
            throw new FileNotFoundException(path);
        }
        return f.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void prepareAuxObj() {
        block24: {
            if (this.auxObj == null) {
                String path = this.tagFileRespositoryRoot + File.separatorChar + this.classAuxFilePath;
                File f = new File(path);
                if (!f.exists()) {
                    return;
                }
                FileInputStream fis = null;
                ObjectInputStream ois = null;
                fis = new FileInputStream(f);
                ois = new ObjectInputStream(fis);
                this.auxObj = (JspCompilationAuxObj)ois.readObject();
                Object var7_5 = null;
                try {
                    if (ois != null) {
                        ois.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                    break block24;
                }
                catch (Exception e) {}
                break block24;
                {
                    catch (FileNotFoundException fnfe) {
                        JspMessages.warningErrorPreparingDependencyFileForTagFile(fnfe);
                        Object var7_6 = null;
                        try {
                            if (ois != null) {
                                ois.close();
                            }
                            if (fis != null) {
                                fis.close();
                            }
                            break block24;
                        }
                        catch (Exception e) {}
                        break block24;
                    }
                    catch (IOException ioe) {
                        JspMessages.warningErrorPreparingDependencyFileForTagFile(ioe);
                        Object var7_7 = null;
                        try {
                            if (ois != null) {
                                ois.close();
                            }
                            if (fis != null) {
                                fis.close();
                            }
                            break block24;
                        }
                        catch (Exception e) {}
                        break block24;
                    }
                    catch (ClassNotFoundException cnfe) {
                        JspMessages.warningErrorPreparingDependencyFileForTagFile(cnfe);
                        Object var7_8 = null;
                        try {
                            if (ois != null) {
                                ois.close();
                            }
                            if (fis != null) {
                                fis.close();
                            }
                            break block24;
                        }
                        catch (Exception e) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    try {
                        if (ois != null) {
                            ois.close();
                        }
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    private boolean needsRecompileByComparingIncludedFiles() throws IOException {
        String fileName;
        this.prepareAuxObj();
        if (this.auxObj == null) {
            return false;
        }
        DependencyFile[] df = this.auxObj.dependentFiles;
        if (df == null) {
            return false;
        }
        if (df.length != 0 && (fileName = df[0].fileName) != null && fileName.equals("oracle_partially_parsed_file_marker")) {
            this.cacheDelay = 0L;
            return true;
        }
        for (int i = 0; i < df.length; ++i) {
            try {
                long mod = TagFilePageInfo.getLastModified(this.rProvider, df[i].fileName);
                if (mod == df[i].lastModified) continue;
                return true;
            }
            catch (FileNotFoundException fnfe) {
                return false;
            }
        }
        try {
            long auxFileLastModified = this.getAuxFileLastModified();
            long classLastModified = this.getClassFileLastModified();
            if (auxFileLastModified > classLastModified) {
                return true;
            }
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
        return false;
    }

    public boolean needsRecompile() throws IOException {
        if (this.cacheDelay == 0L || this.srcModifiedWhenLoaded == 0L) {
            return this.needsRecompileAction();
        }
        if (this.cacheDelay < System.currentTimeMillis() - this.lastPageCheck) {
            this.lastPageCheck = System.currentTimeMillis();
            return this.needsRecompileAction();
        }
        return false;
    }

    private boolean needsRecompileAction() throws IOException {
        long classFileModified;
        long currentSrcModified;
        try {
            currentSrcModified = TagFilePageInfo.getLastModified(this.rProvider, this.tagFilePath);
        }
        catch (FileNotFoundException fnfe) {
            return true;
        }
        try {
            classFileModified = this.getClassFileLastModified();
        }
        catch (Exception e) {
            return true;
        }
        if (this.srcModifiedWhenLoaded == 0L) {
            if (currentSrcModified > classFileModified) {
                return true;
            }
            return this.needsRecompileByComparingIncludedFiles();
        }
        if (this.srcModifiedWhenLoaded != currentSrcModified) {
            return true;
        }
        return this.needsRecompileByComparingIncludedFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compileAndLoad(TagFileCompiler tagFileCompiler, String tagFileName, String tagFilePath, TagLibraryInfo tlib, JspParseState st, String jarName, boolean xmlStyleSrc, ClassLoader classLoader) throws FileNotFoundException, IOException, IllegalAccessException, ServletException, JspParseException, JspEncodingException, JspCompileException, ClassNotFoundException {
        Object object = this.compileSync;
        synchronized (object) {
            if (this.needsRecompileAction()) {
                tagFileCompiler.compileTagFile(tagFileName, tagFilePath, tlib, st, jarName, xmlStyleSrc);
                this.destroyTagFileClassInst();
            }
        }
    }
}

