/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.runtimev2;

import com.evermind.server.ApplicationServer;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ResourceBundle;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.StateIntf;
import oracle.jsp.runtime.tree.OracleJspFileNode;
import oracle.jsp.runtimev2.JspServlet;
import oracle.jsp.runtimev2.ShortCutServlet;
import oracle.jsp.runtimev2.ShortCutSingleInstance;

public class JspPageInstFacade {
    private static final String MSG_FILE = "oracle.jsp.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.LocalStrings");
    private ServletConfig config;
    private Class servletClass;
    private boolean threadSafe;
    private Servlet mtInst;
    private int availableCount = 0;
    private int instanceCount = 0;
    private boolean jsfSharedInst = false;
    private boolean jsfShortCut = false;
    private static final int DMS_UPDATE_AVAILABLE_COUNT = 1;
    private static final int DMS_UPDATE_ACTIVE_COUNT = 2;
    private static final int DMS_UPDATE_ALL_COUNT = 3;
    private static final int DMS_INCREMENT_COUNT = 1;
    private static final int DMS_DECREMENT_COUNT = 2;
    private static final int DMS_DESTROY_COUNT = 3;
    private static final int DMS_NOOP_COUNT = 4;
    private StateIntf activeInst;
    private StateIntf availableInst;
    private Servlet[] pool;
    private int refCount = 0;
    private boolean markedToDestroy = false;
    private boolean destroyed = false;
    private boolean declaresDestroyMethod = false;
    private OracleJspFileNode pageNode;

    public JspPageInstFacade(boolean threadSafe, Class servletClass, ServletConfig config, NounIntf pageNoun, OracleJspFileNode pageNode, boolean jsfSharedInst) throws ClassNotFoundException {
        this.config = config;
        this.servletClass = servletClass;
        this.threadSafe = threadSafe;
        this.pageNode = pageNode;
        this.jsfSharedInst = jsfSharedInst;
        boolean bl = this.jsfShortCut = pageNode != null || jsfSharedInst;
        if (servletClass != null) {
            this.declaresDestroyMethod = (Boolean)AccessController.doPrivileged(new DeclaredAction(servletClass));
        }
        if (!threadSafe) {
            this.pool = new Servlet[4];
            if (JspServlet.DMS_GATE) {
                try {
                    this.activeInst = ApplicationServer.stateFactory().create(pageNoun, "activeInstances", "", "active instances", 0);
                    this.availableInst = ApplicationServer.stateFactory().create(pageNoun, "availableInstances", "", "available instances", 0);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
    }

    protected Class getServletClass() {
        return this.servletClass;
    }

    public boolean isThreadSafe() {
        return this.threadSafe;
    }

    public int getPoolSize() {
        return this.pool.length;
    }

    private Servlet getShortCutInstances() throws ServletException {
        if (this.jsfSharedInst) {
            return this.getSharedServletInstFacade();
        }
        return this.shortCutInst();
    }

    private Servlet createInst() throws ServletException {
        if (this.jsfShortCut) {
            return this.getShortCutInstances();
        }
        Servlet inst = null;
        try {
            inst = (Servlet)this.servletClass.newInstance();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        inst.init(this.config);
        return inst;
    }

    private ShortCutServlet shortCutInst() throws ServletException {
        ShortCutServlet inst = null;
        try {
            inst = new ShortCutServlet();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        inst.init(this.config);
        inst.setPageRootNode(this.pageNode);
        return inst;
    }

    public synchronized Servlet getInstance() throws ServletException {
        if (this.markedToDestroy) {
            throw new ServletException(msgs.getString("zombie_page"));
        }
        ++this.refCount;
        if (this.threadSafe) {
            if (this.mtInst == null) {
                this.mtInst = this.createInst();
            }
            return this.mtInst;
        }
        if (this.availableCount > 0) {
            --this.availableCount;
            this.updateInstanceCount(2, 4);
            return this.pool[this.availableCount];
        }
        this.updateInstanceCount(3, 1);
        return this.createInst();
    }

    public synchronized void returnInstance(Servlet inst) {
        --this.refCount;
        if (!this.threadSafe) {
            if (this.availableCount >= this.pool.length) {
                Servlet[] newPool = new Servlet[this.pool.length * 2];
                System.arraycopy(this.pool, 0, newPool, 0, this.availableCount);
                this.pool = newPool;
            }
            this.pool[this.availableCount++] = inst;
            this.updateInstanceCount(2, 4);
        }
        if (this.refCount == 0 && this.markedToDestroy) {
            this.destroyAction();
        }
    }

    public synchronized void decInstFromPool() {
        if (!this.threadSafe && this.availableCount > 0) {
            Servlet inst = this.pool[this.availableCount];
            this.pool[this.availableCount] = null;
            --this.availableCount;
            inst.destroy();
            this.updateInstanceCount(3, 2);
        }
    }

    private synchronized void destroyAction() {
        if (this.destroyed) {
            return;
        }
        if (this.threadSafe) {
            if (this.mtInst != null) {
                this.mtInst.destroy();
                this.mtInst = null;
            }
        } else {
            if (this.pool != null) {
                for (int i = 0; i < this.pool.length; ++i) {
                    try {
                        if (this.pool[i] == null) continue;
                        this.pool[i].destroy();
                        this.pool[i] = null;
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.updateInstanceCount(3, 3);
            this.pool = null;
        }
        this.pageNode = null;
        this.destroyed = true;
    }

    public synchronized void destroy() {
        this.markedToDestroy = true;
        if (this.refCount == 0) {
            this.destroyAction();
        }
    }

    public void finalize() {
        this.destroy();
    }

    private void updateInstanceCount(int updateWhat, int how) {
        if (JspServlet.DMS_GATE) {
            if (updateWhat != 2) {
                switch (how) {
                    case 1: {
                        ++this.instanceCount;
                        break;
                    }
                    case 2: {
                        --this.instanceCount;
                        break;
                    }
                    case 3: {
                        this.availableCount = 0;
                        this.instanceCount = 0;
                        break;
                    }
                }
            }
            switch (updateWhat) {
                case 1: {
                    if (this.availableInst == null) break;
                    this.availableInst.update(this.instanceCount);
                    break;
                }
                case 2: {
                    if (this.activeInst == null) break;
                    this.activeInst.update(this.instanceCount - this.availableCount);
                    break;
                }
                case 3: {
                    if (this.availableInst != null) {
                        this.availableInst.update(this.instanceCount);
                    }
                    if (this.activeInst == null) break;
                    this.activeInst.update(this.instanceCount - this.availableCount);
                }
            }
        }
    }

    protected synchronized int getRefCount() {
        return this.refCount;
    }

    protected synchronized boolean isDestroyMethodDeclared() {
        return this.declaresDestroyMethod;
    }

    private ShortCutSingleInstance getSharedServletInstFacade() throws ServletException {
        ShortCutSingleInstance inst = null;
        try {
            inst = new ShortCutSingleInstance();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        inst.init(this.config);
        return inst;
    }

    class DeclaredAction
    implements PrivilegedAction {
        Class servletClass;

        DeclaredAction(Class servletClass) {
            this.servletClass = servletClass;
        }

        public Object run() {
            try {
                Method destroyMethod = this.servletClass.getDeclaredMethod("jspDestroy", null);
                return Boolean.TRUE;
            }
            catch (NoSuchMethodException e) {
                return Boolean.FALSE;
            }
        }
    }
}

