/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.runtimev2;

import com.evermind.server.ApplicationServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ResourceBundle;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.jsp.logger.JspMessages;
import oracle.jsp.parse.DependencyFile;
import oracle.jsp.parse.JspCompilationAuxObj;
import oracle.jsp.parse.JspEncodingException;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.provider.JspCompileException;
import oracle.jsp.provider.JspResourceProvider;
import oracle.jsp.runtime.tree.OracleJspFileNode;
import oracle.jsp.runtimev2.JspPageCompiler;
import oracle.jsp.runtimev2.JspPageInstFacade;
import oracle.jsp.runtimev2.JspPageTable;
import oracle.jsp.runtimev2.JspServlet;
import oracle.jsp.util.JspUtil;
import oracle.oc4j.admin.jmx.model.ModelMBeanProvider;
import oracle.oc4j.admin.jmx.server.Oc4jMBeanServerFactory;
import oracle.oc4j.admin.jmx.server.mbeans.model.ModelMBeanFactory;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.callbackinterfaces.JSPCallBackIf;
import oracle.oc4j.admin.management.mbeans.JSP;

public class JspPageInfo
implements JSPCallBackIf {
    private static final String MSG_FILE = "oracle.jsp.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.LocalStrings");
    private JspPageTable pageTable;
    private ServletConfig config;
    protected String pathFromContext;
    private String className;
    private String classFilePath;
    private String classAuxFilePath;
    private OracleJspFileNode pageNode;
    private String pageRepositoryRoot;
    private JspResourceProvider rProvider;
    private long srcModifiedWhenLoaded = 0L;
    private JspCompilationAuxObj auxObj = null;
    private JspPageInstFacade instFacade = null;
    private static JspPageInstFacade sharedInstFacade = null;
    private static Object sharedInstSync = new Object();
    protected long cacheDelay = 1000L;
    private long lastPageCheck = 0L;
    private long lastAccessed;
    private boolean duringCompile = false;
    private NounIntf pageNoun;
    private NounIntf parentNoun;
    private PhaseEventIntf jspExecPhaseEvent;
    private boolean threadSafe;
    private static final String stmType = "oc4j_jsp(threadsafe=false)";
    private static final String nonstmType = "oc4j_jsp(threadsafe=true)";
    private Servlet shortCutServlet;
    private Object compileSync = new Object();
    private int sharedRefCount = 0;

    protected JspPageInfo(JspPageTable pageTable, HttpServletRequest request, String servletpath, ServletConfig config, JspResourceProvider rProvider, String pageRepositoryRoot) {
        this.pageTable = pageTable;
        this.config = config;
        this.rProvider = rProvider;
        if (servletpath == null) {
            throw new IllegalArgumentException(msgs.getString("null_servletpath"));
        }
        this.pathFromContext = servletpath;
        this.className = JspUtil.getFullClassNameFromURL(this.pathFromContext);
        this.classFilePath = this.className.replace('.', File.separatorChar) + ".class";
        this.classAuxFilePath = this.className.replace('.', File.separatorChar) + ".jpa";
        this.pageRepositoryRoot = pageRepositoryRoot;
        if (pageTable.jsfShortCut) {
            this.className = "oracle.jsp.runtimev2.ShortCutServlet";
        }
        if (pageTable.jsfSharedInst) {
            this.className = "oracle.jsp.runtimev2.ShortCutSingleInstance";
        }
        if (JspServlet.DMS_GATE) {
            this.parentNoun = (NounIntf)config.getServletContext().getAttribute("dms.JSP_PARENT_NOUN");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JspPageInstFacade getSingleInstFacade(ClassLoader classLoader, HttpServletRequest request) throws ClassNotFoundException {
        Object object = sharedInstSync;
        synchronized (object) {
            if (sharedInstFacade == null) {
                Class servletClass = null;
                servletClass = this.pageTable.classLoader.loadClass(this.className);
                this.threadSafe = true;
                sharedInstFacade = new JspPageInstFacade(true, servletClass, this.config, this.pageNoun, null, this.pageTable.jsfSharedInst);
            }
        }
        if (this.srcModifiedWhenLoaded == 0L) {
            this.prepareAuxObj();
            try {
                this.srcModifiedWhenLoaded = JspPageInfo.getLastModified(this.rProvider, this.pathFromContext, request);
            }
            catch (Exception e) {
                this.srcModifiedWhenLoaded = 0L;
            }
        }
        request.setAttribute("_oracle._jsp._pageRoot", (Object)this.pageNode);
        return sharedInstFacade;
    }

    private static long getLastModified(JspResourceProvider rp, String path, HttpServletRequest req) throws FileNotFoundException, IOException {
        return rp.getLastModified(path, req);
    }

    public synchronized JspPageInstFacade getInstFacade(ClassLoader classLoader, HttpServletRequest request) throws ClassNotFoundException {
        if (this.pageTable.jsfSharedInst) {
            return this.getSingleInstFacade(classLoader, request);
        }
        if (this.instFacade == null) {
            try {
                Class servletClass = this.pageTable.classLoader.loadClass(this.className);
                boolean bl = this.threadSafe = !SingleThreadModel.class.isAssignableFrom(servletClass);
                if (JspServlet.DMS_GATE) {
                    this.createJspExecPhaseEvent();
                }
                this.addJSPMBean();
                this.instFacade = new JspPageInstFacade(this.threadSafe, servletClass, this.config, this.pageNoun, this.pageNode, this.pageTable.jsfSharedInst);
                try {
                    if (!JspUtil.isFileCaseSensitive() && !JspUtil.isExactFileMatch(this.rProvider, this.pathFromContext)) {
                        throw new FileNotFoundException(this.pathFromContext);
                    }
                    this.srcModifiedWhenLoaded = JspPageInfo.getLastModified(this.rProvider, this.pathFromContext, request);
                }
                catch (Exception e) {
                    this.srcModifiedWhenLoaded = 0L;
                }
                this.prepareAuxObj();
            }
            catch (NoClassDefFoundError e) {
                if (JspUtil.isFileCaseSensitive()) {
                    throw e;
                }
                throw new ClassNotFoundException();
            }
        }
        return this.instFacade;
    }

    public synchronized void destroyInstFacade() {
        if (this.auxObj != null) {
            this.auxObj = null;
        }
        if (this.pageTable.jsfSharedInst) {
            this.srcModifiedWhenLoaded = 0L;
            this.removeJSPMBean();
            return;
        }
        if (this.instFacade != null) {
            JspPageInstFacade oldInstFacade = this.instFacade;
            this.instFacade = null;
            oldInstFacade.destroy();
            this.srcModifiedWhenLoaded = 0L;
            this.removeJSPMBean();
        }
    }

    private final void addJSPMBean() {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        String appName = this.pageTable.application.getName();
        String webModuleName = this.pageTable.application.getConfig().getName();
        String jspName = this.pathFromContext.charAt(0) == '/' ? this.pathFromContext.substring(1).toString() : this.pathFromContext.toString();
        JspPageInfo callBackIf = this;
        JSP mbean = new JSP((JSPCallBackIf)callBackIf, appName, webModuleName, jspName);
        try {
            if (!oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                oc4jMBeanServer.registerMBean(ModelMBeanFactory.getModelMBean((ModelMBeanProvider)mbean), mbean.getObjectName());
            }
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    private final void removeJSPMBean() {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        String appName = this.pageTable.application.getName();
        String webModuleName = this.pageTable.application.getConfig().getName();
        String jspName = this.pathFromContext.charAt(0) == '/' ? this.pathFromContext.substring(1).toString() : this.pathFromContext.toString();
        JSPCallBackIf callBackIf = null;
        JSP mbean = new JSP(callBackIf, appName, webModuleName, jspName);
        try {
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                oc4jMBeanServer.unregisterMBean(mbean.getObjectName());
            }
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    protected synchronized int getRefCount() {
        if (this.duringCompile) {
            return 1;
        }
        if (this.instFacade == null) {
            return 0;
        }
        if (this.pageTable.jsfSharedInst) {
            return this.sharedRefCount;
        }
        return this.instFacade.getRefCount();
    }

    protected void updateLastAccessed() {
        this.lastAccessed = System.currentTimeMillis();
    }

    public synchronized void decCount() {
        --this.sharedRefCount;
    }

    public synchronized void incCount() {
        ++this.sharedRefCount;
    }

    protected long getLastAccessed() {
        return this.lastAccessed;
    }

    protected synchronized boolean containsServletInst() {
        return this.shortCutServlet != null || this.instFacade != null || sharedInstFacade != null;
    }

    protected synchronized void timeout() {
        this.destroyInstFacade();
        this.shortCutServlet = null;
        this.pageNode = null;
    }

    public String getClassName() {
        return this.className;
    }

    public JspCompilationAuxObj getAuxObj() {
        this.prepareAuxObj();
        return this.auxObj;
    }

    private File getFileForPath(String path) {
        File file = new File(this.pageRepositoryRoot + File.separatorChar + path);
        return file;
    }

    private long getFileLastModified(File f) throws FileNotFoundException, IOException {
        if (!f.exists()) {
            throw new FileNotFoundException(f.getPath());
        }
        if (!JspUtil.isFileCaseSensitive() && !f.getCanonicalFile().getName().equals(f.getName())) {
            throw new FileNotFoundException(f.getPath());
        }
        return f.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void prepareAuxObj() {
        block24: {
            if (this.auxObj == null) {
                String path = this.pageRepositoryRoot + File.separatorChar + this.classAuxFilePath;
                File f = new File(path);
                if (!f.exists()) {
                    return;
                }
                FileInputStream fis = null;
                ObjectInputStream ois = null;
                fis = new FileInputStream(f);
                ois = new ObjectInputStream(fis);
                this.auxObj = (JspCompilationAuxObj)ois.readObject();
                Object var7_5 = null;
                try {
                    if (ois != null) {
                        ois.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                    break block24;
                }
                catch (Exception e) {}
                break block24;
                {
                    catch (FileNotFoundException fnfe) {
                        JspMessages.infoPrepareAuxObjFailed("prepareAuxObj:", new Throwable(fnfe));
                        Object var7_6 = null;
                        try {
                            if (ois != null) {
                                ois.close();
                            }
                            if (fis != null) {
                                fis.close();
                            }
                            break block24;
                        }
                        catch (Exception e) {}
                        break block24;
                    }
                    catch (IOException ioe) {
                        JspMessages.infoPrepareAuxObjFailed("prepareAuxObj:", new Throwable(ioe));
                        Object var7_7 = null;
                        try {
                            if (ois != null) {
                                ois.close();
                            }
                            if (fis != null) {
                                fis.close();
                            }
                            break block24;
                        }
                        catch (Exception e) {}
                        break block24;
                    }
                    catch (ClassNotFoundException cnfe) {
                        JspMessages.infoPrepareAuxObjFailed("prepareAuxObj:", new Throwable(cnfe));
                        Object var7_8 = null;
                        try {
                            if (ois != null) {
                                ois.close();
                            }
                            if (fis != null) {
                                fis.close();
                            }
                            break block24;
                        }
                        catch (Exception e) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    try {
                        if (ois != null) {
                            ois.close();
                        }
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    private boolean needsRecompileByComparingIncludedFiles(HttpServletRequest req) throws IOException {
        this.prepareAuxObj();
        if (this.auxObj == null) {
            return false;
        }
        DependencyFile[] df = this.auxObj.dependentFiles;
        if (df == null) {
            return false;
        }
        for (int i = 0; i < df.length; ++i) {
            try {
                long mod = JspPageInfo.getLastModified(this.rProvider, df[i].fileName, req);
                if (mod == df[i].lastModified) continue;
                return true;
            }
            catch (FileNotFoundException fnfe) {
                return false;
            }
        }
        try {
            long auxFileLastModified = this.getFileLastModified(this.getFileForPath(this.classAuxFilePath));
            long classLastModified = 0L;
            classLastModified = this.pageNode != null ? this.pageNode.getLastModified() : this.getFileLastModified(this.getFileForPath(this.classFilePath));
            if (auxFileLastModified > classLastModified) {
                return true;
            }
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
        return false;
    }

    public boolean needsRecompile(HttpServletRequest request) throws IOException {
        if (this.cacheDelay == 0L || this.srcModifiedWhenLoaded == 0L) {
            return this.needsRecompileAction(request);
        }
        if (this.cacheDelay < System.currentTimeMillis() - this.lastPageCheck) {
            this.lastPageCheck = System.currentTimeMillis();
            return this.needsRecompileAction(request);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean needsRecompileAction(HttpServletRequest request) throws IOException {
        long classFileModified;
        long currentSrcModified;
        try {
            if (!JspUtil.isFileCaseSensitive() && !JspUtil.isExactFileMatch(this.rProvider, this.pathFromContext)) {
                throw new FileNotFoundException(this.pathFromContext);
            }
            currentSrcModified = JspPageInfo.getLastModified(this.rProvider, this.pathFromContext, request);
        }
        catch (FileNotFoundException fnfe) {
            return true;
        }
        if (this.pageTable.jsfShortCut) {
            if (this.pageNode == null) return true;
            classFileModified = this.pageNode.getLastModified();
        } else {
            File classFile = this.getFileForPath(this.classFilePath);
            if (classFile.length() == 0L) {
                return true;
            }
            try {
                classFileModified = this.getFileLastModified(classFile);
            }
            catch (Exception e) {
                return true;
            }
        }
        if (this.srcModifiedWhenLoaded == 0L) {
            if (currentSrcModified <= classFileModified) return this.needsRecompileByComparingIncludedFiles(request);
            return true;
        }
        if (this.srcModifiedWhenLoaded == currentSrcModified) return this.needsRecompileByComparingIncludedFiles(request);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JspPageInstFacade compileAndLoad(HttpServletRequest request, HttpServletResponse response, JspPageCompiler pageCompiler, JspResourceProvider pageRepository, ClassLoader classLoader) throws FileNotFoundException, IOException, IllegalAccessException, ServletException, JspParseException, JspEncodingException, JspCompileException, ClassNotFoundException {
        Object object = this.compileSync;
        synchronized (object) {
            try {
                this.duringCompile = true;
                if (!this.needsRecompileAction(request)) {
                    JspPageInstFacade jspPageInstFacade = this.getInstFacade(classLoader, request);
                    return jspPageInstFacade;
                }
                String appDefaultEncoding = this.pageTable.getAppDefaultEncoding();
                if (appDefaultEncoding != null) {
                    if (this.pageTable.jsfShortCut) {
                        this.pageNode = pageCompiler.parseAndGetTreeNode(this.pageTable, this.rProvider, pageRepository, classLoader, request, response, this.pathFromContext, "ISO-8859-1");
                    } else {
                        pageCompiler.compilePage(this.pageTable, this.rProvider, pageRepository, classLoader, request, response, this.pathFromContext, appDefaultEncoding);
                    }
                } else if (this.pageTable.jsfShortCut) {
                    this.pageNode = pageCompiler.parseAndGetTreeNode(this.pageTable, this.rProvider, pageRepository, classLoader, request, response, this.pathFromContext, "ISO-8859-1");
                } else {
                    pageCompiler.compilePage(this.pageTable, this.rProvider, pageRepository, classLoader, request, response, this.pathFromContext, "ISO-8859-1");
                }
                this.destroyInstFacade();
                JspPageInstFacade jspPageInstFacade = this.getInstFacade(classLoader, request);
                return jspPageInstFacade;
            }
            finally {
                this.duringCompile = false;
            }
        }
    }

    private NounIntf getPageNoun() {
        if (this.pageNoun == null) {
            String jspName = this.pathFromContext.charAt(0) == '/' ? this.pathFromContext.substring(1).toString() : this.pathFromContext.toString();
            try {
                this.pageNoun = this.threadSafe ? ApplicationServer.nounFactory().create(this.parentNoun, jspName, nonstmType) : ApplicationServer.nounFactory().create(this.parentNoun, jspName, stmType);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.pageNoun;
    }

    private void createJspExecPhaseEvent() {
        if (this.jspExecPhaseEvent == null) {
            try {
                this.jspExecPhaseEvent = this.threadSafe ? ApplicationServer.phaseEventFactory().create(this.getPageNoun(), "service", nonstmType) : ApplicationServer.phaseEventFactory().create(this.getPageNoun(), "service", stmType);
                this.jspExecPhaseEvent.deriveMetric(511);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public PhaseEventIntf getJspExecPhaseEvent() {
        if (this.jspExecPhaseEvent == null) {
            this.createJspExecPhaseEvent();
        }
        return this.jspExecPhaseEvent;
    }

    protected Servlet getShortCutServlet() {
        return this.shortCutServlet;
    }

    protected void setShortCutServlet(Servlet s) {
        this.shortCutServlet = s;
    }
}

