/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.runtime.tree;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.JspTag;
import javax.servlet.jsp.tagext.SimpleTag;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagAdapter;
import oracle.jsp.runtime.tree.OracleJspNode;
import oracle.jsp.runtime.tree.OracleJspRuntimeContext;
import oracle.jsp.runtime.tree.PrototypeCustomTagFragmentNode;
import oracle.jsp.tagext.SharedTag;
import oracle.jsp.tagext.SimpleTagAdapter;

public abstract class OracleJspCustomTagNode
extends OracleJspNode
implements PrototypeCustomTagFragmentNode {
    private String tagClassName;
    private Class tagClass;
    private Map attributes;
    private Map attrTypes;
    private Map methods;
    private JspTag shareTagHandler;
    private boolean shareTagEnabled;

    public void setAttributes(Map attributes) {
        this.attributes = attributes;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public void setTagClassName(String tagClassName) {
        this.tagClassName = tagClassName;
    }

    public String getTagClassName() {
        return this.tagClassName;
    }

    public void setTagClass(Class tagClass) {
        this.tagClass = tagClass;
    }

    protected Class getTagClass() {
        return this.tagClass;
    }

    public void setAttributeTypes(Map attrTypes) {
        this.attrTypes = attrTypes;
    }

    protected Map getAttributeTypes() {
        return this.attrTypes;
    }

    public void setShareTagEnabled(boolean shareTagEnabled) {
        this.shareTagEnabled = shareTagEnabled;
    }

    protected boolean isShareTagEnabled() {
        return this.shareTagEnabled;
    }

    public void doAfterInit() {
        this.methods = new HashMap();
        try {
            Iterator keys = this.attributes.keySet().iterator();
            Class[] types = new Class[1];
            while (keys.hasNext()) {
                String name = (String)keys.next();
                types[0] = (Class)this.attrTypes.get(name);
                this.methods.put(name, this.tagClass.getMethod(this.getMethodName(name), types));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createShareTagInstance() {
        try {
            JspTag tagParent = null;
            OracleJspNode nodeParent = this.getParent();
            if (nodeParent instanceof OracleJspCustomTagNode) {
                tagParent = ((OracleJspCustomTagNode)nodeParent).getShareTagInstance();
            }
            this.shareTagHandler = (JspTag)this.tagClass.newInstance();
            this.setParentAndContext(this.shareTagHandler, tagParent, null);
            this.invokeSetters(this.shareTagHandler);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doAfterCreateComplete() {
    }

    public JspTag getShareTagInstance() {
        return this.shareTagHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OracleJspRuntimeContext context) throws JspException, ServletException, IOException {
        JspTag handler = this.getTagInstance(context);
        JspTag savedParent = context.getTagParent();
        context.setTagParent(handler);
        boolean savedShareTagAllowed = context.isShareTagAllowed();
        if (!this.isShareTagEnabled()) {
            context.setShareTagAllowed(false);
        }
        try {
            this.executeHandler(context, handler);
            Object var6_5 = null;
            context.setShareTagAllowed(savedShareTagAllowed);
            context.setTagParent(savedParent);
            this.releaseTagInstance(handler);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            context.setShareTagAllowed(savedShareTagAllowed);
            context.setTagParent(savedParent);
            this.releaseTagInstance(handler);
            throw throwable;
        }
    }

    protected abstract void executeHandler(OracleJspRuntimeContext var1, JspTag var2) throws JspException, ServletException, IOException;

    protected JspTag getTagInstance(OracleJspRuntimeContext context) throws JspException {
        if (this.shareTagEnabled && context.isShareTagAllowed()) {
            return this.shareTagHandler;
        }
        JspTag tagHandler = null;
        try {
            tagHandler = (JspTag)this.tagClass.newInstance();
            this.setParentAndContext(tagHandler, context.getTagParent(), context.getPageContext());
            this.invokeSetters(tagHandler);
        }
        catch (InstantiationException e) {
            throw new JspException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new JspException((Throwable)e);
        }
        return tagHandler;
    }

    protected void releaseTagInstance(JspTag tagHandler) {
        if (!this.shareTagEnabled && tagHandler instanceof Tag) {
            ((Tag)tagHandler).release();
        }
    }

    protected void setParentAndContext(JspTag tagHandler, JspTag tagParent, PageContext pCtx) throws JspException {
        if (tagHandler instanceof Tag) {
            if (tagParent instanceof SharedTag) {
                ((Tag)tagHandler).setParent((Tag)new TagAdapter((SimpleTag)new SimpleTagAdapter((SharedTag)tagParent)));
            } else if (tagParent instanceof SimpleTag) {
                ((Tag)tagHandler).setParent((Tag)new TagAdapter((SimpleTag)tagParent));
            } else {
                ((Tag)tagHandler).setParent((Tag)tagParent);
            }
            ((Tag)tagHandler).setPageContext(pCtx);
        } else if (tagHandler instanceof SimpleTag) {
            ((SimpleTag)tagHandler).setParent(tagParent);
            ((SimpleTag)tagHandler).setJspContext((JspContext)pCtx);
        } else {
            ((SharedTag)tagHandler).setParent(tagParent);
        }
    }

    protected void invokeSetters(JspTag tagHandler) throws JspException {
        try {
            Iterator keys = this.attributes.keySet().iterator();
            Object[] params = new Object[1];
            while (keys.hasNext()) {
                String name = (String)keys.next();
                params[0] = this.attributes.get(name);
                Method method = (Method)this.methods.get(name);
                method.invoke((Object)tagHandler, params);
            }
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
    }

    protected String getMethodName(String name) {
        String firstChar = name.substring(0, 1);
        String rest = name.substring(1);
        return "set" + firstChar.toUpperCase() + rest;
    }
}

