/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.provider;

import java.io.File;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import oracle.jsp.provider.JspFilesystemResource;
import oracle.jsp.util.JspVersion;

public class JspFSServletContextResource
extends JspFilesystemResource {
    private static final String MESSAGE_FILE = "oracle.jsp.provider.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.provider.LocalStrings");
    protected ServletContext servletContext;
    private int servletVersion = 0;
    private boolean needsInit = true;
    private boolean repositoryProvided;

    public void init(String repositoryRoot, String contextRoot, String appRoot, ServletContext sc, HttpServletRequest req, Hashtable initParams) throws IllegalStateException {
        if (!this.needsInit) {
            return;
        }
        this.needsInit = false;
        this.servletContext = sc;
        this.appPath = this.normalizeRoot(appRoot, "/");
        if (contextRoot != null) {
            this.contextRoot = this.normalizeRoot(contextRoot, "/");
        }
        this.virtualRoot = this.concatPaths(this.contextRoot, this.appPath, "/");
        this.vLen = this.virtualRoot.length();
        this.repositoryRoot = repositoryRoot;
        if (this.repositoryRoot == null) {
            this.servletVersion = JspVersion.getServletVersion(sc);
            this.repositoryRoot = this.getRepositoryRoot(sc, req, this.servletVersion);
            this.repositoryProvided = false;
        } else {
            this.repositoryProvided = true;
        }
        this.physicalRoot = this.concatPaths(this.repositoryRoot, this.appPath.replace('/', File.separatorChar), File.separator);
        this.ensurePath("/");
    }

    public String translateToAbsolutePath(String rPath) {
        String absPath = null;
        if (this.servletVersion > 1 && !this.repositoryProvided) {
            absPath = this.getServletContextRealPath(this.translateToContextPath(rPath));
        }
        if (absPath == null) {
            return super.translateToAbsolutePath(rPath);
        }
        absPath = absPath.replace('/', File.separatorChar);
        return absPath;
    }

    protected String getServletContextRealPath(String relativePath) {
        return this.servletContext.getRealPath(relativePath);
    }

    private String getRepositoryRoot(ServletContext sc, HttpServletRequest req, int version) throws IllegalStateException {
        Object docRoot = null;
        String absPath = "/";
        if ((absPath = this.getServletContextRealPath(absPath)) == null && (absPath = req.getRealPath("/")) == null) {
            throw new IllegalStateException(msgs.getString("no_real_path"));
        }
        return absPath.replace('/', File.separatorChar);
    }
}

