/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse.tldcache;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import oracle.jsp.logger.JspMessages;
import oracle.jsp.parse.Jsp2JavaParms;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.OracleTagLibraryInfo;
import oracle.jsp.parse.TranslatorPluginSupport;
import oracle.jsp.parse.XMLUtil;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class TldUtil
extends XMLUtil {
    public static final String FIELD_SEPARATOR = "^";
    public static final String MSG_FILE = "oracle.jsp.parse.tldcache.LocalStrings";
    public static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.parse.tldcache.LocalStrings");

    public static String format(String lookup, String s1) {
        return MessageFormat.format(msgs.getString(lookup), s1);
    }

    public static String format(String lookup, String s1, String s2) {
        return MessageFormat.format(msgs.getString(lookup), s1, s2);
    }

    public static String format(String lookup, String s1, String s2, String s3) {
        return MessageFormat.format(msgs.getString(lookup), s1, s2, s3);
    }

    public static String getDetailedXPEMsg(XMLParseException xpe, int max) {
        int numMsg = xpe.getNumMessages();
        if (numMsg > max) {
            numMsg = max;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < numMsg; ++i) {
            sb.append(msgs.getString("line_num"));
            sb.append(xpe.getLineNumber(i));
            sb.append(" ");
            sb.append(msgs.getString("col_num"));
            sb.append(xpe.getColumnNumber(i));
            sb.append(" : ");
            sb.append(xpe.getMessage(i));
            sb.append("\n");
        }
        return sb.toString();
    }

    protected JspParseState initJspParseState(String realPath, ClassLoader loader) {
        Jsp2JavaParms parms = XMLUtil.initializeJspDummyParams(realPath, loader, null);
        if (parms == null) {
            JspMessages.warningErrorGettingJSPParams();
            return null;
        }
        return new JspParseState(null, parms, new TranslatorPluginSupport());
    }

    protected static String generateParsedFormName(URL url, String cacheDir, JspParseState st) {
        String tldPathAndName = null;
        String bmi = "!/META-INF";
        String wid = "WEB-INF/";
        String temp = url.toString();
        if (!(!temp.startsWith("jar:file:") || temp.indexOf(".jar") == -1 && temp.indexOf(".JAR") == -1 || temp.indexOf(".tld") == -1 && temp.indexOf(".TLD") == -1 && temp.indexOf(".otld") == -1)) {
            tldPathAndName = temp.substring(temp.indexOf(bmi) + bmi.length(), temp.length());
            String jarPathAndName = temp.substring(temp.indexOf("jar:file:"), temp.indexOf(bmi) - ".jar".length());
            String jarName = jarPathAndName.substring(jarPathAndName.lastIndexOf("/") + 1, jarPathAndName.length());
            int endIndex = 0;
            endIndex = tldPathAndName.indexOf(".tld") != -1 ? tldPathAndName.indexOf(".tld") : (tldPathAndName.indexOf(".otld") != -1 ? tldPathAndName.length() : tldPathAndName.indexOf(".TLD"));
            String temp1 = cacheDir + jarName + "_jar" + tldPathAndName.substring(0, endIndex);
            return temp1.replace('/', File.separatorChar);
        }
        if (temp.startsWith("file:") && (temp.indexOf(".tld") != -1 || temp.indexOf(".TLD") != -1 || temp.indexOf(".otld") != -1)) {
            if (temp.indexOf(wid) != -1) {
                tldPathAndName = temp.substring(temp.lastIndexOf(wid) + wid.length(), temp.length());
            } else {
                String repRoot = st.parms.resourceProvider.getRepositoryRoot();
                tldPathAndName = temp.substring(temp.lastIndexOf(repRoot) + repRoot.length(), temp.length());
            }
            int endIndex = 0;
            endIndex = tldPathAndName.indexOf(".tld") != -1 ? tldPathAndName.indexOf(".tld") : (tldPathAndName.indexOf(".otld") != -1 ? tldPathAndName.length() : tldPathAndName.indexOf(".TLD"));
            String temp1 = cacheDir + tldPathAndName.substring(0, endIndex);
            return temp1.replace('/', File.separatorChar);
        }
        return null;
    }

    protected static Object[] getTldDocument(byte[] buf, JspParseState st) throws XMLParseException {
        try {
            return TldUtil.getTLDDoc(st, buf);
        }
        catch (XMLParseException x) {
            throw x;
        }
        catch (Exception e) {
            TldUtil.logException(e);
            return null;
        }
    }

    protected static OracleTagLibraryInfo domDocToTagLib(Document doc, JspParseState st, String jarName) {
        try {
            return TldUtil.domDocToTagLib(null, null, doc, TldUtil.getTlibVersionFromDom(doc), st, jarName);
        }
        catch (Exception e) {
            TldUtil.logException(e);
            return null;
        }
    }

    protected static Integer getTlibVersionFromDom(Document doc) {
        Integer tldVersion = JSP_11_TLD;
        Element root = doc.getDocumentElement();
        String vsn = root.getAttribute("version");
        if (vsn != null && vsn.equals("2.0")) {
            tldVersion = JSP_20_TLD;
        } else {
            DocumentType dtd = doc.getDoctype();
            if (dtd != null) {
                String systemId;
                String publicId = dtd.getPublicId();
                if (TldUtil.isDoctype(publicId, "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN", systemId = dtd.getSystemId(), "web-jsptaglibrary_1_1.dtd")) {
                    tldVersion = JSP_11_TLD;
                } else if (TldUtil.isDoctype(publicId, "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN", systemId, "web-jsptaglibrary_1_2.dtd")) {
                    tldVersion = JSP_12_TLD;
                }
            }
        }
        return tldVersion;
    }

    protected static OracleTagLibraryInfo getTlibInfo(Document doc, Integer tldVersion, JspParseState st, String jarName) {
        Integer tv = TldUtil.getTlibVersionFromDom(doc);
        try {
            OracleTagLibraryInfo tlib = TldUtil.domDocToTagLib(null, null, doc, tldVersion, st, jarName);
            return tlib;
        }
        catch (Exception e) {
            TldUtil.logException(e);
            return null;
        }
    }

    protected static byte[] InputStreamToByteBuf(InputStream is) {
        try {
            ByteArrayOutputStream bufOut = new ByteArrayOutputStream(10240);
            TldUtil.copyFromInToOut(is, bufOut, 10240);
            return bufOut.toByteArray();
        }
        catch (Exception e) {
            TldUtil.logException(e);
            return null;
        }
    }

    protected static void logException(Exception e) {
        JspMessages.logTldCacheException(e);
    }

    protected static void logException(String additionalInfo, Exception e) {
        JspMessages.logTldCacheException(additionalInfo, e);
    }

    protected static void logException(String msg) {
        JspMessages.logException(msg);
    }
}

