/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse.tldcache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import oracle.jsp.logger.JspMessages;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.OracleTagLibraryInfo;
import oracle.jsp.parse.tldcache.TldUtil;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Document;

public class CachedTldImpl {
    protected URL url;
    protected String timestamp;
    protected String uriElement;
    protected ArrayList listeners = new ArrayList();
    protected OracleTagLibraryInfo tlibInfo;
    protected Document doc;
    protected String sourceType;
    protected String cacheDirectory;
    protected boolean uriRequired = false;

    public CachedTldImpl(URL url, long timestamp, JspParseState st, String cacheDirectory, boolean uriRequired) throws XMLParseException {
        this.url = url;
        this.sourceType = url.getProtocol();
        this.timestamp = new Long(timestamp).toString();
        this.cacheDirectory = cacheDirectory;
        this.uriRequired = uriRequired;
        this.getTldInfo(st);
    }

    public CachedTldImpl(StringTokenizer strTok, boolean loadDom, String cacheDirectory, JspParseState st, Hashtable uriTable) throws MalformedURLException, IOException {
        if (strTok.hasMoreElements()) {
            this.url = new URL((String)strTok.nextElement());
            this.sourceType = this.url.getProtocol();
        }
        if (strTok.hasMoreElements()) {
            this.timestamp = (String)strTok.nextElement();
        }
        if (strTok.hasMoreElements()) {
            this.uriElement = (String)strTok.nextElement();
            uriTable.put(this.uriElement, this.url);
        }
        while (strTok.hasMoreElements()) {
            this.listeners.add((String)strTok.nextElement());
        }
        if (loadDom) {
            this.readPersistedParsedForm(this.url, cacheDirectory, st);
        }
    }

    protected void getTldInfo(JspParseState st) throws XMLParseException {
        this.uriElement = this.findUriAttribute(st);
        if ((this.uriElement == null || this.uriElement.length() == 0) && this.uriRequired) {
            JspMessages.warningInvalidTldOrMissingURI(this.url.toString());
        }
    }

    protected void format(PrintWriter pw) {
        String temp = this.url.toString() + "^" + this.timestamp + "^" + this.uriElement + "^";
        for (int i = 0; i < this.listeners.size(); ++i) {
            temp = temp + this.listeners.get(i) + "^";
        }
        pw.println(temp);
    }

    protected InputStream getTldAsXmlInputStream(URLConnection connection) throws IOException {
        return connection.getInputStream();
    }

    protected String findUriAttribute(JspParseState st) throws XMLParseException {
        InputStream is = null;
        byte[] buf = null;
        JarFile jarFile = null;
        String jarName = null;
        try {
            if (this.sourceType.equals("jar")) {
                jarName = this.url.toString().substring(9, this.url.toString().lastIndexOf("!"));
                String entryName = this.url.toString().substring(this.url.toString().lastIndexOf("!") + 2, this.url.toString().length());
                jarFile = new JarFile(jarName);
                ZipEntry zipEntry = jarFile.getEntry(entryName);
                is = jarFile.getInputStream(zipEntry);
                buf = TldUtil.InputStreamToByteBuf(is);
                String appJarName = null;
                if (jarName.indexOf("/WEB-INF/lib") != -1) {
                    jarName = appJarName = jarName.substring(jarName.indexOf("/WEB-INF/lib"), jarName.length());
                }
            } else {
                URLConnection uc = this.url.openConnection();
                String fname = uc.getURL().getFile();
                File f = new File(fname);
                is = this.getTldAsXmlInputStream(this.url.openConnection());
                buf = TldUtil.InputStreamToByteBuf(is);
            }
            Object[] docInfo = TldUtil.getTldDocument(buf, st);
            this.doc = (Document)docInfo[0];
            Integer tldVersion = (Integer)docInfo[1];
            this.tlibInfo = TldUtil.getTlibInfo(this.doc, (Integer)docInfo[1], st, jarName);
            if (this.tlibInfo != null) {
                this.uriElement = this.tlibInfo.getReliableURN();
                if (!this.tlibInfo.getListenerList().isEmpty()) {
                    for (int i = 0; i < this.tlibInfo.getListenerList().size(); ++i) {
                        this.listeners.add(this.tlibInfo.getListenerList().get(i));
                    }
                }
            } else {
                JspMessages.warningTldParseError(this.url.toString());
            }
            if (this.sourceType.equals("jar")) {
                jarFile.close();
            }
            is.close();
            return this.uriElement;
        }
        catch (XMLParseException x) {
            throw x;
        }
        catch (Exception e) {
            TldUtil.logException(this.url.toString() + ": ", e);
            return null;
        }
    }

    protected void persistParsedForm(String parsedName) {
        try {
            File dir = new File(parsedName.substring(0, parsedName.lastIndexOf(File.separator)));
            dir.mkdirs();
            FileOutputStream fos = new FileOutputStream(parsedName);
            ObjectOutputStream out = new ObjectOutputStream(fos);
            ((XMLDocument)this.doc).writeExternal((ObjectOutput)out);
            fos.close();
        }
        catch (Exception e) {
            TldUtil.logException(this.url.toString() + ": ", e);
        }
    }

    protected void readPersistedParsedForm(URL url, String cacheDirectory, JspParseState st) throws IOException {
        String name = TldUtil.generateParsedFormName(url, cacheDirectory, st);
        File f = new File(name);
        if (!f.exists()) {
            throw new IOException(TldUtil.msgs.getString("no_tld"));
        }
        FileInputStream fis = new FileInputStream(new File(name));
        ObjectInputStream in = new ObjectInputStream(fis);
        try {
            XMLDocument xdoc = new XMLDocument();
            xdoc.readExternal((ObjectInput)in);
            this.doc = xdoc;
        }
        catch (ClassNotFoundException e) {
            TldUtil.logException(" reading " + name + ": ", e);
        }
        String jarName = null;
        String temp = url.toString();
        if (temp.startsWith("jar:") && temp.indexOf("/WEB-INF/lib/") != -1 && temp.indexOf("!/META-INF/") != -1) {
            jarName = temp.substring(temp.indexOf("/WEB-INF/lib/"), temp.indexOf("!/META-INF/"));
        }
        this.tlibInfo = TldUtil.domDocToTagLib(this.doc, st, jarName);
        fis.close();
    }
}

