/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse.tldcache;

import com.evermind.server.http.JspServletInstanceInfo;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.jsp.logger.JspMessages;
import oracle.jsp.parse.tldcache.TldCacheImpl;
import oracle.jsp.parse.tldcache.TldResourceImpl;
import oracle.jsp.parse.tldcache.TldUtil;

public class ApplicationTldCacheImpl
extends TldCacheImpl {
    private static final String applicationTldCacheName = "_TldCache";

    public ApplicationTldCacheImpl(String realPath, ClassLoader loader, URL jspCacheDir, int verbosity, int searchLevel) throws IOException, InterruptedException, MalformedURLException {
        this.searchLevel = searchLevel;
        this.setLocation(jspCacheDir);
        this.initCache(realPath, loader, verbosity);
        if (!this.isCachePresent()) {
            JspMessages.fineBuildingTldCache("application");
            this.updateCache(!this.isCachePresent());
            this.persistCache();
        } else {
            JspMessages.fineRefreshingTldCache("application");
            if (this.refreshCache()) {
                this.persistCache();
            }
        }
        if (searchLevel < 0) {
            this.buildTagClassMap(this.st);
        }
    }

    protected void getCurrentResources() throws IOException {
        File searchStartDir;
        File[] unjarredResources;
        boolean knownInsert = !this.isCachePresent();
        this.currentResources.clear();
        File f = new File(this.st.parms.resourceProvider.getRepositoryRoot() + "/WEB-INF/lib/");
        File[] resources = f.listFiles();
        if (resources != null) {
            for (int i = 0; i < resources.length; ++i) {
                if (!resources[i].getName().endsWith(".jar") && !resources[i].getName().endsWith(".JAR")) continue;
                this.currentResources.add(new TldResourceImpl(knownInsert ? 1 : 0, resources[i].toURL(), resources[i].lastModified(), this.st));
            }
        }
        if ((unjarredResources = JspServletInstanceInfo.listUnjarredTldFiles((File)(searchStartDir = this.searchLevel == 0 ? new File(this.st.parms.resourceProvider.getRepositoryRoot() + "/") : new File(this.st.parms.resourceProvider.getRepositoryRoot() + "/WEB-INF/")), (int)this.searchLevel)) != null) {
            for (int i = 0; i < unjarredResources.length; ++i) {
                String resourceName = unjarredResources[i].getName();
                if (!resourceName.endsWith(".tld") && !resourceName.endsWith(".otld") && !resourceName.endsWith(".TLD")) continue;
                this.currentResources.add(new TldResourceImpl(knownInsert ? 1 : 0, unjarredResources[i].toURL(), unjarredResources[i].lastModified(), this.st));
            }
        }
        JspMessages.fineGettingCurrentResourceDone();
    }

    private void setLocation(URL jspCacheDir) throws IOException {
        this.cacheName = applicationTldCacheName;
        this.cacheDirectory = jspCacheDir.getFile().endsWith(File.separator) ? jspCacheDir.getFile() : jspCacheDir.getFile() + File.separator;
        File f = new File(this.cacheDirectory);
        if (!f.exists() && !f.mkdirs()) {
            throw new IOException(TldUtil.format("err_creating_app_cache_dir", this.cacheDirectory));
        }
    }
}

