/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import com.evermind.xml.EntityResolverUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import javax.servlet.jsp.tagext.FunctionInfo;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import oracle.jsp.logger.JspMessages;
import oracle.jsp.parse.CachedConfigTable;
import oracle.jsp.parse.Jsp2JavaParms;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspUtils;
import oracle.jsp.parse.OracleTagInfo;
import oracle.jsp.parse.OracleTagLibValidatorInfo;
import oracle.jsp.parse.OracleTagLibraryInfo;
import oracle.jsp.parse.tldcache.TldCacheInitializedMarker;
import oracle.jsp.provider.JspResourceProvider;
import oracle.jsp.runtimev2.JspPageTable;
import oracle.jsp.runtimev2.TagFileCompiler;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class XMLUtil {
    public static final String WEB_APP_22_DOCTYPE_PUBLICID = "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN";
    public static final String WEB_APP_23_DOCTYPE_PUBLICID = "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN";
    public static final String JSP_11_DOCTYPE_PUBLICID = "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN";
    public static final String JSP_12_DOCTYPE_PUBLICID = "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN";
    public static final String JSP_20_SCHEMA_LOCATION = "web-jsptaglibrary_2_0.xsd";
    public static final Integer JSP_11_TLD = new Integer(11);
    public static final Integer JSP_12_TLD = new Integer(12);
    public static final Integer JSP_20_TLD = new Integer(20);
    public static final String WEBXML_LOC = "/WEB-INF/web.xml";
    public static final String JARTLD_LOC = "META-INF/taglib.tld";
    public static final String WEBLIB_LOC = "/WEB-INF/lib/";
    protected static final String TAGDIR_CACHE_PREFIX = "__tagdir:";
    private static final String MSG_FILE = "oracle.jsp.parse.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.parse.LocalStrings");
    private static List jspListenerList;
    private static Hashtable dtdTable;
    private static Hashtable schemaTable;

    private static InputStream getInternalResourceStream(String s) {
        return XMLUtil.class.getResourceAsStream(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized DTD getDTD(String name, String root) throws IOException, XMLParseException, SAXException {
        DTD dtd = (DTD)dtdTable.get(name);
        if (dtd != null) {
            return dtd;
        }
        DOMParser parser = new DOMParser();
        InputStream dtdStream = null;
        try {
            dtdStream = XMLUtil.getInternalResourceStream(name);
            parser.parseDTD(dtdStream, root);
            dtd = parser.getDoctype();
            dtdTable.put(name, dtd);
            DTD dTD = dtd;
            return dTD;
        }
        finally {
            if (dtdStream != null) {
                dtdStream.close();
            }
        }
    }

    public static InputStream getFromStream(JspParseState st, String resourceName) throws FileNotFoundException, IOException {
        InputStream docStream = null;
        JspResourceProvider resProvider = st.parms.resourceProvider;
        resourceName = JspUtils.handlePagePath(st.parms.pagePath, resourceName);
        docStream = resProvider.fromStream(resourceName);
        return docStream;
    }

    public static InputStream getFromStream(JspResourceProvider resProvider, String resourceName) throws FileNotFoundException, IOException {
        InputStream docStream = null;
        docStream = resProvider.fromStream(resourceName);
        return docStream;
    }

    public static long getLastModified(JspParseState st, String resourceName) throws IOException, FileNotFoundException {
        JspResourceProvider resProvider = st.parms.resourceProvider;
        resourceName = JspUtils.handlePagePath(st.parms.pagePath, resourceName);
        return resProvider.getLastModified(resourceName);
    }

    public static String[] listClassRepositories(JspParseState st) {
        JspResourceProvider resProvider = st.parms.resourceProvider;
        String[] list = resProvider.listClassRepositories(WEBLIB_LOC);
        if (list == null) {
            return new String[0];
        }
        String[] list2 = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            list2[i] = WEBLIB_LOC + list[i];
        }
        return list2;
    }

    public static boolean isJarFile(String s) {
        return s.endsWith(".jar") || s.endsWith(".JAR") || s.endsWith(".zip") || s.endsWith(".ZIP");
    }

    public static Document getDocumentNoValidation(InputStream is) throws IOException, SAXException, XMLParseException {
        return XMLUtil.getDocument(is, 0, null, null, false, false, false);
    }

    public static Document getDocumentValidation(InputStream is) throws IOException, SAXException, XMLParseException {
        int validationMode = XMLUtil.getValidationMode(is);
        return XMLUtil.getDocument(is, validationMode, null, null, false, false, false);
    }

    protected static Document getDocument(InputStream is, int validationMode, DTD dtd, Object schema, boolean debugMode, boolean preserveWhitespace, boolean retainCDATA) throws IOException, SAXException, XMLParseException {
        DOMParser parser = new DOMParser();
        parser.setDebugMode(debugMode);
        parser.setPreserveWhitespace(preserveWhitespace);
        parser.retainCDATASection(retainCDATA);
        if (EntityResolverUtil.getConfiguredEntityResolver() == null) {
            EntityResolverUtil.initDefault();
        }
        parser.setEntityResolver((EntityResolver)EntityResolverUtil.getConfiguredEntityResolver());
        parser.setValidationMode(validationMode);
        parser.showWarnings(true);
        parser.parse(is);
        XMLDocument doc = parser.getDocument();
        return doc;
    }

    private static String getSystemId(Document doc) {
        if (doc != null) {
            if (doc.getDoctype() != null) {
                return doc.getDoctype().getSystemId();
            }
            return null;
        }
        return null;
    }

    public static String getPublicId(Document doc) {
        if (doc != null) {
            if (doc.getDoctype() != null) {
                String publicId = doc.getDoctype().getPublicId();
                if (publicId != null) {
                    publicId = publicId.trim();
                }
                return publicId;
            }
            return null;
        }
        return null;
    }

    public static boolean isDoctype(String public_id, String public_value, String system_id, String system_value) {
        if (public_id == null && system_id == null) {
            return false;
        }
        if (public_id != null && public_id.equals(public_value)) {
            return true;
        }
        return system_id != null && system_id.endsWith(system_value);
    }

    public static Document getWebAppDoc(JspParseState st) throws FileNotFoundException, IOException, SAXException, XMLParseException {
        return XMLUtil.getWebAppDoc(st, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getWebAppDoc(JspParseState st, boolean debugMode) throws FileNotFoundException, IOException, SAXException, XMLParseException {
        XMLDocument xMLDocument;
        InputStream tmpDocStream;
        block7: {
            InputStream docStream = null;
            tmpDocStream = null;
            try {
                XMLDocument doc;
                docStream = XMLUtil.getFromStream(st, WEBXML_LOC);
                DOMParser parser = new DOMParser();
                parser.setDebugMode(debugMode);
                parser.showWarnings(true);
                if (!st.parms.validate) {
                    parser.setValidationMode(0);
                } else {
                    tmpDocStream = XMLUtil.getFromStream(st, WEBXML_LOC);
                    parser.setValidationMode(XMLUtil.getValidationMode(tmpDocStream));
                    tmpDocStream.close();
                }
                if (EntityResolverUtil.getConfiguredEntityResolver() == null) {
                    EntityResolverUtil.initDefault();
                }
                parser.setEntityResolver((EntityResolver)EntityResolverUtil.getConfiguredEntityResolver());
                parser.parse(docStream);
                xMLDocument = doc = parser.getDocument();
                Object var8_7 = null;
                if (docStream == null) break block7;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var8_8 = null;
                    if (docStream != null) {
                        docStream.close();
                    }
                    if (tmpDocStream == null) break block8;
                    tmpDocStream.close();
                }
                throw throwable;
            }
            docStream.close();
        }
        if (tmpDocStream != null) {
            tmpDocStream.close();
        }
        return xMLDocument;
    }

    public static Hashtable domDocToTaglibTable(JspParseState st, Document doc, boolean webXmlIsPre24) throws JspParseException {
        int i;
        int len;
        Vector<Node> taglibs = new Vector<Node>();
        if (webXmlIsPre24) {
            NodeList taglibList = doc.getElementsByTagName("taglib");
            len = taglibList.getLength();
            for (i = 0; i < len; ++i) {
                Node node = taglibList.item(i);
                taglibs.addElement(node);
            }
        } else {
            NodeList jspConfigList = doc.getElementsByTagName("jsp-config");
            if (jspConfigList != null && jspConfigList.getLength() > 0) {
                Node jspConfig = jspConfigList.item(0);
                NodeList childNodes = jspConfig.getChildNodes();
                int len2 = childNodes.getLength();
                for (int i2 = 0; i2 < len2; ++i2) {
                    Node node = childNodes.item(i2);
                    if (!node.getNodeName().equals("taglib")) continue;
                    taglibs.addElement(node);
                }
            }
        }
        Hashtable<String, String> result = new Hashtable<String, String>();
        len = taglibs.size();
        for (i = 0; i < len; ++i) {
            Element taglibElem = (Element)taglibs.elementAt(i);
            NodeList taglibChildNodes = taglibElem.getChildNodes();
            int clen = taglibChildNodes.getLength();
            String taglib_uri = null;
            String taglib_loc = null;
            for (int j = 0; j < clen; ++j) {
                Node cn = taglibChildNodes.item(j);
                if (!(cn instanceof Element)) continue;
                if (((Element)cn).getTagName().equals("taglib-uri")) {
                    taglib_uri = XMLUtil.getSimpleElemValue((Element)taglibChildNodes.item(j));
                }
                if (!((Element)cn).getTagName().equals("taglib-location")) continue;
                taglib_loc = XMLUtil.getSimpleElemValue((Element)taglibChildNodes.item(j));
            }
            if (taglib_uri == null || taglib_loc == null) continue;
            taglib_uri = taglib_uri.trim();
            if (!(taglib_loc = taglib_loc.trim()).startsWith("/") && !taglib_loc.startsWith("http://")) {
                taglib_loc = "/WEB-INF/" + taglib_loc;
            }
            if (result.get(taglib_uri) != null && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("duplicate_taglib_uri"), taglib_uri)))) {
                return null;
            }
            result.put(taglib_uri, taglib_loc);
        }
        return result;
    }

    public static String getSimpleElemValue(Element e) {
        if (e.hasChildNodes()) {
            return e.getFirstChild().getNodeValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getTLDDocBuf(JspParseState st, String tldLoc) throws FileNotFoundException, IOException, ZipException {
        byte[] byArray;
        ZipInputStream zipStream;
        InputStream jarStream;
        block11: {
            InputStream docStream = null;
            jarStream = null;
            zipStream = null;
            try {
                if (tldLoc.endsWith(".jar") || tldLoc.endsWith(".JAR")) {
                    jarStream = XMLUtil.getFromStream(st, tldLoc);
                    zipStream = new ZipInputStream(jarStream);
                    ZipEntry entry = null;
                    do {
                        if ((entry = zipStream.getNextEntry()) == null) continue;
                        if (entry.getName().equals(JARTLD_LOC)) {
                            docStream = zipStream;
                            continue;
                        }
                        zipStream.closeEntry();
                    } while (entry != null && docStream == null);
                    if (docStream == null) {
                        throw new FileNotFoundException(msgs.getString("jar_tld_not_found"));
                    }
                } else {
                    docStream = XMLUtil.getFromStream(st, tldLoc);
                }
                int result = -1;
                ByteArrayOutputStream bufOut = new ByteArrayOutputStream(10240);
                XMLUtil.copyFromInToOut(docStream, bufOut, 10240);
                byArray = bufOut.toByteArray();
                Object var9_9 = null;
                if (docStream == null) break block11;
            }
            catch (Throwable throwable) {
                block12: {
                    Object var9_10 = null;
                    if (docStream != null) {
                        docStream.close();
                    }
                    if (zipStream != null) {
                        zipStream.close();
                    }
                    if (jarStream == null) break block12;
                    jarStream.close();
                }
                throw throwable;
            }
            docStream.close();
        }
        if (zipStream != null) {
            zipStream.close();
        }
        if (jarStream != null) {
            jarStream.close();
        }
        return byArray;
    }

    protected static void copyFromInToOut(InputStream in, OutputStream out, int bufSize) throws IOException {
        int len;
        byte[] tmpbuf = new byte[bufSize];
        while (in.available() > 0 && (len = in.read(tmpbuf, 0, bufSize)) > 0) {
            out.write(tmpbuf, 0, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector getMultiTLDDocBufFromOneJar(JspParseState st, String jarLoc, boolean direct, Vector tldNames) throws FileNotFoundException, IOException, ZipException {
        Vector<byte[]> vector;
        ZipInputStream zipStream;
        InputStream jarStream;
        block8: {
            Vector<byte[]> v = new Vector<byte[]>();
            InputStream docStream = null;
            jarStream = null;
            zipStream = null;
            try {
                jarStream = !direct ? XMLUtil.getFromStream(st, jarLoc) : new FileInputStream(jarLoc);
                zipStream = new ZipInputStream(jarStream);
                ZipEntry entry = null;
                do {
                    if ((entry = zipStream.getNextEntry()) == null) continue;
                    String entryName = entry.getName();
                    if (entryName.startsWith("META-INF/") && (entryName.endsWith(".tld") || entryName.endsWith(".TLD") || entryName.endsWith(".otld"))) {
                        docStream = zipStream;
                        int result = -1;
                        ByteArrayOutputStream bufOut = new ByteArrayOutputStream(10240);
                        XMLUtil.copyFromInToOut(docStream, bufOut, 10240);
                        v.addElement(bufOut.toByteArray());
                        tldNames.addElement(entry.getName());
                        continue;
                    }
                    zipStream.closeEntry();
                } while (entry != null);
                vector = v;
                Object var13_12 = null;
                if (docStream == null) break block8;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var13_13 = null;
                    if (docStream != null) {
                        docStream.close();
                    }
                    if (zipStream != null) {
                        zipStream.close();
                    }
                    if (jarStream == null) break block9;
                    jarStream.close();
                }
                throw throwable;
            }
            docStream.close();
        }
        if (zipStream != null) {
            zipStream.close();
        }
        if (jarStream != null) {
            jarStream.close();
        }
        return vector;
    }

    private static void scanWebLibJarsTLD(JspParseState st) throws FileNotFoundException, IOException, ZipException, XMLParseException, SAXException, IllegalAccessException, JspParseException, ClassNotFoundException, InstantiationException {
        String[] webJarFiles = XMLUtil.listClassRepositories(st);
        XMLUtil.scanJarListTLD(st, webJarFiles, false);
        String[] directJarFiles = XMLUtil.listDirectJarFiles(st.parms.getComputedWellKnownTLDJarDir());
        XMLUtil.scanJarListTLD(st, directJarFiles, true);
    }

    private static void scanWebFilesTLD(JspParseState st) throws JspParseException, IOException {
        String temp = null;
        ArrayList tldList = new ArrayList();
        JspResourceProvider resProvider = st.parms.resourceProvider;
        String resRoot = resProvider.getRepositoryRoot();
        XMLUtil.getWebINFTLDs(tldList, resRoot, resRoot + "WEB-INF");
        if (!tldList.isEmpty()) {
            for (int i = 0; i < tldList.size(); ++i) {
                OracleTagLibraryInfo tlib = null;
                try {
                    temp = ((String)tldList.get(i)).replace('\\', '/');
                    byte[] buf = XMLUtil.getTLDDocBuf(st, temp);
                    Object[] result = XMLUtil.getTLDDoc(st, buf);
                    Document doc = (Document)result[0];
                    Integer tldVersion = (Integer)result[1];
                    tlib = XMLUtil.domDocToTagLib(null, null, doc, tldVersion, st, null);
                }
                catch (Exception e) {
                    String error = MessageFormat.format(msgs.getString("tld_in_dir"), tldList.get(i));
                    tlib = new OracleTagLibraryInfo(null, null, null, null, null, null, null);
                    tlib.setErrMsg(new JspParseException(st, e.getMessage() + " " + error));
                }
                tlib.overridingLocation = temp;
                tlib.direct = false;
                if (st.parms.cachedConfigTable == null) continue;
                st.parms.cachedConfigTable.setConfigObject(temp, (Object)tlib, st);
                String reliableURN = tlib.getReliableURN();
                if (reliableURN == null) continue;
                if (temp.endsWith(".otld")) {
                    reliableURN = reliableURN + "_oracle";
                }
                st.parms.cachedConfigTable.setConfigObject(reliableURN, (Object)tlib, temp, false, st);
            }
        }
    }

    public static String[] listDirectJarFiles(String directLoc) {
        File f = new File(directLoc);
        if (!f.exists()) {
            return new String[0];
        }
        String[] l1 = f.list();
        if (l1 == null) {
            return new String[0];
        }
        String[] l2 = new String[l1.length];
        int numOfJar = 0;
        for (int i = 0; i < l1.length; ++i) {
            if (!XMLUtil.isJarFile(l1[i])) continue;
            l2[numOfJar++] = directLoc + File.separatorChar + l1[i];
        }
        String[] l3 = new String[numOfJar];
        for (int i = 0; i < numOfJar; ++i) {
            l3[i] = l2[i];
        }
        return l3;
    }

    private static void scanJarListTLD(JspParseState st, String[] files, boolean direct) throws FileNotFoundException, IOException, ZipException, XMLParseException, SAXException, IllegalAccessException, JspParseException, ClassNotFoundException, InstantiationException {
        for (int i = 0; i < files.length; ++i) {
            Vector tldNames = new Vector();
            Vector v = XMLUtil.getMultiTLDDocBufFromOneJar(st, files[i], direct, tldNames);
            for (int j = 0; j < v.size(); ++j) {
                String reliableURN;
                byte[] buf = (byte[])v.elementAt(j);
                OracleTagLibraryInfo tlib = null;
                try {
                    Object[] result = XMLUtil.getTLDDoc(st, buf);
                    Document doc = (Document)result[0];
                    Integer tldVersion = (Integer)result[1];
                    tlib = XMLUtil.domDocToTagLib(null, null, doc, tldVersion, st, files[i]);
                }
                catch (Exception e) {
                    String error = MessageFormat.format(msgs.getString("tld_in_jar"), tldNames.elementAt(j), files[i]);
                    tlib = new OracleTagLibraryInfo(null, null, null, null, null, null, null);
                    tlib.setErrMsg(new JspParseException(st, e.getMessage() + " " + error));
                }
                tlib.overridingLocation = files[i];
                tlib.direct = direct;
                if (st.parms.cachedConfigTable == null) continue;
                if (!direct) {
                    st.parms.cachedConfigTable.setConfigObject(files[i], (Object)tlib, st);
                }
                if ((reliableURN = tlib.getReliableURN()) == null) continue;
                if (((String)tldNames.elementAt(j)).endsWith(".otld")) {
                    reliableURN = reliableURN + "_oracle";
                }
                st.parms.cachedConfigTable.setConfigObject(reliableURN, (Object)tlib, files[i], direct, st);
            }
        }
    }

    protected static Object[] getTLDDoc(JspParseState st, byte[] buf) throws FileNotFoundException, IOException, SAXException, XMLParseException, ZipException {
        return XMLUtil.getTLDDoc(st, buf, false);
    }

    private static int getValidationMode(InputStream docStream) throws IOException, SAXException {
        Document doc = XMLUtil.getDocumentNoValidation(docStream);
        if (doc.getDoctype() == null) {
            return 3;
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] getTLDDoc(JspParseState st, byte[] buf, boolean debugMode) throws FileNotFoundException, IOException, SAXException, XMLParseException, ZipException {
        Object[] objectArray;
        InputStream tmpDocStream;
        block17: {
            ByteArrayInputStream docStream = null;
            tmpDocStream = null;
            try {
                docStream = new ByteArrayInputStream(buf);
                DOMParser parser = new DOMParser();
                parser.setDebugMode(debugMode);
                parser.showWarnings(true);
                if (!st.parms.tldXmlValidate) {
                    parser.setValidationMode(0);
                } else {
                    tmpDocStream = new ByteArrayInputStream(buf);
                    parser.setValidationMode(XMLUtil.getValidationMode(tmpDocStream));
                }
                if (EntityResolverUtil.getConfiguredEntityResolver() == null) {
                    EntityResolverUtil.initDefault();
                }
                try {
                    parser.setEntityResolver((EntityResolver)EntityResolverUtil.getConfiguredEntityResolver());
                    parser.parse((InputStream)docStream);
                }
                catch (Exception e) {
                    System.out.println("TLD parsing exception e: " + e);
                }
                XMLDocument doc = parser.getDocument();
                Integer tldVersion = JSP_11_TLD;
                String systemId = XMLUtil.getSystemId((Document)doc);
                String publicId = XMLUtil.getPublicId((Document)doc);
                if (systemId == null && publicId == null) {
                    Node n = doc.getDocumentElement().getAttributes().getNamedItem("version");
                    if (n != null) {
                        String xsdVersion = n.getNodeValue();
                        if (xsdVersion.trim().equals("2.0")) {
                            tldVersion = JSP_20_TLD;
                        } else {
                            JspMessages.warningInvalidTldVersion(xsdVersion);
                        }
                    }
                } else if (XMLUtil.isDoctype(publicId, JSP_11_DOCTYPE_PUBLICID, systemId, "web-jsptaglibrary_1_1.dtd")) {
                    tldVersion = JSP_11_TLD;
                } else if (XMLUtil.isDoctype(publicId, JSP_12_DOCTYPE_PUBLICID, systemId, "web-jsptaglibrary_1_2.dtd")) {
                    tldVersion = JSP_12_TLD;
                }
                objectArray = new Object[]{doc, tldVersion};
                Object var13_13 = null;
                if (docStream == null) break block17;
            }
            catch (Throwable throwable) {
                block18: {
                    Object var13_14 = null;
                    if (docStream != null) {
                        docStream.close();
                    }
                    if (tmpDocStream == null) break block18;
                    tmpDocStream.close();
                }
                throw throwable;
            }
            docStream.close();
        }
        if (tmpDocStream != null) {
            tmpDocStream.close();
        }
        return objectArray;
    }

    private static OracleTagLibraryInfo fixTagLibFromScannedJar(OracleTagLibraryInfo tlib, String prefix, String uri, JspParseState st) throws FileNotFoundException, IOException, IllegalAccessException, InstantiationException {
        if (tlib.overridingLocation != null) {
            if (!tlib.direct) {
                st.addIncludeDependency(tlib.overridingLocation, XMLUtil.getLastModified(st, tlib.overridingLocation));
            }
        } else {
            st.addIncludeDependency(uri, XMLUtil.getLastModified(st, uri));
        }
        return tlib;
    }

    public static OracleTagLibraryInfo getTagLib(String prefix, String uri, String loc, JspParseState st, String originalUri) throws JspParseException {
        OracleTagLibraryInfo tlib;
        block18: {
            tlib = null;
            if (st.parms.cachedConfigTable != null) {
                try {
                    if (st.parms.tldCache != null) {
                        if (!st.parms.cachedConfigTable.containsClass("oracle.jsp.parse.tldcache.TldCacheInitializedMarker")) {
                            JspMessages.fineLoadingCacheConfigTable();
                            st.parms.cachedConfigTable = (CachedConfigTable)st.parms.tldCache.loadAllTlds(st.parms.cachedConfigTable, st);
                            st.parms.cachedConfigTable.setConfigObject("TLDCACHEINITIALIZED", new TldCacheInitializedMarker(), "/WEB-INF", false, st);
                        }
                        if ((tlib = (OracleTagLibraryInfo)((Object)st.parms.cachedConfigTable.getConfigObject(loc, OracleTagLibraryInfo.class, st))) == null && !loc.startsWith("http://")) {
                            XMLUtil.checkValidTldLocation(st, loc);
                            tlib = XMLUtil.loadTagLibFromTLD(prefix, uri, loc, st, originalUri);
                        }
                        if (tlib == null && !JspUtils.allowNonTaglibNamespace(st, originalUri) && st.throwParseException(new JspParseException(st, "\"" + loc + "\" is not a registered TLD namespace."))) {
                            return null;
                        }
                        return tlib;
                    }
                    tlib = (OracleTagLibraryInfo)((Object)st.parms.cachedConfigTable.getConfigObject(loc, OracleTagLibraryInfo.class, st));
                    if (tlib == null) {
                        XMLUtil.scanWebFilesTLD(st);
                        tlib = (OracleTagLibraryInfo)((Object)st.parms.cachedConfigTable.getConfigObject(loc, OracleTagLibraryInfo.class, st));
                        if (tlib != null) {
                            return tlib;
                        }
                    } else {
                        return XMLUtil.fixTagLibFromScannedJar(tlib, prefix, uri, st);
                    }
                    XMLUtil.scanWebLibJarsTLD(st);
                    tlib = (OracleTagLibraryInfo)((Object)st.parms.cachedConfigTable.getConfigObject(loc, OracleTagLibraryInfo.class, st));
                    if (tlib == null) {
                        if (loc.startsWith("http://") && !JspUtils.allowNonTaglibNamespace(st, originalUri)) {
                            if (loc.indexOf("_oracle") == -1) {
                                if (st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("invalid_tld_namespace"), loc)))) {
                                    return null;
                                }
                            } else {
                                return null;
                            }
                        }
                        XMLUtil.checkValidTldLocation(st, loc);
                        tlib = XMLUtil.loadTagLibFromTLD(prefix, uri, loc, st, originalUri);
                        return tlib;
                    }
                    return XMLUtil.fixTagLibFromScannedJar(tlib, prefix, uri, st);
                }
                catch (JspParseException jpe) {
                    if (st.throwParseException(jpe)) {
                        return null;
                    }
                    break block18;
                }
                catch (Exception e) {
                    if (st.throwParseException(new JspParseException(st, (Throwable)e))) {
                        return null;
                    }
                    break block18;
                }
            }
            tlib = XMLUtil.loadTagLibFromTLD(prefix, uri, loc, st, originalUri);
        }
        return tlib;
    }

    private static void checkValidTldLocation(JspParseState st, String loc) throws JspParseException {
        String temp = loc.replace('\\', '/');
        if (temp.endsWith(".tld") && (temp.indexOf("/WEB-INF/classes") != -1 || temp.indexOf("/WEB-INF/lib") != -1) && (st.parms.tldCache == null || st.parms.tldCache != null && (st.parms.tldCache.getSearchLevel() == 1 || st.parms.tldCache.getSearchLevel() == -1)) && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("tld_in_webinf_lib_or_classes"), loc)))) {
            return;
        }
    }

    protected static OracleTagLibraryInfo buildImplicitTagFileTLDs(String prefix, String loc, JspParseState st) throws JspParseException {
        block8: {
            try {
                Object o;
                File f = new File(st.parms.resourceProvider.translateToAbsolutePath(loc));
                if (!(f.exists() && f.isDirectory() || !st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("nonexistent_tagdir"), loc))))) {
                    return null;
                }
                ArrayList<String> tagfiles = new ArrayList<String>();
                if (st.parms.cachedConfigTable != null && (o = st.parms.cachedConfigTable.getConfigObject(TAGDIR_CACHE_PREFIX + loc, OracleTagLibraryInfo.class, st)) != null) {
                    return (OracleTagLibraryInfo)((Object)o);
                }
                File[] files = f.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].getName().endsWith(".tag") && !files[i].getName().endsWith(".tagx")) continue;
                    tagfiles.add(files[i].getName());
                }
                OracleTagLibraryInfo tlib = XMLUtil.tagListToTagLib(prefix, loc, tagfiles, st);
                if (st.parms.cachedConfigTable != null) {
                    st.parms.cachedConfigTable.setConfigObject(TAGDIR_CACHE_PREFIX + loc, (Object)tlib, st);
                }
                return tlib;
            }
            catch (IOException io) {
                File f = new File(st.parms.resourceProvider.translateToAbsolutePath(loc));
                if (!f.exists() ? st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("invalid_tagfile_loc"), loc))) : st.throwParseException(new JspParseException(st, (Throwable)io))) {
                    return null;
                }
            }
            catch (Exception e) {
                if (!st.throwParseException(new JspParseException(st, (Throwable)e))) break block8;
                return null;
            }
        }
        return null;
    }

    private static OracleTagLibraryInfo loadTagLibFromTLD(String prefix, String uri, String loc, JspParseState st, String originalUri) throws JspParseException {
        block9: {
            OracleTagLibraryInfo tlib = null;
            String temp = loc.replace('\\', '/');
            try {
                byte[] buf = XMLUtil.getTLDDocBuf(st, temp);
                Object[] result = XMLUtil.getTLDDoc(st, buf);
                Document doc = (Document)result[0];
                Integer tldVersion = (Integer)result[1];
                tlib = XMLUtil.domDocToTagLib(prefix, uri, doc, tldVersion, st, loc.endsWith(".jar") ? loc : null);
                if (!loc.equals(uri)) {
                    tlib.overridingLocation = temp;
                }
                if (st.parms.cachedConfigTable != null) {
                    st.parms.cachedConfigTable.setConfigObject(temp, (Object)tlib, st);
                    if (tlib.getReliableURN() != null) {
                        st.parms.cachedConfigTable.setConfigObject(tlib.getReliableURN(), (Object)tlib, temp, false, st);
                    }
                }
                st.addIncludeDependency(loc, XMLUtil.getLastModified(st, loc));
                return tlib;
            }
            catch (JspParseException jpe) {
                if (st.throwParseException(jpe)) {
                    return null;
                }
            }
            catch (Exception e) {
                if (JspUtils.allowNonTaglibNamespace(st, originalUri)) {
                    return null;
                }
                if (loc.endsWith(".otld") || loc.endsWith("_oracle")) {
                    return null;
                }
                if (!st.throwParseException(new JspParseException(st, (Throwable)e))) break block9;
                return null;
            }
        }
        return null;
    }

    protected static OracleTagLibraryInfo tagListToTagLib(String prefix, String loc, ArrayList al, JspParseState st) throws JspParseException {
        String tlibVersion = "1.0";
        String info = null;
        if (!loc.endsWith("/")) {
            loc = loc + "/";
        }
        String urn = loc;
        String shortName = null;
        OracleTagLibraryInfo tlib = null;
        if (loc.length() == "/WEB-INF/tags/".length()) {
            shortName = "tags";
        } else {
            shortName = loc.substring("/WEB-INF/tags".length(), loc.length());
            shortName = shortName.replace('/', '-');
        }
        tlib = new OracleTagLibraryInfo(prefix, loc, tlibVersion, "2.0", shortName, urn, info);
        TagFileInfo[] tagFiles = new TagFileInfo[al.size()];
        for (int i = 0; i < al.size(); ++i) {
            String temp = (String)al.get(i);
            String name = temp.substring(0, temp.lastIndexOf("."));
            String path = loc + temp;
            Object taginfo = null;
            tagFiles[i] = new TagFileInfo(name, path, null);
        }
        tlib.setTagFiles(tagFiles);
        return tlib;
    }

    protected static TagInfo parseTagFile(JspParseState st, String path, String tagName, TagLibraryInfo tlib, String jarName) throws JspParseException {
        OracleTagInfo info;
        block4: {
            info = null;
            try {
                JspPageTable tagFilePageTable = st.parms.tagFilePageTable;
                if (tagFilePageTable != null) {
                    info = tagFilePageTable.serviceTagFile(tagName, path, tlib, st, jarName, XMLUtil.isXMLTagFile(path, st));
                    break block4;
                }
                TagFileCompiler tagFileCompiler = st.parms.tagFileCompiler;
                if (tagFileCompiler != null) {
                    tagFileCompiler.compileTagFile(tagName, path, tlib, st, jarName, XMLUtil.isXMLTagFile(path, st));
                    info = tagFileCompiler.getTagInfoValue();
                    break block4;
                }
                throw new Exception(msgs.getString("null_tagfilecompiler"));
            }
            catch (Throwable e) {
                info = new OracleTagInfo(tagName, tlib, true, new JspParseException(st, e));
            }
        }
        return info;
    }

    protected static OracleTagLibraryInfo domDocToTagLib(String prefix, String uri, Document doc, Integer tldVersion, JspParseState st, String jarName) throws ClassNotFoundException, IllegalAccessException, InstantiationException, JspParseException {
        Element taglibElem = doc.getDocumentElement();
        NodeList nl = taglibElem.getChildNodes();
        int len = nl.getLength();
        OracleTagLibraryInfo tlib = null;
        Hashtable<String, String> simpleValues = new Hashtable<String, String>();
        Hashtable<String, TagInfo> tagsTable = new Hashtable<String, TagInfo>();
        Hashtable<String, FunctionInfo> functionsTable = new Hashtable<String, FunctionInfo>();
        Hashtable<String, TagFileInfo> tagfilesTable = new Hashtable<String, TagFileInfo>();
        ArrayList<String> listenerList = new ArrayList<String>();
        OracleTagLibValidatorInfo validatorInfo = null;
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            String nodeName = e.getNodeName();
            String nodeValue = XMLUtil.getSimpleElemValue(e);
            if (nodeName.equals("tag") || nodeName.equals("function") || nodeName.equals("tag-file") || nodeName.equals("validator") || nodeName.equals("listener")) {
                String error;
                if (tlib == null) {
                    tlib = tldVersion.equals(JSP_11_TLD) ? new OracleTagLibraryInfo(prefix, uri, (String)simpleValues.get("tlibversion"), (String)simpleValues.get("jspversion"), (String)simpleValues.get("shortname"), (String)simpleValues.get("uri"), (String)simpleValues.get("info")) : new OracleTagLibraryInfo(prefix, uri, (String)simpleValues.get("tlib-version"), (String)simpleValues.get("jsp-version"), (String)simpleValues.get("short-name"), (String)simpleValues.get("uri"), (String)simpleValues.get("description"));
                }
                if (nodeName.equals("tag")) {
                    TagInfo tag = XMLUtil.elemToTagInfo(tlib, e, st, tldVersion);
                    if (tagsTable.get(tag.getTagName()) != null) {
                        error = MessageFormat.format(msgs.getString("duplicate_tags"), tag.getTagName());
                        if (!st.throwParseException(new JspParseException(st, error))) continue;
                        return null;
                    }
                    tagsTable.put(tag.getTagName(), tag);
                    continue;
                }
                if (nodeName.equals("function")) {
                    FunctionInfo func = XMLUtil.elemToFunctionInfo(tlib, e, st, tldVersion);
                    if (functionsTable.get(func.getName()) != null && st.throwParseException(new JspParseException(st, error = MessageFormat.format(msgs.getString("duplicate_functions"), func.getName())))) {
                        return null;
                    }
                    functionsTable.put(func.getName(), func);
                    continue;
                }
                if (nodeName.equals("tag-file")) {
                    TagFileInfo tagfile = XMLUtil.elemToTagFileInfo(tlib, e, st, tldVersion, jarName);
                    if (tagfile == null) continue;
                    if (tagfilesTable.get(tagfile.getName()) != null || tagsTable.get(tagfile.getName()) != null) {
                        error = MessageFormat.format(msgs.getString("duplicate_tagfile_defs"), tagfile.getName());
                        JspMessages.warningDuplicateTagNameInTld(tagfile.getName(), new JspParseException(st, error));
                        if (st.throwParseException(new JspParseException(st, error))) {
                            return null;
                        }
                    }
                    tagfilesTable.put(tagfile.getName(), tagfile);
                    continue;
                }
                if (nodeName.equals("listener")) {
                    listenerList.add(XMLUtil.elemToListenerClass(e));
                    continue;
                }
                if (!nodeName.equals("validator")) continue;
                validatorInfo = XMLUtil.elemToValidator(e);
                continue;
            }
            if (nodeValue == null) continue;
            simpleValues.put(nodeName, nodeValue.trim());
        }
        TagInfo[] tags = new TagInfo[tagsTable.size()];
        Enumeration enumerator = tagsTable.elements();
        int i = 0;
        while (enumerator.hasMoreElements()) {
            tags[i++] = (TagInfo)enumerator.nextElement();
        }
        tlib.setTags(tags);
        FunctionInfo[] functions = new FunctionInfo[functionsTable.size()];
        enumerator = functionsTable.elements();
        i = 0;
        while (enumerator.hasMoreElements()) {
            functions[i++] = (FunctionInfo)enumerator.nextElement();
        }
        tlib.setFunctions(functions);
        TagFileInfo[] tagfiles = new TagFileInfo[tagfilesTable.size()];
        enumerator = tagfilesTable.elements();
        i = 0;
        while (enumerator.hasMoreElements()) {
            tagfiles[i++] = (TagFileInfo)enumerator.nextElement();
        }
        tlib.setTagFiles(tagfiles);
        tlib.listenerList = listenerList;
        tlib.validatorInfo = validatorInfo;
        tlib.displayName = (String)simpleValues.get("display-name");
        tlib.smallIcon = (String)simpleValues.get("small-icon");
        tlib.largeIcon = (String)simpleValues.get("large-icon");
        tlib.setJarName(jarName);
        return tlib;
    }

    private static String elemToListenerClass(Element listenerElement) {
        String nodeValue;
        NodeList nl = listenerElement.getElementsByTagName("listener-class");
        int len = nl.getLength();
        String listenerClassName = null;
        Node n = nl.item(0);
        Element e = (Element)n;
        listenerClassName = nodeValue = XMLUtil.getSimpleElemValue(e);
        return listenerClassName;
    }

    private static OracleTagLibValidatorInfo elemToValidator(Element validatorElem) {
        NodeList nl = validatorElem.getChildNodes();
        int len = nl.getLength();
        Hashtable<String, String> simpleValues = new Hashtable<String, String>();
        OracleTagLibValidatorInfo validatorInfo = new OracleTagLibValidatorInfo();
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            String nodeName = e.getNodeName();
            String nodeValue = XMLUtil.getSimpleElemValue(e);
            if (nodeName.equals("init-param")) {
                XMLUtil.elemAddToInitParams(e, validatorInfo.initParams);
                continue;
            }
            if (nodeValue == null) continue;
            simpleValues.put(nodeName, nodeValue.trim());
        }
        validatorInfo.validatorClassStr = (String)simpleValues.get("validator-class");
        validatorInfo.description = (String)simpleValues.get("description");
        return validatorInfo;
    }

    private static void elemAddToInitParams(Element paramElem, HashMap map) {
        NodeList nl = paramElem.getChildNodes();
        int len = nl.getLength();
        String paramName = null;
        String paramValue = null;
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            String nodeName = e.getNodeName();
            String nodeValue = XMLUtil.getSimpleElemValue(e);
            if (nodeName.equals("param-name")) {
                if (nodeValue == null) continue;
                paramName = nodeValue.trim();
                continue;
            }
            if (!nodeName.equals("param-value") || nodeValue == null) continue;
            paramValue = nodeValue.trim();
        }
        map.put(paramName, paramValue);
    }

    private static TagInfo elemToTagInfo(TagLibraryInfo tlib, Element tagElem, JspParseState st, Integer tldVersion) throws ClassNotFoundException, IllegalAccessException, InstantiationException, JspParseException {
        String bodycontent;
        NodeList nl = tagElem.getChildNodes();
        int len = nl.getLength();
        Hashtable<String, String> simpleValues = new Hashtable<String, String>();
        TagInfo tag = null;
        Vector<TagAttributeInfo> attrsList = new Vector<TagAttributeInfo>();
        Vector<TagVariableInfo> varList = new Vector<TagVariableInfo>();
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            String nodeName = e.getNodeName();
            String nodeValue = XMLUtil.getSimpleElemValue(e);
            if (nodeName.equals("attribute")) {
                TagAttributeInfo attr = XMLUtil.elemToAttr(e);
                attrsList.addElement(attr);
                continue;
            }
            if (nodeName.equals("variable")) {
                TagVariableInfo tvi = XMLUtil.elemToVar(e, st);
                varList.addElement(tvi);
                continue;
            }
            if (nodeValue == null) continue;
            simpleValues.put(nodeName, nodeValue.trim());
        }
        String teiClassStr = tldVersion.equals(JSP_11_TLD) ? (String)simpleValues.get("teiclass") : (String)simpleValues.get("tei-class");
        TagExtraInfo tei = null;
        if (teiClassStr != null) {
            Class teiClass = null;
            teiClass = JspUtils.loadClass(teiClassStr, st);
            if (teiClass == null) {
                throw new ClassNotFoundException(teiClassStr);
            }
            tei = (TagExtraInfo)teiClass.newInstance();
        }
        if ((bodycontent = tldVersion.equals(JSP_11_TLD) ? (String)simpleValues.get("bodycontent") : (String)simpleValues.get("body-content")) != null) {
            if (!((bodycontent = bodycontent.toUpperCase()).equals("JSP") || bodycontent.equals("TAGDEPENDENT") || bodycontent.equals("EMPTY") || bodycontent.equals("SCRIPTLESS") || !st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("invalid_tld_body_value"), bodycontent))))) {
                return null;
            }
        } else {
            bodycontent = "JSP";
        }
        Object[] attrs = new TagAttributeInfo[attrsList.size()];
        attrsList.copyInto(attrs);
        Object[] tvis = new TagVariableInfo[varList.size()];
        varList.copyInto(tvis);
        if (tldVersion.equals(JSP_11_TLD)) {
            tag = new TagInfo((String)simpleValues.get("name"), (String)simpleValues.get("tagclass"), bodycontent, (String)simpleValues.get("info"), tlib, tei, (TagAttributeInfo[])attrs);
        } else if (tldVersion.equals(JSP_12_TLD)) {
            tag = new TagInfo((String)simpleValues.get("name"), (String)simpleValues.get("tag-class"), bodycontent, (String)simpleValues.get("description"), tlib, tei, (TagAttributeInfo[])attrs, (String)simpleValues.get("display-name"), (String)simpleValues.get("small-icon"), (String)simpleValues.get("large-icon"), (TagVariableInfo[])tvis);
        } else if (tldVersion.equals(JSP_20_TLD)) {
            tag = new TagInfo((String)simpleValues.get("name"), (String)simpleValues.get("tag-class"), bodycontent, (String)simpleValues.get("description"), tlib, tei, (TagAttributeInfo[])attrs, (String)simpleValues.get("display-name"), (String)simpleValues.get("small-icon"), (String)simpleValues.get("large-icon"), (TagVariableInfo[])tvis, Boolean.valueOf((String)simpleValues.get("dynamic-attributes")).booleanValue());
        }
        if (tei != null) {
            tei.setTagInfo(tag);
        }
        return tag;
    }

    private static FunctionInfo elemToFunctionInfo(TagLibraryInfo tlib, Element functionElem, JspParseState st, Integer tldVersion) throws ClassNotFoundException, IllegalAccessException, InstantiationException, JspParseException {
        if ((tldVersion.equals(JSP_11_TLD) || tldVersion.equals(JSP_12_TLD)) && st.throwParseException(new JspParseException(st, "Functions not supported"))) {
            return null;
        }
        NodeList nl = functionElem.getChildNodes();
        int len = nl.getLength();
        Hashtable<String, String> simpleValues = new Hashtable<String, String>();
        FunctionInfo functionInfo = null;
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            String nodeName = e.getNodeName();
            String nodeValue = XMLUtil.getSimpleElemValue(e);
            if (nodeValue == null) continue;
            simpleValues.put(nodeName, nodeValue.trim());
        }
        String funcSig = (String)simpleValues.get("function-signature");
        if ((funcSig.indexOf("(") == -1 || funcSig.indexOf(")") == -1) && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("invalid_func_signature"), (String)simpleValues.get("name"))))) {
            return null;
        }
        functionInfo = new FunctionInfo((String)simpleValues.get("name"), (String)simpleValues.get("function-class"), (String)simpleValues.get("function-signature"));
        return functionInfo;
    }

    private static TagFileInfo elemToTagFileInfo(TagLibraryInfo tlib, Element tagfileElem, JspParseState st, Integer tldVersion, String jarName) throws ClassNotFoundException, IllegalAccessException, InstantiationException, JspParseException {
        if ((tldVersion.equals(JSP_11_TLD) || tldVersion.equals(JSP_12_TLD)) && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("tagfiles_unsupported"), tldVersion)))) {
            return null;
        }
        NodeList nl = tagfileElem.getChildNodes();
        int len = nl.getLength();
        Hashtable<String, String> simpleValues = new Hashtable<String, String>();
        TagFileInfo tagfileInfo = null;
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            String nodeName = e.getNodeName();
            String nodeValue = XMLUtil.getSimpleElemValue(e);
            if ("path".equals(nodeName) && !XMLUtil.isValidTagFilePath(nodeValue)) {
                return null;
            }
            simpleValues.put(nodeName, nodeValue.trim());
        }
        tagfileInfo = new TagFileInfo((String)simpleValues.get("name"), (String)simpleValues.get("path"), null);
        return tagfileInfo;
    }

    private static boolean isValidTagFilePath(String path) {
        if (path == null) {
            JspMessages.warningInvalidTagFilePath(path);
            return false;
        }
        if (!path.endsWith(".tag") && !path.endsWith(".tagx")) {
            JspMessages.warningInvalidTagFilePath(path);
            return false;
        }
        if (!path.startsWith("/WEB-INF/tags") && !path.startsWith("/META-INF/tags")) {
            JspMessages.warningInvalidTagFilePath(path);
            return false;
        }
        return true;
    }

    public static TagAttributeInfo elemToAttr(Element attrElem) {
        NodeList nl = attrElem.getChildNodes();
        int len = nl.getLength();
        Hashtable<String, String> simpleValues = new Hashtable<String, String>();
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            String nodeName = e.getNodeName();
            String nodeValue = XMLUtil.getSimpleElemValue(e);
            if (nodeValue == null) continue;
            simpleValues.put(nodeName, nodeValue.trim());
        }
        return new TagAttributeInfo((String)simpleValues.get("name"), XMLUtil.convBoolStr((String)simpleValues.get("required"), false), (String)simpleValues.get("type"), XMLUtil.convBoolStr((String)simpleValues.get("rtexprvalue"), false), XMLUtil.convBoolStr((String)simpleValues.get("fragment"), false));
    }

    public static TagVariableInfo elemToVar(Element varElem, JspParseState st) throws JspParseException {
        NodeList nl = varElem.getChildNodes();
        int len = nl.getLength();
        Hashtable<String, String> simpleValues = new Hashtable<String, String>();
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            String nodeName = e.getNodeName();
            String nodeValue = XMLUtil.getSimpleElemValue(e);
            if (nodeValue == null) continue;
            simpleValues.put(nodeName, nodeValue.trim());
        }
        int scope = XMLUtil.convVarScopeStr((String)simpleValues.get("scope"), st);
        String className = (String)simpleValues.get("variable-class");
        if (className == null) {
            className = "java.lang.String";
        }
        return new TagVariableInfo((String)simpleValues.get("name-given"), (String)simpleValues.get("name-from-attribute"), className, XMLUtil.convBoolStr((String)simpleValues.get("declare"), true), scope);
    }

    public static int convVarScopeStr(String s, JspParseState st) throws JspParseException {
        if (s == null) {
            return 0;
        }
        String us = s.toUpperCase();
        if (us.equals("AT_BEGIN")) {
            return 1;
        }
        if (us.equals("NESTED")) {
            return 0;
        }
        if (us.equals("AT_END")) {
            return 2;
        }
        if (st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("invalid_tag_variable_scope"), s)))) {
            return -1;
        }
        return -1;
    }

    public static boolean convBoolStr(String s, boolean defaultVal) {
        if (s == null) {
            return defaultVal;
        }
        if ((s = s.toLowerCase()).equals("yes") || s.equals("true")) {
            return true;
        }
        if (s.equals("no") || s.equals("false")) {
            return false;
        }
        return defaultVal;
    }

    protected static Jsp2JavaParms initializeJspDummyParams(String realPath, ClassLoader appClassLoader, JspResourceProvider provider) {
        JspResourceProvider resProviderClass = null;
        Class<?> resProvider = null;
        try {
            try {
                resProvider = appClassLoader.loadClass("oracle.jsp.provider.JspFSServletContextResource");
            }
            catch (Exception e) {
                Class.forName("oracle.jsp.provider.JspFSServletContextResource");
            }
            if (resProvider != null) {
                resProviderClass = (JspResourceProvider)resProvider.newInstance();
                resProviderClass.init(realPath, "/", "/", null, null, null);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Jsp2JavaParms params = new Jsp2JavaParms();
        params.resourceProvider = resProviderClass;
        params.pagePath = "/";
        params.validate = false;
        params.tldXmlValidate = false;
        params.cachedConfigTable = new CachedConfigTable();
        params.classLoader = appClassLoader;
        return params;
    }

    public static List getJspTaglibListeners(String realPath, ClassLoader loader, JspResourceProvider provider, Map tagClassMap) {
        jspListenerList = new ArrayList();
        try {
            Jsp2JavaParms parms = XMLUtil.initializeJspDummyParams(realPath, loader, provider);
            if (parms == null) {
                return null;
            }
            JspParseState st = new JspParseState(null, parms);
            XMLUtil.identifyWebLibJarsTLDListeners(st, tagClassMap);
            XMLUtil.identifyWebINFDirTLDListeners(st, realPath, tagClassMap);
            XMLUtil.identifyWebXMLTLDListeners(st, tagClassMap);
            return jspListenerList;
        }
        catch (Throwable e) {
            JspMessages.warningErrorGettingTaglibListeners(e);
            return jspListenerList;
        }
    }

    private static void identifyWebLibJarsTLDListeners(JspParseState st, Map tagClassMap) {
        ArrayList listenerList = new ArrayList();
        try {
            XMLUtil.scanWebLibJarsTLD(st);
            Enumeration taglibList = st.parms.cachedConfigTable.getConfigObjectEnum();
            if (st.parms.cachedConfigTable != null) {
                while (taglibList.hasMoreElements()) {
                    String tldName = (String)taglibList.nextElement();
                    String actualTldname = tldName == null ? null : tldName.substring(tldName.indexOf(58) + 1);
                    OracleTagLibraryInfo tlib = (OracleTagLibraryInfo)((Object)st.parms.cachedConfigTable.getConfigObject(actualTldname, class$oracle$jsp$parse$OracleTagLibraryInfo == null ? XMLUtil.class$("oracle.jsp.parse.OracleTagLibraryInfo") : class$oracle$jsp$parse$OracleTagLibraryInfo, st));
                    if (tlib == null) continue;
                    if (!tlib.direct && !tlib.listenerList.isEmpty()) {
                        XMLUtil.addToTLDListenerList(tlib.listenerList);
                    }
                    XMLUtil.loadTagClassMap(tlib, tagClassMap);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void identifyWebINFDirTLDListeners(JspParseState st, String appRoot, Map tagClassMap) {
        ArrayList tldList = new ArrayList();
        XMLUtil.getWebINFTLDs(tldList, appRoot, appRoot + "/WEB-INF");
        try {
            if (!tldList.isEmpty()) {
                for (int i = 0; i < tldList.size(); ++i) {
                    OracleTagLibraryInfo tlib = XMLUtil.loadTagLibFromTLD(null, "dummyuri", (String)tldList.get(i), st, null);
                    if (tlib != null && !tlib.listenerList.isEmpty()) {
                        XMLUtil.addToTLDListenerList(tlib.listenerList);
                    }
                    XMLUtil.loadTagClassMap(tlib, tagClassMap);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private static void getWebINFTLDs(List list, String appRoot, String dirName) {
        File dirObj = new File(dirName);
        if (dirObj.exists() && dirObj.isDirectory()) {
            File[] fileList = dirObj.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                String filename;
                if (fileList[i].isDirectory()) {
                    String fname = fileList[i].getName();
                    if ("classes".equalsIgnoreCase(fname) || "lib".equalsIgnoreCase(fname)) continue;
                    XMLUtil.getWebINFTLDs(list, appRoot, fileList[i].getPath());
                    continue;
                }
                if (!fileList[i].isFile() || !(filename = fileList[i].getPath()).endsWith(".tld") && !filename.endsWith("TLD") && !filename.endsWith(".otld")) continue;
                list.add(filename.substring(appRoot.length() - 1));
            }
        }
    }

    private static void identifyWebXMLTLDListeners(JspParseState st, Map tagClassMap) {
        block6: {
            try {
                Hashtable uriToLocMapping = st.getUriToLocMapping();
                if (uriToLocMapping == null) break block6;
                Enumeration e = uriToLocMapping.keys();
                while (e.hasMoreElements()) {
                    String uri = (String)e.nextElement();
                    String loc = (String)uriToLocMapping.get(uri);
                    if (st.parms.cachedConfigTable == null || !loc.startsWith("http://")) continue;
                    OracleTagLibraryInfo tlib = (OracleTagLibraryInfo)((Object)st.parms.cachedConfigTable.getConfigObject(loc, class$oracle$jsp$parse$OracleTagLibraryInfo == null ? XMLUtil.class$("oracle.jsp.parse.OracleTagLibraryInfo") : class$oracle$jsp$parse$OracleTagLibraryInfo, st));
                    if (tlib != null) {
                        if (tlib.direct) {
                            if (!tlib.listenerList.isEmpty()) {
                                XMLUtil.addToTLDListenerList(tlib.listenerList);
                            }
                            XMLUtil.loadTagClassMap(tlib, tagClassMap);
                            continue;
                        }
                        break;
                    }
                    JspMessages.warningCannotLoadTlibFromWebXML(loc);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void loadTagClassMap(OracleTagLibraryInfo tlib, Map tagClassMap) {
        if (tagClassMap != null) {
            TagInfo[] ti = tlib.getTags();
            for (int j = 0; j < ti.length; ++j) {
                tagClassMap.put(ti[j].getTagClassName(), null);
            }
        }
    }

    private static void addToTLDListenerList(List listener) {
        for (int i = 0; i < listener.size(); ++i) {
            jspListenerList.add(((String)listener.get(i)).trim());
        }
    }

    static boolean isXMLTagFile(String path, JspParseState st) throws JspParseException {
        if (path == null) {
            st.throwParseException(new JspParseException(st, msgs.getString("empty_tagfile")));
        } else {
            if (path.endsWith(".tagx")) {
                return true;
            }
            if (path.endsWith(".tag")) {
                return false;
            }
            st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("bad_tagfile_extension"), path)));
        }
        return false;
    }

    public static InputStream getTagFileFromJarFile(JspResourceProvider provider, String fileName, String jarFileName) throws FileNotFoundException, IOException {
        ZipInputStream docStream = null;
        InputStream jarStream = null;
        ZipInputStream zipStream = null;
        String tagfileName = fileName.substring(1, fileName.length());
        jarStream = XMLUtil.getFromStream(provider, jarFileName);
        zipStream = new ZipInputStream(jarStream);
        ZipEntry entry = null;
        do {
            if ((entry = zipStream.getNextEntry()) == null) continue;
            if (entry.getName().equals(tagfileName)) {
                docStream = zipStream;
                continue;
            }
            zipStream.closeEntry();
        } while (entry != null && docStream == null);
        if (docStream == null) {
            throw new FileNotFoundException(MessageFormat.format(msgs.getString("tagfile_not_found"), tagfileName));
        }
        return docStream;
    }

    static {
        dtdTable = new Hashtable();
        schemaTable = new Hashtable();
    }
}

