/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.BufferedReader;
import java.io.IOException;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspParseTag;
import oracle.jsp.parse.JspParseTagFile;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TagFileParseDirectives
extends JspParseTagFile {
    public TagFileParseDirectives(BufferedReader in, String enc) {
        super(7);
        this.in = in;
        this.nonXMLJspEncoding = enc;
    }

    public TagFileParseDirectives(JspParseState st, Element xmlSrcElem, String fileName) throws JspParseException {
        super(7);
        this.setXMLSrcElem(st, xmlSrcElem);
        this.setFileName(fileName);
    }

    private Element pruneXmlSrcElem(JspParseState st, JspParseTag tag) {
        while (tag.xmlSrcCurChildIdx < tag.xmlSrcBodyLen) {
            Node n = this.xmlSrcElemChildren.item(this.xmlSrcCurChildIdx);
            ++this.xmlSrcCurChildIdx;
            if (!(n instanceof Element)) continue;
            Element childElem = (Element)n;
            String name = ((XMLElement)childElem).getLocalName();
            String prefix = ((XMLElement)childElem).getPrefix();
            String prefixValue = null;
            if (prefix != null) {
                prefixValue = ((XMLElement)childElem).resolveNamespacePrefix(prefix);
            }
            boolean remove = true;
            if (prefixValue != null && prefixValue.equals("http://java.sun.com/JSP/Page") && name.startsWith("directive")) {
                remove = false;
            }
            if (!remove) continue;
            try {
                Node temp = this.xmlSrcElem.removeChild(n);
            }
            catch (DOMException e) {}
        }
        return this.xmlSrcElem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(JspParseState st) throws IOException, JspParseException {
        if (this.xmlSrcElem != null) {
            NodeList nl = this.xmlSrcElem.getChildNodes();
            this.xmlSrcElem = this.pruneXmlSrcElem(st, this);
            this.parseXMLSrc(st);
            return;
        }
        st.pushSrcParseInfo();
        st.in = this.in;
        st.clearLine();
        st.position.Clear();
        try {
            JspParseTag tag;
            while ((tag = this.parseNextTag(st)) != null) {
                this.addTagToBody(st, tag);
            }
        }
        finally {
            st.popSrcParseInfo();
        }
    }

    protected JspParseTag parseNextTag(JspParseState st) throws IOException, JspParseException {
        if (st.getLine() == null || st.getLine().length() == 0) {
            st.ReadLine();
        }
        JspParseTag tag = null;
        String tagStr = null;
        while (st.getLine() != null) {
            int idx;
            if (st.getLine().length() > 0 && st.getLine().charAt(0) == '<') {
                idx = TagFileParseDirectives.findTagEnd(st.getLine());
                tagStr = idx >= st.getLine().length() ? st.getLine() : st.getLine().substring(0, idx);
                if (this.isEndTag(tagStr)) {
                    this.skipEndTag(st);
                    return null;
                }
                int tagLen = this.isKnownDirectiveTag(st, tagStr);
                if (tagLen != -1) {
                    tagStr = tagStr.substring(0, tagLen);
                    idx = tagStr.length();
                    tag = st.createTagParser(tagStr, this);
                    tag.lineNumber = st.position.lineNum;
                    tag.columnNumber = st.getColNum() + 1;
                    if (idx >= st.getLine().length()) {
                        st.clearLine();
                    } else {
                        st.advLine(idx);
                    }
                    int bodyLen = this.body.size();
                    tag.parse(st);
                    if (this.body.size() == bodyLen) {
                        return tag;
                    }
                } else if (st.getLine().length() > 1) {
                    st.advLine(1);
                } else {
                    st.clearLine();
                }
            } else {
                idx = st.getLine().indexOf(60);
                if (idx != -1) {
                    st.advLine(idx);
                } else {
                    st.clearLine();
                }
            }
            if (st.getLine() != null && st.getLine().length() != 0) continue;
            st.ReadLine();
        }
        this.parseFileEnd(st);
        return null;
    }

    public int isKnownDirectiveTag(JspParseState st, String tagStr) {
        if (tagStr == null) {
            return -1;
        }
        if (tagStr.startsWith("<%")) {
            if (tagStr.length() > 2 && tagStr.startsWith("<%") && tagStr.charAt(2) == '@') {
                st.foundKnownTag = st.getTagHandler("<%@", false);
                if (st.foundKnownTag != null) {
                    return 3;
                }
            }
        } else if (tagStr.startsWith("<jsp:directive")) {
            st.foundKnownTag = st.getTagHandler(tagStr, false);
            if (st.foundKnownTag != null) {
                return tagStr.length();
            }
        }
        return -1;
    }
}

