/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.Serializable;
import java.text.MessageFormat;
import oracle.jsp.parse.JspDirective;
import oracle.jsp.parse.JspDirectiveAttrDesc;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspUtils;
import oracle.jsp.parse.XMLUtil;

public class TagFileDirectiveTag
extends JspDirective
implements Serializable {
    private static final JspDirectiveAttrDesc[] attrs = new JspDirectiveAttrDesc[11];
    private static final JspDirectiveAttrDesc dirAttr = new JspDirectiveAttrDesc("page", true);
    private static final String[] languageValue = new String[]{"java"};

    public TagFileDirectiveTag() {
        if (attrs[0] == null) {
            TagFileDirectiveTag.dirAttr.validValues = new String[0];
            TagFileDirectiveTag.attrs[0] = new JspDirectiveAttrDesc("display-name", true, true);
            TagFileDirectiveTag.attrs[0].required = false;
            TagFileDirectiveTag.attrs[1] = new JspDirectiveAttrDesc("body-content", true, true);
            TagFileDirectiveTag.attrs[1].required = false;
            TagFileDirectiveTag.attrs[2] = new JspDirectiveAttrDesc("dynamic-attributes", true, true);
            TagFileDirectiveTag.attrs[2].required = false;
            TagFileDirectiveTag.attrs[3] = new JspDirectiveAttrDesc("small-icon", false, true);
            TagFileDirectiveTag.attrs[3].required = false;
            TagFileDirectiveTag.attrs[4] = new JspDirectiveAttrDesc("large-icon", false, true);
            TagFileDirectiveTag.attrs[4].required = false;
            TagFileDirectiveTag.attrs[5] = new JspDirectiveAttrDesc("description", false, true);
            TagFileDirectiveTag.attrs[5].required = false;
            TagFileDirectiveTag.attrs[6] = new JspDirectiveAttrDesc("example", true, true);
            TagFileDirectiveTag.attrs[6].required = false;
            TagFileDirectiveTag.attrs[7] = new JspDirectiveAttrDesc("language", false, true);
            TagFileDirectiveTag.attrs[7].required = false;
            TagFileDirectiveTag.attrs[7].validValues = languageValue;
            TagFileDirectiveTag.attrs[8] = new JspDirectiveAttrDesc("import", ',', true, true);
            TagFileDirectiveTag.attrs[8].required = false;
            TagFileDirectiveTag.attrs[9] = new JspDirectiveAttrDesc("pageEncoding", ';', false, true, false);
            TagFileDirectiveTag.attrs[9].required = false;
            TagFileDirectiveTag.attrs[10] = new JspDirectiveAttrDesc("isELIgnored", false, true);
            TagFileDirectiveTag.attrs[10].required = false;
        }
    }

    public JspDirectiveAttrDesc getDirectiveDescription() {
        return dirAttr;
    }

    public JspDirectiveAttrDesc[] getAttributeDescriptions() {
        return attrs;
    }

    public void validateAttributes(JspParseState st) throws JspParseException {
        super.validateAttributes(st);
        String bodycontent = this.getAttrValue("body-content");
        if (bodycontent != null && !bodycontent.equalsIgnoreCase("EMPTY") && !bodycontent.equalsIgnoreCase("TAGDEPENDENT") && !bodycontent.equalsIgnoreCase("SCRIPTLESS") && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("invalid_bodycontent_value"), bodycontent)))) {
            return;
        }
        String val = this.getAttrValue("language");
        if (val == null) {
            val = "java";
        } else {
            val = val.toLowerCase();
            val = val.trim();
        }
        if (!val.equals("java") && st.throwParseException(new JspParseException(st, msgs.getString("bad_lang")))) {
            return;
        }
        val = this.getAttrValue("isELIgnored");
        if (val != null) {
            if (JspUtils.isBoolean(val)) {
                st.parms.elIgnored = JspUtils.translateBoolean(val, false);
            } else if (st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("bad_elignored_val"), val)))) {
                return;
            }
        }
        if ((val = this.getAttrValue("pageEncoding")) != null && XMLUtil.isXMLTagFile(st.position.currentSourceFile, st) && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("disallow_page_encoding_in_xml"), st.position.currentSourceFile)))) {
            return;
        }
    }
}

