/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.Serializable;
import java.text.MessageFormat;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import oracle.jsp.parse.JspDirective;
import oracle.jsp.parse.JspDirectiveAttrDesc;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspUtils;

public class TagFileDirectiveAttribute
extends JspDirective
implements Serializable {
    private static final JspDirectiveAttrDesc[] attrs = new JspDirectiveAttrDesc[6];
    private static final JspDirectiveAttrDesc dirAttr = new JspDirectiveAttrDesc("attribute", true);
    private static final String[] languageValue = new String[]{"java", "sqlj"};

    public TagFileDirectiveAttribute() {
        if (attrs[0] == null) {
            TagFileDirectiveAttribute.dirAttr.validValues = new String[0];
            TagFileDirectiveAttribute.attrs[0] = new JspDirectiveAttrDesc("name", true, false);
            TagFileDirectiveAttribute.attrs[0].required = true;
            TagFileDirectiveAttribute.attrs[1] = new JspDirectiveAttrDesc("required", true, false);
            TagFileDirectiveAttribute.attrs[1].required = false;
            TagFileDirectiveAttribute.attrs[2] = new JspDirectiveAttrDesc("fragment", true, false);
            TagFileDirectiveAttribute.attrs[2].required = false;
            TagFileDirectiveAttribute.attrs[3] = new JspDirectiveAttrDesc("rtexprvalue", true, false);
            TagFileDirectiveAttribute.attrs[3].required = false;
            TagFileDirectiveAttribute.attrs[4] = new JspDirectiveAttrDesc("type", true, false);
            TagFileDirectiveAttribute.attrs[4].required = false;
            TagFileDirectiveAttribute.attrs[5] = new JspDirectiveAttrDesc("description", true, false);
            TagFileDirectiveAttribute.attrs[5].required = false;
        }
    }

    public JspDirectiveAttrDesc getDirectiveDescription() {
        return dirAttr;
    }

    public JspDirectiveAttrDesc[] getAttributeDescriptions() {
        return attrs;
    }

    public void validateAttributes(JspParseState st) throws JspParseException {
        super.validateAttributes(st);
        String attributeName = this.getAttrValue("name");
        if (st.tagFileHt.get(attributeName) != null && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("tagfile_attrVar_nameexists"), attributeName)))) {
            return;
        }
        boolean fragment = JspUtils.translateBoolean(this.getAttrValue("fragment"), false);
        String type = this.getAttrValue("type");
        String rtexprValue = this.getAttrValue("rtexprvalue");
        if (fragment) {
            if (type != null && st.throwParseException(new JspParseException(st, msgs.getString("fragment_with_typevalue")))) {
                return;
            }
            if (rtexprValue != null && st.throwParseException(new JspParseException(st, msgs.getString("fragment_with_rtexprvalue")))) {
                return;
            }
        } else if (type == null) {
            type = "java.lang.String";
        }
        boolean rtexprVal = JspUtils.translateBoolean(rtexprValue, true);
        boolean required = JspUtils.translateBoolean(this.getAttrValue("required"), false);
        TagAttributeInfo attrInfo = new TagAttributeInfo(attributeName, required, type, rtexprVal, fragment);
        st.tagFileAttributeVector.addElement(attrInfo);
        st.tagFileHt.put(attributeName, attrInfo);
    }
}

