/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.servlet.jsp.tagext.TagInfo;
import oracle.jsp.parse.JspAttributeValuePiece;
import oracle.jsp.parse.JspBeanPropertyInfo;
import oracle.jsp.parse.JspEmitState;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspUtils;
import oracle.jsp.parse.OpenJspAVInfo;

public class PropertyUtil {
    private static final String MSG_FILE = "oracle.jsp.parse.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.parse.LocalStrings");
    private static String eval1 = "oracle.jsp.runtime.OracleJspRuntime.evaluate(";
    private static String eval2 = ".class, __ojsp_varRes,null)";
    private static String eval3 = ".class, __ojsp_varRes, __ojsp_fnmappers[";
    private static String eval4 = "])";

    public static void checkSetValue(OpenJspAVInfo av, JspBeanPropertyInfo pinfo, JspParseState parseState, Class bean, String attrName) throws JspParseException {
        PropertyUtil.checkSetValue(av, pinfo, parseState, null, bean, attrName);
    }

    public static void checkSetValue(OpenJspAVInfo av, JspBeanPropertyInfo pinfo, JspParseState parseState, TagInfo tagInfo) throws JspParseException {
        PropertyUtil.checkSetValue(av, pinfo, parseState, tagInfo, null, null);
    }

    public static void checkSetValue(OpenJspAVInfo av, JspBeanPropertyInfo pinfo, JspParseState parseState, TagInfo tagInfo, Class bean, String attrName) throws JspParseException {
        boolean validEL = false;
        boolean mixedEL = false;
        if (JspUtils.isELEvaluationOn(parseState) && av.attributeValueHasEL()) {
            validEL = true;
        }
        if (validEL && JspUtils.isItMixed(av.stringValueElPieces) && !JspUtils.isTrivialType(pinfo.type)) {
            PropertyUtil.checkForPropertyEditorClass(bean, attrName, pinfo);
            if (pinfo.propertyEditorClass == null && parseState.throwParseException(new JspParseException(parseState, msgs.getString("mixed_el_no_prop")))) {
                return;
            }
        }
        if (av.isJspAttribute()) {
            return;
        }
        String value = av.getExpression();
        if ((pinfo.isMultiValue || pinfo.type.isArray()) && JspUtils.valueIsQuoted(value) && !validEL && (tagInfo == null ? parseState.throwParseException(new JspParseException(parseState, msgs.getString("need_expr_for_prop"))) : parseState.throwParseException(new JspParseException(parseState, "Attribute \"" + av.desc.name + "\" of tag \"" + tagInfo.getTagName() + "\" cannot be set with a constant, " + "an expression must be specified.")))) {
            return;
        }
        if (!av.isExpression() || validEL) {
            Object val;
            block13: {
                val = null;
                if (tagInfo == null) {
                    PropertyUtil.checkForPropertyEditorClass(bean, attrName, pinfo);
                    if (pinfo.propertyEditorClass != null) {
                        value = av.getUnquotedValue();
                        try {
                            val = JspUtils.getValueFromPropertyEditor(attrName, pinfo.type.getName(), value, pinfo.propertyEditorClass);
                        }
                        catch (IntrospectionException e) {
                            if (!parseState.throwParseException(new JspParseException(parseState, (Throwable)e))) break block13;
                            return;
                        }
                    }
                }
            }
            if (pinfo.propertyEditorClass == null) {
                if (!JspUtils.valueIsQuoted(value)) {
                    value = av.getQuotedValue();
                }
                val = JspUtils.convertConstant(value, pinfo.type);
            }
            if (val == null && !av.attributeValueHasEL() && (tagInfo == null ? parseState.throwParseException(new JspParseException(parseState, MessageFormat.format(msgs.getString("no_convert_to_type"), pinfo.type.getName()))) : parseState.throwParseException(new JspParseException(parseState, "Unable to convert constant to type " + pinfo.type.getName() + " for attribute \"" + av.desc.name + "\" of tag \"" + tagInfo.getTagName() + "\".")))) {
                return;
            }
        }
    }

    private static String getWrapper(Class type) {
        String v = null;
        if (type.equals(Integer.TYPE)) {
            v = "java.lang.Integer";
        } else if (type.equals(Boolean.TYPE)) {
            v = "java.lang.Boolean";
        } else if (type.equals(Short.TYPE)) {
            v = "java.lang.Short";
        } else if (type.equals(Float.TYPE)) {
            v = "java.lang.Float";
        } else if (type.equals(Double.TYPE)) {
            v = "java.lang.Double";
        } else if (type.equals(Long.TYPE)) {
            v = "java.lang.Long";
        } else if (type.equals(Byte.TYPE)) {
            v = "java.lang.Byte";
        } else if (type.equals(Character.TYPE)) {
            v = "java.lang.Character";
        }
        return v;
    }

    public static void emitSetValue(JspEmitState st, JspBeanPropertyInfo pinfo, OpenJspAVInfo av, String beanName, String attrName) {
        PropertyUtil.emitSetValue(st, pinfo, av, beanName, attrName, null);
    }

    private static String getELEndStr(ArrayList al) {
        JspAttributeValuePiece avp = (JspAttributeValuePiece)al.get(0);
        if (avp != null && avp.isElFunction) {
            return eval3 + avp.elFunctionNum + eval4;
        }
        return eval2;
    }

    public static void emitSetValue(JspEmitState st, JspBeanPropertyInfo pinfo, OpenJspAVInfo av, String beanName, String attrName, String attrURI) {
        String value = av.getExpression();
        if (av.isExpression()) {
            StringBuffer elMixedText = PropertyUtil.generateElMixedText(st, av);
            if (pinfo.isMultiValue) {
                PropertyUtil.emitSetValueMultiValueExpression(st, pinfo, av, beanName, attrName, attrURI, value);
            } else if (pinfo.propertyEditorClass != null) {
                PropertyUtil.emitSetValuePropEditorExpression(st, pinfo, av, beanName, attrName, attrURI, value, JspUtils.isBasicType(pinfo.type), elMixedText);
            } else {
                PropertyUtil.emitSetValueSingleExpression(st, pinfo, av, beanName, attrName, attrURI, value, JspUtils.isBasicType(pinfo.type), elMixedText);
            }
        } else {
            value = av.isJspAttribute() ? av.getUnquotedValue() : av.getQuotedValue();
            if (JspUtils.isTrivialType(pinfo.type)) {
                if (pinfo.propertyEditorClass != null) {
                    PropertyUtil.emitSetValueTrivialPropEditorConstant(st, pinfo, av, beanName, attrName, attrURI, value, JspUtils.isBasicType(pinfo.type));
                } else {
                    PropertyUtil.emitSetValueTrivialPlainConstant(st, pinfo, av, beanName, attrName, attrURI, value, JspUtils.isBasicType(pinfo.type));
                }
            } else {
                PropertyUtil.emitSetValueSingleNonTrivialConstant(st, pinfo, av, beanName, attrName, attrURI, value);
            }
        }
    }

    private static void emitSetValueMultiValueExpression(JspEmitState st, JspBeanPropertyInfo pinfo, OpenJspAVInfo av, String beanName, String attrName, String attrURI, String value) {
        st.iprintln("{");
        st.indent();
        if (JspUtils.isELEvaluationOn(st) && av.attributeValueHasEL()) {
            st.iprintln(pinfo.type.getName() + "[] __a = " + "(" + pinfo.type.getName() + "[])oracle.jsp.runtime.OracleJspRuntime.evaluate(" + value + "," + pinfo.type.getName() + "[].class, __ojsp_varRes," + PropertyUtil.getELEndStr(av.stringValueElPieces) + ";");
        } else {
            st.iprintln(pinfo.type.getName() + "[] __a = " + value + ";");
        }
        st.iprintln("for (int __i = 0; __i < __a.length; __i++) {");
        st.indent();
        st.iprintln(beanName + "." + pinfo.getName() + "( __i, " + PropertyUtil.convertExpression("__a[__i]", pinfo) + ");");
        st.undent();
        st.iprintln("}");
        st.undent();
        st.iprintln("}");
    }

    private static void emitSetValueSingleExpression(JspEmitState st, JspBeanPropertyInfo pinfo, OpenJspAVInfo av, String beanName, String attrName, String attrURI, String value, boolean basicType, StringBuffer elMixedText) {
        String result = null;
        String modifyString = null;
        boolean introspector = false;
        if (JspUtils.isELEvaluationOn(st) && av.attributeValueHasEL()) {
            if (elMixedText.length() > 0) {
                if (basicType || pinfo.type.isPrimitive()) {
                    modifyString = PropertyUtil.convertExpression(elMixedText.toString(), pinfo);
                } else if (pinfo.type.equals(String.class) || pinfo.type.equals(Object.class)) {
                    modifyString = "(" + pinfo.type.getName() + ")" + " (" + elMixedText + ")";
                }
            } else {
                String end = PropertyUtil.getELEndStr(av.stringValueElPieces);
                if (pinfo.type.isArray()) {
                    String fm = null;
                    fm = av.stringValueElPieces.size() == 1 && ((JspAttributeValuePiece)av.stringValueElPieces.get((int)0)).isElFunction ? "__ojsp_fnmappers[" + ((JspAttributeValuePiece)av.stringValueElPieces.get((int)0)).elFunctionNum + "]," : "new oracle.jsp.el.OracleFunctionMapperImpl()";
                    modifyString = "OracleJspRuntime.__IntrospectHelper(" + fm + ", __ojsp_varRes, " + value + ", " + beanName + ", \"" + attrName + "\"" + ", " + st.parms.needToRaiseBeanException + ");";
                    introspector = true;
                } else if (pinfo.type.isPrimitive()) {
                    String elexpr = "(" + PropertyUtil.getWrapper(pinfo.type) + ")" + eval1 + value + "," + PropertyUtil.getWrapper(pinfo.type) + end;
                    modifyString = PropertyUtil.convertExpression(elexpr, pinfo);
                } else {
                    modifyString = "(" + pinfo.type.getName() + ")" + eval1 + value + "," + pinfo.type.getName() + end;
                }
            }
        } else {
            modifyString = pinfo.isMethod() && pinfo.overloaded ? value : PropertyUtil.convertExpression(value, pinfo);
        }
        result = PropertyUtil.createResult(st, pinfo, av, beanName, attrName, attrURI, value, modifyString, introspector);
        st.iprintln(result);
    }

    private static void emitSetValuePropEditorExpression(JspEmitState st, JspBeanPropertyInfo pinfo, OpenJspAVInfo av, String beanName, String attrName, String attrURI, String value, boolean basicType, StringBuffer elMixedText) {
        String result = null;
        Object val = null;
        String modifyString = null;
        if (pinfo.propertyEditorClass != null) {
            value = av.getUnquotedValue();
            try {
                val = JspUtils.getValueFromPropertyEditor(pinfo.getName(), pinfo.type.getName(), value, pinfo.propertyEditorClass);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (val != null && JspUtils.isELEvaluationOn(st) && av.attributeValueHasEL()) {
                String end = PropertyUtil.getELEndStr(av.stringValueElPieces);
                if (pinfo.type.equals(String.class)) {
                    modifyString = "(" + pinfo.type.getName() + ")" + eval1 + "\"" + val + "\"," + pinfo.type.getName() + end;
                    result = PropertyUtil.createResult(st, pinfo, av, beanName, attrName, attrURI, value, modifyString, false);
                    st.iprintln(result);
                }
            }
        }
    }

    private static void emitSetValueTrivialPropEditorConstant(JspEmitState st, JspBeanPropertyInfo pinfo, OpenJspAVInfo av, String beanName, String attrName, String attrURI, String value, boolean basicType) {
        String result = null;
        Object val = null;
        String modifyString = null;
        if (pinfo.propertyEditorClass != null) {
            value = av.getUnquotedValue();
            try {
                val = JspUtils.getValueFromPropertyEditor(pinfo.getName(), pinfo.type.getName(), value, pinfo.propertyEditorClass);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (val != null) {
                if (pinfo.type.equals(String.class)) {
                    modifyString = "\"" + PropertyUtil.emitConstant(val, pinfo.type) + "\"";
                }
                if (basicType || pinfo.type.equals(Object.class)) {
                    modifyString = "( new " + pinfo.type.getName() + "( " + PropertyUtil.emitConstant(val, pinfo.type) + "))";
                }
            }
        }
        result = PropertyUtil.createResult(st, pinfo, av, beanName, attrName, attrURI, value, modifyString, false);
        st.iprintln(result);
    }

    private static void emitSetValueTrivialPlainConstant(JspEmitState st, JspBeanPropertyInfo pinfo, OpenJspAVInfo av, String beanName, String attrName, String attrURI, String value, boolean basicType) {
        String result = null;
        Object val = null;
        String modifyString = null;
        val = av.isJspAttribute() ? JspUtils.convertExpression(value, pinfo.type) : JspUtils.convertConstant(value, pinfo.type);
        if (val != null) {
            modifyString = av.isJspAttribute() ? val.toString() : (basicType ? "( new " + pinfo.type.getName() + "( " + PropertyUtil.emitConstant(val, pinfo.type) + "))" : PropertyUtil.emitConstant(val, pinfo.type));
        }
        result = PropertyUtil.createResult(st, pinfo, av, beanName, attrName, attrURI, value, modifyString, false);
        st.iprintln(result);
    }

    private static void emitSetValueSingleNonTrivialConstant(JspEmitState st, JspBeanPropertyInfo pinfo, OpenJspAVInfo av, String beanName, String attrName, String attrURI, String value) {
        String result = null;
        String modifyString = null;
        boolean introspector = false;
        if (av.desc.isFragment) {
            modifyString = value;
        } else {
            modifyString = "OracleJspRuntime.__IntrospectHelper(" + value + ", " + beanName + ", \"" + attrName + "\"" + ", " + st.parms.needToRaiseBeanException + ")";
            introspector = true;
        }
        result = PropertyUtil.createResult(st, pinfo, av, beanName, attrName, attrURI, value, modifyString, introspector);
        st.iprintln(result);
    }

    private static String createResult(JspEmitState st, JspBeanPropertyInfo pinfo, OpenJspAVInfo av, String beanName, String attrName, String attrURI, String value, String modifyString, boolean introspector) {
        String result = null;
        if (av.isDynamicAttribute()) {
            String attr_uri = "null";
            String attr_name = "";
            String attr_prefix = null;
            String attr_value = null;
            if (attrName.indexOf(58) != -1) {
                int div_loc = attrName.indexOf(58);
                attr_prefix = attrName.substring(0, div_loc - 1);
                attr_name = attrName.substring(div_loc + 1);
            } else {
                attr_name = attrName;
            }
            if (attr_prefix != null && attrURI != null) {
                attr_uri = "\"" + attrURI + "\"";
            }
            attr_value = av.attributeValueHasEL() && JspUtils.isELEvaluationOn(st) ? modifyString : PropertyUtil.convertExpression(value, pinfo);
            result = beanName + ".setDynamicAttribute(" + attr_uri + ",\"" + attr_name + "\"," + attr_value + ");";
        } else if (introspector) {
            result = modifyString + ";";
        } else {
            result = beanName + "." + pinfo.getName();
            result = pinfo.isMethod() ? result + "(" + modifyString + ");" : result + "=" + modifyString + ";";
        }
        return result;
    }

    private static StringBuffer generateElMixedText(JspEmitState st, OpenJspAVInfo av) {
        StringBuffer elMixedText = new StringBuffer();
        if (av.stringValueElPieces != null && av.stringValueElPieces.size() > 0 && JspUtils.isItMixed(av.stringValueElPieces)) {
            for (int i = 0; i < av.stringValueElPieces.size(); ++i) {
                JspAttributeValuePiece avp = (JspAttributeValuePiece)av.stringValueElPieces.get(i);
                if (avp.isELPiece()) {
                    if (avp.isElFunction) {
                        elMixedText.append(JspUtils.evstr1 + "\"" + avp.getPiece() + "\"" + JspUtils.evstr3 + avp.elFunctionNum + JspUtils.evstr4 + "+");
                        continue;
                    }
                    elMixedText.append(JspUtils.evstr1 + "\"" + avp.getPiece() + "\"" + JspUtils.evstr2 + "+");
                    continue;
                }
                elMixedText.append("\"" + avp.getPiece() + "\"+");
            }
            elMixedText.setLength(elMixedText.length() - 1);
        }
        return elMixedText;
    }

    private static String convertExpression(String inValue, JspBeanPropertyInfo pinfo) {
        return JspUtils.convertExpression(inValue, pinfo.type);
    }

    private static String emitConstant(Object val, Class type) {
        String v = type.equals(Byte.TYPE) || type.equals(Byte.class) ? "(byte) " + val.toString() : (type.equals(Character.TYPE) || type.equals(Character.class) ? "'" + val.toString() + "'" : (type.equals(Float.TYPE) || type.equals(Float.class) ? "(float) " + val.toString() : (type.equals(Short.TYPE) || type.equals(Short.class) ? "(short) " + val.toString() : (type.equals(Object.class) ? val.toString() : val.toString()))));
        return v;
    }

    public static void checkForPropertyEditorClass(Class beanClass, String name, JspBeanPropertyInfo info) {
        try {
            BeanInfo binfo = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] props = binfo.getPropertyDescriptors();
            for (int i = 0; i < props.length; ++i) {
                if (!name.equalsIgnoreCase(props[i].getName())) continue;
                Class<?> propertyEditorClass = props[i].getPropertyEditorClass();
                if (propertyEditorClass != null) {
                    info.editorClassNameFromPD = propertyEditorClass.getName();
                    info.propertyEditorClass = (PropertyEditor)propertyEditorClass.newInstance();
                } else {
                    Class<?> propType = props[i].getPropertyType();
                    if (!JspUtils.isTrivialType(propType)) {
                        info.propertyEditorClass = PropertyEditorManager.findEditor(propType);
                    }
                }
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

