/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import oracle.jsp.parse.JspEmitException;
import oracle.jsp.parse.JspEmitState;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspParseTag;
import oracle.jsp.parse.JspParseTagText;
import oracle.jsp.parse.JspUtils;
import oracle.jsp.parse.OpenJspAVDesc;
import oracle.jsp.parse.OpenJspAVInfo;
import oracle.jsp.parse.OpenJspTagAttribute;
import oracle.jsp.parse.OpenJspTagBody;
import oracle.jsp.parse.OpenJspTagHandler;
import oracle.jsp.parse.OpenJspTagPluginFallback;
import oracle.jsp.parse.OpenJspTagPluginParam;
import oracle.jsp.parse.OpenJspTagPluginParams;

public class OpenJspTagPlugin
extends OpenJspTagHandler {
    private static final OpenJspAVDesc[] avList = new OpenJspAVDesc[14];
    private static final String[] subTags = new String[8];
    private static final String[] validTypes = new String[]{"bean", "applet"};
    private boolean gotParams;
    private boolean gotFallback;
    private String type;
    private String code;
    private String codebase;
    private String align;
    private String archive;
    private String height;
    private String hspace;
    private String jreversion;
    private String name;
    private String vspace;
    private String width;
    private String nspluginurl;
    private String iepluginurl;
    private String mayscript;
    private String ieClassId = "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93";
    public static final String DEFAULT_URL_IE = "http://java.sun.com/products/plugin/1.2.2/jinstall-1_2_2-win.cab#Version=1,2,2,0";
    public static final String DEFAULT_URL_NS = "http://java.sun.com/products/plugin/";

    public OpenJspTagPlugin() {
        this.htmlTag = "plugin";
        if (avList[0] == null) {
            OpenJspTagPlugin.avList[0] = new OpenJspAVDesc("type", 1, true, true, validTypes);
            OpenJspTagPlugin.avList[1] = new OpenJspAVDesc("code", 1, true);
            OpenJspTagPlugin.avList[2] = new OpenJspAVDesc("codebase", 1, false);
            OpenJspTagPlugin.avList[3] = new OpenJspAVDesc("align", 1, false);
            OpenJspTagPlugin.avList[4] = new OpenJspAVDesc("archive", 1, false);
            OpenJspTagPlugin.avList[5] = new OpenJspAVDesc("height", 11, false);
            OpenJspTagPlugin.avList[6] = new OpenJspAVDesc("hspace", 1, false);
            OpenJspTagPlugin.avList[7] = new OpenJspAVDesc("jreversion", 1, false);
            OpenJspTagPlugin.avList[8] = new OpenJspAVDesc("name", 1, false);
            OpenJspTagPlugin.avList[9] = new OpenJspAVDesc("vspace", 1, false);
            OpenJspTagPlugin.avList[10] = new OpenJspAVDesc("width", 11, false);
            OpenJspTagPlugin.avList[11] = new OpenJspAVDesc("nspluginurl", 1, false);
            OpenJspTagPlugin.avList[12] = new OpenJspAVDesc("iepluginurl", 1, false);
            OpenJspTagPlugin.avList[13] = new OpenJspAVDesc("mayscript", 1, false);
            OpenJspTagPlugin.subTags[0] = ":params";
            OpenJspTagPlugin.subTags[1] = OpenJspTagPluginParams.class.getName();
            OpenJspTagPlugin.subTags[2] = ":fallback";
            OpenJspTagPlugin.subTags[3] = OpenJspTagPluginFallback.class.getName();
            OpenJspTagPlugin.subTags[4] = ":attribute";
            OpenJspTagPlugin.subTags[5] = OpenJspTagAttribute.class.getName();
            OpenJspTagPlugin.subTags[6] = ":body";
            OpenJspTagPlugin.subTags[7] = OpenJspTagBody.class.getName();
        }
    }

    public OpenJspAVDesc[] getAVDescriptions() {
        return avList;
    }

    public String[] getSubTags() {
        return subTags;
    }

    public boolean isTagValidInBody(JspParseState st, String tagStr, Class tagClass, JspParseTag tag) {
        if (tagClass.equals(OpenJspTagPluginParams.class)) {
            if (this.gotParams) {
                return false;
            }
            this.gotParams = true;
            return true;
        }
        if (tagClass.equals(OpenJspTagPluginFallback.class)) {
            if (this.gotFallback) {
                return false;
            }
            this.gotFallback = true;
            return true;
        }
        return tagClass.equals(OpenJspTagBody.class) || tagClass.equals(OpenJspTagAttribute.class);
    }

    public void addTagToBody(JspParseState st, JspParseTag tag) throws JspParseException {
        if (JspUtils.isTagWhitespace(tag)) {
            return;
        }
        if (tag.getClass().equals(JspParseTagText.class)) {
            if (st.throwParseException(new JspParseException(st, msgs.getString("bad_text_in_plugin")))) {
                return;
            }
        } else {
            this.body.addElement(tag);
        }
    }

    public String validateAttributeList(JspParseState st, OpenJspAVInfo[] avList) {
        this.type = this.getAV(0).getStringValue();
        this.code = this.getAV(1).getStringValue();
        this.codebase = this.getAV(2).getStringValue();
        this.align = this.getAV(3).getStringValue();
        this.archive = this.getAV(4).getStringValue();
        this.hspace = this.getAV(6).getStringValue();
        this.jreversion = this.getAV(7).getStringValue();
        this.name = this.getAV(8).getStringValue();
        this.vspace = this.getAV(9).getStringValue();
        this.nspluginurl = this.getAV(11).getStringValue();
        this.iepluginurl = this.getAV(12).getStringValue();
        this.mayscript = this.getAV(13).getStringValue();
        if (this.nspluginurl == null) {
            this.nspluginurl = DEFAULT_URL_NS;
        }
        if (this.iepluginurl == null) {
            this.iepluginurl = DEFAULT_URL_IE;
        }
        return null;
    }

    public void emitTagBody(JspEmitState st) throws JspEmitException {
        int i;
        st.iprint("out.println(\"<OBJECT classid=" + this.ieClassId + " ");
        if (this.name != null) {
            st.print(" name=\\\"" + this.name + "\\\" ");
        }
        this.emitCommon(st);
        st.println(" codebase=\\\"" + this.iepluginurl + "\\\" >\");");
        st.iprint("out.println(\"<PARAM name=\\\"java_code\\\" value=\\\"");
        st.print(this.code);
        st.println("\\\" >\");");
        if (this.codebase != null) {
            st.iprint("out.println(\"<PARAM name=\\\"java_codebase\\\" value=\\\"");
            st.print(this.codebase);
            st.println("\\\" >\");");
        }
        if (this.archive != null) {
            st.iprint("out.println(\"<PARAM name=\\\"java_archive\\\" value=\\\"");
            st.print(this.archive);
            st.println("\\\" >\");");
        }
        st.iprint("out.println(\"<PARAM name=\\\"type\\\" value=\\\"");
        if (this.type.equals("applet")) {
            st.print("application/x-java-applet;");
        } else if (this.type.equals("bean")) {
            st.print("application/x-java-bean;");
        }
        if (this.jreversion != null) {
            st.print("version=" + this.jreversion);
        }
        st.println("\\\" >\");");
        JspParseTag paramsTag = this.findTagInBody("params");
        int len = paramsTag != null ? paramsTag.body.size() : 0;
        String[] paramNames = new String[len];
        String[] paramValues = new String[len];
        for (i = 0; i < len; ++i) {
            OpenJspTagPluginParam paramTag = (OpenJspTagPluginParam)paramsTag.body.elementAt(i);
            paramTag.emitJspAttributes(st);
            paramNames[i] = paramTag.getAV(0).getStringValue();
            paramValues[i] = paramTag.getAV(1).attributeValueHasEL() ? JspUtils.getELAttributeEmitString(st, paramTag.getAV(1), true) : paramTag.getAV(1).getExpression();
        }
        for (i = 0; i < len; ++i) {
            st.iprint("out.print(\"<PARAM name=\\\"");
            if (paramNames[i].equalsIgnoreCase("object")) {
                st.print("java_object");
            } else if (paramNames[i].equalsIgnoreCase("type")) {
                st.print("java_type");
            } else {
                st.print(paramNames[i]);
            }
            st.println("\\\" value=\\\"\");");
            st.iprintln("out.print(" + paramValues[i] + ");");
            st.iprintln("out.println(\"\\\" >\");");
        }
        st.iprintln("out.println(\"<COMMENT>\");");
        st.iprint("out.print(\"<EMBED type=\\\"");
        if (this.type.equals("applet")) {
            st.print("application/x-java-applet;");
        } else if (this.type.equals("bean")) {
            st.print("application/x-java-bean;");
        }
        if (this.jreversion != null) {
            st.print("version=" + this.jreversion);
        }
        if (this.name != null) {
            st.print(" name=\\\"" + this.name + "\\\" ");
        }
        st.print("\\\"");
        this.emitCommon(st);
        st.print(" pluginspage=\\\"" + this.nspluginurl + "\\\" ");
        st.print("java_code=\\\"" + this.code + "\\\" ");
        if (this.codebase != null) {
            st.print("java_codebase=\\\"" + this.codebase + "\\\" ");
        }
        if (this.archive != null) {
            st.print("java_archive=\\\"" + this.archive + "\\\" ");
        }
        st.println(" \");");
        for (i = 0; i < len; ++i) {
            st.iprint("out.print(\"");
            if (paramNames[i].equalsIgnoreCase("object")) {
                st.print("java_object");
            } else if (paramNames[i].equalsIgnoreCase("type")) {
                st.print("java_type");
            } else {
                st.print(paramNames[i]);
            }
            st.println("=\\\"\");");
            st.iprintln("out.print(" + paramValues[i] + ");");
            st.iprintln("out.print(\"\\\" \");");
        }
        st.println("out.println(\">\");");
        st.iprintln("out.println(\"</EMBED>\");");
        st.iprintln("out.println(\"<NOEMBED>\");");
        JspParseTag fallbackTag = this.findTagInBody("fallback");
        if (fallbackTag != null) {
            fallbackTag.emitTagBody(st);
        }
        st.iprintln("out.println(\"</NOEMBED>\");");
        st.iprintln("out.println(\"</COMMENT>\");");
        st.iprintln("out.println(\"</OBJECT>\");");
    }

    private void emitCommon(JspEmitState st) {
        boolean haveExprToEmit;
        boolean bl = haveExprToEmit = this.getAV(10).getExpression() != null || this.getAV(5).getExpression() != null;
        if (haveExprToEmit) {
            st.print("\" + \"");
        }
        if (this.getAV(10).getExpression() != null) {
            this.emitCommonRtexpr(st, 10, "width");
        }
        if (this.getAV(5).getExpression() != null) {
            this.emitCommonRtexpr(st, 5, "height");
        }
        if (this.hspace != null) {
            st.print(" hspace=\\\"" + this.hspace + "\\\" ");
        }
        if (this.vspace != null) {
            st.print(" vspace=\\\"" + this.vspace + "\\\" ");
        }
        if (this.align != null) {
            st.print(" align=\\\"" + this.align + "\\\" ");
        }
        if (this.mayscript != null) {
            st.print(" mayscript=\\\"" + this.mayscript + "\\\" ");
        }
    }

    private void emitCommonRtexpr(JspEmitState st, int i, String name) {
        if (this.getAV(i).getExpression() != null) {
            String exprStr = null;
            exprStr = this.getAV(i).attributeValueHasEL() && !this.getAV(i).isJspAttribute() ? JspUtils.getELAttributeEmitString(st, this.getAV(i), false) : this.getAV(i).getExpression();
            st.print(" " + name + "=\\\"\"+ " + exprStr + "+      \"\\\"" + "\" +   \"");
        }
    }
}

