/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.IOException;
import java.text.MessageFormat;
import oracle.jsp.parse.JspBeanInfo;
import oracle.jsp.parse.JspDirectiveTaglibInfo;
import oracle.jsp.parse.JspEmitException;
import oracle.jsp.parse.JspEmitState;
import oracle.jsp.parse.JspFragment;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParsePosition;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspParseTag;
import oracle.jsp.parse.JspRTTag;
import oracle.jsp.parse.JspUtils;
import oracle.jsp.parse.OpenJspAVDesc;
import oracle.jsp.parse.OpenJspAVInfo;
import oracle.jsp.parse.OpenJspDefineItem;
import oracle.jsp.parse.OpenJspTagAttribute;
import oracle.jsp.parse.OpenJspTagElement;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Element;

public class OpenJspTagHandler
extends JspParseTag {
    public String nameSpace;
    public String htmlTag;
    public boolean bodyIsText;
    protected OpenJspAVInfo[] avInfo;
    private boolean emittedJspAttributesForThisTag = false;
    protected boolean classicTagsInFragmentClass = false;
    public static final String[] validScopes = new String[]{"page", "request", "session", "application"};
    public static final OpenJspAVDesc idDesc = new OpenJspAVDesc("id", 4, true);
    public static final OpenJspAVDesc scopeDesc = new OpenJspAVDesc("scope", 1, false, true, validScopes);
    public static final String[] validJmlTypes = new String[]{"string", "boolean", "number", "fpnumber"};
    private int blockScope = 0;

    public OpenJspTagHandler() {
        super(7);
    }

    public String getPrefix() {
        return this.nameSpace;
    }

    public String getNameSpaceURI(JspParseState st) {
        JspDirectiveTaglibInfo dtli = null;
        String prefixValue = null;
        if (this.xmlSrcElem != null) {
            String namespacePrefix = "#default";
            if (this.nameSpace != null && this.nameSpace.length() != 0) {
                namespacePrefix = this.nameSpace;
            }
            if ((prefixValue = ((XMLElement)this.xmlSrcElem).resolveNamespacePrefix(namespacePrefix)) != null) {
                dtli = (JspDirectiveTaglibInfo)st.jspDirectiveTaglibInfoTable.get(prefixValue);
            }
        } else {
            dtli = (JspDirectiveTaglibInfo)st.jspDirectiveTaglibInfoTable.get(this.nameSpace);
        }
        if (dtli == null) {
            return "http://java.sun.com/JSP/Page";
        }
        if (dtli.isTagDir()) {
            return dtli.getTagDir();
        }
        return dtli.getXMLStyleURI();
    }

    public boolean allowsBody() {
        return true;
    }

    public String getTagName() {
        return this.htmlTag;
    }

    public String getFullTagString() {
        return this.tagString;
    }

    public void setTagString(String tag) {
        super.setTagString(tag);
        int idx = tag.indexOf(58);
        this.nameSpace = idx == -1 || idx + 1 >= tag.length() ? "" : tag.substring(0, idx);
    }

    private void getAVInfo() {
        if (this.avInfo != null) {
            return;
        }
        OpenJspAVDesc[] desc = this.getAVDescriptions();
        if (desc == null || desc.length == 0) {
            this.avInfo = new OpenJspAVInfo[0];
        } else {
            this.avInfo = new OpenJspAVInfo[desc.length];
            for (int i = 0; i < desc.length; ++i) {
                this.avInfo[i] = new OpenJspAVInfo(desc[i]);
            }
        }
    }

    public void processAttributeValue(JspParseState st, int index, String name, String value) throws JspParseException {
        int idx;
        if (this.avInfo == null) {
            this.getAVInfo();
        }
        String attrPrefix = null;
        String attrNameAfterPrefix = null;
        if (this.xmlSrcElem != null && (idx = name.indexOf(":")) >= 0) {
            String prefixValue;
            attrPrefix = name.substring(0, idx);
            if (this.getPrefix().equals(attrPrefix)) {
                name = attrNameAfterPrefix = name.substring(idx + 1, name.length());
            } else if (name.equals("id") && attrPrefix != null && (prefixValue = ((XMLElement)st.curXmlSrcElem).resolveNamespacePrefix(attrPrefix)) != null && prefixValue.equals("http://java.sun.com/JSP/Page")) {
                return;
            }
        }
        for (int i = 0; i < this.avInfo.length; ++i) {
            if (!this.avInfo[i].desc.name.equals(name)) continue;
            if (this.avInfo[i].valueExists() && this.checkNameAttrInElement(this.avInfo[i].desc.name) && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("same_attr"), name)))) {
                return;
            }
            if (this.xmlSrcElem != null) {
                this.avInfo[i].setXMLViewValue(value, true);
                if (JspUtils.isELEvaluationOn(st)) {
                    this.avInfo[i].setHasEL(JspUtils.processELAttribute(st, value, this.avInfo[i]));
                    this.avInfo[i].setXMLSrcValue(st, JspUtils.decodeDollarEscape(value));
                } else {
                    this.avInfo[i].setXMLSrcValue(st, value);
                }
            } else {
                this.avInfo[i].setXMLViewValue(value, false);
                if (JspUtils.isELEvaluationOn(st)) {
                    this.avInfo[i].setHasEL(JspUtils.processELAttribute(st, value, this.avInfo[i]));
                    this.avInfo[i].setValue(st, JspUtils.decodeQuotes(value));
                } else {
                    this.avInfo[i].setValue(st, value);
                }
            }
            return;
        }
        if (this.xmlSrcElem != null && name.startsWith("xmlns")) {
            super.processAttributeValue(st, index, name, value);
            return;
        }
        if (this.addAttributeIfDynamic(st, name)) {
            this.processAttributeValue(st, index, name, value);
            return;
        }
        if (st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("bad_attr_name"), name)))) {
            return;
        }
    }

    protected boolean getScopeSensitive() {
        return true;
    }

    public void validateTagAttributes(JspParseState st) throws JspParseException {
        String scope;
        OpenJspAVInfo scopeInfo;
        JspParsePosition currParsePosition = null;
        if (this.positionSnapShotForValidation != null) {
            currParsePosition = st.getPosition();
            st.position = this.positionSnapShotForValidation;
        }
        if (this.avInfo == null) {
            this.getAVInfo();
        }
        this.scanForJspAttributes(st);
        for (int i = 0; i < this.avInfo.length; ++i) {
            if (!this.avInfo[i].desc.required || this.avInfo[i].valueExists() || this.avInfo[i].isJspAttribute() || !st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("need_attr"), this.avInfo[i].desc.name)))) continue;
            return;
        }
        String error = this.validateAttributeList(st, this.avInfo);
        if (error != null && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("bad_attr_list"), error)))) {
            return;
        }
        this.blockScope = this.defineBeans(st);
        if (this.getScopeSensitive() && (scopeInfo = this.findAV("scope")) != null && scopeInfo.valueExists() && (scope = scopeInfo.getStringValue()).equals("session") && !JspUtils.translateBoolean(st.getDirectiveAttrValue("page", "session"), true) && st.throwParseException(new JspParseException(st, msgs.getString("bad_session_scope")))) {
            return;
        }
        if (currParsePosition != null) {
            st.position = currParsePosition;
        }
    }

    private void scanForJspAttributes(JspParseState st) throws JspParseException {
        if (this.jspAttributes == null) {
            return;
        }
        int max = this.jspAttributes.size();
        for (int i = 0; i < max; ++i) {
            OpenJspTagAttribute tag = (OpenJspTagAttribute)this.jspAttributes.elementAt(i);
            this.validateJspAttributeList(tag, st);
        }
    }

    private boolean shouldCheckAttrPrefix(OpenJspTagAttribute tag) {
        if (tag.parent instanceof OpenJspTagElement) {
            return false;
        }
        return !(tag.parent instanceof JspRTTag) || !((JspRTTag)tag.parent).getTagInfo().hasDynamicAttributes();
    }

    private void validateJspAttributeList(OpenJspTagAttribute tag, JspParseState st) throws JspParseException {
        String name = tag.getName().trim();
        if (tag.getJspAttributePrefix() != null && this.shouldCheckAttrPrefix(tag)) {
            if (this.getPrefix().equals(tag.getJspAttributePrefix().trim())) {
                name = tag.getLocalName().trim();
            } else if (st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("bad_attr_name"), name)))) {
                return;
            }
        }
        for (int i = 0; i < this.avInfo.length; ++i) {
            if (!this.avInfo[i].desc.name.equals(name)) continue;
            if (this.avInfo[i].valueExists() && this.checkNameAttrInElement(this.avInfo[i].desc.name)) {
                if (!st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("same_attr"), name)))) continue;
                return;
            }
            tag.isFragment = this.avInfo[i].desc.isFragment;
            if (tag.isFragment && !tag.scriptless && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("no_scripting"), name)))) {
                return;
            }
            if (!this.avInfo[i].desc.canbeRequestTime() && !tag.isFragment) {
                if (!tag.onlyTemplateText && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("bad_jspattribute_requesttime"), name)))) {
                    return;
                }
                this.avInfo[i].setStringValue(tag.getTextString());
            } else {
                this.avInfo[i].setJspAttributeNode(tag);
            }
            return;
        }
        if (this.addAttributeIfDynamic(st, name)) {
            this.validateJspAttributeList(tag, st);
            return;
        }
        if (tag.parent instanceof OpenJspTagElement) {
            return;
        }
        if (st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("bad_attr_name"), name)))) {
            return;
        }
    }

    private boolean checkNameAttrInElement(String name) {
        return !name.equals("name") || !(this instanceof OpenJspTagElement) && (!(this instanceof OpenJspTagAttribute) || !(this.parent instanceof OpenJspTagElement));
    }

    private int defineBeans(JspParseState st) throws JspParseException {
        return this.defineBeans(st, this.getDefinedObjects());
    }

    private int defineAfterBeans(JspParseState st) throws JspParseException {
        return this.defineBeans(st, this.getDefinedAfterObjects());
    }

    private int defineBeans(JspParseState st, OpenJspDefineItem[] newBeans) throws JspParseException {
        boolean addedBeans = false;
        int bScope = 10;
        if (newBeans != null && newBeans.length > 0) {
            for (int i = 0; i < newBeans.length; ++i) {
                int scope;
                boolean duplicateBean = false;
                if (newBeans[i].getScope() != 0) {
                    if (st.beans.beanExists(newBeans[i].name)) {
                        if (st.parms.requestTimeIntrospection) {
                            duplicateBean = true;
                        } else if (st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("seen_bean"), newBeans[i].name)))) {
                            return 0;
                        }
                    }
                    scope = newBeans[i].getScope();
                } else {
                    if (!addedBeans) {
                        bScope = st.beans.getNextBlockScope();
                        addedBeans = true;
                    }
                    scope = bScope;
                }
                JspBeanInfo info = new JspBeanInfo(newBeans[i].name, newBeans[i].className, scope);
                if (!info.loadBean(st)) {
                    if (newBeans[i].isBeanDefinedFromType()) {
                        info.className = "java.lang.Object";
                    } else if (st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("no_bean_class"), newBeans[i].name, newBeans[i].className)))) {
                        return 0;
                    }
                }
                if (duplicateBean) {
                    info.setDuplicateBean(duplicateBean);
                    info.className = "java.lang.Object";
                }
                st.beans.addBean(info);
                newBeans[i].bean = info;
            }
        }
        if (addedBeans) {
            return bScope;
        }
        return 0;
    }

    private String getRegistrationTagName(JspParseState st, String name) {
        String nSpace = null;
        nSpace = st.curXmlSrcElem != null ? (this.nameSpace != null ? ((XMLElement)st.curXmlSrcElem).resolveNamespacePrefix(this.nameSpace) : ((XMLElement)st.curXmlSrcElem).resolveNamespacePrefix("#default")) : this.nameSpace;
        return nSpace + ":" + name;
    }

    private void registerHandlers(JspParseState st, String name, String className) {
        if (name.charAt(0) == ':') {
            name = name.substring(1);
        }
        String tagName = this.getRegistrationTagName(st, name);
        st.registerTagHandler(tagName, className);
    }

    private void unRegisterHandlers(JspParseState st, String name) {
        if (name.charAt(0) == ':') {
            name = name.substring(1);
        }
        String tagName = this.getRegistrationTagName(st, name);
        st.unRegisterTagHandler(tagName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseBody(JspParseState st) throws IOException, JspParseException {
        int i;
        String[] tagClasses = this.getSubTags();
        if (tagClasses != null && tagClasses.length > 0) {
            for (i = 0; i < tagClasses.length; i += 2) {
                this.registerHandlers(st, tagClasses[i], tagClasses[i + 1]);
            }
        }
        try {
            if (this.bodyIsText) {
                String str = this.parseBodyAsText(st);
                this.validateTextBody(st, str);
            } else {
                super.parseBody(st);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (tagClasses != null && tagClasses.length > 0) {
                for (i = 0; i < tagClasses.length; i += 2) {
                    this.unRegisterHandlers(st, tagClasses[i]);
                }
            }
            throw throwable;
        }
        if (tagClasses != null && tagClasses.length > 0) {
            for (i = 0; i < tagClasses.length; i += 2) {
                this.unRegisterHandlers(st, tagClasses[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseXMLSrcBody(JspParseState st) throws IOException, JspParseException {
        int i;
        String[] tagClasses = this.getSubTags();
        if (tagClasses != null && tagClasses.length > 0) {
            for (i = 0; i < tagClasses.length; i += 2) {
                this.registerHandlers(st, tagClasses[i], tagClasses[i + 1]);
            }
        }
        try {
            super.parseXMLSrcBody(st);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (tagClasses != null && tagClasses.length > 0) {
                for (i = 0; i < tagClasses.length; i += 2) {
                    this.unRegisterHandlers(st, tagClasses[i]);
                }
            }
            throw throwable;
        }
        if (tagClasses != null && tagClasses.length > 0) {
            for (i = 0; i < tagClasses.length; i += 2) {
                this.unRegisterHandlers(st, tagClasses[i]);
            }
        }
    }

    public String parseBodyAsText(JspParseState st) throws IOException, JspParseException {
        StringBuffer sb = new StringBuffer(128);
        if (st.getLine() == null || st.getLine().length() == 0) {
            st.ReadLine();
        }
        String terminateStr = "</" + this.tagString + ">";
        while (st.getLine() != null) {
            int idx = st.getLine().indexOf(terminateStr);
            if (idx != -1) {
                if (idx > 0) {
                    sb.append(st.getLine().substring(0, idx));
                }
                this.endLineNumber = st.position.lineNum;
                this.endColumnNumber = st.getColNum() + idx + terminateStr.length();
                if (idx + terminateStr.length() >= st.getLine().length()) {
                    st.clearLine();
                } else {
                    st.advLine(idx + terminateStr.length());
                }
                return sb.toString();
            }
            sb.append(st.getLine());
            st.clearLine();
            if (st.getLine() != null && st.getLine().length() != 0) continue;
            st.ReadLine();
        }
        if (st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("no_end_tag"), terminateStr)))) {
            return null;
        }
        return null;
    }

    protected void parse(JspParseState st) throws IOException, JspParseException {
        int afterScope;
        super.parse(st);
        if (this.blockScope > 0) {
            st.beans.killBlockScope(this.blockScope);
        }
        if ((afterScope = this.defineAfterBeans(st)) > 0) {
            st.beans.killBlockScope(afterScope);
        }
    }

    public void emitJspAttributes(JspEmitState st) throws JspEmitException {
        if (this.emittedJspAttributesForThisTag || this.avInfo == null || this instanceof OpenJspTagElement) {
            return;
        }
        for (int i = 0; i < this.avInfo.length; ++i) {
            if (!this.avInfo[i].isJspAttribute()) continue;
            OpenJspTagAttribute tag = this.avInfo[i].getJspAttributeNode();
            if (tag != null) {
                tag.emit(st);
            }
            this.avInfo[i].setStringValue(tag.getVariableName(st));
        }
        this.emittedJspAttributesForThisTag = true;
    }

    public void emitTagStart(JspEmitState st) throws JspEmitException {
        try {
            this.emitJspAttributes(st);
            this.emitStart(st);
        }
        catch (Throwable e) {
            throw new JspEmitException(MessageFormat.format(msgs.getString("emit_error"), this.htmlTag, e.getMessage()));
        }
    }

    public void emitTagEnd(JspEmitState st) throws JspEmitException {
        try {
            this.emitEnd(st);
        }
        catch (Throwable e) {
            throw new JspEmitException(MessageFormat.format(msgs.getString("emit_end_error"), this.htmlTag, e.getMessage()));
        }
    }

    public OpenJspAVInfo getAV(int index) {
        if (this.avInfo == null) {
            this.getAVInfo();
        }
        if (index < 0 || index >= this.avInfo.length) {
            return null;
        }
        return this.avInfo[index];
    }

    public OpenJspAVInfo findAV(String name) {
        if (this.avInfo == null) {
            this.getAVInfo();
        }
        for (int i = 0; i < this.avInfo.length; ++i) {
            if (!this.avInfo[i].desc.name.equals(name)) continue;
            return this.avInfo[i];
        }
        return null;
    }

    public OpenJspAVDesc[] getAVDescriptions() {
        return null;
    }

    public OpenJspDefineItem[] getDefinedObjects() {
        return null;
    }

    public OpenJspDefineItem[] getDefinedAfterObjects() {
        return null;
    }

    public String validateAttributeList(JspParseState st, OpenJspAVInfo[] avList) {
        return null;
    }

    public void validateTextBody(JspParseState st, String bodyText) throws JspParseException {
    }

    public String[] getSubTags() {
        return null;
    }

    public void emitStart(JspEmitState st) {
    }

    public void emitEnd(JspEmitState st) {
    }

    public Element toXMLElement(JspParseState st) {
        String xmlStyleNSURI = this.getNameSpaceURI(st);
        Element e = st.xvd.createElementNS(xmlStyleNSURI, this.getFullTagString());
        JspUtils.setJspIdInXMLView(st, e, this);
        for (int i = 0; i < this.avInfo.length; ++i) {
            String xsv = this.avInfo[i].getXMLStyleStringValue();
            if (xsv == null) continue;
            e.setAttributeNS(null, this.avInfo[i].desc.name, xsv);
        }
        this.xmlview_element = e;
        this.addBodyElementTo(e, st);
        return e;
    }

    protected JspFragment generateJspFragment(JspEmitState st, String tagVarName) {
        st.parseState.initialiseFragmentSupportClass();
        JspFragment fragment = st.parseState.fragmentSupportClass.createFragment(this, tagVarName);
        String varRes = "__ojsp_varRes";
        if (st.parseState.parms.elIgnored) {
            varRes = "null";
        }
        st.print("new " + st.parseState.fragmentSupportClass.getClassName() + "( " + fragment.getFragId() + ", pageContext, " + tagVarName + ", " + varRes);
        if (this instanceof JspRTTag || this instanceof OpenJspTagAttribute) {
            OpenJspTagHandler tag = this;
            if (tag.classicTagsInFragmentClass) {
                st.print(", __ojsp_classicTags");
            }
        }
        st.print(")");
        return fragment;
    }

    public boolean addAttributeIfDynamic(JspParseState st, String name) {
        return false;
    }
}

