/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.deployment.JspConfigDescriptor;
import com.evermind.server.http.deployment.OJSPConfigDescriptor;
import com.evermind.server.http.deployment.ServletMapping;
import com.evermind.util.ByteString;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.tagext.FunctionInfo;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import oracle.jsp.parse.JspAttributeValuePiece;
import oracle.jsp.parse.JspDirective;
import oracle.jsp.parse.JspDirectiveTaglibInfo;
import oracle.jsp.parse.JspEmitState;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspParseTag;
import oracle.jsp.parse.JspParseTagText;
import oracle.jsp.parse.OpenJspAVDesc;
import oracle.jsp.parse.OpenJspAVInfo;
import oracle.jsp.parse.OracleJsp2Java;
import oracle.jsp.util.JspUtil;
import oracle.xml.parser.v2.XMLElement;
import org.apache.commons.el.Expression;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class JspUtils {
    private static final String MSG_FILE = "oracle.jsp.parse.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.parse.LocalStrings");
    public static final String JSP_SPEC_SUPPORTED_VERSION = "2.0";
    public static String evstr1 = " (java.lang.String)oracle.jsp.runtime.OracleJspRuntime.evaluate(";
    public static String evstr2 = ",java.lang.String.class, __ojsp_varRes, null)";
    public static String evstr3 = ",java.lang.String.class, __ojsp_varRes, __ojsp_fnmappers[";
    public static String evstr4 = "])";
    static boolean lookingForEnd = false;
    private static final String[] elReservedWords = new String[]{"and", "div", "empty", "eq", "false", "ge", "gt", "instanceof", "le", "lt", "mod", "ne", "not", "null", "or", "true"};

    public static boolean translateBoolean(String s, boolean defValue) {
        if (s == null) {
            return defValue;
        }
        if ((s = s.trim()).equalsIgnoreCase("true")) {
            return true;
        }
        if (s.equalsIgnoreCase("false")) {
            return false;
        }
        return defValue;
    }

    public static boolean isBoolean(String s) {
        if (s == null) {
            return false;
        }
        if ((s = s.trim()).equalsIgnoreCase("true")) {
            return true;
        }
        return s.equalsIgnoreCase("false");
    }

    public static boolean isTagWhitespace(JspParseTag tag) {
        if (JspParseTagText.class.isInstance(tag) && !tag.hasBody()) {
            String s = tag.toString();
            return (s = s.trim()).length() == 0;
        }
        return false;
    }

    public static String trimBeginningWhite(String str) {
        int max = str.length();
        for (int idx = 0; idx < max; ++idx) {
            if (Character.isWhitespace(str.charAt(idx))) continue;
            if (idx > 0) {
                return str.substring(idx);
            }
            return str;
        }
        return "";
    }

    public static String trimTrailingWhite(String str) {
        for (int index = str.length(); index > 0; --index) {
            if (Character.isWhitespace(str.charAt(index - 1))) continue;
            return str.substring(0, index);
        }
        return "";
    }

    public static String extractContentType(String ct) {
        if (ct == null || ct.length() == 0) {
            return "text/html";
        }
        int idx = ct.indexOf(59);
        if (idx != -1) {
            return ct.substring(0, idx);
        }
        return ct;
    }

    public static String extractEncoding(String ct) {
        int idx;
        if (ct != null && (idx = ct.indexOf(59)) != -1 && idx + 1 < ct.length()) {
            ct = ct.substring(idx + 1);
            if ((ct = ct.trim()).startsWith("charset") && (ct = ct.substring(7).trim()).charAt(0) == '=' && (ct = ct.substring(1).trim()).length() > 0) {
                return ct;
            }
        }
        return null;
    }

    public static boolean isMismatchEncoding(String enc1, String enc2) {
        if (enc1 == null || enc2 == null) {
            return false;
        }
        String IANAenc1 = JspUtil.convIANAtoJavaEncoding(enc1, false);
        String IANAenc2 = JspUtil.convIANAtoJavaEncoding(enc2, false);
        return !enc1.equalsIgnoreCase(enc2) && !enc1.equalsIgnoreCase(IANAenc2) && (IANAenc1 == null || !IANAenc1.equalsIgnoreCase(enc2)) && (IANAenc1 == null || !IANAenc1.equalsIgnoreCase(IANAenc2));
    }

    public static ClassLoader getCurrentThreadClassLoader() {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return cl;
        }
        catch (Throwable th) {
            return null;
        }
    }

    public static Class loadClass(String className, JspParseState st) {
        return JspUtils.loadClassJDK(className, st);
    }

    private static Class loadClassJDK(String className, JspParseState st) {
        Class cls = null;
        try {
            ClassLoader curLoader = JspUtils.getCurrentThreadClassLoader();
            if (curLoader != null) {
                cls = curLoader.loadClass(className);
            }
            if (cls != null) {
                if (st != null) {
                    st.dbgPrintln(MessageFormat.format(msgs.getString("dbg_class_load"), className));
                    st.addBeanDependency(cls.getName());
                }
                return cls;
            }
        }
        catch (ClassNotFoundException e) {
            cls = null;
        }
        try {
            cls = Class.forName(className);
            if (cls != null) {
                if (st != null) {
                    st.dbgPrintln(MessageFormat.format(msgs.getString("dbg_class_load"), className));
                    st.addBeanDependency(cls.getName());
                }
                return cls;
            }
        }
        catch (ClassNotFoundException e) {
            cls = null;
        }
        ClassLoader myLoader = OracleJsp2Java.class.getClassLoader();
        if (myLoader != null) {
            if (st != null) {
                st.dbgPrintln(MessageFormat.format(msgs.getString("dbg_try_class_load"), className));
            }
            try {
                cls = myLoader.loadClass(className);
                if (cls != null) {
                    if (st != null) {
                        st.dbgPrintln(MessageFormat.format(msgs.getString("dbg_class_loaded"), className));
                        st.addBeanDependency(cls.getName());
                    }
                    return cls;
                }
            }
            catch (ClassNotFoundException e) {
                cls = null;
            }
        }
        if (st != null && st.parms.classLoader != null) {
            st.dbgPrintln(MessageFormat.format(msgs.getString("dbg_try_class_load2"), className));
            try {
                cls = st.parms.classLoader.loadClass(className);
                if (cls != null) {
                    st.dbgPrintln(MessageFormat.format(msgs.getString("dbg_class_loaded2"), className));
                    st.addBeanDependency(cls.getName());
                    return cls;
                }
            }
            catch (ClassNotFoundException e) {
                cls = null;
            }
        }
        if (st != null && st.parms.tagFilePageTable != null && st.parms.tagFilePageTable.classLoader != null) {
            st.dbgPrintln(MessageFormat.format(msgs.getString("dbg_try_class_load2"), className));
            try {
                cls = st.parms.tagFilePageTable.classLoader.loadClass(className);
                if (cls != null) {
                    st.dbgPrintln(MessageFormat.format(msgs.getString("dbg_class_loaded2"), className));
                    st.addBeanDependency(cls.getName());
                    return cls;
                }
            }
            catch (ClassNotFoundException e) {
                cls = null;
            }
        }
        return null;
    }

    public static String getCanonicalName(Class c) {
        String binaryName = c.getName();
        if ((c = c.getDeclaringClass()) == null) {
            return binaryName;
        }
        StringBuffer buf = new StringBuffer(binaryName);
        do {
            buf.setCharAt(c.getName().length(), '.');
        } while ((c = c.getDeclaringClass()) != null);
        return buf.toString();
    }

    public static final Hashtable cloneDirectives(Hashtable in) {
        if (in == null) {
            return null;
        }
        Hashtable out = new Hashtable();
        Enumeration keys = in.keys();
        try {
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                JspDirective element = (JspDirective)in.get(key);
                out.put(key, element.clone());
            }
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        return out;
    }

    private static Object getDefaultConstant(Class type) {
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return new Boolean(false);
        }
        if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
            return new Byte(0);
        }
        if (type.equals(Character.TYPE) || type.equals(Character.class)) {
            return new Character('\u0000');
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return new Double(0.0);
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return new Integer(0);
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return new Float(0.0f);
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return new Long(0L);
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class)) {
            return new Short(0);
        }
        if (String.class.isAssignableFrom(type) || type.equals(Object.class)) {
            return new String("\"\"");
        }
        return null;
    }

    public static Object convertConstant(String qVal, Class type) {
        try {
            String val = qVal.substring(1, qVal.length() - 1);
            if (val.length() == 0) {
                return JspUtils.getDefaultConstant(type);
            }
            if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
                return Boolean.valueOf(val);
            }
            if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
                return Byte.valueOf(val);
            }
            if (type.equals(Character.TYPE) || type.equals(Character.class)) {
                return new Character(val.charAt(0));
            }
            if (type.equals(Double.TYPE) || type.equals(Double.class)) {
                return Double.valueOf(val);
            }
            if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                return Integer.valueOf(val);
            }
            if (type.equals(Float.TYPE) || type.equals(Float.class)) {
                return Float.valueOf(val);
            }
            if (type.equals(Long.TYPE) || type.equals(Long.class)) {
                return Long.valueOf(val);
            }
            if (type.equals(Short.TYPE) || type.equals(Short.class)) {
                return Short.valueOf(val);
            }
            if (String.class.isAssignableFrom(type)) {
                return qVal;
            }
            if (type.equals(Object.class)) {
                return qVal;
            }
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String convertExpression(String inValue, Class type) {
        String v = type.equals(Integer.TYPE) ? "OracleJspRuntime.toInt( " + inValue + ")" : (type == Integer.class ? "OracleJspRuntime.toIntObject(" + inValue + ")" : (type == String.class ? "OracleJspRuntime.toStr( " + inValue + ")" : (type.equals(Boolean.TYPE) ? "OracleJspRuntime.toBoolean( " + inValue + ")" : (type == Boolean.class ? "OracleJspRuntime.toBooleanObject(" + inValue + ")" : (type == Byte.TYPE ? "OracleJspRuntime.toByte( " + inValue + ")" : (type == Byte.class ? "OracleJspRuntime.toByteObject(" + inValue + ")" : (type == Character.TYPE ? "OracleJspRuntime.toCharacter( " + inValue + ")" : (type == Character.class ? "OracleJspRuntime.toCharacterObject(" + inValue + ")" : (type == Short.TYPE ? "OracleJspRuntime.toShort( " + inValue + ")" : (type == Short.class ? "OracleJspRuntime.toShortObject(" + inValue + ")" : (type == Double.TYPE ? "OracleJspRuntime.toDouble( " + inValue + ")" : (type == Double.class ? "OracleJspRuntime.toDoubleObject(" + inValue + ")" : (type == Float.TYPE ? "OracleJspRuntime.toFloat( " + inValue + ")" : (type == Float.class ? "OracleJspRuntime.toFloatObject(" + inValue + ")" : (type == Long.TYPE ? "OracleJspRuntime.toLong( " + inValue + ")" : (type == Long.class ? "OracleJspRuntime.toLongObject(" + inValue + ")" : inValue))))))))))))))));
        return v;
    }

    public static boolean valueIsQuoted(String value) {
        if (value.startsWith("\"") && value.endsWith("\"") && value.length() >= 2) {
            int idx;
            int max = value.length() - 1;
            for (idx = 1; idx < max; ++idx) {
                if (value.charAt(idx) == '\"') {
                    return false;
                }
                if (value.charAt(idx) != '\\') continue;
                ++idx;
            }
            return idx == max;
        }
        return false;
    }

    public static String decodeQuotes(String text) {
        StringBuffer sb = new StringBuffer();
        int max = text.length();
        boolean escape = false;
        for (int i = 0; i < max; ++i) {
            char ch = text.charAt(i);
            if (!escape) {
                if (ch == '\\') {
                    escape = true;
                    continue;
                }
                sb.append(ch);
                escape = false;
                continue;
            }
            sb.append(ch);
            escape = false;
        }
        text = sb.toString();
        return text;
    }

    public static String decodeDollarEscape(String text) {
        StringBuffer sb = new StringBuffer();
        int max = text.length();
        boolean escape = false;
        for (int i = 0; i < max; ++i) {
            char ch = text.charAt(i);
            if (ch == '\\' && i < max - 1 && text.charAt(i + 1) == '$') continue;
            sb.append(ch);
        }
        text = sb.toString();
        return text;
    }

    public static String getBooleanString(boolean val) {
        if (val) {
            return "true";
        }
        return "false";
    }

    public static int translateBufferSize(String buffer) {
        int sz;
        if (buffer == null) {
            return -2;
        }
        boolean kbSpecified = false;
        buffer = buffer.trim();
        if ((buffer = buffer.toLowerCase()).equals("none")) {
            return 0;
        }
        if (buffer.endsWith("kb")) {
            if (buffer.length() < 3) {
                return -1;
            }
            buffer = buffer.substring(0, buffer.length() - 2).trim();
            kbSpecified = true;
        }
        if (buffer.endsWith("k")) {
            if (buffer.length() < 2) {
                return -1;
            }
            buffer = buffer.substring(0, buffer.length() - 1).trim();
            kbSpecified = true;
        }
        if (buffer.length() == 0) {
            return -1;
        }
        try {
            sz = Integer.valueOf(buffer);
            if (kbSpecified) {
                sz *= 1024;
            } else if (sz < 128) {
                sz *= 1024;
            }
        }
        catch (NumberFormatException e) {
            sz = -1;
        }
        return sz;
    }

    public static String scopeStrToPageContextStr(String scope) {
        if (scope.equalsIgnoreCase("request")) {
            return "PageContext.REQUEST_SCOPE";
        }
        if (scope.equalsIgnoreCase("session")) {
            return "PageContext.SESSION_SCOPE";
        }
        if (scope.equalsIgnoreCase("application")) {
            return "PageContext.APPLICATION_SCOPE";
        }
        return "PageContext.PAGE_SCOPE";
    }

    public static String getValidScopeNS(String scope) {
        if (scope.equalsIgnoreCase("request")) {
            return "request";
        }
        if (scope.equalsIgnoreCase("session")) {
            return "session";
        }
        if (scope.equalsIgnoreCase("application")) {
            return "application";
        }
        return "pageContext";
    }

    public static void emitDeclaration(JspEmitState st, String id, String scope, String type, String className, String beanName, OpenJspAVInfo beanAv) {
        st.iprintln(type + " " + id + ";");
        st.iprintln("synchronized (" + JspUtils.getValidScopeNS(scope) + ") {");
        st.indent();
        st.iprintln("if ((" + id + " = (" + type + ") pageContext.getAttribute( \"" + id + "\", " + JspUtils.scopeStrToPageContextStr(scope) + ")) == null) {");
        st.indent();
        if (className != null) {
            st.iprintln(id + " = (" + type + ") new " + className + "();");
            st.iprintln("pageContext.setAttribute( \"" + id + "\", " + id + ", " + JspUtils.scopeStrToPageContextStr(scope) + ");");
        } else if (beanName != null) {
            if (JspUtils.isELEvaluationOn(st) && beanAv.attributeValueHasEL()) {
                st.iprintln(id + " = (" + type + ") java.beans.Beans.instantiate( this.getClass().getClassLoader(), " + JspUtils.getELAttributeEmitString(st, beanAv, false) + ");");
            } else {
                st.iprintln(id + " = (" + type + ") java.beans.Beans.instantiate( this.getClass().getClassLoader(), " + beanName + ");");
            }
            st.iprintln("pageContext.setAttribute( \"" + id + "\", " + id + ", " + JspUtils.scopeStrToPageContextStr(scope) + ");");
        } else {
            st.iprintln("throw new InstantiationException(\"" + JspParseTag.sanitizeQuotedString(MessageFormat.format(msgs.getString("bean_not_in_scope"), id, scope)) + "\");");
        }
    }

    public static void emitEndDeclaration(JspEmitState st) {
        st.undent();
        st.iprintln("}");
        st.undent();
        st.iprintln("}");
    }

    public static void addImport(String className, JspParseState st) {
        boolean imported = false;
        int len = 0;
        int index = 0;
        String[] a = new String[]{};
        if (st.parms.imports != null) {
            int i;
            len = st.parms.imports.length;
            for (i = 0; i < len; ++i) {
                if (!className.equals(st.parms.imports[i])) continue;
                imported = true;
            }
            if (imported) {
                return;
            }
            a = new String[len + 1];
            for (i = 0; i < len; ++i) {
                a[i] = st.parms.imports[i];
            }
            index = len;
        } else {
            a = new String[1];
        }
        a[index] = className;
        st.parms.imports = a;
    }

    public static String handlePagePath(String pageBase, String oPath) {
        if (!oPath.startsWith("/") && pageBase != null) {
            oPath = pageBase.endsWith("/") ? pageBase + oPath : pageBase + "/" + oPath;
        }
        oPath = JspUtil.handleDotsInPath(oPath, '/');
        return oPath;
    }

    public static PropertyEditor findPropertyEditorClass(PropertyDescriptor pd) throws IntrospectionException {
        try {
            Class<?> propertyEditorClass = pd.getPropertyEditorClass();
            if (propertyEditorClass == null) {
                Class<?> propType = pd instanceof IndexedPropertyDescriptor ? ((IndexedPropertyDescriptor)pd).getIndexedPropertyType() : pd.getPropertyType();
                if (!JspUtils.isTrivialType(propType)) {
                    return PropertyEditorManager.findEditor(propType);
                }
                return null;
            }
            return (PropertyEditor)propertyEditorClass.newInstance();
        }
        catch (Exception e) {
            throw new IntrospectionException(MessageFormat.format(msgs.getString("propertyEditor_setup_failure"), pd.getName(), e.toString()));
        }
    }

    public static Object getValueFromPropertyEditor(String attrName, String attrClass, String value, PropertyEditor propEditorObj) throws IntrospectionException {
        try {
            propEditorObj.setAsText(value);
            return propEditorObj.getValue();
        }
        catch (Exception e) {
            throw new IntrospectionException(MessageFormat.format(msgs.getString("no_convert_to_class"), value, attrClass, attrName, e));
        }
    }

    public static boolean isBasicType(Class type) {
        return type.equals(Boolean.class) || type.equals(Double.class) || type.equals(Integer.class) || type.equals(Float.class) || type.equals(Short.class) || type.equals(Long.class) || type.equals(Byte.class) || type.equals(Character.class);
    }

    public static boolean isTrivialType(Class type) {
        return type == null || type.equals(String.class) || type.equals(Object.class) || type.isPrimitive() || JspUtils.isBasicType(type);
    }

    private static void parseELInAttributeValue(JspParseState st, StringBuffer sbuf) throws JspParseException {
        block23: {
            st.attributeValueElPieces = new ArrayList();
            String str = null;
            int elStartLine = 0;
            int currLine = 0;
            int currPos = 0;
            int elEnd = 0;
            int elStart = 0;
            StringBuffer tempBuf = new StringBuffer();
            StringBuffer tempELBuf = new StringBuffer();
            lookingForEnd = false;
            boolean lookForEndQuote = false;
            boolean foundEscape = false;
            boolean hasEL = false;
            int ridx = 0;
            do {
                str = null;
                StringBuffer s = new StringBuffer();
                while (ridx < sbuf.length()) {
                    s.append(sbuf.charAt(ridx));
                    if (sbuf.charAt(ridx) == '\n') {
                        ++ridx;
                        break;
                    }
                    if (sbuf.charAt(ridx) == '\r' && ridx < sbuf.length() - 1 && sbuf.charAt(ridx + 1) == '\n') {
                        s.append(sbuf.charAt(++ridx));
                        ++ridx;
                        break;
                    }
                    if (sbuf.charAt(ridx) == '\r') {
                        ++ridx;
                        break;
                    }
                    ++ridx;
                }
                if ((str = s.length() == 0 ? null : s.toString()) == null) break;
                for (currPos = 0; currPos < str.length(); ++currPos) {
                    if (str.charAt(currPos) == '$' && currPos < str.length() - 1 && str.charAt(currPos + 1) == '{') {
                        foundEscape = JspUtils.isELEscaped(str, currPos, st.parms.xmlStyleSrc);
                        if (!foundEscape) {
                            lookingForEnd = true;
                        } else {
                            tempBuf.setLength(tempBuf.length() - 1);
                        }
                    }
                    if (lookingForEnd) {
                        tempELBuf = tempELBuf.append(str.charAt(currPos));
                    } else {
                        tempBuf = tempBuf.append(str.charAt(currPos));
                    }
                    if (str.charAt(currPos) == '$' && currPos < str.length() - 1 && str.charAt(currPos + 1) == '{' && !JspUtils.isELEscaped(str, currPos, st.parms.xmlStyleSrc)) {
                        elStart = currPos;
                        lookingForEnd = true;
                        if (tempBuf.length() != 0) {
                            st.attributeValueElPieces.add(new JspAttributeValuePiece(false, tempBuf.toString(), foundEscape));
                            foundEscape = false;
                            tempBuf.delete(0, tempBuf.length());
                        }
                        tempELBuf.append(str.charAt(++currPos));
                    }
                    char currChar = str.charAt(currPos);
                    if (lookingForEnd && currPos < str.length() && (currChar == '\'' || currChar == '\"')) {
                        lookForEndQuote = !lookForEndQuote;
                    }
                    if (!lookingForEnd || lookForEndQuote || currPos >= str.length() || str.charAt(currPos) != '}') continue;
                    lookingForEnd = false;
                    hasEL = true;
                    st.attributeValueElPieces.add(new JspAttributeValuePiece(true, tempELBuf.toString(), false));
                    JspAttributeValuePiece j = (JspAttributeValuePiece)st.attributeValueElPieces.get(st.attributeValueElPieces.size() - 1);
                    tempELBuf.delete(0, tempELBuf.length());
                }
                ++currLine;
            } while (str != null);
            if (lookingForEnd) {
                if (st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("incomplete_el_expr"), new Integer(elStart), new Integer(elStartLine))))) {
                    return;
                }
            } else if ((hasEL || foundEscape) && tempBuf.length() > 0) {
                st.attributeValueElPieces.add(new JspAttributeValuePiece(false, tempBuf.toString(), foundEscape));
            }
            try {
                if (st.attributeValueElPieces != null && st.attributeValueElPieces.size() > 0) {
                    for (int i = 0; i < st.attributeValueElPieces.size(); ++i) {
                        Object ret;
                        JspAttributeValuePiece j = (JspAttributeValuePiece)st.attributeValueElPieces.get(i);
                        String temp = JspUtils.decodeQuotes(j.getPiece());
                        boolean mightBeFunction = false;
                        if (temp.indexOf("(") != -1 && temp.indexOf(")") != -1) {
                            mightBeFunction = true;
                        }
                        if (!j.isELPiece() || !((ret = st.elEvaluator.parseExpressionString(JspUtils.decodeQuotes(j.getPiece()))) instanceof Expression)) continue;
                        j.elFunctionNum = JspUtils.setFunctionInfo(st, j.getPiece());
                        if (j.elFunctionNum == -1) continue;
                        j.isElFunction = true;
                    }
                }
            }
            catch (ELException el) {
                if (!st.throwParseException(new JspParseException(st, (Throwable)el))) break block23;
                return;
            }
        }
    }

    public static boolean isELEscaped(String str, int pos, boolean xmlSrc) {
        boolean escaped = false;
        if (str.charAt(pos) == '$' && pos < str.length() - 1 && str.charAt(pos + 1) == '{') {
            if (xmlSrc) {
                if (pos != 0 && str.charAt(pos - 1) == '\\') {
                    escaped = true;
                }
            } else {
                int checked = 0;
                int contigEscapeChars = 0;
                do {
                    if (pos - ++checked <= -1 || str.charAt(pos - checked) != '\\') continue;
                    ++contigEscapeChars;
                } while (checked < pos && str.charAt(pos - checked) == '\\');
                if (contigEscapeChars % 2 != 0) {
                    escaped = true;
                }
            }
            if (!escaped) {
                lookingForEnd = true;
            }
        }
        return escaped;
    }

    public static boolean isItMixed(ArrayList pieces) {
        return pieces == null || pieces.size() != 1 || !((JspAttributeValuePiece)pieces.get(0)).isELPiece();
    }

    public static boolean hasEscapingText(JspParseState st) {
        boolean foundEscapingText = false;
        if (st.attributeValueElPieces != null) {
            for (int i = 0; i < st.attributeValueElPieces.size(); ++i) {
                JspAttributeValuePiece j = (JspAttributeValuePiece)st.attributeValueElPieces.get(i);
                if (!j.isEscapingText()) continue;
                foundEscapingText = true;
            }
        }
        return foundEscapingText;
    }

    public static boolean hasProcessedEL(JspParseState st) {
        boolean foundEL = false;
        if (st.attributeValueElPieces != null) {
            for (int i = 0; i < st.attributeValueElPieces.size(); ++i) {
                JspAttributeValuePiece j = (JspAttributeValuePiece)st.attributeValueElPieces.get(i);
                if (!j.isELPiece()) continue;
                foundEL = true;
            }
        }
        return foundEL;
    }

    private static boolean hasELWithCreation(JspParseState st, String str, OpenJspAVInfo avInfo) throws JspParseException {
        boolean ELpresent = false;
        OpenJspAVDesc desc = avInfo.desc;
        if (str.indexOf("${") == -1) {
            return false;
        }
        JspUtils.parseELInAttributeValue(st, new StringBuffer(str));
        ELpresent = JspUtils.hasProcessedEL(st);
        if (ELpresent && !desc.canbeRequestTime() && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("el_in_nonrtexpr"), desc.name)))) {
            return false;
        }
        return ELpresent;
    }

    public static boolean isELEvaluationOn(JspParseState st) {
        return !st.parms.elIgnored;
    }

    public static boolean isELEvaluationOn(JspEmitState st) {
        return !st.parms.elIgnored;
    }

    public static boolean processELAttribute(JspParseState st, String val, OpenJspAVInfo avInfo) throws JspParseException {
        return JspUtils.isELEvaluationOn(st) && JspUtils.hasELWithCreation(st, val, avInfo);
    }

    public static StringBuffer getELMixedText(OpenJspAVInfo avinfo) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < avinfo.stringValueElPieces.size(); ++i) {
            JspAttributeValuePiece avp = (JspAttributeValuePiece)avinfo.stringValueElPieces.get(i);
            if (avp.isELPiece()) {
                if (avp.isElFunction) {
                    sb.append(evstr1 + "\"" + avp.getPiece() + "\"" + evstr3 + avp.elFunctionNum + evstr4 + "+");
                    continue;
                }
                sb.append(evstr1 + "\"" + avp.getPiece() + "\"" + evstr2 + "+");
                continue;
            }
            sb.append("\"" + avp.getPiece() + "\"+");
        }
        sb.setLength(sb.length() - 1);
        return sb;
    }

    public static String getELAttributeEmitString(JspEmitState st, OpenJspAVInfo avinfo, boolean needQuote) {
        String result = null;
        if (JspUtils.isELEvaluationOn(st.parseState) && avinfo.attributeValueHasEL()) {
            if (JspUtils.isItMixed(avinfo.stringValueElPieces)) {
                StringBuffer elMixedText = JspUtils.getELMixedText(avinfo);
                result = elMixedText.toString();
            } else {
                String end = null;
                end = avinfo.stringValueElPieces.size() == 1 && ((JspAttributeValuePiece)avinfo.stringValueElPieces.get((int)0)).isElFunction ? evstr3 + ((JspAttributeValuePiece)avinfo.stringValueElPieces.get((int)0)).elFunctionNum + evstr4 : evstr2;
                result = needQuote ? evstr1 + "\"" + avinfo.getExpression() + "\"" + end : evstr1 + avinfo.getExpression() + end;
            }
        }
        return result;
    }

    protected static Object validateELSyntax(JspParseState st, StringBuffer sb) throws ELException {
        Object ret = st.elEvaluator.parseExpressionString(sb.toString());
        return st.elEvaluator.parseExpressionString(sb.toString());
    }

    protected static FunctionInfo getFunctionInfo(JspParseState st, JspDirectiveTaglibInfo dtli, String fName) throws JspParseException {
        FunctionInfo[] functionList = dtli.rtTagLibObj.getFunctions();
        for (int i = 0; i < functionList.length; ++i) {
            String name = functionList[i].getName();
            if (!name.equals(fName)) continue;
            return functionList[i];
        }
        return null;
    }

    protected static int setFunctionInfo(JspParseState st, String str) throws JspParseException {
        int functionMappingNum = -1;
        String funcName = null;
        String elFunctionPrefix = null;
        String prefixValue = null;
        int colonIdx = -1;
        JspDirectiveTaglibInfo jdti = null;
        String key = null;
        Hashtable funcs = JspUtils.obtainAllFuncsInExpr(st, str.substring(2, str.length() - 1));
        if (funcs == null || funcs.size() == 0) {
            return -1;
        }
        functionMappingNum = JspUtils.functionSetSeen(st, funcs);
        if (functionMappingNum != -1) {
            return functionMappingNum;
        }
        Enumeration e = funcs.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            colonIdx = key.indexOf(":");
            elFunctionPrefix = key.substring(0, colonIdx);
            if (st.curXmlSrcElem != null) {
                prefixValue = key.substring(colonIdx + 1, key.lastIndexOf(":"));
                funcName = key.substring(key.lastIndexOf(":") + 1, key.length());
            } else {
                funcName = key.substring(colonIdx + 1, key.length());
                prefixValue = null;
            }
            jdti = st.curXmlSrcElem != null ? (JspDirectiveTaglibInfo)st.jspDirectiveTaglibInfoTable.get(prefixValue) : (JspDirectiveTaglibInfo)st.jspDirectiveTaglibInfoTable.get(elFunctionPrefix);
            if (jdti == null && st.curXmlSrcElem == null && st.prevXmlSrcElem != null && (prefixValue = ((XMLElement)st.prevXmlSrcElem).resolveNamespacePrefix(elFunctionPrefix)) != null) {
                jdti = (JspDirectiveTaglibInfo)st.jspDirectiveTaglibInfoTable.get(prefixValue);
            }
            FunctionInfo fInfo = null;
            if (jdti != null) {
                fInfo = JspUtils.getFunctionInfo(st, jdti, funcName);
                if (fInfo == null) {
                    String f = elFunctionPrefix.equals("#default") ? funcName : elFunctionPrefix + ":" + funcName;
                    String v = null;
                    if (st.curXmlSrcElem != null) {
                        v = prefixValue;
                    } else {
                        String string = v = jdti.isTagDir() ? jdti.getTagDir() : jdti.uri;
                    }
                    if (st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("unknown_function"), f, v)))) {
                        return -1;
                    }
                }
                funcs.put(key, fInfo);
                continue;
            }
            Object[] objectArray = new Object[1];
            Object object = objectArray[0] = elFunctionPrefix.equals("#default") ? funcName : elFunctionPrefix + ":" + funcName;
            if (!st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("func_bad_prefix_no_default_ns"), objectArray)))) continue;
            return -1;
        }
        st.elFunctionsUsed.add(++st.elFunctionCounter, funcs);
        return st.elFunctionCounter;
    }

    private static int containsValidFunction(JspParseState st, String expr) {
        Object prefix = null;
        String fname = null;
        int start = JspUtils.previousNonAllowedChar(expr);
        if (start == expr.length() - 1) {
            return -1;
        }
        if (start > 0 && expr.charAt(start) == ':') {
            fname = expr.substring(start + 1, expr.length());
            start = JspUtils.previousNonAllowedChar(expr.substring(0, start));
        } else if (st.curXmlSrcElem != null) {
            fname = expr;
        } else {
            return -1;
        }
        if (!Character.isJavaIdentifierStart(fname.charAt(0))) {
            return -1;
        }
        for (int i = 0; i < elReservedWords.length; ++i) {
            if (!elReservedWords[i].equals(fname)) continue;
            return -1;
        }
        return start + 1;
    }

    private static int previousNonAllowedChar(String str) {
        int pos;
        for (pos = str.length() - 1; pos > -1 && Character.isJavaIdentifierPart(str.charAt(pos)); --pos) {
        }
        return pos;
    }

    private static Hashtable obtainAllFuncsInExpr(JspParseState st, String str) {
        Hashtable<String, String> funcs = new Hashtable<String, String>();
        String prefixAndName = null;
        int openPIdx = str.indexOf("(");
        String elFunctionPrefix = null;
        boolean startPos = false;
        while (openPIdx > 0) {
            prefixAndName = str.substring(0, openPIdx);
            int colonIdx = prefixAndName.indexOf(":");
            int funcStart = JspUtils.containsValidFunction(st, prefixAndName);
            if (funcStart != -1) {
                if ((prefixAndName = prefixAndName.substring(funcStart, prefixAndName.length())).indexOf(":") == -1) {
                    elFunctionPrefix = "#default";
                    prefixAndName = ":" + prefixAndName;
                } else {
                    elFunctionPrefix = prefixAndName.substring(0, prefixAndName.indexOf(":"));
                }
            } else {
                str = str.substring(openPIdx + 1, str.length());
                openPIdx = str.indexOf("(");
                continue;
            }
            if (st.curXmlSrcElem != null) {
                String prefixValue = null;
                prefixValue = ((XMLElement)st.curXmlSrcElem).resolveNamespacePrefix(elFunctionPrefix);
                prefixAndName = colonIdx != -1 ? elFunctionPrefix + ":" + prefixValue + prefixAndName.substring(colonIdx, prefixAndName.length()) : elFunctionPrefix + ":" + prefixValue + prefixAndName;
            }
            funcs.put(prefixAndName, prefixAndName);
            str = str.substring(openPIdx + 1, str.length());
            openPIdx = str.indexOf("(");
        }
        return funcs;
    }

    public static int functionSetSeen(JspParseState st, Hashtable funcs) {
        for (int i = 0; i < st.elFunctionsUsed.size(); ++i) {
            Hashtable h = (Hashtable)st.elFunctionsUsed.get(i);
            Enumeration f = funcs.keys();
            boolean matched = true;
            while (f.hasMoreElements()) {
                String fkey = (String)f.nextElement();
                if (h.containsKey(fkey)) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return i;
        }
        return -1;
    }

    public static boolean allowNonTaglibNamespace(JspParseState st, String originalUri) {
        if (originalUri == null) {
            return false;
        }
        return st.parms.xmlStyleSrc && !originalUri.startsWith("urn:jsptld");
    }

    public static String getterMethod(String attrName) {
        char[] charArr = attrName.toCharArray();
        charArr[0] = Character.toUpperCase(charArr[0]);
        return "get" + new String(charArr);
    }

    public static String setterMethod(String attrName) {
        char[] charArr = attrName.toCharArray();
        charArr[0] = Character.toUpperCase(charArr[0]);
        return "set" + new String(charArr);
    }

    public static boolean determineIsIncludedPageXML(JspParseState st, String includedPage) {
        Boolean temp = JspUtils.doesPageHaveXMLConfigValue(st, includedPage);
        if (temp != null) {
            return temp;
        }
        return includedPage.endsWith(".jspx") || includedPage.endsWith(".tagx");
    }

    public static void checkOjspConfigForDefaultBufferSize(JspParseState st) {
        OJSPConfigDescriptor.OJSPPropertyGroup propgroup;
        List matches;
        String requestPage = st.parms.sourceFileName;
        HttpApplication happ = st.parms.happ;
        if (happ != null && happ.getConfig().isOJSPPropertyGroupDefined() && (matches = JspUtils.getJspPropertyGroups(requestPage, happ.getServletMappings(), false, true)) != null && matches.size() > 0 && (propgroup = (OJSPConfigDescriptor.OJSPPropertyGroup)matches.get(0)) != null && !propgroup.defaultBufferSize.equals("")) {
            st.parms.defaultBufferSz = propgroup.defaultBufferSize;
        }
    }

    public static Boolean doesPageHaveXMLConfigValue(JspParseState st, String includedPage) {
        JspConfigDescriptor.JspPropertyGroup propgroup;
        List matches;
        if (st.parms.happ != null && st.parms.happ instanceof HttpApplication && (matches = JspUtils.getJspPropertyGroups(includedPage, st.parms.happ.getServletMappings(), false)) != null && matches.size() > 0 && (propgroup = (JspConfigDescriptor.JspPropertyGroup)matches.get(0)) != null) {
            return propgroup.isXML;
        }
        return null;
    }

    public static List getJspPropertyGroups(String requestPage, ServletMapping[] servletMappings, boolean all) {
        return JspUtils.getJspPropertyGroups(requestPage, servletMappings, all, false);
    }

    public static List getJspPropertyGroups(String requestPage, ServletMapping[] servletMappings, boolean all, boolean needsOjspPropGroup) {
        ArrayList<Object> matches = new ArrayList<Object>();
        boolean endsWithSlash = false;
        ByteString originalPath = new ByteString(requestPage);
        ByteString path = new ByteString(requestPage);
        while (path.charAt(path.length - 1) == '/') {
            path = path.substring(0, path.length() - 1);
            endsWithSlash = true;
            if (path.length != 0) continue;
        }
        boolean USE_CTS_PATH_INFO = true;
        if (servletMappings != null) {
            int matchResult = ServletMapping.findMatch((ByteString)originalPath, (ByteString)path, (boolean)endsWithSlash, (boolean)USE_CTS_PATH_INFO, (ServletMapping[])servletMappings);
            while (matchResult != Integer.MIN_VALUE) {
                ServletMapping mapping = servletMappings[matchResult];
                if (needsOjspPropGroup) {
                    if (mapping instanceof OJSPConfigDescriptor.OJSPConfigImplicitServletMapping) {
                        OJSPConfigDescriptor.OJSPConfigImplicitServletMapping ojspMapping = (OJSPConfigDescriptor.OJSPConfigImplicitServletMapping)mapping;
                        matches.add(ojspMapping.getOJSPPropertyGroup());
                        break;
                    }
                } else {
                    if (mapping instanceof JspConfigDescriptor.JspConfigImplicitServletMapping) {
                        JspConfigDescriptor.JspConfigImplicitServletMapping jspMapping = (JspConfigDescriptor.JspConfigImplicitServletMapping)mapping;
                        matches.add(jspMapping.getJspPropertyGroup());
                    }
                    if (!all) break;
                }
                ServletMapping[] _tmp = servletMappings;
                servletMappings = new ServletMapping[_tmp.length - (matchResult + 1)];
                System.arraycopy(_tmp, matchResult + 1, servletMappings, 0, servletMappings.length);
                matchResult = ServletMapping.findMatch((ByteString)originalPath, (ByteString)path, (boolean)endsWithSlash, (boolean)USE_CTS_PATH_INFO, (ServletMapping[])servletMappings);
            }
        }
        return matches;
    }

    public static String getPageEncoding(String requestPage, HttpApplication happ) {
        JspConfigDescriptor.JspPropertyGroup propgroup;
        List matches;
        if (happ != null && requestPage != null && !requestPage.equals("") && (matches = JspUtils.getJspPropertyGroups(requestPage, happ.getServletMappings(), false)) != null && matches.size() > 0 && (propgroup = (JspConfigDescriptor.JspPropertyGroup)matches.get(0)) != null) {
            if (!propgroup.pageEncoding.equals("")) {
                return propgroup.pageEncoding;
            }
            return null;
        }
        return null;
    }

    public static String getAttrInfoString(TagAttributeInfo attrInfo) {
        String retStr = "new TagAttributeInfo(\"" + attrInfo.getName() + "\"," + attrInfo.isRequired() + "," + "\"" + attrInfo.getTypeName() + "\"," + attrInfo.canBeRequestTime() + "," + attrInfo.isFragment() + ")";
        return retStr;
    }

    public static String getVarInfoString(TagVariableInfo varInfo) {
        String nameGiven = null;
        String nameFromAttr = null;
        nameGiven = varInfo.getNameGiven();
        nameFromAttr = varInfo.getNameFromAttribute();
        if (nameGiven != null) {
            nameGiven = "\"" + nameGiven + "\"";
        }
        if (nameFromAttr != null) {
            nameFromAttr = "\"" + nameFromAttr + "\"";
        }
        String retStr = "new TagVariableInfo(" + nameGiven + "," + nameFromAttr + "," + "\"" + varInfo.getClassName() + "\"," + varInfo.getDeclare() + "," + varInfo.getScope() + ")";
        return retStr;
    }

    public static String convertToXMLViewValue(String str) {
        StringBuffer xmlViewStrBuf = new StringBuffer();
        int startIndex = 0;
        int slashCount = 0;
        int elIndex = str.indexOf("${");
        int currIndex = elIndex - 1;
        while (elIndex != -1) {
            while (currIndex >= startIndex && str.charAt(currIndex) == '\\') {
                ++slashCount;
                --currIndex;
            }
            xmlViewStrBuf.append(str.substring(startIndex, elIndex - slashCount));
            if (slashCount != 0) {
                int i;
                if (slashCount % 2 == 0) {
                    xmlViewStrBuf.append("${'");
                    for (i = 0; i < slashCount; ++i) {
                        xmlViewStrBuf.append("\\");
                    }
                    xmlViewStrBuf.append("'}");
                } else {
                    slashCount /= 2;
                    for (i = 0; i < slashCount; ++i) {
                        xmlViewStrBuf.append("\\");
                    }
                    xmlViewStrBuf.append("\\");
                }
            }
            startIndex = elIndex;
            slashCount = 0;
            elIndex = str.indexOf("${", elIndex + 1);
            currIndex = elIndex - 1;
        }
        xmlViewStrBuf.append(str.substring(startIndex));
        return xmlViewStrBuf.toString();
    }

    protected static void setJspIdInXMLView(JspParseState st, Element e, JspParseTag tag) {
        JspUtils.setJspIdInXMLView(st, e, tag, false);
    }

    protected static void setJspIdInXMLView(JspParseState st, Element e, JspParseTag tag, boolean bumpupId) {
        String prefix = st.getJspIdPrefix();
        if (bumpupId) {
            int id = st.getXMLViewJspIdCount();
            e.setAttributeNS("http://java.sun.com/JSP/Page", prefix + ":id", Integer.toString(id));
        } else {
            e.setAttributeNS("http://java.sun.com/JSP/Page", prefix + ":id", Integer.toString(tag.getXMLViewJspId(st)));
        }
    }

    protected static Element createXMLViewStdJspElement(JspParseState st, JspParseTag tag, String suffix) {
        return JspUtils.createXMLViewStdJspElement(st, tag, suffix, null, false);
    }

    protected static Element createXMLViewStdJspElement(JspParseState st, JspParseTag tag, String suffix, Text text) {
        return JspUtils.createXMLViewStdJspElement(st, tag, suffix, text, false);
    }

    protected static Element createXMLViewStdJspElement(JspParseState st, JspParseTag tag, String suffix, Text text, boolean bumpupId) {
        String prefix = null;
        prefix = tag.xmlSrcElem == null ? "jsp:" : ((prefix = tag.xmlSrcElem.getPrefix()) == null ? "" : prefix + ":");
        String xmlDecl = prefix + suffix;
        Element e = st.xvd.createElementNS("http://java.sun.com/JSP/Page", xmlDecl);
        JspUtils.setJspIdInXMLView(st, e, tag, bumpupId);
        if (text != null) {
            e.appendChild(text);
        }
        return e;
    }
}

