/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Stack;
import java.util.Vector;
import oracle.jsp.parse.Jsp2JavaParms;
import oracle.jsp.parse.JspEmitException;
import oracle.jsp.parse.JspEmitState;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspParseTag;
import oracle.jsp.parse.JspParseTagText;
import oracle.jsp.parse.JspUtils;
import oracle.jsp.parse.OpenJspAVDesc;
import oracle.jsp.parse.OpenJspAVInfo;
import oracle.jsp.parse.StackNode;
import oracle.jsp.runtime.tree.OracleJspNode;
import oracle.jsp.runtime.tree.OracleJspParseContext;
import oracle.jsp.runtime.tree.OracleJspXMLTextNode;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLPrintDriver;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class JspParseTagXMLTextContainer
extends JspParseTag {
    public JspParseTagXMLTextContainer(JspParseTag parent) {
        super(7);
        this.setParent(parent);
    }

    public boolean allowsBody() {
        return true;
    }

    public void processAttributeValue(JspParseState st, int index, String name, String value) throws JspParseException {
        if (name.startsWith("xmlns")) {
            super.processAttributeValue(st, index, name, value);
        }
        this.processAttributeForELFunctions(st, name, value);
    }

    private void processAttributeForELFunctions(JspParseState st, String name, String value) throws JspParseException {
        OpenJspAVDesc desc = new OpenJspAVDesc(name, 11);
        OpenJspAVInfo av = new OpenJspAVInfo(desc);
        JspUtils.processELAttribute(st, value, av);
    }

    protected static String getXMLElementOneLineStr(Element e) throws IOException {
        return JspParseTagXMLTextContainer.getXMLElementOneLineStr(null, e);
    }

    protected static String getXMLElementOneLineStr(JspParseState st, Element e) throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        XMLPrintDriver xpd = new XMLPrintDriver(pw);
        XMLElement xe = (XMLElement)e;
        try {
            String str;
            if (e.hasChildNodes()) {
                if (st != null) {
                    xe = JspParseTagXMLTextContainer.removeKnownPrefixes(st, xe);
                }
                xpd.printAttributeNodes(xe);
                pw.flush();
                str = "<" + e.getTagName() + sw.toString() + ">";
            } else {
                xpd.printElement(xe);
                pw.flush();
                str = sw.toString();
            }
            return str;
        }
        catch (IOException ioe) {
            return e.toString();
        }
    }

    protected String getXMLElementOutputStr(JspEmitState st, Element e) throws JspParseException {
        XMLElement xe = (XMLElement)e;
        String str = null;
        String attrStr = null;
        str = e.hasChildNodes() ? ((attrStr = this.printAttributeNodesWithEL(st, xe = JspParseTagXMLTextContainer.removeKnownPrefixes(st.parseState, xe), str)) == null ? "<" + e.getTagName() + ">" : "<" + e.getTagName() + "\" +" + attrStr + "\">") : this.printElementNode(st, xe, str);
        return str;
    }

    protected String printElementNode(JspEmitState st, XMLElement xe, String str) throws JspParseException {
        String attrStr = this.printAttributeNodesWithEL(st, xe, str);
        str = "<" + xe.getNodeName();
        str = attrStr != null ? str + "\"+" + attrStr + "\"/>" : str + "/>" + JspParseTagXMLTextContainer.sanitizeQuotedString(System.getProperty("line.separator"));
        return str;
    }

    protected String getStartTagString() {
        String str;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        XMLPrintDriver xpd = new XMLPrintDriver(pw);
        try {
            if (this.xmlSrcElem.hasChildNodes()) {
                xpd.printAttributeNodes((XMLElement)this.xmlSrcElem);
                pw.flush();
                str = "<" + this.xmlSrcElem.getTagName() + sw.toString() + ">";
            } else {
                xpd.printElement((XMLElement)this.xmlSrcElem);
                pw.flush();
                str = sw.toString();
            }
        }
        catch (IOException ioe) {
            str = this.xmlSrcElem.toString();
        }
        return str;
    }

    protected String getEndTagString() {
        if (this.xmlSrcElem.hasChildNodes()) {
            return "</" + this.xmlSrcElem.getTagName() + ">";
        }
        return "";
    }

    public OracleJspNode createNode(OracleJspParseContext context, OracleJspNode parent) {
        OracleJspNode node = new OracleJspNode();
        node.setParent(parent);
        Stack<StackNode> stack = new Stack<StackNode>();
        StackNode stackNode = new StackNode();
        stackNode.tag = this;
        stack.push(stackNode);
        ArrayList<OracleJspNode> children = new ArrayList<OracleJspNode>();
        StringBuffer textBuf = new StringBuffer();
        while (!stack.empty()) {
            StackNode currNode = (StackNode)stack.pop();
            if (currNode.tag instanceof JspParseTagXMLTextContainer) {
                if (currNode.visited) {
                    textBuf.append(((JspParseTagXMLTextContainer)currNode.tag).getEndTagString());
                    continue;
                }
                currNode.visited = true;
                textBuf.append(((JspParseTagXMLTextContainer)currNode.tag).getStartTagString());
                stack.push(currNode);
                for (int i = currNode.tag.body.size() - 1; i >= 0; --i) {
                    stackNode = new StackNode();
                    stackNode.tag = (JspParseTag)currNode.tag.body.elementAt(i);
                    stack.push(stackNode);
                }
                continue;
            }
            if (currNode.tag instanceof JspParseTagText) {
                textBuf.append(currNode.tag.toString());
                continue;
            }
            if (textBuf.length() != 0) {
                children.add(new OracleJspXMLTextNode(textBuf.toString()));
                textBuf = new StringBuffer();
            }
            children.add(currNode.tag.createNode(context, node));
        }
        if (textBuf.length() != 0) {
            children.add(new OracleJspXMLTextNode(textBuf.toString()));
        }
        node.setChildren(children);
        return node;
    }

    protected String printAttributeNodesWithEL(JspEmitState st, XMLElement xe, String str) throws JspParseException {
        NamedNodeMap nmap = xe.getAttributes();
        for (int i = 0; i < nmap.getLength(); ++i) {
            Node attrNode = nmap.item(i);
            String attrName = attrNode.getNodeName();
            String attrVal = attrNode.getNodeValue();
            str = str == null ? " \" " + attrName + "=\\\"\" + " : str + " \" " + attrName + "=\\\"\" + ";
            OpenJspAVDesc desc = new OpenJspAVDesc(attrName, 11);
            OpenJspAVInfo av = new OpenJspAVInfo(desc);
            if (JspUtils.processELAttribute(st.parseState, attrVal, av)) {
                av.setHasEL(true);
            }
            av.setValue(st.parseState, attrVal);
            if (av != null && av.attributeValueHasEL()) {
                str = str + JspUtils.getELAttributeEmitString(st, av, false) + " + \"\\\"\" + ";
                continue;
            }
            attrVal = JspUtils.decodeDollarEscape(attrVal);
            attrVal = JspParseTagXMLTextContainer.sanitizeQuotedString(attrVal);
            str = str + "\"" + attrVal + "\"" + "+ \"\\\"\" +";
        }
        return str;
    }

    private static XMLElement removeKnownPrefixes(JspParseState st, XMLElement xe) {
        int i;
        NamedNodeMap nmap = xe.getAttributes();
        Vector<String> v = new Vector<String>();
        for (i = 0; i < nmap.getLength(); ++i) {
            Node attrNode = nmap.item(i);
            String attrStr = attrNode.getNodeName();
            String attrVal = attrNode.getNodeValue();
            if ((!attrStr.startsWith("xmlns:") || !st.prefixRegistered(JspParseTagXMLTextContainer.obtainPrefix(attrStr, xe))) && !attrVal.equals("http://java.sun.com/JSP/Page")) continue;
            v.add(attrStr);
        }
        for (i = 0; i < v.size(); ++i) {
            xe.removeAttribute((String)v.get(i));
        }
        return xe;
    }

    private static String obtainPrefix(String str, XMLElement xe) {
        String prefix = null;
        prefix = str.substring(str.indexOf("xmlns:") + "xmlns:".length(), str.length()).trim();
        String prefixValue = xe.resolveNamespacePrefix(prefix);
        return prefixValue;
    }

    public void emitTagStart(JspEmitState st) throws JspEmitException {
        String str = null;
        try {
            str = this.getXMLElementOutputStr(st, this.xmlSrcElem);
        }
        catch (JspParseException jp) {
            throw new JspEmitException(jp.toString());
        }
        Jsp2JavaParms cfr_ignored_0 = st.parms;
        if (st.parms.gensmap != 0) {
            st.printLineInfo(this.lineNumber, this.columnNumber);
        }
        st.iprintln("out.write( \"" + str + "\");");
    }

    public void emitTagEnd(JspEmitState st) throws JspEmitException {
        if (this.xmlSrcElem.hasChildNodes()) {
            String str = "</" + this.xmlSrcElem.getTagName() + ">";
            Jsp2JavaParms cfr_ignored_0 = st.parms;
            if (st.parms.gensmap != 0) {
                int endTagLineNumber = ((XMLNode)this.xmlSrcElem).getEndTagLineNum();
                st.printLineInfo(endTagLineNumber, 0);
            }
            st.iprintln("out.write( \"" + JspParseTagXMLTextContainer.sanitizeQuotedString(str) + "\");");
        }
    }

    public Element toXMLElement(JspParseState st) {
        Element e = st.xvd.createElement(this.getTagName());
        JspUtils.setJspIdInXMLView(st, e, this);
        NamedNodeMap nmap = this.xmlSrcElem.getAttributes();
        for (int i = 0; i < nmap.getLength(); ++i) {
            Node attrNode = nmap.item(i);
            String attrVal = attrNode.getNodeValue();
            if (attrVal == null) continue;
            e.setAttribute(attrNode.getNodeName(), attrVal);
        }
        this.xmlview_element = e;
        this.addBodyElementTo(e, st);
        return e;
    }
}

