/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import javax.servlet.jsp.el.ELException;
import oracle.jsp.parse.JspEmitException;
import oracle.jsp.parse.JspEmitState;
import oracle.jsp.parse.JspEmitter;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspParseTag;
import oracle.jsp.parse.JspParseTagEl;
import oracle.jsp.parse.JspUtils;
import oracle.jsp.runtime.tree.OracleJspNode;
import oracle.jsp.runtime.tree.OracleJspParseContext;
import oracle.jsp.runtime.tree.OracleJspTextNode;
import oracle.jsp.util.JspUtil;
import oracle.xml.parser.v2.XMLElement;
import org.apache.commons.el.Expression;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class JspParseTagText
extends JspParseTag {
    private boolean hasEL = false;
    private StringBuffer sb = new StringBuffer();
    private String str = null;
    private String xmlViewStr = null;
    public static final int SEG_SIZE = 16384;
    private boolean fromAttribute = false;
    private boolean jspAttributeNoEmit = false;
    protected int lastRealJspLineNum = 0;
    protected String xmlSrcBodyStr;
    private boolean escapeEnabled = true;

    public JspParseTagText() {
        super(1);
    }

    protected void setFromJspAttribute() {
        this.fromAttribute = true;
    }

    protected void setFromJspAttributeNoEmit() {
        this.setFromJspAttribute();
        this.jspAttributeNoEmit = true;
    }

    public JspParseTagText(JspParseTag parent) {
        super(1);
    }

    public String getTagName() {
        return "Text_block";
    }

    public void parse(JspParseState st) throws IOException, JspParseException {
        if (this.xmlSrcElem != null) {
            this.parseXMLSrc(st);
            return;
        }
        if (st.throwParseException(new JspParseException(st, msgs.getString("bad_parse_call")))) {
            return;
        }
    }

    public void ltrim() {
        String tempStr = this.getString();
        this.str = JspUtils.trimBeginningWhite(tempStr);
    }

    public void rtrim() {
        String tempStr = this.getString();
        this.str = JspUtils.trimTrailingWhite(tempStr);
    }

    public String toString() {
        return this.getString();
    }

    public String getString() {
        if (this.str == null) {
            if (this.xmlSrcBodyStr != null) {
                this.str = this.xmlSrcBodyStr;
            } else {
                this.str = new String(this.sb);
                this.str = this.removeEscapes(this.str);
            }
        }
        return this.str;
    }

    public OracleJspNode createNode(OracleJspParseContext context, OracleJspNode parent) {
        int[] types;
        Object[] textElements;
        this.getString();
        OracleJspTextNode node = new OracleJspTextNode();
        node.setParent(parent);
        String encoding = this.getEncoding(context);
        if (this.hasEL) {
            textElements = new Object[this.body.size()];
            types = new int[this.body.size()];
            for (int i = 0; i < this.body.size(); ++i) {
                String text;
                JspParseTag temp = (JspParseTag)this.body.elementAt(i);
                if (temp.getTagBaseType() == 0) {
                    text = ((JspParseTagEl)temp).getString();
                    textElements[i] = text;
                    types[i] = 0;
                    continue;
                }
                text = ((JspParseTagText)temp).getString();
                if (encoding == null) {
                    textElements[i] = text.toCharArray();
                    types[i] = 2;
                    continue;
                }
                try {
                    textElements[i] = text.getBytes(encoding);
                    types[i] = 1;
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
        } else {
            textElements = new Object[1];
            types = new int[1];
            if (encoding == null) {
                textElements[0] = this.str.toCharArray();
                types[0] = 2;
            } else {
                try {
                    textElements[0] = this.str.getBytes(encoding);
                    types[0] = 1;
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
        }
        node.setTextElements(textElements);
        node.setTypes(types);
        return node;
    }

    private String getEncoding(OracleJspParseContext context) {
        String javaEncoding;
        String encoding = JspUtils.extractEncoding(context.getContentType());
        if (encoding == null) {
            encoding = context.getSrcEncoding();
        }
        if (encoding != null && (javaEncoding = JspUtil.convIANAtoJavaEncoding(encoding, false)) != null) {
            encoding = javaEncoding;
        }
        return encoding;
    }

    public void setEscapeEnabled(boolean flag) {
        this.escapeEnabled = flag;
    }

    private String removeEscapes(String text) {
        if (!this.escapeEnabled) {
            return text;
        }
        int idx = text.indexOf("<\\%");
        while (idx != -1) {
            text = text.substring(0, idx + 1) + text.substring(idx + 2);
            idx = text.indexOf("<\\%", idx + 1);
        }
        return text;
    }

    public void addLine(String text) {
        this.sb.append(text);
    }

    public void addLine(boolean generatingSmap, String text) {
        if (generatingSmap && this.sb.length() == 0 && text.indexOf(10) != -1 && text.substring(0, text.indexOf(10)).trim().equals("")) {
            ++this.lineNumber;
        }
        this.sb.append(text);
    }

    public void emitTagBody(JspEmitState st) throws JspEmitException {
        st.fromTextTag = true;
        if (this.hasEL) {
            for (int i = 0; i < this.body.size(); ++i) {
                JspParseTag temp = (JspParseTag)this.body.elementAt(i);
                if (temp.getTagBaseType() == 0) {
                    if (this.jspAttributeNoEmit) {
                        ((JspParseTagEl)temp).setFromJspAttributeNoEmit();
                    }
                    ((JspParseTagEl)temp).emitTagBody(st, (JspParseTagEl)temp);
                    continue;
                }
                if (this.jspAttributeNoEmit) {
                    ((JspParseTagText)temp).setFromJspAttributeNoEmit();
                }
                ((JspParseTagText)temp).emitTagBody(st, (JspParseTagText)temp);
            }
        } else {
            this.emitTagBody(st, this);
        }
        st.fromTextTag = false;
    }

    public void emitTagBody(JspEmitState st, JspParseTagText tag) throws JspEmitException {
        if (!(this.fromAttribute || st.isFromFragment() || st.parseState.isTagFile())) {
            int end;
            st.printLineInfoGenerated();
            this.getString();
            int start = 0;
            int len = this.str.length();
            do {
                end = start + 16384 > len ? len : start + 16384;
                if (st.parms.staticChars) {
                    int textId = st.addStaticText(this.str.substring(start, end));
                    if (st.parms.staticTextInBytes && "com.orionserver.http.OrionHttpJspPage".equals(st.parms.extend)) {
                        if (JspEmitter.isOc4jJspCommonExtraWriterDefined(st)) {
                            if (st.parms.staticTextInSameClass) {
                                st.iprintln("__ojsp_s_out.write(__oracle_jsp_text[" + textId + "]);");
                            } else {
                                st.iprintln("__ojsp_s_out.write(__jsp_StaticText.__oracle_jsp_text[" + textId + "]);");
                            }
                        } else if (st.parms.staticTextInSameClass) {
                            st.iprintln("Oc4jJspRuntime.outputStaticTextinBytes(out, __oracle_jsp_text[" + textId + "]);");
                        } else {
                            st.iprintln("Oc4jJspRuntime.outputStaticTextinBytes(out,__jsp_StaticText.__oracle_jsp_text[" + textId + "]);");
                        }
                    } else if (st.parms.staticTextInSameClass) {
                        st.iprintln("out.write(__oracle_jsp_text[" + textId + "]);");
                    } else {
                        st.iprintln("out.write(__jsp_StaticText.__oracle_jsp_text[" + textId + "]);");
                    }
                } else {
                    st.iprintln("out.write( \"" + JspParseTagText.sanitizeQuotedString(this.str.substring(start, end)) + "\");");
                }
                start = end;
            } while (end < len);
            st.printLineInfoTranslated();
        } else if (!this.jspAttributeNoEmit) {
            this.getString();
            st.iprintln("out.write(\"" + JspParseTagText.sanitizeQuotedString(this.str) + "\");");
        }
    }

    public Element toXMLElement(JspParseState st) {
        this.getString();
        Text t = JspParseTagText.createCDATAText(this.xmlViewStr == null ? this.str : this.xmlViewStr, st);
        Element e = JspUtils.createXMLViewStdJspElement(st, this, "text", t);
        return e;
    }

    protected void parseXMLSrc(JspParseState st) throws JspParseException, IOException {
        Node childNode;
        st.position.curXMLSrcElem = this.xmlSrcElem;
        if (this.xmlSrcElem instanceof XMLElement) {
            XMLElement xe_xmlSrcElem = (XMLElement)this.xmlSrcElem;
            this.lineNumber = xe_xmlSrcElem.getLineNumber();
            this.columnNumber = xe_xmlSrcElem.getColumnNumber();
        }
        if ((childNode = this.xmlSrcElem.getFirstChild()) == null) {
            this.xmlSrcBodyStr = null;
            return;
        }
        if (childNode instanceof Text) {
            this.xmlSrcBodyStr = ((Text)childNode).getData();
            if (JspUtils.isELEvaluationOn(st)) {
                this.processELXMLSrc(st);
            }
            if (childNode.getNextSibling() != null && st.throwParseException(new JspParseException(st, msgs.getString("non_text_not_allowed") + this.xmlSrcElem.getTagName()))) {
                return;
            }
        } else if (st.throwParseException(new JspParseException(st, msgs.getString("non_text_not_allowed") + this.xmlSrcElem.getTagName()))) {
            return;
        }
    }

    protected void setXMLSrcBodyStr(String s) {
        this.xmlSrcBodyStr = s;
    }

    public void processELXMLSrc(JspParseState st) throws JspParseException {
        block2: {
            StringBuffer sbuf = new StringBuffer(this.xmlSrcBodyStr);
            try {
                this.processBothEL(st, sbuf, st.parms.xmlStyleSrc);
            }
            catch (ELException el) {
                if (!st.throwParseException(new JspParseException(st, (Throwable)el))) break block2;
                return;
            }
        }
    }

    public void processEL(JspParseState st) throws JspParseException {
        block2: {
            StringBuffer sbuf = new StringBuffer(this.sb.toString());
            try {
                this.processBothEL(st, sbuf, st.parms.xmlStyleSrc);
            }
            catch (ELException el) {
                if (!st.throwParseException(new JspParseException(st, (Throwable)el))) break block2;
                return;
            }
        }
    }

    public void processBothEL(JspParseState st, StringBuffer sbuf, boolean xmlStyleSrc) throws JspParseException, ELException {
        this.xmlViewStr = sbuf.toString();
        String str = null;
        int elStartLine = 0;
        int currLine = 0;
        int currPos = 0;
        int elEnd = 0;
        int elStart = 0;
        StringBuffer tempBuf = new StringBuffer();
        StringBuffer tempELBuf = new StringBuffer();
        boolean lookingForEnd = false;
        boolean lookForEndQuote = false;
        boolean foundEscape = false;
        int ridx = 0;
        do {
            str = null;
            StringBuffer s = new StringBuffer();
            while (ridx < sbuf.length()) {
                s.append(sbuf.charAt(ridx));
                if (sbuf.charAt(ridx) == '\n') {
                    ++ridx;
                    break;
                }
                if (sbuf.charAt(ridx) == '\r' && ridx < sbuf.length() - 1 && sbuf.charAt(ridx + 1) == '\n') {
                    s.append(sbuf.charAt(++ridx));
                    ++ridx;
                    break;
                }
                if (sbuf.charAt(ridx) == '\r') {
                    ++ridx;
                    break;
                }
                ++ridx;
            }
            if ((str = s.length() == 0 ? null : s.toString()) == null) break;
            for (currPos = 0; currPos < str.length(); ++currPos) {
                if (str.charAt(currPos) == '$' && currPos < str.length() - 1 && str.charAt(currPos + 1) == '{' && !(foundEscape = JspUtils.isELEscaped(str, currPos, true))) {
                    lookingForEnd = true;
                }
                if (lookingForEnd) {
                    tempELBuf = tempELBuf.append(str.charAt(currPos));
                } else {
                    tempBuf = tempBuf.append(str.charAt(currPos));
                }
                if (currPos < str.length() - 1 && str.charAt(currPos) == '$' && str.charAt(currPos + 1) == '{' && !JspUtils.isELEscaped(str, currPos, true)) {
                    elStart = currPos;
                    lookingForEnd = true;
                    if (tempBuf.length() != 0) {
                        JspParseTagText tTag = new JspParseTagText(this);
                        tTag.addLine(JspUtils.decodeDollarEscape(tempBuf.toString()));
                        tTag.lineNumber = this.lineNumber;
                        tTag.endLineNumber = this.lineNumber + currLine;
                        tTag.endColumnNumber = elStart;
                        this.addTagToBody(st, tTag);
                        tempBuf.delete(0, tempBuf.length());
                    }
                    tempELBuf.append(str.charAt(++currPos));
                }
                char currChar = str.charAt(currPos);
                if (lookingForEnd && currPos < str.length() && (currChar == '\'' || currChar == '\"')) {
                    lookForEndQuote = !lookForEndQuote;
                }
                if (!lookingForEnd || lookForEndQuote || currPos >= str.length() || str.charAt(currPos) != '}') continue;
                lookingForEnd = false;
                Object o = JspUtils.validateELSyntax(st, tempELBuf);
                this.hasEL = true;
                JspParseTagEl eTag = new JspParseTagEl(this);
                String elExpr = JspParseTag.sanitizeQuotedString(tempELBuf.toString());
                eTag.addLine(elExpr);
                eTag.lineNumber = this.lineNumber;
                eTag.endLineNumber = this.lineNumber + currLine;
                eTag.endColumnNumber = currPos;
                if (o instanceof Expression) {
                    eTag.elFunctionNum = JspUtils.setFunctionInfo(st, elExpr);
                    if (eTag.elFunctionNum != -1) {
                        eTag.isElFunction = true;
                    }
                }
                this.addTagToBody(st, eTag);
                tempELBuf.delete(0, tempELBuf.length());
            }
            ++currLine;
        } while (str != null);
        if (lookingForEnd) {
            throw new JspParseException(st, MessageFormat.format(msgs.getString("incomplete_el_expr"), new Integer(elStart), new Integer(elStartLine)));
        }
        if ((this.hasEL || foundEscape) && tempBuf.length() > 0) {
            this.hasEL = true;
            JspParseTagText tTag = new JspParseTagText(this);
            tTag.addLine(JspUtils.decodeDollarEscape(tempBuf.toString()));
            tTag.lineNumber = this.lineNumber;
            tTag.endLineNumber = this.lineNumber + currLine;
            tTag.endColumnNumber = elStart;
            this.addTagToBody(st, tTag);
            if (!xmlStyleSrc) {
                this.sb.delete(0, this.sb.length());
            } else {
                this.xmlSrcBodyStr = null;
            }
        } else if (!xmlStyleSrc) {
            if (this.sb.toString().indexOf("\\$") != -1) {
                this.sb = new StringBuffer(JspUtils.decodeDollarEscape(this.sb.toString()));
            }
        } else if (this.xmlSrcBodyStr != null && this.xmlSrcBodyStr.indexOf("\\$") != -1) {
            this.xmlSrcBodyStr = JspUtils.decodeDollarEscape(this.xmlSrcBodyStr);
        }
    }

    public boolean hasEL() {
        return this.hasEL;
    }

    public String getELString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.body.size(); ++i) {
            JspParseTag temp = (JspParseTag)this.body.elementAt(i);
            if (temp.getTagBaseType() == 0) {
                if (((JspParseTagEl)temp).isElFunction) {
                    sb.append(JspUtils.evstr1 + "\"" + ((JspParseTagEl)temp).getString() + "\"" + JspUtils.evstr3 + ((JspParseTagEl)temp).elFunctionNum + JspUtils.evstr4 + "+");
                    continue;
                }
                sb.append(JspUtils.evstr1 + "\"" + ((JspParseTagEl)temp).getString() + "\"" + JspUtils.evstr2 + "+");
                continue;
            }
            String str = ((JspParseTagText)temp).getString();
            if (i == 0) {
                str = JspUtils.trimBeginningWhite(str);
            }
            if (i == this.body.size() - 1) {
                str = JspUtils.trimTrailingWhite(str);
            }
            if (str == null || str.equals("")) continue;
            sb.append("\"" + str + "\"+");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }
}

