/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.BufferedReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import oracle.jsp.parse.GlobalInclude;
import oracle.jsp.parse.JspDirective;
import oracle.jsp.parse.JspDirectiveTaglibInfo;
import oracle.jsp.parse.JspEmitException;
import oracle.jsp.parse.JspEmitState;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspParseTag;
import oracle.jsp.parse.JspParseTagDirective;
import oracle.jsp.parse.JspUtils;
import oracle.jsp.runtime.tree.OracleJspFileNode;
import oracle.jsp.runtime.tree.OracleJspParseContext;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JspParseTagFile
extends JspParseTag {
    BufferedReader in;
    JspParseTag inParent;
    String fileName;
    private String jspXMLSrcVersion;
    String xmlEncoding;
    String configEncoding;
    String pageEncoding;
    String contentEncoding;
    String nonXMLJspEncoding;
    String defaultCharSet;
    protected boolean pageEncodingEncountered = false;
    private String JSP_ID_PREFIX = "__oracle_jsp";

    public JspParseTagFile(int type) {
        super(type);
    }

    public JspParseTagFile(JspParseState st, BufferedReader in, String enc) {
        super(7);
        this.in = in;
        this.nonXMLJspEncoding = enc;
        if (st.parms.tagFilePageTable != null) {
            this.defaultCharSet = st.parms.tagFilePageTable.getAppDefaultEncoding();
        }
        if (st.curXmlSrcElem != null) {
            st.prevXmlSrcElem = st.curXmlSrcElem;
            st.curXmlSrcElem = null;
        }
    }

    public JspParseTagFile(JspParseState st, Element xmlSrcElem, String fileName) throws JspParseException {
        super(7);
        if (st.curXmlSrcElem != null) {
            st.prevXmlSrcElem = xmlSrcElem;
        }
        st.elemCount = 0;
        this.setXMLSrcElem(st, xmlSrcElem);
        this.setFileName(fileName);
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getTagName() {
        return "File_Parser";
    }

    public void parseFileEnd(JspParseState st) throws JspParseException {
        if (st.prevXmlSrcElem != null) {
            st.curXmlSrcElem = st.prevXmlSrcElem;
        }
    }

    public boolean isEndTag(String tag) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(JspParseState st) throws IOException, JspParseException {
        String path;
        Iterator i;
        if (this.xmlSrcElem != null) {
            this.parseXMLSrc(st);
            return;
        }
        st.pushSrcParseInfo();
        st.in = this.in;
        st.clearLine();
        st.position.Clear();
        GlobalInclude giObj = null;
        if (this.parent == null) {
            if (st.parms.includePrelude.size() > 0) {
                i = st.parms.includePrelude.iterator();
                while (i.hasNext()) {
                    path = (String)i.next();
                    this.addGlobalIncludeDirective(st, path, 0);
                }
            } else {
                giObj = GlobalInclude.getGlobalInclude(st);
                if (giObj != null) {
                    giObj.matchGlobalInclude(0, st, this);
                }
            }
        }
        try {
            JspParseTag tag;
            while ((tag = this.parseNextTag(st)) != null) {
                this.addTagToBody(st, tag);
            }
        }
        finally {
            st.popSrcParseInfo();
        }
        if (this.parent == null) {
            if (st.parms.includeCoda.size() > 0) {
                i = st.parms.includeCoda.iterator();
                while (i.hasNext()) {
                    path = (String)i.next();
                    this.addGlobalIncludeDirective(st, path, 1);
                }
            } else if (giObj != null) {
                giObj.matchGlobalInclude(1, st, this);
            }
        }
    }

    protected void parseXMLSrc(JspParseState st) throws JspParseException, IOException {
        GlobalInclude giObj = null;
        if (this.parent == null) {
            if (st.parms.includePrelude.size() > 0) {
                Iterator i = st.parms.includePrelude.iterator();
                while (i.hasNext()) {
                    String path = (String)i.next();
                    this.addGlobalIncludeDirective(st, path, 0);
                }
            } else {
                giObj = GlobalInclude.getGlobalInclude(st);
                if (giObj != null) {
                    giObj.matchGlobalInclude(0, st, this);
                }
            }
        }
        String prefix = this.xmlSrcElem.getPrefix();
        String prefixValue = null;
        prefixValue = prefix == null || prefix.equals("") ? this.xmlSrcElem.getNamespaceURI() : ((XMLElement)this.xmlSrcElem).resolveNamespacePrefix(prefix);
        if (this.xmlSrcElem.getLocalName().equals("root") && prefixValue != null && prefixValue.equals("http://java.sun.com/JSP/Page")) {
            st.omitXmlDecl = true;
            super.parseXMLSrc(st);
        } else {
            JspParseTag t = this.genXMLSrcTag(st, this.xmlSrcElem);
            this.addTagToBody(st, t);
        }
        if (this.parent == null) {
            if (st.parms.includeCoda.size() > 0) {
                Iterator i = st.parms.includeCoda.iterator();
                while (i.hasNext()) {
                    String path = (String)i.next();
                    this.addGlobalIncludeDirective(st, path, 1);
                }
            } else if (giObj != null) {
                giObj.matchGlobalInclude(1, st, this);
            }
        }
    }

    protected void addGlobalIncludeDirective(JspParseState st, String includedFile, int position) throws JspParseException, IOException {
        JspParseTagDirective parseDirective = new JspParseTagDirective();
        parseDirective.setParent(this);
        parseDirective.setVirtual(true);
        parseDirective.processAttributeValue(st, 1, "include", null);
        parseDirective.processAttributeValue(st, 2, "file", includedFile);
        parseDirective.validateTagAttributes(st);
        parseDirective.parse(st);
    }

    private String getContentType(JspParseState st) {
        String srcEncoding = this.getSrcEncoding();
        String contentType = st.getDirectiveAttrValue("page", "contentType");
        if (contentType == null) {
            contentType = this.xmlSrcElem == null ? "text/html;charset=" + srcEncoding : "text/xml;charset=" + srcEncoding;
        } else {
            String contentTypePrefix;
            String encoding = JspUtils.extractEncoding(contentType);
            if (encoding == null && !(contentTypePrefix = JspUtils.extractContentType(contentType)).startsWith("application/")) {
                contentType = contentTypePrefix + ";charset=" + srcEncoding;
            }
        }
        return contentType;
    }

    public OracleJspFileNode createTree(JspParseState st, OracleJspParseContext context) {
        OracleJspFileNode root = new OracleJspFileNode();
        root.setContentType(this.getContentType(st));
        root.setSrcEncoding(this.getSrcEncoding());
        context.setSrcEncoding(root.getSrcEncoding());
        context.setContentType(root.getSrcEncoding());
        String inSession = st.getDirectiveAttrValue("page", "session");
        root.setInSession(JspUtils.translateBoolean(inSession, true));
        String buffer = st.getDirectiveAttrValue("page", "buffer");
        int bufferSize = JspUtils.translateBufferSize(buffer);
        if (bufferSize < 0) {
            bufferSize = -1;
        } else if (bufferSize == 0) {
            bufferSize = 0;
        }
        root.setBufferSize(bufferSize);
        String autoFlushEnabled = st.getDirectiveAttrValue("page", "autoFlush");
        root.setAutoFlushEnabled(JspUtils.translateBoolean(autoFlushEnabled, true));
        String errorPage = st.getDirectiveAttrValue("page", "errorPage");
        if (errorPage != null) {
            root.setErrorPage("\"" + JspParseTag.sanitizeQuotedString(errorPage) + "\"");
        }
        root.setChildren(this.createChildNodes(context, root, this.body));
        return root;
    }

    public void emit(JspEmitState st) throws JspEmitException {
        st.printLineInfoFile(this.fileName);
        super.emit(st);
        JspParseTagFile parentFileTag = (JspParseTagFile)JspParseTagFile.findAncestorWithClass(this, JspParseTagFile.class);
        if (parentFileTag != null) {
            st.printLineInfoFile(parentFileTag.fileName);
        }
    }

    private void setXMLViewPageEncodingAndContentType(JspParseState st, Element parent) {
        String contentType = null;
        String pageEncoding = null;
        JspDirective dir = (JspDirective)st.directives.get("page");
        if (dir != null) {
            contentType = dir.getAttrValue("contentType");
            pageEncoding = dir.getAttrValue("pageEncoding");
        }
        if (contentType != null && pageEncoding != null) {
            return;
        }
        Element e = JspUtils.createXMLViewStdJspElement(st, this, "directive.page", null, true);
        if (pageEncoding == null) {
            e.setAttributeNS(null, "pageEncoding", "UTF-8");
        }
        if (contentType == null) {
            String ct = "";
            if (st.parms.xmlStyleSrc) {
                ct = "text/xml;charset=UTF-8";
            } else {
                ct = "text/html";
                if (pageEncoding == null) {
                    pageEncoding = JspUtils.getPageEncoding(st.parms.sourceFileName, st.parms.happ);
                }
                if (pageEncoding != null) {
                    ct = ct + ";charset=";
                    ct = ct + pageEncoding;
                }
            }
            e.setAttributeNS(null, "contentType", ct);
        }
        parent.appendChild(e);
    }

    public Element toXMLElement(JspParseState st) {
        if (this.parent == null) {
            if (st.xvd == null) {
                st.xvd = new XMLDocument();
            }
            Element e = st.xvd.createElementNS("http://java.sun.com/JSP/Page", "jsp:root");
            e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:jsp", "http://java.sun.com/JSP/Page");
            if (st.isJspPrefixRedefined) {
                st.jspIdPrefix = this.JSP_ID_PREFIX;
                e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + this.JSP_ID_PREFIX, "http://java.sun.com/JSP/Page");
            }
            JspUtils.setJspIdInXMLView(st, e, this);
            e.setAttributeNS(null, "version", "2.0");
            Enumeration enumerator = st.jspDirectiveTaglibInfoTable.elements();
            Hashtable<String, String> processed = new Hashtable<String, String>();
            while (enumerator.hasMoreElements()) {
                JspDirectiveTaglibInfo dtli = (JspDirectiveTaglibInfo)enumerator.nextElement();
                String key = dtli.isTagDir() ? dtli.getTagDir() : dtli.getXMLStyleURI();
                if (processed.containsKey(key)) continue;
                if (st.curXmlSrcElem == null) {
                    e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + dtli.prefix, key);
                }
                processed.put(key, dtli.prefix);
            }
            this.xmlview_element = e;
            this.setXMLViewPageEncodingAndContentType(st, e);
            this.addBodyElementTo(e, st);
            st.xvd.appendChild((Node)e);
            return e;
        }
        JspParseTag prev = this;
        JspParseTag cur = prev.parent;
        while (cur != null) {
            prev = cur;
            cur = prev.parent;
        }
        this.addBodyElementTo(prev.xmlview_element, st);
        return null;
    }

    public void processAttributeValue(JspParseState st, int index, String name, String value) throws JspParseException {
        if (this.xmlSrcElem == null) {
            return;
        }
        if (name.equals("version") || name.equals("jsp:version")) {
            this.jspXMLSrcVersion = value;
            if (!value.equals("2.0") && !value.equals("1.2") && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("invalid_jsp_version"), value)))) {
                return;
            }
            return;
        }
        if (name.equals("id") || value != null && value.equals("http://java.sun.com/JSP/Page")) {
            return;
        }
        if (this.xmlSrcElem != null) {
            super.processAttributeValue(st, index, name, value);
        }
        if (this.xmlSrcElem != null && this.xmlSrcElem.getLocalName().equals("root") && !name.startsWith("xmlns") && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("jsp_root_invalid_attr"), name)))) {
            return;
        }
    }

    public void validateTagAttributes(JspParseState st) throws JspParseException {
        if (this.xmlSrcElem == null) {
            return;
        }
        if (((XMLElement)this.xmlSrcElem).getExpandedName().equals("http://java.sun.com/JSP/Page:root") && this.jspXMLSrcVersion == null && st.throwParseException(new JspParseException(st, "Missing mandatory jsp version number attribute"))) {
            return;
        }
    }

    public boolean allowsBody() {
        return true;
    }

    public String getSrcEncoding() {
        if (this.xmlSrcElem == null) {
            if (this.nonXMLJspEncoding == null) {
                return "ISO-8859-1";
            }
            return this.nonXMLJspEncoding;
        }
        Document doc = this.xmlSrcElem.getOwnerDocument();
        XMLDocument xdoc = (XMLDocument)doc;
        return xdoc.getEncoding();
    }

    protected String getNodeById(String id) {
        JspParseTag tag = this.findNode(this, new Integer(id));
        if (tag != null) {
            String filename = tag.getContainingFile(this.getFileName());
            String tagname = tag.getTagName() == null ? msgs.getString("unknown") : tag.getTagName();
            return MessageFormat.format(msgs.getString("fill_out_id_map"), filename, tagname, new Integer(tag.lineNumber), new Integer(tag.columnNumber));
        }
        return MessageFormat.format(msgs.getString("invalid_tag_id"), id);
    }

    protected JspParseTag findNode(JspParseTag start, int id) {
        if (start.getId() == id) {
            return start;
        }
        if (start.isLeaf() && start.getId() != 0) {
            return null;
        }
        JspParseTag tf = null;
        tf = start.getId() == 0 ? start : (start.getTagName().equals("directive") && ((JspParseTagDirective)start).getIncludedFileName() != null ? ((JspParseTagDirective)start).getIncludedFile() : start);
        int num = tf.body.size();
        JspParseTag found = null;
        for (int i = 0; found == null && i < num; ++i) {
            found = this.findNode(tf.getChild(i), id);
        }
        return found;
    }
}

