/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.Vector;
import oracle.jsp.parse.Jsp2JavaParms;
import oracle.jsp.parse.JspDirective;
import oracle.jsp.parse.JspDirectiveAttribute;
import oracle.jsp.parse.JspDirectiveInclude;
import oracle.jsp.parse.JspEmitException;
import oracle.jsp.parse.JspEmitState;
import oracle.jsp.parse.JspEncodingException;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParsePosition;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspParseTag;
import oracle.jsp.parse.JspParseTagFile;
import oracle.jsp.parse.JspUtils;
import oracle.jsp.parse.JspXMLSrcException;
import oracle.jsp.parse.ParseStateSnapshot;
import oracle.jsp.parse.XMLUtil;
import oracle.jsp.runtime.tree.OracleJspNode;
import oracle.jsp.runtime.tree.OracleJspParseContext;
import oracle.jsp.util.JspUtil;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class JspParseTagDirective
extends JspParseTag {
    private String dirName;
    private String dirValue;
    private Vector directiveAttrNames = new Vector();
    private Vector directiveAttrValues = new Vector();
    private JspDirective directive;
    private JspParsePosition startPos;
    private String directiveName;
    private boolean virtual = false;
    private JspParseTagFile includedFile;

    public JspParseTagDirective() {
        super(2);
    }

    public String getTagName() {
        return "directive";
    }

    protected void setTagString(String tag) {
        super.setTagString(tag);
        if (tag.indexOf(":directive.") != -1) {
            this.directiveName = tag.substring(tag.indexOf(":directive.") + 11);
        } else if (tag.indexOf("directive.") != -1) {
            this.directiveName = tag.substring(tag.indexOf("directive.") + "directive.".length());
        }
        this.dirName = this.directiveName;
    }

    protected boolean isEndAVTag(JspParseState st, String tag) {
        if (tag.equals("%>") && this.directiveName == null) {
            st.tagHasBody = false;
            return true;
        }
        if (tag.equals("/>") && this.directiveName != null) {
            st.tagHasBody = false;
            return true;
        }
        if (tag.equals(">")) {
            st.tagHasBody = true;
            return true;
        }
        return false;
    }

    public void validateTagAttributes(JspParseState st) throws JspParseException {
        if (this.directive == null && st.throwParseException(new JspParseException(st, msgs.getString("no_direct_name")))) {
            return;
        }
        this.directive.validateAttributes(st);
        this.validateFileEncoding(st);
        st.directives.put(this.directive.getName(), this.directive);
    }

    private void validateFileEncoding(JspParseState st) throws JspEncodingException, JspParseException {
        if (this.directive.getName().equals("page")) {
            JspParseTagFile file = (JspParseTagFile)JspParseTagFile.findAncestorWithClass(this, JspParseTagFile.class);
            String encoding = null;
            String currentEncoding = file.getSrcEncoding();
            if (this.xmlSrcElem == null) {
                file.configEncoding = JspUtils.getPageEncoding(file.fileName, st.parms.happ);
                file.pageEncoding = this.directive.getAttrValue("pageEncoding");
                if (JspUtils.isMismatchEncoding(file.configEncoding, file.pageEncoding) && st.throwParseException(new JspParseException(st, msgs.getString("config_page_encoding_mismatch")))) {
                    return;
                }
                if (file.configEncoding != null) {
                    encoding = file.configEncoding;
                } else if (file.pageEncoding != null) {
                    encoding = file.pageEncoding;
                } else {
                    String contentType = this.directive.getAttrValue("contentType");
                    file.contentEncoding = JspUtils.extractEncoding(contentType);
                    if (file.contentEncoding != null) {
                        encoding = file.contentEncoding;
                    }
                }
                if (encoding == null) {
                    // empty if block
                }
                if (encoding != null && JspUtils.isMismatchEncoding(currentEncoding, encoding)) {
                    throw new JspEncodingException(st, currentEncoding, encoding);
                }
            } else {
                file.pageEncoding = this.directive.getAttrValue("pageEncoding");
                if (JspUtils.isMismatchEncoding(file.xmlEncoding, file.pageEncoding) && st.throwParseException(new JspParseException(st, msgs.getString("xml_page_encoding_mismatch")))) {
                    return;
                }
                if (JspUtils.isMismatchEncoding(file.configEncoding, file.pageEncoding) && st.throwParseException(new JspParseException(st, msgs.getString("config_page_encoding_mismatch")))) {
                    return;
                }
            }
        }
    }

    public void processAttributeValue(JspParseState st, int index, String name, String value) throws JspParseException {
        if (index == 1 && this.directiveName == null) {
            this.directive = st.getDirectiveHandler(name);
            if (this.directive == null && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("undef_direct"), name)))) {
                return;
            }
            this.directive.setValue(value);
            this.dirName = name;
            this.dirValue = value;
        } else {
            if (this.directive == null && st.throwParseException(new JspParseException(st, msgs.getString("no_direct")))) {
                return;
            }
            if (name.equals(this.directive.getName())) {
                this.directive.setValue(value);
                this.dirName = name;
                this.dirValue = value;
            } else {
                JspDirectiveAttribute a;
                if (this.xmlSrcElem != null && this.dirName.equals("page") && name.equals("jsp:id")) {
                    return;
                }
                if (this.dirName.equals("page") && name.equals("pageEncoding") && !st.parms.forgiveDupDirectiveAttr) {
                    JspParseTagFile fileTag = (JspParseTagFile)JspParseTagFile.findAncestorWithClass(this, JspParseTagFile.class);
                    if (fileTag.pageEncodingEncountered) {
                        if (st.throwParseException(new JspParseException(st, msgs.getString("dup_encoding_in_file")))) {
                            return;
                        }
                    } else {
                        fileTag.pageEncodingEncountered = true;
                    }
                }
                if (!st.parms.forgiveDupDirectiveAttr && this.directiveAttrNames.contains(name) && (a = this.directive.findAttribute(name)) != null && !a.description.accumulate && st.throwParseException(new JspParseException(st, JspUtil.format(msgs.getString("duplicate_attr"), new Object[]{name})))) {
                    return;
                }
                this.directive.addAttribute(st, name, value);
                this.directiveAttrNames.addElement(name);
                this.directiveAttrValues.addElement(value);
            }
        }
    }

    private JspParseTag findRootParent() {
        JspParseTag nextParent;
        JspParseTag myParent = this.parent;
        if (myParent == null || !(myParent instanceof JspParseTagFile)) {
            return myParent;
        }
        while ((nextParent = myParent.parent) != null && nextParent instanceof JspParseTagFile) {
            myParent = nextParent;
        }
        return myParent;
    }

    protected void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parse(JspParseState st) throws IOException, JspParseException {
        if (this.directiveName != null) {
            this.directive = st.getDirectiveHandler(this.directiveName);
            if (this.directive == null && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("undef_direct"), this.directiveName)))) {
                return;
            }
        }
        if (!this.virtual) {
            super.parse(st);
        }
        if (this.directive == null) {
            return;
        }
        if (this.directive.getClass() == JspDirectiveInclude.class) {
            String file = ((JspDirectiveInclude)this.directive).file;
            file = st.parms.oldIncludeDirective ? JspUtils.handlePagePath(st.parms.pagePath, file) : JspUtils.handlePagePath(JspUtil.stripTarget(st.position.currentSourceFile), file);
            if (file == null && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("include_unresolved"), ((JspDirectiveInclude)this.directive).file)))) {
                return;
            }
            if (st.parms.resourceProvider == null && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("cannot_include"), file)))) {
                return;
            }
            boolean fileCaseSensitive = File.separatorChar == '/';
            JspParseTag cur = this.parent;
            while (cur != null) {
                if (cur instanceof JspParseTagFile) {
                    JspParseTagFile fileTag = (JspParseTagFile)cur;
                    String parentFileName = fileTag.getFileName();
                    if (fileCaseSensitive ? file.equals(parentFileName) && st.throwParseException(new JspParseException(st, "recursive include directive")) : file.equalsIgnoreCase(parentFileName) && st.throwParseException(new JspParseException(st, "recursive include directive"))) {
                        return;
                    }
                }
                cur = cur.parent;
            }
            String encoding = JspUtils.getPageEncoding(file, st.parms.happ);
            if (encoding == null) {
                encoding = "ISO-8859-1";
            }
            InputStream inStream = null;
            try {
                block21: {
                    try {
                        long lastModified = XMLUtil.getLastModified(st, file);
                        st.addIncludeDependency(file, lastModified);
                        inStream = XMLUtil.getFromStream(st, file);
                    }
                    catch (FileNotFoundException e) {
                        if (!st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("no_includef"), file)))) break block21;
                        if (inStream != null) {
                            inStream.close();
                        }
                        return;
                    }
                }
                String oldFile = st.position.currentSourceFile;
                st.position.currentSourceFile = file;
                boolean isXML = JspUtils.determineIsIncludedPageXML(st, file);
                if (this.xmlSrcElem == null) {
                    this.lineNumber = st.position.lineNum;
                }
                this.includedFile = JspParseTagDirective.parseJSP(st, inStream, file, encoding, isXML, this);
                if (this.xmlSrcElem == null) {
                    JspParseTag rootParent = this.findRootParent();
                    rootParent.addTagToBody(st, this);
                }
                st.position.currentSourceFile = oldFile;
            }
            finally {
                if (inStream != null) {
                    inStream.close();
                }
            }
        }
    }

    public void emitTagBody(JspEmitState st) throws JspEmitException {
        if (this.includedFile != null) {
            Jsp2JavaParms cfr_ignored_0 = st.parms;
            if (st.parms.gensmap != 0) {
                if (this.xmlSrcElem == null) {
                    st.printLineInfo(this.lineNumber + 1, this.columnNumber);
                } else {
                    st.printLineInfo(this.lineNumber, this.columnNumber);
                }
                st.iprintln("out.write(\"\");");
            }
            this.includedFile.emit(st);
        }
    }

    public Element toXMLElement(JspParseState st) {
        if (this.includedFile != null) {
            return this.includedFile.toXMLElement(st);
        }
        if (this.dirName.equals("page")) {
            Element e = JspUtils.createXMLViewStdJspElement(st, this, "directive.page");
            for (int i = 0; i < this.directiveAttrNames.size(); ++i) {
                String a = (String)this.directiveAttrNames.elementAt(i);
                String v = (String)this.directiveAttrValues.elementAt(i);
                if (a.startsWith("xmlns")) {
                    e.setAttributeNS("http://www.w3.org/2000/xmlns/", a, v);
                    continue;
                }
                if (a.startsWith("contentType")) {
                    String enc = JspUtils.extractEncoding(v);
                    if (enc != null && enc.length() > 0) {
                        e.setAttributeNS(null, "contentType", v);
                        continue;
                    }
                    String ct = JspUtils.extractContentType(v);
                    if (st.parms.xmlStyleSrc) {
                        ct = ct + ";charset=UTF-8";
                    } else {
                        String pageEncoding = null;
                        JspDirective dir = (JspDirective)st.directives.get("page");
                        if (dir != null) {
                            pageEncoding = dir.getAttrValue("pageEncoding");
                        }
                        if (pageEncoding == null) {
                            pageEncoding = JspUtils.getPageEncoding(st.parms.sourceFileName, st.parms.happ);
                        }
                        if (pageEncoding != null) {
                            ct = ct + ";charset=";
                            ct = ct + pageEncoding;
                        }
                    }
                    e.setAttributeNS(null, "contentType", ct);
                    continue;
                }
                if (a.startsWith("pageEncoding")) {
                    e.setAttributeNS(null, "pageEncoding", "UTF-8");
                    continue;
                }
                e.setAttributeNS(null, a, v);
            }
            return e;
        }
        return null;
    }

    protected JspParseTagFile getIncludedFile() {
        return this.includedFile;
    }

    protected String getIncludedFileName() {
        if (this.includedFile != null) {
            return this.includedFile.getFileName();
        }
        return null;
    }

    public static JspParseTagFile parseJSP(JspParseState st, InputStream in, String file, String encoding, boolean isXML, JspParseTag parent) throws JspParseException, IOException {
        ParseStateSnapshot snapshot = st.saveCurrentParseState();
        JspParseTagFile tagfile = null;
        BufferedInputStream buffer = new BufferedInputStream(in);
        buffer.mark(0x100000);
        String byteOrderMarkEncoding = JspUtil.scanForByteOrderMark(buffer);
        buffer.reset();
        int BOMLen = 0;
        boolean parseWithDefaultEnc = false;
        String ianaEnc = null;
        if (byteOrderMarkEncoding != null) {
            BOMLen = JspUtil.getBOMLengthInBytes(byteOrderMarkEncoding);
            ianaEnc = JspUtil.convIANAtoJavaEncoding(byteOrderMarkEncoding, true);
        }
        if (ianaEnc != null) {
            encoding = ianaEnc;
        }
        while (true) {
            try {
                if (isXML) {
                    Document doc = XMLUtil.getDocument(buffer, 0, null, null, true, true, false);
                    tagfile = new JspParseTagFile(st, doc.getDocumentElement(), file);
                    tagfile.setFileName(file);
                    tagfile.setParent(parent);
                    tagfile.xmlEncoding = ((XMLDocument)doc).getXmlEncoding();
                    tagfile.configEncoding = JspUtils.getPageEncoding(file, st.parms.happ);
                    if (JspUtils.isMismatchEncoding(tagfile.xmlEncoding, tagfile.configEncoding) && st.throwParseException(new JspParseException(st, msgs.getString("xml_config_encoding_mismatch")))) {
                        return null;
                    }
                    tagfile.parse(st);
                    return tagfile;
                }
                if (BOMLen != 0 && !parseWithDefaultEnc && JspUtil.needToSkipBOM(byteOrderMarkEncoding, encoding)) {
                    buffer.skip(BOMLen);
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)buffer, encoding));
                tagfile = new JspParseTagFile(st, reader, encoding);
                tagfile.setFileName(file);
                tagfile.setParent(parent);
                tagfile.configEncoding = JspUtils.getPageEncoding(file, st.parms.happ);
                tagfile.parse(st);
                parseWithDefaultEnc = false;
                if (BOMLen != 0 && JspUtils.isMismatchEncoding(st.parms.encoding, "ISO-8859-1") && tagfile.configEncoding == null && tagfile.pageEncoding == null && tagfile.contentEncoding == null) {
                    parseWithDefaultEnc = true;
                    throw new JspEncodingException(st, st.parms.encoding, "ISO-8859-1", false);
                }
                return tagfile;
            }
            catch (XMLParseException e) {
                if (st.throwParseException(new JspParseException(-1, "", file, e))) {
                    return null;
                }
            }
            catch (SAXException e) {
                if (st.throwParseException(new JspParseException(-1, "", file, e))) {
                    return null;
                }
            }
            catch (JspXMLSrcException e) {
                isXML = true;
            }
            catch (JspEncodingException e) {
                encoding = e.getSpecifiedEncoding();
            }
            buffer.reset();
            st.restoreCurrentParseState(snapshot);
        }
    }

    public OracleJspNode createNode(OracleJspParseContext context, OracleJspNode parent) {
        if (this.includedFile != null) {
            return this.includedFile.createNode(context, parent);
        }
        return super.createNode(context, parent);
    }
}

