/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.IOException;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspParseTag;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class JspParseTagCore
extends JspParseTag {
    protected boolean findTagEnd = false;
    protected String terminateStr = "%>";
    protected String xmlSrcBodyStr;

    public JspParseTagCore(int type) {
        super(type);
    }

    public void handleCoreLine(JspParseState st, String line) throws JspParseException {
        int idx = line.indexOf("%\\>");
        while (idx != -1) {
            line = line.substring(0, idx + 1) + line.substring(idx + 2);
            idx = line.indexOf("%\\>", idx + 1);
        }
        this.processCoreLine(st, line);
    }

    public void processCoreLine(JspParseState st, String line) throws JspParseException {
        if ((st.parms.scriptingInvalid || this.ancestorDisallowsScripting(this)) && st.throwParseException(new JspParseException(st, msgs.getString("no_scripting")))) {
            return;
        }
    }

    public void parse(JspParseState st) throws IOException, JspParseException {
        int idx;
        if (this.xmlSrcElem != null) {
            this.parseXMLSrc(st);
            return;
        }
        this.lineNumber = st.position.lineNum;
        if (this.findTagEnd) {
            if (st.getLine() == null && st.throwParseException(new JspParseException(st, msgs.getString("missing_rtAngle")))) {
                return;
            }
            idx = st.getLine().indexOf(62);
            if (idx > 0 && idx != -1 && st.getLine().charAt(idx - 1) == '/' && st.throwParseException(new JspParseException(st, msgs.getString("missing_body")))) {
                return;
            }
            if (idx != -1) {
                if (idx + 1 < st.getLine().length()) {
                    st.advLine(idx + 1);
                } else {
                    st.clearLine();
                }
            } else if (st.throwParseException(new JspParseException(st, msgs.getString("missing_rtAngle")))) {
                return;
            }
        }
        if (st.getLine() == null || st.getLine().length() == 0) {
            st.ReadLine();
        }
        while (st.getLine() != null) {
            idx = st.getLine().indexOf(this.terminateStr);
            if (idx != -1) {
                if (idx > 0) {
                    this.handleCoreLine(st, st.getLine().substring(0, idx));
                } else {
                    this.handleCoreLine(st, "");
                }
                this.endLineNumber = st.position.lineNum;
                this.endColumnNumber = st.getColNum() + (idx += this.terminateStr.length());
                if (idx >= st.getLine().length()) {
                    st.clearLine();
                } else {
                    st.advLine(idx);
                }
                return;
            }
            this.handleCoreLine(st, st.getLine());
            st.clearLine();
            if (st.getLine() != null && st.getLine().length() != 0) continue;
            st.ReadLine();
        }
        if (st.throwParseException(new JspParseException(st, msgs.getString("bad_eof_in_tag")))) {
            return;
        }
    }

    protected void parseXMLSrc(JspParseState st) throws JspParseException, IOException {
        Node childNode;
        st.position.curXMLSrcElem = this.xmlSrcElem;
        if (this.xmlSrcElem instanceof XMLElement) {
            String tagName;
            XMLElement xe_xmlSrcElem = (XMLElement)this.xmlSrcElem;
            if ((st.parms.scriptingInvalid || this.ancestorDisallowsScripting(this)) && ((tagName = xe_xmlSrcElem.getTagName()).indexOf(":scriptlet") != -1 || tagName.indexOf(":expression") != -1 || tagName.indexOf(":declaration") != -1) && st.throwParseException(new JspParseException(st, msgs.getString("no_scripting")))) {
                return;
            }
            this.lineNumber = xe_xmlSrcElem.getLineNumber();
            this.columnNumber = xe_xmlSrcElem.getColumnNumber();
        }
        if ((childNode = this.xmlSrcElem.getFirstChild()) == null) {
            this.xmlSrcBodyStr = "";
            return;
        }
        if (childNode instanceof Text) {
            this.xmlSrcBodyStr = ((Text)childNode).getData();
            if (childNode.getNextSibling() != null && st.throwParseException(new JspParseException(st, msgs.getString("non_text_not_allowed") + this.xmlSrcElem.getTagName()))) {
                return;
            }
        } else if (st.throwParseException(new JspParseException(st, msgs.getString("non_text_not_allowed") + this.xmlSrcElem.getTagName()))) {
            return;
        }
    }

    public String getString() {
        if (this.xmlSrcElem != null) {
            return this.xmlSrcBodyStr;
        }
        StringBuffer sb = new StringBuffer();
        int max = this.body.size();
        for (int i = 0; i < max; ++i) {
            sb.append((String)this.body.elementAt(i));
        }
        return new String(sb);
    }
}

