/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.jsp.parse.Jsp2JavaParms;
import oracle.jsp.parse.JspEmitException;
import oracle.jsp.parse.JspEmitState;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParsePosition;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspParseTagDirective;
import oracle.jsp.parse.JspParseTagText;
import oracle.jsp.parse.JspParseTagXMLTextContainer;
import oracle.jsp.parse.JspRTTag;
import oracle.jsp.parse.JspUtils;
import oracle.jsp.parse.JspXMLSrcException;
import oracle.jsp.parse.OpenJspTagAttribute;
import oracle.jsp.parse.OpenJspTagBody;
import oracle.jsp.parse.OpenJspTagHandler;
import oracle.jsp.runtime.tree.OracleJspNode;
import oracle.jsp.runtime.tree.OracleJspParseContext;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class JspParseTag {
    protected static final String MSG_FILE = "oracle.jsp.parse.LocalStrings";
    protected static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.parse.LocalStrings");
    public static final int JSPPARSETAG_EL = 0;
    public static final int JSPPARSETAG_TEXT = 1;
    public static final int JSPPARSETAG_DIRECTIVE = 2;
    public static final int JSPPARSETAG_DECLARATION = 3;
    public static final int JSPPARSETAG_EXPRESSION = 4;
    public static final int JSPPARSETAG_SCRIPTLET = 5;
    public static final int JSPPARSETAG_COMMENT = 6;
    public static final int JSPPARSETAG_CUSTOM = 7;
    public static final String JSP_XMLNS = "http://java.sun.com/JSP/Page";
    public static final String XMLNS_XMLNS = "http://www.w3.org/2000/xmlns/";
    public JspParseTag parent;
    public Vector body;
    public Vector jspAttributes;
    private int tagBaseType;
    protected boolean requiresBody;
    protected String tagString;
    protected int lineNumber;
    protected int columnNumber = 0;
    protected int endLineNumber = 0;
    protected int endColumnNumber = 0;
    private int xmlview_jspid = -1;
    protected Element xmlview_element;
    protected Element xmlSrcElem;
    protected NodeList xmlSrcElemChildren;
    protected int xmlSrcBodyLen;
    protected int xmlSrcCurChildIdx;
    private boolean validationDone = false;
    private boolean isCheckingJspAttributeAndBodyRelevant = false;
    private boolean foundJspAttributeTag = false;
    private boolean foundJspBodyTag = false;
    private boolean foundFirstNonTextTag = false;
    protected JspParsePosition positionSnapShotForValidation = null;
    protected boolean scriptingDisallowed = false;
    public static final char[] SANITIZE_FROM_CHAR = new char[]{'\\', '\"', '\r', '\n', '\t', '\b', '\f'};
    public static final String[] SANITIZE_TO_STR = new String[]{"\\\\", "\\\"", "\\r", "\\n", "\\t", "\\b", "\\f"};

    public JspParseTag(int type) {
        this.tagBaseType = type;
        this.body = new Vector();
        this.jspAttributes = new Vector();
    }

    public int getTagBaseType() {
        return this.tagBaseType;
    }

    public void setParent(JspParseTag parent) {
        this.parent = parent;
    }

    public void setXMLSrcElem(JspParseState st, Element xmlSrcElem) {
        this.xmlSrcElem = xmlSrcElem;
        this.xmlSrcElemChildren = xmlSrcElem.getChildNodes();
        this.xmlSrcBodyLen = this.xmlSrcElemChildren.getLength();
        this.xmlSrcCurChildIdx = 0;
        st.curXmlSrcElem = xmlSrcElem;
    }

    public boolean hasBody() {
        return this.body.size() > 0;
    }

    protected int getXMLViewJspId() {
        return this.xmlview_jspid;
    }

    protected void setTagString(String tag) {
        this.tagString = tag;
    }

    public String getTagName() {
        if (this.tagString != null) {
            return this.tagString;
        }
        return "Unknown Tag";
    }

    protected boolean isEndTag(String tag) {
        if (!tag.startsWith("</")) {
            return false;
        }
        if (this.tagString != null) {
            return tag.substring(2).equals(this.tagString);
        }
        return false;
    }

    protected boolean isEndAVTag(JspParseState st, String tag) {
        if (tag.equals(">")) {
            st.tagHasBody = true;
            return true;
        }
        if (tag.equals("/>")) {
            st.tagHasBody = false;
            return true;
        }
        return false;
    }

    public boolean allowsBody() {
        return false;
    }

    protected static int skipWhiteSpace(JspParseState st) throws IOException, JspParseException {
        int max = st.getLineLength();
        int idx = 0;
        boolean done = false;
        while (!done) {
            while (max == 0) {
                if (st.ReadLine() == null && st.throwParseException(new JspParseException(st, msgs.getString("no_tag_end")))) {
                    return -1;
                }
                max = st.getLineLength();
            }
            for (idx = 0; idx < max && Character.isWhitespace(st.getLine().charAt(idx)); ++idx) {
            }
            if (idx < max) {
                done = true;
                continue;
            }
            max = 0;
        }
        return idx;
    }

    protected boolean getAttributeName(JspParseState st) throws IOException, JspParseException {
        int idx = JspParseTag.skipWhiteSpace(st);
        int eIdx = st.getLine().indexOf(62, idx);
        if (eIdx != -1 && this.isEndAVTag(st, st.getLine().substring(idx, eIdx + 1))) {
            st.attributeName = "";
            this.endLineNumber = st.position.lineNum;
            this.endColumnNumber = st.getColNum() + eIdx + 1;
            if (eIdx + 1 < st.getLine().length()) {
                String tagStr;
                st.advLine(eIdx + 1);
                if (st.tagHasBody && st.getLine().length() >= 2 && st.getLine().substring(0, 2).equals("</") && this.isEndTag(tagStr = (idx = JspParseTag.findTagEnd(st.getLine())) >= st.getLine().length() ? st.getLine() : st.getLine().substring(0, idx))) {
                    this.skipEndTag(st);
                    st.tagHasBody = false;
                }
            } else {
                st.clearLine();
            }
            return false;
        }
        int max = st.getLineLength();
        for (eIdx = idx; eIdx < max; ++eIdx) {
            if (st.getLine().charAt(eIdx) != '=' && !Character.isWhitespace(st.getLine().charAt(eIdx)) && st.getLine().charAt(eIdx) != '>') continue;
            st.attributeName = st.getLine().substring(idx, eIdx);
            st.advLine(eIdx);
            return true;
        }
        st.attributeName = st.getLine().substring(idx);
        st.clearLine();
        return true;
    }

    protected static boolean getAttributeValue(JspParseState st) throws IOException, JspParseException {
        int idx = JspParseTag.skipWhiteSpace(st);
        if (st.getLine().charAt(idx) != '=') {
            st.advLine(idx);
            st.attributeValue = null;
            return false;
        }
        if (idx + 1 < st.getLine().length()) {
            st.advLine(idx + 1);
        } else {
            st.clearLine();
        }
        idx = JspParseTag.skipWhiteSpace(st);
        char ch = st.getLine().charAt(idx);
        if (ch != '\"' && ch != '\'' && st.throwParseException(new JspParseException(st, msgs.getString("no_quoted_val") + ch))) {
            return false;
        }
        st.attributeValue = "";
        boolean quoteEnd = false;
        boolean escape = false;
        int max = st.getLineLength();
        int eIdx = ++idx;
        while (!quoteEnd) {
            max = st.getLineLength();
            for (eIdx = idx; eIdx < max; ++eIdx) {
                if (!escape) {
                    if (st.getLine().charAt(eIdx) == ch) {
                        quoteEnd = true;
                        break;
                    }
                    if (st.getLine().charAt(eIdx) == '\\') {
                        escape = true;
                        continue;
                    }
                    escape = false;
                    continue;
                }
                escape = false;
            }
            if (eIdx > idx) {
                st.attributeValue = st.attributeValue + st.getLine().substring(idx, eIdx);
            }
            if (eIdx != max) continue;
            st.ReadLine();
            if (st.getLine() == null && st.throwParseException(new JspParseException(st, msgs.getString("eof_in_Str")))) {
                return false;
            }
            idx = 0;
        }
        if (eIdx + 1 < st.getLine().length()) {
            st.advLine(eIdx + 1);
        } else {
            st.clearLine();
        }
        if (!JspUtils.isELEvaluationOn(st)) {
            st.attributeValue = JspUtils.decodeQuotes(st.attributeValue);
        }
        String temp = JspUtils.decodeQuotes(st.attributeValue);
        return true;
    }

    public void processAttributeValue(JspParseState st, int index, String name, String value) throws JspParseException {
        if (this.xmlSrcElem != null && name.startsWith("xmlns")) {
            String prefix;
            if (value.equals(JSP_XMLNS)) {
                return;
            }
            String string = prefix = name.startsWith("xmlns:") ? name.substring("xmlns:".length(), name.length()) : name.substring("xmlns".length(), name.length());
            if (prefix.equals("jsp") && !st.isJspPrefixRedefined) {
                st.isJspPrefixRedefined = true;
            }
            String uri = null;
            String originalUri = null;
            String tagdir = null;
            if (value.startsWith("urn:jsptagdir:")) {
                tagdir = value.substring(14, value.length());
            } else {
                uri = value.startsWith("urn:jsptld:") ? value.substring(11, value.length()) : value;
            }
            originalUri = value;
            this.addTagLibDirective(st, prefix, uri, originalUri, tagdir);
        }
    }

    protected void parseFileEnd(JspParseState st) throws JspParseException {
        if (st.throwParseException(new JspParseException(st, msgs.getString("bad_eof")))) {
            return;
        }
    }

    public void validateTagAttributes(JspParseState st) throws JspParseException {
    }

    public void validateTagParse(JspParseState st) throws JspParseException {
    }

    public boolean isTagValidInBody(JspParseState st, String tagStr, Class tagClass, JspParseTag tag) {
        return true;
    }

    protected void skipEndTag(JspParseState st) throws JspParseException {
        int idx = st.getLine().indexOf(62);
        if (idx == -1) {
            if (st.throwParseException(new JspParseException(st, msgs.getString("bad_term")))) {
                return;
            }
        } else if (idx + 1 < st.getLine().length()) {
            st.advLine(idx + 1);
            this.endLineNumber = st.position.lineNum;
            this.endColumnNumber = st.getColNum();
        } else {
            st.clearLine();
            this.endLineNumber = st.position.lineNum;
            this.endColumnNumber = st.getColNum() + idx + 1;
        }
    }

    protected static int findTagEnd(String line) {
        int max = line.length();
        for (int idx = 0; idx < max; ++idx) {
            if (Character.isWhitespace(line.charAt(idx))) {
                return idx;
            }
            if (line.charAt(idx) != '>') continue;
            if (idx > 0 && line.charAt(idx - 1) == '/') {
                --idx;
            }
            return idx;
        }
        return max;
    }

    protected JspParseTag parseXMLSrcNextTag(JspParseState st) throws JspParseException, IOException {
        Node n = this.xmlSrcElemChildren.item(this.xmlSrcCurChildIdx);
        ++this.xmlSrcCurChildIdx;
        return this.genXMLSrcTag(st, n);
    }

    protected void processXmlNamespaceAttrs(JspParseState st, Element n) throws JspParseException {
        st.curXmlSrcElem = n;
        NamedNodeMap nmap = n.getAttributes();
        for (int i = 0; i < nmap.getLength(); ++i) {
            Node attrNode = nmap.item(i);
            if (!attrNode.getNodeName().startsWith("xmlns")) continue;
            this.processAttributeValue(st, i, attrNode.getNodeName(), attrNode.getNodeValue());
        }
    }

    protected JspParseTag genXMLSrcTag(JspParseState st, Node n) throws JspParseException, IOException {
        if (n instanceof Element) {
            if (n.getNamespaceURI() != null && n.getNamespaceURI().equals(JSP_XMLNS) && n.getLocalName().equals("root") && st.elemCount != 0 && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("jsp_root_not_top"), n.getNodeName())))) {
                return null;
            }
            ++st.elemCount;
            Element childElem = (Element)n;
            String expandedName = "<" + ((XMLElement)childElem).getExpandedName();
            String prefix = ((XMLElement)childElem).getPrefix();
            this.processXmlNamespaceAttrs(st, childElem);
            String tagName = childElem.getTagName();
            String tagStr = "<" + tagName;
            int idx = tagStr.indexOf(58);
            if (!st.isKnownTagXMLSrc(expandedName)) {
                String prefixValue;
                if (n.getNamespaceURI() != null && n.getNamespaceURI().equals(JSP_XMLNS) && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("jsp_tag_not_allowed_here"), n.getNodeName())))) {
                    return null;
                }
                if (idx != -1 && idx > 1 && prefix != null && (prefixValue = ((XMLElement)this.xmlSrcElem).resolveNamespacePrefix(prefix)) != null && st.prefixRegistered(prefixValue) && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("bad_tag"), expandedName.substring(1))))) {
                    return null;
                }
                JspParseTagXMLTextContainer xtc = new JspParseTagXMLTextContainer(this);
                xtc.lineNumber = ((XMLElement)childElem).getLineNumber();
                xtc.setTagString(tagName);
                xtc.setXMLSrcElem(st, childElem);
                if (!this.validationDone) {
                    this.validateTagAttributes(st);
                    this.validationDone = true;
                }
                xtc.parse(st);
                return xtc;
            }
            if ((tagStr.startsWith("<jsp:attribute") || expandedName.startsWith("<http://java.sun.com/JSP/Page:body") || tagStr.startsWith("<jsp:body") || expandedName.startsWith("<http://java.sun.com/JSP/Page:body")) && !(this instanceof OpenJspTagHandler) && !((XMLElement)this.xmlSrcElem).getExpandedName().equals("http://java.sun.com/JSP/Page:root") && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("bad_jspattribute_jspbody"), tagStr.substring(1))))) {
                return null;
            }
            this.checkForJspAttributeBodyValidation(st, expandedName);
            JspParseTag tag = st.createTagParser(tagStr, this);
            tag.lineNumber = ((XMLElement)childElem).getLineNumber();
            tag.setXMLSrcElem(st, childElem);
            tag.setParent(this);
            tag.parse(st);
            return tag;
        }
        if (n instanceof Text) {
            if (n instanceof XMLText && ((XMLText)n).isWhiteSpaceNode()) {
                return null;
            }
            String textStr = ((Text)n).getData();
            JspParseTagText tTag = new JspParseTagText(this);
            tTag.lineNumber = this.getNodeLineNumber((XMLNode)n, textStr);
            tTag.columnNumber = st.getColNum() + 1;
            tTag.setXMLSrcBodyStr(textStr);
            if (JspUtils.isELEvaluationOn(st)) {
                tTag.processELXMLSrc(st);
            }
            return tTag;
        }
        return null;
    }

    private int getNodeLineNumber(XMLNode n, String str) {
        int nodeEndLine = n.getLineNumber();
        int pos = 0;
        boolean firstNewLine = true;
        while (pos < str.length() && pos != -1) {
            if ((pos = str.indexOf(10, pos)) == -1) continue;
            if (firstNewLine) {
                firstNewLine = false;
                if (!str.substring(0, pos).trim().equals("")) {
                    --nodeEndLine;
                }
            } else {
                --nodeEndLine;
            }
            ++pos;
        }
        return nodeEndLine;
    }

    protected JspParseTag parseNextTag(JspParseState st) throws IOException, JspParseException {
        boolean generatingSmap;
        if (st.getLine() == null || st.getLine().length() == 0) {
            st.ReadLine();
        }
        JspParseTagText tTag = null;
        JspParseTag tag = null;
        Jsp2JavaParms cfr_ignored_0 = st.parms;
        boolean bl = generatingSmap = st.parms.gensmap != 0;
        while (st.getLine() != null) {
            int idx;
            if (st.getLine().length() > 0 && st.getLine().charAt(0) == '<') {
                String tagStr;
                idx = JspParseTag.findTagEnd(st.getLine());
                String tStr = "";
                if (idx >= st.getLine().length()) {
                    tStr = tagStr = st.getLine();
                } else {
                    tagStr = st.getLine().substring(0, idx);
                    tStr = tagStr + st.getLine().charAt(idx);
                }
                if (this.isEndTag(tagStr)) {
                    if (tTag != null) {
                        if (JspUtils.isELEvaluationOn(st)) {
                            tTag.processEL(st);
                        }
                        return tTag;
                    }
                    this.skipEndTag(st);
                    return null;
                }
                int tagLen = st.isKnownTag(tagStr);
                if (tagLen != -1) {
                    if (tTag != null) {
                        if (JspUtils.isELEvaluationOn(st)) {
                            tTag.processEL(st);
                        }
                        return tTag;
                    }
                    tagStr = tagStr.substring(0, tagLen);
                    idx = tagStr.length();
                    if ((tagStr.startsWith("<jsp:attribute") || tagStr.startsWith("<jsp:body")) && !(this instanceof OpenJspTagHandler) && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("bad_jspattribute_jspbody"), tagStr.substring(1))))) {
                        return null;
                    }
                    this.checkForJspAttributeBodyValidation(st, tagStr);
                    tag = st.createTagParser(tagStr, this);
                    tag.lineNumber = st.position.lineNum;
                    tag.columnNumber = st.getColNum() + 1;
                    if (idx >= st.getLine().length()) {
                        st.clearLine();
                    } else {
                        st.advLine(idx);
                    }
                    int bodyLen = this.body.size();
                    if (tag instanceof JspRTTag && ((JspRTTag)tag).getInvalid()) {
                        return tag;
                    }
                    tag.parse(st);
                    if (this.body.size() == bodyLen) {
                        return tag;
                    }
                } else {
                    idx = tagStr.indexOf(58);
                    if (idx != -1 && idx > 1) {
                        String prefix;
                        boolean isEndTag = false;
                        if (tagStr.startsWith("</")) {
                            prefix = tagStr.substring(2, idx);
                            isEndTag = true;
                        } else {
                            prefix = tagStr.substring(1, idx);
                        }
                        if (st.prefixRegistered(prefix)) {
                            if (tagStr.startsWith("<jsp:root")) {
                                throw new JspXMLSrcException(st.position, MessageFormat.format(msgs.getString("jsp_root_in_non_xml_1"), tagStr));
                            }
                            if (isEndTag && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("extra_etag"), tStr)))) {
                                return null;
                            }
                            if (st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("bad_tag"), tagStr.substring(1))))) {
                                return null;
                            }
                        }
                        st.addPrefix(prefix);
                    }
                    if (tTag == null) {
                        tTag = new JspParseTagText(this);
                        tTag.lineNumber = st.position.lineNum;
                        tTag.columnNumber = st.getColNum() + 1;
                    }
                    tTag.addLine(generatingSmap, st.getLine().substring(0, 1));
                    tTag.endLineNumber = st.position.lineNum;
                    tTag.endColumnNumber = st.getColNum() + 1;
                    if (st.getLine().length() > 1) {
                        st.advLine(1);
                    } else {
                        st.clearLine();
                    }
                }
            } else {
                idx = st.getLine().indexOf(60);
                if (tTag == null) {
                    tTag = new JspParseTagText(this);
                    tTag.lineNumber = st.position.lineNum;
                    tTag.columnNumber = st.getColNum() + 1;
                }
                if (idx != -1) {
                    tTag.addLine(generatingSmap, st.getLine().substring(0, idx));
                    st.advLine(idx);
                    tTag.endLineNumber = st.position.lineNum;
                    tTag.endColumnNumber = st.getColNum();
                } else {
                    tTag.addLine(generatingSmap, st.getLine());
                    tTag.endLineNumber = st.position.lineNum;
                    tTag.endColumnNumber = st.getColNum() + st.getLine().length();
                    st.clearLine();
                }
            }
            if (st.getLine() != null && st.getLine().length() != 0) continue;
            st.ReadLine();
        }
        if (tTag != null) {
            Jsp2JavaParms cfr_ignored_1 = st.parms;
            if (st.parms.gensmap != 0) {
                tTag.lastRealJspLineNum = st.position.lineNum;
            }
            if (JspUtils.isELEvaluationOn(st)) {
                tTag.processEL(st);
            }
            return tTag;
        }
        this.parseFileEnd(st);
        return null;
    }

    public void parseXMLSrcBody(JspParseState st) throws JspParseException, IOException {
        this.setAttributeBodyFlagAndValidate(st);
        while (this.xmlSrcCurChildIdx < this.xmlSrcBodyLen) {
            JspParseTag tag = this.parseXMLSrcNextTag(st);
            if (tag == null) continue;
            this.checkForJspAttributeAndBody(st, tag, true);
            this.addTagToBody(st, tag);
        }
    }

    private void setAttributeBodyFlagAndValidate(JspParseState st) throws JspParseException {
        if ((this instanceof OpenJspTagHandler || this.xmlSrcElem != null && this.xmlSrcElem.getNamespaceURI() != null && this.xmlSrcElem.getNamespaceURI().equals(JSP_XMLNS) && this.xmlSrcElem.getLocalName().equals("root")) && !(this instanceof OpenJspTagAttribute) && !(this instanceof OpenJspTagBody)) {
            this.isCheckingJspAttributeAndBodyRelevant = true;
        }
        if (!this.isCheckingJspAttributeAndBodyRelevant && !this.validationDone) {
            this.validateTagAttributes(st);
            this.validationDone = true;
        }
        if (!this.validationDone) {
            this.positionSnapShotForValidation = st.getPosition();
        }
    }

    private void checkForJspAttributeBodyValidation(JspParseState st, String tagStr) throws IOException, JspParseException {
        String origTagStr = null;
        origTagStr = this.xmlSrcElem != null && tagStr.indexOf(":") != -1 ? ((XMLElement)this.xmlSrcElem).getPrefix() + tagStr.substring(tagStr.indexOf(":"), tagStr.length()) : tagStr;
        if (this.isCheckingJspAttributeAndBodyRelevant) {
            if (tagStr.startsWith("<jsp:body") || tagStr.startsWith("<http://java.sun.com/JSP/Page:body")) {
                this.isCheckingJspAttributeAndBodyRelevant = false;
            } else if (!tagStr.startsWith("<jsp:attribute") && !tagStr.startsWith("<http://java.sun.com/JSP/Page:attribute")) {
                if (this.foundJspAttributeTag || this.foundJspBodyTag) {
                    if (st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("bad_tag_after_jspbody_jspattribute"), origTagStr + ">")))) {
                        return;
                    }
                } else {
                    this.isCheckingJspAttributeAndBodyRelevant = false;
                }
            }
        } else if ((tagStr.startsWith("<jsp:body") || tagStr.startsWith("<http://java.sun.com/JSP/Page:body") || tagStr.startsWith("<jsp:attribute") || tagStr.startsWith("<http://java.sun.com/JSP/Page:attribute")) && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("jspbody_jspattribute_not_allowed"), origTagStr + ">")))) {
            return;
        }
        if (!this.isCheckingJspAttributeAndBodyRelevant && !this.validationDone) {
            this.validateTagAttributes(st);
            this.validationDone = true;
        }
    }

    private void checkForJspAttributeAndBody(JspParseState st, JspParseTag tag, boolean isxml) throws IOException, JspParseException {
        if (!this.foundFirstNonTextTag && !(tag instanceof JspParseTagText)) {
            this.foundFirstNonTextTag = true;
            if (tag instanceof OpenJspTagBody) {
                this.isCheckingJspAttributeAndBodyRelevant = false;
            } else if (!(tag instanceof OpenJspTagAttribute)) {
                this.isCheckingJspAttributeAndBodyRelevant = false;
            }
        }
        if (this.foundFirstNonTextTag) {
            if (this.isCheckingJspAttributeAndBodyRelevant || this.foundJspBodyTag || this.foundJspAttributeTag) {
                if (!isxml) {
                    if (tag instanceof JspParseTagText && !JspUtils.isTagWhitespace(tag)) {
                        --st.position.lineNum;
                        if (st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("bad_tag_after_jspbody_jspattribute"), tag.getTagName())))) {
                            return;
                        }
                    }
                } else if (tag instanceof JspParseTagText || tag instanceof JspParseTagXMLTextContainer) {
                    --st.position.lineNum;
                    if (st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("bad_tag_after_jspbody_jspattribute"), tag.getTagName())))) {
                        return;
                    }
                }
            }
        } else if (!isxml) {
            if (tag instanceof JspParseTagText && !JspUtils.isTagWhitespace(tag)) {
                this.isCheckingJspAttributeAndBodyRelevant = false;
            }
        } else if (tag instanceof JspParseTagText || tag instanceof JspParseTagXMLTextContainer) {
            this.isCheckingJspAttributeAndBodyRelevant = false;
        }
        if (tag instanceof OpenJspTagBody) {
            this.foundJspBodyTag = true;
        }
        if (tag instanceof OpenJspTagAttribute) {
            this.foundJspAttributeTag = true;
            this.jspAttributes.addElement((OpenJspTagAttribute)tag);
        }
        if (!this.isCheckingJspAttributeAndBodyRelevant && !this.validationDone) {
            this.validateTagAttributes(st);
            this.validationDone = true;
        }
    }

    public void parseBody(JspParseState st) throws IOException, JspParseException {
        JspParseTag tag;
        this.setAttributeBodyFlagAndValidate(st);
        while ((tag = this.parseNextTag(st)) != null) {
            this.checkForJspAttributeAndBody(st, tag, false);
            this.addTagToBody(st, tag);
        }
    }

    public void addTagToBody(JspParseState st, JspParseTag tag) throws JspParseException {
        this.body.addElement(tag);
    }

    protected void parseXMLSrc(JspParseState st) throws JspParseException, IOException {
        st.position.curXMLSrcElem = this.xmlSrcElem;
        if (this.xmlSrcElem instanceof XMLElement) {
            XMLElement xe_xmlSrcElem = (XMLElement)this.xmlSrcElem;
            this.lineNumber = xe_xmlSrcElem.getLineNumber();
            this.columnNumber = xe_xmlSrcElem.getColumnNumber();
        }
        NamedNodeMap attrList = this.xmlSrcElem.getAttributes();
        int len = attrList.getLength();
        for (int i = 0; i < len; ++i) {
            Node attr = attrList.item(i);
            st.attributeName = attr.getNodeName();
            st.attributeValue = attr.getNodeValue();
            this.processAttributeValue(st, i, st.attributeName, st.attributeValue);
        }
        st.tagHasBody = this.xmlSrcElem.hasChildNodes();
        if (st.tagHasBody) {
            if (this.allowsBody()) {
                this.parseXMLSrcBody(st);
            } else if (st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("no_slash"), this.getTagName())))) {
                return;
            }
        } else if (this.requiresBody && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("no_body"), this.getTagName())))) {
            return;
        }
        if (!this.validationDone) {
            this.validateTagAttributes(st);
            this.validationDone = true;
        }
        this.checkForRightBody(st);
        this.validateTagParse(st);
    }

    protected void parse(JspParseState st) throws IOException, JspParseException {
        if (this.xmlSrcElem != null) {
            this.parseXMLSrc(st);
            return;
        }
        this.lineNumber = st.position.lineNum;
        boolean avDone = false;
        int avItemNum = 0;
        while (!avDone) {
            if (this.getAttributeName(st)) {
                JspParseTag.getAttributeValue(st);
                ++avItemNum;
                if (st.attributeName != null && st.attributeName.length() > 0) {
                    this.processAttributeValue(st, avItemNum, st.attributeName, st.attributeValue);
                    continue;
                }
                if (!st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("cannot_get_attr"), this.getTagName())))) continue;
                return;
            }
            avDone = true;
        }
        if (st.tagHasBody) {
            if (this.allowsBody()) {
                this.parseBody(st);
            } else if (st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("no_slash"), this.getTagName())))) {
                return;
            }
        } else if (this.requiresBody && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("no_body"), this.getTagName())))) {
            return;
        }
        if (!this.validationDone) {
            this.validateTagAttributes(st);
            this.validationDone = true;
        }
        this.checkForRightBody(st);
        this.validateTagParse(st);
    }

    private void copyTheRightBody(JspParseState st, Vector bodyVector) throws JspParseException {
        this.body.clear();
        int max = bodyVector.size();
        for (int i = 0; i < max; ++i) {
            this.addTagToBody(st, (JspParseTag)bodyVector.elementAt(i));
        }
    }

    protected void checkForRightBody(JspParseState st) throws JspParseException {
        JspParseTag jspbodyTag = this.findTagInBody("body");
        if (jspbodyTag != null) {
            this.copyTheRightBody(st, jspbodyTag.body);
        } else if (this.jspAttributes.size() > 0) {
            this.body.clear();
        }
    }

    public JspParseTag findTagInBody(String tagName) {
        if (this.body == null) {
            return null;
        }
        int max = this.body.size();
        int idx = -1;
        for (int i = 0; i < max; ++i) {
            JspParseTag tag = (JspParseTag)this.body.elementAt(i);
            if (tag.tagString == null) continue;
            if (tag.xmlSrcElem == null) {
                if (!tag.tagString.equals("jsp:" + tagName)) continue;
                return tag;
            }
            idx = tag.tagString.indexOf(":");
            String name = null;
            String prefix = null;
            if (idx != -1) {
                prefix = tag.tagString.substring(0, idx);
                name = tag.tagString.substring(idx + 1, tag.tagString.length());
            } else {
                prefix = "#default";
                name = tag.tagString;
            }
            String namespace = ((XMLElement)tag.xmlSrcElem).resolveNamespacePrefix(prefix);
            if (namespace == null || !namespace.equals(JSP_XMLNS) || name == null || !name.equals(tagName)) continue;
            return tag;
        }
        return null;
    }

    public static JspParseTag findAncestorWithClass(JspParseTag tag, Class k) {
        JspParseTag cur = tag.parent;
        while (cur != null) {
            if (k.isAssignableFrom(cur.getClass())) {
                return cur;
            }
            cur = cur.parent;
        }
        return null;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getEndLineNumber() {
        return this.endLineNumber;
    }

    public int getEndColumnNumber() {
        return this.endColumnNumber;
    }

    protected List createChildNodes(OracleJspParseContext context, OracleJspNode parent, Vector body) {
        ArrayList<OracleJspNode> children = new ArrayList<OracleJspNode>(body.size());
        for (int i = 0; i < body.size(); ++i) {
            JspParseTag tag = (JspParseTag)body.elementAt(i);
            if (tag == null || tag instanceof OpenJspTagAttribute) continue;
            OracleJspNode child = tag.createNode(context, parent);
            if (tag instanceof JspParseTagDirective) {
                children.addAll(child.getChildren());
                continue;
            }
            children.add(child);
        }
        return children;
    }

    public OracleJspNode createNode(OracleJspParseContext context, OracleJspNode parent) {
        OracleJspNode node = new OracleJspNode();
        node.setParent(parent);
        node.setChildren(this.createChildNodes(context, node, this.body));
        return node;
    }

    public void emit(JspEmitState st) throws JspEmitException {
        st.printLineInfo(st.parseState.parms.xmlStyleSrc ? this.lineNumber : this.lineNumber + 1, this.columnNumber);
        Jsp2JavaParms cfr_ignored_0 = st.parms;
        if (st.parms.gensmap != 0 && this instanceof JspParseTagText && ((JspParseTagText)this).lastRealJspLineNum != 0) {
            st.lastRealJspLineNum = ((JspParseTagText)this).lastRealJspLineNum;
        }
        st.tps.setAttribute("current.tag", this);
        st.tps.fireEvent(128L);
        this.emitTagStart(st);
        st.tps.setAttribute("current.tag", this);
        st.tps.fireEvent(256L);
        st.tps.setAttribute("current.tag", this);
        st.tps.fireEvent(512L);
        this.emitTagBody(st);
        st.tps.setAttribute("current.tag", this);
        st.tps.fireEvent(1024L);
        st.tps.setAttribute("current.tag", this);
        st.tps.fireEvent(2048L);
        this.emitTagEnd(st);
        st.tps.setAttribute("current.tag", this);
        st.tps.fireEvent(4096L);
    }

    public void emitTagStart(JspEmitState st) throws JspEmitException {
    }

    public void emitTagBody(JspEmitState st) throws JspEmitException {
        int max = this.body.size();
        for (int i = 0; i < max; ++i) {
            JspParseTag tag = (JspParseTag)this.body.elementAt(i);
            if (tag == null || tag instanceof OpenJspTagAttribute) continue;
            tag.emit(st);
        }
    }

    public void emitTagEnd(JspEmitState st) throws JspEmitException {
    }

    public static String sanitizeQuotedString(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        char[] srcChars = s.toCharArray();
        int srcCharsLen = srcChars.length;
        for (int i = 0; i < srcCharsLen; ++i) {
            boolean match = false;
            for (int j = 0; j < SANITIZE_FROM_CHAR.length; ++j) {
                if (srcChars[i] != SANITIZE_FROM_CHAR[j]) continue;
                match = true;
                sb.append(SANITIZE_TO_STR[j]);
                break;
            }
            if (match) continue;
            sb.append(srcChars[i]);
        }
        return new String(sb);
    }

    public Element toXMLElement(JspParseState st) {
        return null;
    }

    protected int getXMLViewJspId(JspParseState st) {
        if (this.xmlview_jspid == -1) {
            this.xmlview_jspid = st.getXMLViewJspIdCount();
        }
        return this.xmlview_jspid;
    }

    protected void addBodyElementTo(Element containingElem, JspParseState st) {
        for (int i = 0; i < this.body.size(); ++i) {
            JspParseTag t = (JspParseTag)this.body.elementAt(i);
            Element e = t.toXMLElement(st);
            if (e == null) continue;
            containingElem.appendChild(e);
        }
    }

    public static Text createCDATAText(String s, JspParseState st) {
        if (s.indexOf("]]>") >= 0) {
            return st.xvd.createTextNode(s);
        }
        return st.xvd.createCDATASection(s);
    }

    protected JspParseTag getChild(int i) {
        return (JspParseTag)this.body.elementAt(i);
    }

    protected int getId() {
        return this.getXMLViewJspId();
    }

    protected boolean isLeaf() {
        if (this.getTagName().equals("directive") && ((JspParseTagDirective)this).getIncludedFileName() != null) {
            return false;
        }
        return this.body.size() == 0;
    }

    protected String getContainingFile(String filename) {
        JspParseTag prev = this;
        JspParseTag cur = prev.parent;
        while (cur != null) {
            if (cur.getTagName().equals("directive") && ((JspParseTagDirective)cur).getIncludedFileName() != null) {
                filename = ((JspParseTagDirective)cur).getIncludedFileName();
                break;
            }
            prev = cur;
            cur = prev.parent;
        }
        return filename;
    }

    protected void addTagLibDirective(JspParseState st, String prefix, String uri, String originalUri, String tagdir) throws JspParseException {
        JspParseTagDirective parseDirective = new JspParseTagDirective();
        parseDirective.setParent(this);
        parseDirective.setVirtual(true);
        parseDirective.processAttributeValue(st, 1, "taglib", null);
        parseDirective.processAttributeValue(st, 2, "prefix", prefix);
        if (uri != null) {
            parseDirective.processAttributeValue(st, 3, "uri", uri);
        } else {
            parseDirective.processAttributeValue(st, 3, "tagdir", tagdir);
        }
        parseDirective.processAttributeValue(st, 4, "originalUri", originalUri);
        parseDirective.validateTagAttributes(st);
        if (st.curXmlSrcElem == null) {
            this.addTagToBody(st, parseDirective);
        }
    }

    protected boolean ancestorDisallowsScripting(JspParseTag tag) {
        JspParseTag cur = tag.parent;
        if (cur instanceof OpenJspTagAttribute) {
            cur = cur.parent.parent;
        }
        while (cur != null) {
            if (cur.scriptingDisallowed) {
                return true;
            }
            cur = cur.parent;
        }
        return false;
    }
}

