/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import oracle.jsp.parse.JspDirective;
import oracle.jsp.parse.JspDirectiveAttrDesc;
import oracle.jsp.parse.JspDirectiveTaglibInfo;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspUtils;
import oracle.jsp.parse.OracleTagLibraryInfo;
import oracle.jsp.parse.XMLUtil;
import oracle.jsp.tagext.SharedTagInfo;
import oracle.jsp.util.JspUtil;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLParseException;

public class JspDirectiveTaglib
extends JspDirective
implements Serializable {
    private static final JspDirectiveAttrDesc[] attrs = new JspDirectiveAttrDesc[4];
    private static final JspDirectiveAttrDesc dirAttr = new JspDirectiveAttrDesc("taglib", true);

    public JspDirectiveTaglib() {
        if (attrs[0] == null) {
            JspDirectiveTaglib.attrs[0] = new JspDirectiveAttrDesc("uri", ';', false, true, false, false);
            JspDirectiveTaglib.attrs[1] = new JspDirectiveAttrDesc("prefix", ';', false, true, false, true);
            JspDirectiveTaglib.attrs[2] = new JspDirectiveAttrDesc("tagdir", ';', false, true, false, false);
            JspDirectiveTaglib.attrs[3] = new JspDirectiveAttrDesc("originalUri", ';', false, true, false, false);
            JspDirectiveTaglib.dirAttr.validValues = new String[0];
        }
    }

    public JspDirectiveAttrDesc getDirectiveDescription() {
        return dirAttr;
    }

    public JspDirectiveAttrDesc[] getAttributeDescriptions() {
        return attrs;
    }

    public String getPrefix() {
        return super.getAttrValue("prefix");
    }

    public String getURI() {
        return super.getAttrValue("uri");
    }

    public String getOriginalURI() {
        return super.getAttrValue("originalUri");
    }

    public String getTagdir() {
        return super.getAttrValue("tagdir");
    }

    private void createAndRegisterTagLib(JspParseState st, String prefix, String uri, String originalUri, String tagDir, String loc) throws IOException, JspParseException {
        OracleTagLibraryInfo tlib = null;
        JspDirectiveTaglibInfo dtli = new JspDirectiveTaglibInfo();
        dtli.prefix = prefix;
        dtli.uri = uri;
        dtli.loc = loc;
        tlib = (OracleTagLibraryInfo)((Object)st.parms.cachedConfigTable.getConfigObject(loc, OracleTagLibraryInfo.class, st));
        OracleTagLibraryInfo otlib = null;
        String oracleLoc = null;
        if (st.parms.jsfShortCut) {
            int endIndex = loc.indexOf(".tld");
            if (endIndex != -1) {
                String locPrefix = loc.substring(0, endIndex);
                oracleLoc = locPrefix + ".otld";
            } else {
                oracleLoc = loc + "_oracle";
            }
            try {
                otlib = (OracleTagLibraryInfo)((Object)st.parms.cachedConfigTable.getConfigObject(oracleLoc, OracleTagLibraryInfo.class, st));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((tlib = tagDir != null ? (OracleTagLibraryInfo)((Object)st.parms.cachedConfigTable.getConfigObject("__tagdir:" + loc, OracleTagLibraryInfo.class, st)) : (OracleTagLibraryInfo)((Object)st.parms.cachedConfigTable.getConfigObject(loc, OracleTagLibraryInfo.class, st))) == null) {
            if (tagDir != null) {
                tlib = XMLUtil.buildImplicitTagFileTLDs(prefix, loc, st);
            } else {
                tlib = XMLUtil.getTagLib(prefix, uri, loc, st, originalUri);
                if (st.parms.jsfShortCut) {
                    try {
                        otlib = XMLUtil.getTagLib(prefix, uri, oracleLoc, st, originalUri);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            if (tlib == null ? JspUtils.allowNonTaglibNamespace(st, originalUri) : tlib.getErrMsg() != null && st.throwParseException(tlib.getErrMsg())) {
                return;
            }
        }
        if (st.curXmlSrcElem != null) {
            String prefixValue = null;
            prefixValue = prefix == null || prefix.equals("") ? originalUri : ((XMLElement)st.curXmlSrcElem).resolveNamespacePrefix(prefix);
            this.registerAllTagHandlersInTlib(tlib, otlib, prefixValue, st);
            dtli.rtTagLibObj = tlib;
            st.jspDirectiveTaglibInfoTable.put(prefixValue, dtli);
            st.registerPrefix(prefixValue);
        } else {
            this.registerAllTagHandlersInTlib(tlib, otlib, prefix, st);
            dtli.rtTagLibObj = tlib;
            st.jspDirectiveTaglibInfoTable.put(prefix, dtli);
            st.registerPrefix(prefix);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validateAttributes(JspParseState st) throws JspParseException {
        String loc;
        String originalUri;
        String tagDir;
        String uri;
        String prefix;
        block24: {
            super.validateAttributes(st);
            prefix = this.getPrefix();
            prefix = prefix.trim();
            if (prefix.length() < 1 && st.curXmlSrcElem == null && st.throwParseException(new JspParseException(st, msgs.getString("bad_prefix_val")))) {
                return;
            }
            if (st.curXmlSrcElem == null && prefix.length() == 3 && prefix.equals("jsp") && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("reserved_prefix_jsp"), prefix)))) {
                return;
            }
            if (st.prefixUsed(prefix) && st.curXmlSrcElem == null && st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("bad_prefix_posn"), prefix)))) {
                return;
            }
            uri = this.getURI();
            tagDir = this.getTagdir();
            originalUri = this.getOriginalURI();
            loc = null;
            if (uri == null && tagDir == null) {
                if (st.throwParseException(new JspParseException(st, JspUtil.format(msgs.getString("no_attr"), new Object[]{"uri or tagdir"})))) {
                    return;
                }
            } else if (uri != null && tagDir == null) {
                loc = uri = uri.trim();
            } else if (tagDir != null && uri == null) {
                if (!tagDir.startsWith("/WEB-INF/tags") && st.throwParseException(new JspParseException(st, JspUtil.format(msgs.getString("bad_tagdir"), new Object[]{tagDir})))) {
                    return;
                }
                loc = tagDir;
            } else if (st.throwParseException(new JspParseException(st, msgs.getString("both_uri_taglib_present")))) {
                return;
            }
            if (uri != null) {
                try {
                    Hashtable uriToLocMapping = st.getUriToLocMapping();
                    String locLookup = (String)uriToLocMapping.get(uri);
                    if (locLookup != null) {
                        loc = locLookup;
                    }
                }
                catch (FileNotFoundException fnfe) {
                }
                catch (XMLParseException xpe) {
                    if (st.throwParseException(new JspParseException(xpe.getLineNumber(), xpe.getMessage(), "/WEB-INF/web.xml", xpe))) {
                        return;
                    }
                }
                catch (Exception e) {
                    if (!st.throwParseException(new JspParseException(st, e.toString()))) break block24;
                    return;
                }
            }
        }
        try {
            String lookup;
            String registeredWith = null;
            registeredWith = st.curXmlSrcElem != null ? (uri == null ? tagDir : originalUri) : prefix;
            boolean previouslyRegistered = st.prefixRegistered(registeredWith);
            if (!previouslyRegistered && st.prevXmlSrcElem != null && st.curXmlSrcElem == null && (lookup = ((XMLElement)st.prevXmlSrcElem).resolveNamespacePrefix(prefix)) != null && (previouslyRegistered = st.prefixRegistered(lookup))) {
                registeredWith = lookup;
            }
            if (previouslyRegistered) {
                JspDirectiveTaglibInfo dtli = (JspDirectiveTaglibInfo)st.jspDirectiveTaglibInfoTable.get(registeredWith);
                if (uri == null) return;
                if (dtli.uri == null || dtli.uri.equals(uri)) return;
                if (!st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("seen_prefix"), prefix)))) return;
                return;
            }
            this.createAndRegisterTagLib(st, prefix, uri, originalUri, tagDir, loc);
            return;
        }
        catch (ClassCastException e) {
            if (!st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("bad_class_cast"), uri)))) return;
            return;
        }
        catch (IOException e) {
            if (!st.throwParseException(new JspParseException(st, MessageFormat.format(msgs.getString("cannot_create_taglib"), uri)))) return;
            return;
        }
    }

    private void registerAllTagHandlersInTlib(OracleTagLibraryInfo tb, OracleTagLibraryInfo otb, String prefix, JspParseState st) {
        TagFileInfo[] tagfiles;
        String prefixTagName;
        int i;
        TagInfo[] tags;
        HashMap<String, TagInfo> oracleTags = new HashMap<String, TagInfo>();
        if (otb != null && st.parms.jsfShortCut && (tags = otb.getTags()) != null) {
            for (i = 0; i < tags.length; ++i) {
                oracleTags.put(tags[i].getTagName(), tags[i]);
            }
        }
        if (tb == null) {
            return;
        }
        tags = tb.getTags();
        if (tags != null) {
            for (i = 0; i < tags.length; ++i) {
                TagInfo tagInfo = tags[i];
                TagInfo sharedTagInfo = (TagInfo)oracleTags.get(tagInfo.getTagName());
                if (sharedTagInfo != null) {
                    tagInfo = new SharedTagInfo(tagInfo.getTagName(), sharedTagInfo.getTagClassName(), tagInfo.getBodyContent(), tagInfo.getInfoString(), tagInfo.getTagLibrary(), tagInfo.getTagExtraInfo(), tagInfo.getAttributes(), tagInfo.getDisplayName(), tagInfo.getSmallIcon(), tagInfo.getLargeIcon(), tagInfo.getTagVariableInfos(), tagInfo.hasDynamicAttributes());
                }
                prefixTagName = prefix + ":" + tagInfo.getTagName();
                st.registerTagHandler(prefixTagName, tagInfo);
            }
        }
        if ((tagfiles = tb.getTagFiles()) != null) {
            for (i = 0; i < tagfiles.length; ++i) {
                prefixTagName = prefix + ":" + tagfiles[i].getName();
                st.registerTagHandler(prefixTagName, tagfiles[i].getTagInfo(), true, tagfiles[i].getPath());
            }
        }
    }
}

