/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.jsp.parse.JspDirectiveAttrDesc;
import oracle.jsp.parse.JspDirectiveAttribute;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.util.JspUtil;

public abstract class JspDirective
implements Cloneable,
Serializable {
    protected static final String MSG_FILE = "oracle.jsp.parse.LocalStrings";
    protected static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.parse.LocalStrings");
    protected JspDirectiveAttribute directive = new JspDirectiveAttribute(this.getDirectiveDescription());
    protected Vector attributes;
    protected JspDirectiveAttrDesc[] descriptions = this.getAttributeDescriptions();

    public abstract JspDirectiveAttrDesc getDirectiveDescription();

    public abstract JspDirectiveAttrDesc[] getAttributeDescriptions();

    protected Object clone() throws CloneNotSupportedException {
        JspDirective dir = (JspDirective)super.clone();
        dir.directive = (JspDirectiveAttribute)this.directive.clone();
        if (this.attributes != null) {
            dir.attributes = new Vector();
            for (int i = 0; i < this.attributes.size(); ++i) {
                JspDirectiveAttribute a = (JspDirectiveAttribute)this.attributes.elementAt(i);
                dir.attributes.addElement(a.clone());
            }
        }
        return dir;
    }

    public void setValue(String value) {
        this.directive.setValue(value);
    }

    public String getValue() {
        return this.directive.getValue();
    }

    public String getName() {
        return this.directive.description.name;
    }

    public String getAttrValue(String attr) {
        if (this.attributes == null) {
            return null;
        }
        JspDirectiveAttribute a = this.findAttribute(attr);
        if (a != null) {
            return a.getValue();
        }
        return null;
    }

    protected JspDirectiveAttribute findAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        for (int i = 0; i < this.attributes.size(); ++i) {
            JspDirectiveAttribute a = (JspDirectiveAttribute)this.attributes.elementAt(i);
            if (!a.description.name.equals(name)) continue;
            return a;
        }
        return null;
    }

    public void addAttribute(JspParseState st, String name, String value) throws JspParseException {
        JspDirectiveAttribute a = this.findAttribute(name);
        if (a != null) {
            String oldVal;
            if (!st.parms.forgiveDupDirectiveAttr && a.description.noDupAttr && (oldVal = a.getValue()) != null && !oldVal.equals(value) && st.throwParseException(new JspParseException(st, JspUtil.format(msgs.getString("same_attr_dif_val"), new Object[]{name})))) {
                return;
            }
            if (value != null && value.startsWith("<%=") && st.throwParseException(new JspParseException(st, JspUtil.format(msgs.getString("illegal_request_time_value"), new Object[]{name, value})))) {
                return;
            }
            if (a.setValue(value)) {
                return;
            }
            if (!(st.parms.xmlStyleSrc && name.startsWith("xmlns") || !st.throwParseException(new JspParseException(st, JspUtil.format(msgs.getString("bad_attr_value"), new Object[]{value, name}))))) {
                return;
            }
        }
        if (this.attributes == null) {
            this.attributes = new Vector();
        }
        for (int i = 0; i < this.descriptions.length; ++i) {
            if (!this.descriptions[i].name.equals(name)) continue;
            a = new JspDirectiveAttribute(this.descriptions[i]);
            this.attributes.addElement(a);
            if (value != null && value.startsWith("<%=") && st.throwParseException(new JspParseException(st, JspUtil.format(msgs.getString("illegal_request_time_value"), new Object[]{name, value})))) {
                return;
            }
            if (a.setValue(value)) {
                return;
            }
            if (!st.throwParseException(new JspParseException(st, JspUtil.format(msgs.getString("bad_attr_value"), new Object[]{value, name})))) continue;
            return;
        }
        if (st.parms.xmlStyleSrc && name.startsWith("xmlns")) {
            return;
        }
        if (st.throwParseException(new JspParseException(st, JspUtil.format(msgs.getString("bad_attr"), new Object[]{name})))) {
            return;
        }
    }

    public void validateAttributes(JspParseState st) throws JspParseException {
        if (this.directive.getValue() == null && this.directive.description.required && st.throwParseException(new JspParseException(st, JspUtil.format(msgs.getString("bad_direct"), new Object[]{this.directive.description.name})))) {
            return;
        }
        for (int i = 0; i < this.descriptions.length; ++i) {
            if (!this.descriptions[i].required) continue;
            JspDirectiveAttribute a = this.findAttribute(this.descriptions[i].name);
            if (a == null && st.throwParseException(new JspParseException(st, JspUtil.format(msgs.getString("no_attr"), new Object[]{this.descriptions[i].name})))) {
                return;
            }
            if (a.getValue() != null || !st.throwParseException(new JspParseException(st, JspUtil.format(msgs.getString("no_attr_value"), new Object[]{this.descriptions[i].name})))) continue;
            return;
        }
    }
}

