/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.jsp.parse.JspBeanInfo;
import oracle.jsp.parse.JspBeanPropertyInfo;

public class JspBeanDictionary
implements Cloneable,
Serializable {
    private Hashtable dictionary = new Hashtable();
    private int blockScope = 10;
    private Hashtable defaultProperties;

    public JspBeanDictionary() {
        this.addDefaultProperty("oracle.jsp.jml.JmlBoolean", "value");
        this.addDefaultProperty("oracle.jsp.jml.JmlString", "value");
        this.addDefaultProperty("oracle.jsp.jml.JmlNumber", "value");
        this.addDefaultProperty("javax.servlet.ServletContext", "attribute");
        this.addDefaultProperty("javax.servlet.http.HttpSession", "value");
        this.addDefaultProperty("javax.servlet.http.HttpServletRequest", "parameter");
        this.addDefaultProperty("javax.servlet.jsp.PageContext", "attribute");
    }

    protected Object clone() throws CloneNotSupportedException, OutOfMemoryError {
        JspBeanDictionary dict = (JspBeanDictionary)super.clone();
        dict.dictionary = (Hashtable)this.dictionary.clone();
        if (this.defaultProperties != null) {
            dict.defaultProperties = (Hashtable)this.defaultProperties.clone();
        }
        return dict;
    }

    public boolean beanExists(String name) {
        return this.dictionary.get(name) != null;
    }

    public JspBeanInfo getBeanInfo(String name) {
        JspBeanInfo info = (JspBeanInfo)this.dictionary.get(name);
        return info;
    }

    public Enumeration getAllBeans() {
        return this.dictionary.elements();
    }

    public void addBean(JspBeanInfo bean) {
        JspBeanInfo o = this.dictionary.put(bean.name, bean);
        if (o != null) {
            bean.hides = o;
        }
    }

    public int getNextBlockScope() {
        ++this.blockScope;
        return this.blockScope;
    }

    public void killBlockScope(int scope) {
        this.blockScope = scope - 1;
        if (this.blockScope < 10) {
            return;
        }
        Enumeration e = this.dictionary.elements();
        while (e.hasMoreElements()) {
            JspBeanInfo info = (JspBeanInfo)e.nextElement();
            if (info.scope < scope) continue;
            if (info.hides != null) {
                this.dictionary.put(info.name, info.hides);
                continue;
            }
            this.dictionary.remove(info.name);
        }
    }

    public JspBeanPropertyInfo getSetPropertyInfo(String beanName, String propertyName) {
        JspBeanInfo info = this.getBeanInfo(beanName);
        if (info != null) {
            return info.getSetProperty(propertyName);
        }
        return null;
    }

    public String getDefaultProperty(String className) {
        if (this.defaultProperties == null) {
            return null;
        }
        return (String)this.defaultProperties.get(className);
    }

    public void addDefaultProperty(String className, String propertyName) {
        if (this.defaultProperties == null) {
            this.defaultProperties = new Hashtable();
        }
        this.defaultProperties.put(className, propertyName);
    }
}

