/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.jui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.jbo.uicli.binding.JUCtrlAttrsBinding;
import oracle.jbo.uicli.binding.JUCtrlValueBinding;
import oracle.jbo.uicli.binding.JUFormBinding;
import oracle.jbo.uicli.binding.JUIteratorBinding;
import oracle.jbo.uicli.jui.JUIUtil;
import oracle.jbo.uicli.jui.JUSVUpdateableFocusAdapter;

public class JUTextFieldBinding
extends JUCtrlAttrsBinding
implements Document,
ActionListener {
    private Document mDocument;

    public JUTextFieldBinding(JTextComponent jTextComponent, JUIteratorBinding jUIteratorBinding, String string) {
        super((Object)jTextComponent, (DCIteratorBinding)jUIteratorBinding, new String[]{string});
        this.setControl(jTextComponent);
    }

    public void setControl(Object object) {
        JTextComponent jTextComponent = (JTextComponent)object;
        super.setControl((Object)jTextComponent);
        this.mDocument = this.getModelImpl(jTextComponent);
        if (jTextComponent != null) {
            if (this.mDocument != jTextComponent.getDocument()) {
                jTextComponent.setDocument(this.mDocument);
            }
            if (jTextComponent instanceof JTextField) {
                ((JTextField)jTextComponent).addActionListener(this);
            }
            jTextComponent.addFocusListener(new JUSVUpdateableFocusAdapter((JUCtrlValueBinding)this, 0));
        } else if (this.getControl() != null && (jTextComponent = (JTextComponent)this.getControl()) instanceof JTextField) {
            ((JTextField)jTextComponent).removeActionListener(this);
        }
    }

    protected Document getModelImpl(JTextComponent jTextComponent) {
        Document document = this.mDocument;
        if (document == null && jTextComponent != null) {
            document = jTextComponent.getDocument();
        }
        return document;
    }

    protected boolean isControlQueriable() {
        return true;
    }

    public void addControlToPanel(Object object, Object object2, Object object3) {
        ((JPanel)object).add((Component)object2, object3);
    }

    public Object getValueAt(int n) {
        JTextComponent jTextComponent = (JTextComponent)this.getControl();
        return jTextComponent != null ? jTextComponent.getText() : super.getValueAt(n);
    }

    public void setValueAt(Object object, int n) {
        JTextComponent jTextComponent = (JTextComponent)this.getControl();
        if (jTextComponent != null) {
            jTextComponent.setText(object == null ? "" : object.toString());
        } else {
            super.setValueAt(object, n);
        }
    }

    public void setDataValueAt(Object object, int n) {
        this.setValueAt(object, n);
        this.setAttribute(0, object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setAttributeInRow(this.getCurrentRow(), this.getAttributeDef(0), this.getValueAt(0), true);
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.mDocument.addDocumentListener(documentListener);
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.mDocument.addUndoableEditListener(undoableEditListener);
    }

    public Position createPosition(int n) throws BadLocationException {
        return this.mDocument.createPosition(n);
    }

    public Element getDefaultRootElement() {
        return this.mDocument.getDefaultRootElement();
    }

    public Position getEndPosition() {
        return this.mDocument.getEndPosition();
    }

    public int getLength() {
        return this.mDocument.getLength();
    }

    public Object getProperty(Object object) {
        return this.mDocument.getProperty(object);
    }

    public Element[] getRootElements() {
        return this.mDocument.getRootElements();
    }

    public Position getStartPosition() {
        return this.mDocument.getStartPosition();
    }

    public String getText(int n, int n2) throws BadLocationException {
        return this.mDocument.getText(n, n2);
    }

    public void getText(int n, int n2, Segment segment) throws BadLocationException {
        this.mDocument.getText(n, n2, segment);
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        this.mDocument.insertString(n, string, attributeSet);
    }

    public void putProperty(Object object, Object object2) {
        this.mDocument.putProperty(object, object2);
    }

    public void remove(int n, int n2) throws BadLocationException {
        this.mDocument.remove(n, n2);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.mDocument.removeDocumentListener(documentListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.mDocument.removeUndoableEditListener(undoableEditListener);
    }

    public void render(Runnable runnable) {
        this.mDocument.render(runnable);
    }

    public Object getControlModel(Object object) {
        Object object2 = this.getControl();
        JTextComponent jTextComponent = (JTextComponent)object;
        this.setControl(jTextComponent);
        return this.getModelImpl(jTextComponent);
    }

    public static Document createAttributeBinding(JUFormBinding jUFormBinding, JTextComponent jTextComponent, String string, String string2, String string3, String string4) {
        if (!JUIUtil.inDesignTime()) {
            JUTextFieldBinding jUTextFieldBinding = new JUTextFieldBinding(jTextComponent, jUFormBinding.getRowIterBinding(string, string2, string3), string4);
            jUTextFieldBinding.refreshControl();
            return jUTextFieldBinding.getModelImpl(null);
        }
        try {
            Class<?> clazz = Class.forName("oracle.jbo.dt.ui.jui.propertyeditors.dtmodels.DTJTextFieldBinding");
            Constructor<?>[] constructorArray = clazz.getConstructors();
            int n = 0;
            while (n < constructorArray.length) {
                Constructor<?> constructor = constructorArray[n];
                Class<?>[] classArray = constructor.getParameterTypes();
                if (classArray.length == 1) {
                    Object[] objectArray = new Object[]{String.valueOf(string) + "." + string4};
                    Object obj = constructor.newInstance(objectArray);
                    Document document = (Document)obj;
                    return document;
                }
                ++n;
            }
            Document document = null;
            return document;
        }
        catch (Exception exception) {
            Document document = null;
            return document;
        }
    }

    public static Document getInstance(JUFormBinding jUFormBinding, JTextComponent jTextComponent, String string, String string2, String string3, String string4) {
        return JUTextFieldBinding.createAttributeBinding(jUFormBinding, jTextComponent, string, string2, string3, string4);
    }
}

