/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.graph;

import java.util.ArrayList;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.CubeDataDirector;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataAccessAdapter;
import oracle.dss.util.DataAvailableEvent;
import oracle.dss.util.DataChangedEvent;
import oracle.dss.util.DataDirectorException;
import oracle.dss.util.DataDirectorListener;
import oracle.dss.util.DataMap;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerMetadataMap;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.RelationalDataDirector;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.jbo.uicli.graph.JUGraphBinding;

public class BIBeanDataAccessAdapter
extends DataAccessAdapter
implements RelationalDataDirector,
CubeDataDirector {
    private static final String mEmptyString = "";
    private int pageCount;
    private int currentPage;
    protected DataDirectorListener mListener;
    JUGraphBinding mOwner;
    ArrayList listeners = new ArrayList(5);

    public BIBeanDataAccessAdapter(JUGraphBinding jUGraphBinding) {
        this.mOwner = jUGraphBinding;
        this.currentPage = 0;
    }

    public boolean pivot(int n, int n2, int n3, int n4, int n5) throws DataDirectorException, LayerOutOfRangeException, EdgeOutOfRangeException {
        return false;
    }

    public boolean drill(int n, int n2, int n3, int n4) throws DataDirectorException, SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        return true;
    }

    public int getEdgeExtent(int n) throws EdgeOutOfRangeException {
        switch (n) {
            case 0: {
                return this.mOwner.getColumnCount();
            }
            case 1: {
                return (int)this.mOwner.getRowCount();
            }
        }
        return this.pageCount;
    }

    public int getEdgeCount() {
        return 3;
    }

    public Object getValue(int n, int n2, String string) throws ColumnOutOfRangeException, RowOutOfRangeException {
        return this.mOwner.getValue(n, n2);
    }

    public boolean setValue(Object object, int n, int n2, String string) throws ColumnOutOfRangeException, RowOutOfRangeException {
        return false;
    }

    public Object getSliceLabel(int n, int n2, String string) throws SliceOutOfRangeException, EdgeOutOfRangeException {
        switch (n) {
            case 0: {
                return this.mOwner.getColumnLabel(n2);
            }
            case 1: {
                return this.mOwner.getRowLabel(n2);
            }
        }
        if (n2 < 0 || n2 >= this.pageCount) {
            throw new SliceOutOfRangeException(n2, this.pageCount);
        }
        return mEmptyString;
    }

    public int getEdgeCurrentSlice(int n) throws EdgeOutOfRangeException {
        return this.currentPage;
    }

    public boolean changeEdgeCurrentSlice(int n, int n2) throws DataDirectorException, SliceOutOfRangeException, EdgeOutOfRangeException {
        if (n2 < 0 || n2 >= this.pageCount) {
            return false;
        }
        this.currentPage = n2;
        return true;
    }

    public int getLayerCount(int n) throws EdgeOutOfRangeException {
        if (n == 2) {
            return 0;
        }
        return 1;
    }

    public int getSliceMemberCount(int n, int n2) throws SliceOutOfRangeException, EdgeOutOfRangeException {
        if (n == 2) {
            return 0;
        }
        return 1;
    }

    public Object getMemberMetadata(int n, int n2, int n3, String string) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        if (string.equals("drillState")) {
            switch (n3) {
                case 0: {
                    return new Integer(1);
                }
                case 1: {
                    return new Integer(2);
                }
            }
            return new Integer(0);
        }
        if (string.equals("hierLevel")) {
            return new Integer(n3);
        }
        String string2 = null;
        switch (n) {
            case 0: {
                string2 = this.mOwner.getColumnLabel(n3);
                break;
            }
            case 1: {
                string2 = this.mOwner.getRowLabel(n3);
                break;
            }
            case 2: {
                string2 = mEmptyString;
            }
        }
        return string2;
    }

    public int getMemberExtent(int n, int n2, int n3) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        return 1;
    }

    public int getMemberDepth(int n, int n2, int n3) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        return 1;
    }

    public int getMemberStartLayer(int n, int n2, int n3) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        return n2;
    }

    public void addDataDirectorListener(DataDirectorListener dataDirectorListener) {
        if (dataDirectorListener != null) {
            this.listeners.add(dataDirectorListener);
            dataDirectorListener.viewDataAvailable(new DataAvailableEvent((Object)this, (DataAccess)this));
        }
    }

    public void removeDataDirectorListener(DataDirectorListener dataDirectorListener) {
        if (dataDirectorListener != null) {
            this.listeners.remove(dataDirectorListener);
        }
    }

    public boolean refresh() throws DataDirectorException {
        DataChangedEvent dataChangedEvent = new DataChangedEvent((Object)this, (DataAccess)this, true, true, true, true);
        int n = 0;
        while (n < this.listeners.size()) {
            DataDirectorListener dataDirectorListener = (DataDirectorListener)this.listeners.get(n);
            dataDirectorListener.viewDataChanged(dataChangedEvent);
            ++n;
        }
        return true;
    }

    public DataMap getSupportedDataMap() {
        String[] stringArray = new String[]{"dataUnformatted", "dataFormatted"};
        return new DataMap(stringArray);
    }

    public MetadataMap getSupportedMetadataMap() {
        String[] stringArray = new String[]{"longName", "mediumName", "shortName"};
        return new MetadataMap(stringArray);
    }

    public LayerMetadataMap getSupportedLayerMetadataMap() {
        String[] stringArray = new String[]{"dimLongName", "dimMediumName", "dimShortName"};
        return new LayerMetadataMap(stringArray);
    }

    void releaseReferences() {
        this.mOwner = null;
        this.listeners.clear();
    }
}

